/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalCountHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class CountHistogramFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData indexFieldData;
    private final HistogramFacet.ComparatorType comparatorType;
    final long interval;
    final TLongLongHashMap counts;

    public CountHistogramFacetExecutor(IndexNumericFieldData indexFieldData, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        this.comparatorType = comparatorType;
        this.indexFieldData = indexFieldData;
        this.interval = interval;
        this.counts = CacheRecycler.popLongLongMap();
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalCountHistogramFacet(facetName, this.comparatorType, this.counts, true);
    }

    public static long bucket(double value, long interval) {
        return (long)(value / (double)interval) * interval;
    }

    public static final class HistogramProc
    extends DoubleFacetAggregatorBase {
        private final long interval;
        private final TLongLongHashMap counts;

        public HistogramProc(long interval, TLongLongHashMap counts) {
            this.interval = interval;
            this.counts = counts;
        }

        @Override
        public void onValue(int docId, double value) {
            long bucket = CountHistogramFacetExecutor.bucket(value, this.interval);
            this.counts.adjustOrPutValue(bucket, 1L, 1L);
        }

        public TLongLongHashMap counts() {
            return this.counts;
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final HistogramProc histoProc;
        private DoubleValues values;

        public Collector() {
            this.histoProc = new HistogramProc(CountHistogramFacetExecutor.this.interval, CountHistogramFacetExecutor.this.counts);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((AtomicNumericFieldData)CountHistogramFacetExecutor.this.indexFieldData.load(context)).getDoubleValues();
        }

        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
        }
    }
}

