/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.FullHistogramFacetExecutor;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalFullHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ValueHistogramFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData keyIndexFieldData;
    private final IndexNumericFieldData valueIndexFieldData;
    private final HistogramFacet.ComparatorType comparatorType;
    private final long interval;
    final ExtTLongObjectHashMap<InternalFullHistogramFacet.FullEntry> entries;

    public ValueHistogramFacetExecutor(IndexNumericFieldData keyIndexFieldData, IndexNumericFieldData valueIndexFieldData, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        this.comparatorType = comparatorType;
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueIndexFieldData = valueIndexFieldData;
        this.interval = interval;
        this.entries = CacheRecycler.popLongObjectMap();
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalFullHistogramFacet(facetName, this.comparatorType, this.entries, true);
    }

    public static final class HistogramProc
    extends DoubleFacetAggregatorBase {
        final long interval;
        final ExtTLongObjectHashMap<InternalFullHistogramFacet.FullEntry> entries;
        DoubleValues valueValues;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public HistogramProc(long interval, ExtTLongObjectHashMap<InternalFullHistogramFacet.FullEntry> entries) {
            this.interval = interval;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double value) {
            long bucket = FullHistogramFacetExecutor.bucket(value, this.interval);
            InternalFullHistogramFacet.FullEntry entry = (InternalFullHistogramFacet.FullEntry)this.entries.get(bucket);
            if (entry == null) {
                entry = new InternalFullHistogramFacet.FullEntry(bucket, 0L, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0L, 0.0);
                this.entries.put(bucket, entry);
            }
            ++entry.count;
            this.valueAggregator.entry = entry;
            this.valueAggregator.onDoc(docId, this.valueValues);
        }

        public static final class ValueAggregator
        extends DoubleFacetAggregatorBase {
            InternalFullHistogramFacet.FullEntry entry;

            @Override
            public void onValue(int docId, double value) {
                ++this.entry.totalCount;
                this.entry.total += value;
                if (value < this.entry.min) {
                    this.entry.min = value;
                }
                if (value > this.entry.max) {
                    this.entry.max = value;
                }
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final HistogramProc histoProc;
        private DoubleValues keyValues;

        public Collector() {
            this.histoProc = new HistogramProc(ValueHistogramFacetExecutor.this.interval, ValueHistogramFacetExecutor.this.entries);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = ((AtomicNumericFieldData)ValueHistogramFacetExecutor.this.keyIndexFieldData.load(context)).getDoubleValues();
            this.histoProc.valueValues = ((AtomicNumericFieldData)ValueHistogramFacetExecutor.this.valueIndexFieldData.load(context)).getDoubleValues();
        }

        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
        }
    }
}

