/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.statistical.StatisticalFacet;

public class InternalStatisticalFacet
extends InternalFacet
implements StatisticalFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray("statistical");
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalStatisticalFacet.readStatisticalFacet(in);
        }
    };
    private double min;
    private double max;
    private double total;
    private double sumOfSquares;
    private long count;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    private InternalStatisticalFacet() {
    }

    public InternalStatisticalFacet(String name, double min, double max, double total, double sumOfSquares, long count) {
        super(name);
        this.min = min;
        this.max = max;
        this.total = total;
        this.sumOfSquares = sumOfSquares;
        this.count = count;
    }

    @Override
    public String getType() {
        return "statistical";
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public double getTotal() {
        return this.total;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    @Override
    public double getMean() {
        if (this.count == 0L) {
            return 0.0;
        }
        return this.total / (double)this.count;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public double getVariance() {
        return (this.sumOfSquares - this.total * this.total / (double)this.count) / (double)this.count;
    }

    @Override
    public double getStdDeviation() {
        return Math.sqrt(this.getVariance());
    }

    @Override
    public Facet reduce(List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        double min = Double.NaN;
        double max = Double.NaN;
        double total = 0.0;
        double sumOfSquares = 0.0;
        long count = 0L;
        for (Facet facet : facets) {
            InternalStatisticalFacet statsFacet = (InternalStatisticalFacet)facet;
            if (statsFacet.getMin() < min || Double.isNaN(min)) {
                min = statsFacet.getMin();
            }
            if (statsFacet.getMax() > max || Double.isNaN(max)) {
                max = statsFacet.getMax();
            }
            total += statsFacet.getTotal();
            sumOfSquares += statsFacet.getSumOfSquares();
            count += statsFacet.getCount();
        }
        return new InternalStatisticalFacet(this.getName(), min, max, total, sumOfSquares, count);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "statistical");
        builder.field(Fields.COUNT, this.getCount());
        builder.field(Fields.TOTAL, this.getTotal());
        builder.field(Fields.MIN, this.getMin());
        builder.field(Fields.MAX, this.getMax());
        builder.field(Fields.MEAN, this.getMean());
        builder.field(Fields.SUM_OF_SQUARES, this.getSumOfSquares());
        builder.field(Fields.VARIANCE, this.getVariance());
        builder.field(Fields.STD_DEVIATION, this.getStdDeviation());
        builder.endObject();
        return builder;
    }

    public static StatisticalFacet readStatisticalFacet(StreamInput in) throws IOException {
        InternalStatisticalFacet facet = new InternalStatisticalFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.count = in.readVLong();
        this.total = in.readDouble();
        this.min = in.readDouble();
        this.max = in.readDouble();
        this.sumOfSquares = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.count);
        out.writeDouble(this.total);
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        out.writeDouble(this.sumOfSquares);
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString SUM_OF_SQUARES = new XContentBuilderString("sum_of_squares");
        static final XContentBuilderString VARIANCE = new XContentBuilderString("variance");
        static final XContentBuilderString STD_DEVIATION = new XContentBuilderString("std_deviation");

        Fields() {
        }
    }
}

