/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.doubles;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.trove.iterator.TDoubleIntIterator;
import org.elasticsearch.common.trove.map.hash.TDoubleIntHashMap;
import org.elasticsearch.common.trove.set.hash.TDoubleHashSet;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.doubles.InternalDoubleTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class TermsDoubleFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData indexFieldData;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final SearchScript script;
    private final ImmutableSet<BytesRef> excluded;
    final TDoubleIntHashMap facets;
    long missing;
    long total;

    public TermsDoubleFacetExecutor(IndexNumericFieldData indexFieldData, int size, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<BytesRef> excluded, SearchScript script) {
        this.indexFieldData = indexFieldData;
        this.size = size;
        this.comparatorType = comparatorType;
        this.script = script;
        this.excluded = excluded;
        this.facets = CacheRecycler.popDoubleIntMap();
        if (allTerms) {
            for (AtomicReaderContext readerContext : context.searcher().getTopReaderContext().leaves()) {
                int maxDoc = readerContext.reader().maxDoc();
                DoubleValues values = ((AtomicNumericFieldData)indexFieldData.load(readerContext)).getDoubleValues();
                if (values instanceof DoubleValues.WithOrdinals) {
                    DoubleValues.WithOrdinals valuesWithOrds = (DoubleValues.WithOrdinals)values;
                    Ordinals.Docs ordinals = valuesWithOrds.ordinals();
                    for (int ord = 1; ord < ordinals.getMaxOrd(); ++ord) {
                        this.facets.putIfAbsent(valuesWithOrds.getValueByOrd(ord), 0);
                    }
                    continue;
                }
                if (values.isMultiValued()) {
                    for (int docId = 0; docId < maxDoc; ++docId) {
                        if (!values.hasValue(docId)) continue;
                        DoubleValues.Iter iter = values.getIter(docId);
                        while (iter.hasNext()) {
                            this.facets.putIfAbsent(iter.next(), 0);
                        }
                    }
                    continue;
                }
                for (int docId = 0; docId < maxDoc; ++docId) {
                    if (!values.hasValue(docId)) continue;
                    double value = values.getValue(docId);
                    this.facets.putIfAbsent(value, 0);
                }
            }
        }
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        if (this.facets.isEmpty()) {
            CacheRecycler.pushDoubleIntMap(this.facets);
            return new InternalDoubleTermsFacet(facetName, this.comparatorType, this.size, ImmutableList.<InternalDoubleTermsFacet.DoubleEntry>of(), this.missing, this.total);
        }
        if (this.size < 5000) {
            EntryPriorityQueue ordered = new EntryPriorityQueue(this.size, this.comparatorType.comparator());
            TDoubleIntIterator it = this.facets.iterator();
            while (it.hasNext()) {
                it.advance();
                ordered.insertWithOverflow(new InternalDoubleTermsFacet.DoubleEntry(it.key(), it.value()));
            }
            InternalDoubleTermsFacet.DoubleEntry[] list = new InternalDoubleTermsFacet.DoubleEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalDoubleTermsFacet.DoubleEntry)ordered.pop();
            }
            CacheRecycler.pushDoubleIntMap(this.facets);
            return new InternalDoubleTermsFacet(facetName, this.comparatorType, this.size, Arrays.asList(list), this.missing, this.total);
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size);
        TDoubleIntIterator it = this.facets.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new InternalDoubleTermsFacet.DoubleEntry(it.key(), it.value()));
        }
        CacheRecycler.pushDoubleIntMap(this.facets);
        return new InternalDoubleTermsFacet(facetName, this.comparatorType, this.size, ordered, this.missing, this.total);
    }

    public static class StaticAggregatorValueProc
    extends DoubleFacetAggregatorBase {
        private final TDoubleIntHashMap facets;

        public StaticAggregatorValueProc(TDoubleIntHashMap facets) {
            this.facets = facets;
        }

        @Override
        public void onValue(int docId, double value) {
            this.facets.adjustOrPutValue(value, 1, 1);
        }

        public final TDoubleIntHashMap facets() {
            return this.facets;
        }
    }

    public static class AggregatorValueProc
    extends StaticAggregatorValueProc {
        private final SearchScript script;
        private final TDoubleHashSet excluded;

        public AggregatorValueProc(TDoubleIntHashMap facets, Set<BytesRef> excluded, SearchScript script) {
            super(facets);
            this.script = script;
            if (excluded == null || excluded.isEmpty()) {
                this.excluded = null;
            } else {
                this.excluded = new TDoubleHashSet(excluded.size());
                for (BytesRef s : excluded) {
                    this.excluded.add(Double.parseDouble(s.utf8ToString()));
                }
            }
        }

        @Override
        public void onValue(int docId, double value) {
            if (this.excluded != null && this.excluded.contains(value)) {
                return;
            }
            if (this.script != null) {
                this.script.setNextDocId(docId);
                this.script.setNextVar("term", value);
                Object scriptValue = this.script.run();
                if (scriptValue == null) {
                    return;
                }
                if (scriptValue instanceof Boolean) {
                    if (!((Boolean)scriptValue).booleanValue()) {
                        return;
                    }
                } else {
                    value = ((Number)scriptValue).doubleValue();
                }
            }
            super.onValue(docId, value);
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final StaticAggregatorValueProc aggregator;
        private DoubleValues values;

        public Collector() {
            this.aggregator = TermsDoubleFacetExecutor.this.script == null && TermsDoubleFacetExecutor.this.excluded.isEmpty() ? new StaticAggregatorValueProc(TermsDoubleFacetExecutor.this.facets) : new AggregatorValueProc(TermsDoubleFacetExecutor.this.facets, TermsDoubleFacetExecutor.this.excluded, TermsDoubleFacetExecutor.this.script);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (TermsDoubleFacetExecutor.this.script != null) {
                TermsDoubleFacetExecutor.this.script.setScorer(scorer);
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((AtomicNumericFieldData)TermsDoubleFacetExecutor.this.indexFieldData.load(context)).getDoubleValues();
            if (TermsDoubleFacetExecutor.this.script != null) {
                TermsDoubleFacetExecutor.this.script.setNextReader(context);
            }
        }

        public void collect(int doc) throws IOException {
            this.aggregator.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
            TermsDoubleFacetExecutor.this.missing = this.aggregator.missing();
            TermsDoubleFacetExecutor.this.total = this.aggregator.total();
        }
    }
}

