/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStringOrdinalsFacetExecutor
extends FacetExecutor {
    private final IndexFieldData.WithOrdinals indexFieldData;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int minCount;
    private final ImmutableSet<BytesRef> excluded;
    private final Matcher matcher;
    final int ordinalsCacheAbove;
    final List<ReaderAggregator> aggregators;
    long missing;
    long total;

    public TermsStringOrdinalsFacetExecutor(IndexFieldData.WithOrdinals indexFieldData, int size, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<BytesRef> excluded, Pattern pattern, int ordinalsCacheAbove) {
        this.indexFieldData = indexFieldData;
        this.size = size;
        this.comparatorType = comparatorType;
        this.ordinalsCacheAbove = ordinalsCacheAbove;
        this.excluded = excluded == null || excluded.isEmpty() ? null : excluded;
        this.matcher = pattern != null ? pattern.matcher("") : null;
        this.minCount = allTerms ? -1 : 0;
        this.aggregators = new ArrayList<ReaderAggregator>(context.searcher().getIndexReader().leaves().size());
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        ReaderAggregator agg;
        Object ordered;
        CharsRef spare = new CharsRef();
        AggregatorPriorityQueue queue = new AggregatorPriorityQueue(this.aggregators.size());
        for (ReaderAggregator aggregator : this.aggregators) {
            if (!aggregator.nextPosition()) continue;
            queue.add(aggregator);
        }
        if (this.size < 5000) {
            ordered = new EntryPriorityQueue(this.size, this.comparatorType.comparator());
            while (queue.size() > 0) {
                agg = (ReaderAggregator)queue.top();
                BytesRef value = agg.values.makeSafe(agg.current);
                int count = 0;
                do {
                    count += agg.counts[agg.position];
                    if (agg.nextPosition()) {
                        agg = (ReaderAggregator)queue.updateTop();
                        continue;
                    }
                    queue.pop();
                    agg = (ReaderAggregator)queue.top();
                } while (agg != null && value.equals((Object)agg.current));
                if (count <= this.minCount || this.excluded != null && this.excluded.contains(value)) continue;
                if (this.matcher != null) {
                    UnicodeUtil.UTF8toUTF16((BytesRef)value, (CharsRef)spare);
                    assert (spare.toString().equals(value.utf8ToString()));
                    if (!this.matcher.reset((CharSequence)spare).matches()) continue;
                }
                InternalStringTermsFacet.TermEntry entry = new InternalStringTermsFacet.TermEntry(value, count);
                ordered.insertWithOverflow((Object)entry);
            }
            InternalStringTermsFacet.TermEntry[] list = new InternalStringTermsFacet.TermEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalStringTermsFacet.TermEntry)ordered.pop();
            }
            for (ReaderAggregator aggregator : this.aggregators) {
                if (aggregator.counts.length <= this.ordinalsCacheAbove) continue;
                CacheRecycler.pushIntArray(aggregator.counts);
            }
            return new InternalStringTermsFacet(facetName, this.comparatorType, this.size, Arrays.asList(list), this.missing, this.total);
        }
        ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size);
        while (queue.size() > 0) {
            agg = (ReaderAggregator)queue.top();
            BytesRef value = agg.values.makeSafe(agg.current);
            int count = 0;
            do {
                count += agg.counts[agg.position];
                if (agg.nextPosition()) {
                    agg = (ReaderAggregator)queue.updateTop();
                    continue;
                }
                queue.pop();
                agg = (ReaderAggregator)queue.top();
            } while (agg != null && value.equals((Object)agg.current));
            if (count <= this.minCount || this.excluded != null && this.excluded.contains(value)) continue;
            if (this.matcher != null) {
                UnicodeUtil.UTF8toUTF16((BytesRef)value, (CharsRef)spare);
                assert (spare.toString().equals(value.utf8ToString()));
                if (!this.matcher.reset((CharSequence)spare).matches()) continue;
            }
            InternalStringTermsFacet.TermEntry entry = new InternalStringTermsFacet.TermEntry(value, count);
            ((BoundedTreeSet)ordered).add(entry);
        }
        for (ReaderAggregator aggregator : this.aggregators) {
            if (aggregator.counts.length <= this.ordinalsCacheAbove) continue;
            CacheRecycler.pushIntArray(aggregator.counts);
        }
        return new InternalStringTermsFacet(facetName, this.comparatorType, this.size, (Collection<InternalStringTermsFacet.TermEntry>)ordered, this.missing, this.total);
    }

    public static class AggregatorPriorityQueue
    extends PriorityQueue<ReaderAggregator> {
        public AggregatorPriorityQueue(int size) {
            super(size);
        }

        protected boolean lessThan(ReaderAggregator a, ReaderAggregator b) {
            return a.current.compareTo(b.current) < 0;
        }
    }

    public static final class ReaderAggregator {
        final BytesValues.WithOrdinals values;
        final int[] counts;
        int position = 0;
        BytesRef current;
        int total;
        private final int maxOrd;

        public ReaderAggregator(BytesValues.WithOrdinals values, int ordinalsCacheLimit) {
            this.values = values;
            this.maxOrd = values.ordinals().getMaxOrd();
            this.counts = this.maxOrd > ordinalsCacheLimit ? CacheRecycler.popIntArray(this.maxOrd) : new int[this.maxOrd];
        }

        final void onOrdinal(int docId, int ordinal) {
            int n = ordinal;
            this.counts[n] = this.counts[n] + 1;
            ++this.total;
        }

        public boolean nextPosition() {
            if (++this.position >= this.maxOrd) {
                return false;
            }
            this.current = this.values.getValueByOrd(this.position);
            return true;
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private long missing;
        private long total;
        private BytesValues.WithOrdinals values;
        private ReaderAggregator current;
        private Ordinals.Docs ordinals;

        Collector() {
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            if (this.current != null) {
                this.missing += (long)this.current.counts[0];
                this.total += (long)(this.current.total - this.current.counts[0]);
                if (this.current.values.ordinals().getNumOrds() > 0) {
                    TermsStringOrdinalsFacetExecutor.this.aggregators.add(this.current);
                }
            }
            this.values = TermsStringOrdinalsFacetExecutor.this.indexFieldData.load(context).getBytesValues();
            this.current = new ReaderAggregator(this.values, TermsStringOrdinalsFacetExecutor.this.ordinalsCacheAbove);
            this.ordinals = this.values.ordinals();
        }

        public void collect(int doc) throws IOException {
            Ordinals.Docs.Iter iter = this.ordinals.getIter(doc);
            int ord = iter.next();
            this.current.onOrdinal(doc, ord);
            while ((ord = iter.next()) != 0) {
                this.current.onOrdinal(doc, ord);
            }
        }

        @Override
        public void postCollection() {
            if (this.current != null) {
                this.missing += (long)this.current.counts[0];
                this.total += (long)(this.current.total - this.current.counts[0]);
                if (this.current.values.ordinals().getNumOrds() > 0) {
                    TermsStringOrdinalsFacetExecutor.this.aggregators.add(this.current);
                }
                this.current = null;
            }
            TermsStringOrdinalsFacetExecutor.this.missing = this.missing;
            TermsStringOrdinalsFacetExecutor.this.total = this.total;
        }
    }
}

