/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats.longs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.LongFacetAggregatorBase;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.longs.InternalTermsStatsLongFacet;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStatsLongFacetExecutor
extends FacetExecutor {
    private final TermsStatsFacet.ComparatorType comparatorType;
    final IndexNumericFieldData keyIndexFieldData;
    final IndexNumericFieldData valueIndexFieldData;
    final SearchScript script;
    private final int size;
    final ExtTLongObjectHashMap<InternalTermsStatsLongFacet.LongEntry> entries;
    long missing;

    public TermsStatsLongFacetExecutor(IndexNumericFieldData keyIndexFieldData, IndexNumericFieldData valueIndexFieldData, SearchScript script, int size, TermsStatsFacet.ComparatorType comparatorType, SearchContext context) {
        this.size = size;
        this.comparatorType = comparatorType;
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueIndexFieldData = valueIndexFieldData;
        this.script = script;
        this.entries = CacheRecycler.popLongObjectMap();
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        InternalTermsStatsLongFacet.LongEntry value;
        if (this.entries.isEmpty()) {
            return new InternalTermsStatsLongFacet(facetName, this.comparatorType, this.size, ImmutableList.<InternalTermsStatsLongFacet.LongEntry>of(), this.missing);
        }
        if (this.size == 0) {
            return new InternalTermsStatsLongFacet(facetName, this.comparatorType, 0, this.entries.valueCollection(), this.missing);
        }
        Object[] values = this.entries.internalValues();
        Arrays.sort(values, this.comparatorType.comparator());
        int limit = this.size;
        ArrayList<InternalTermsStatsLongFacet.LongEntry> ordered = Lists.newArrayList();
        for (int i = 0; i < limit && (value = (InternalTermsStatsLongFacet.LongEntry)values[i]) != null; ++i) {
            ordered.add(value);
        }
        CacheRecycler.pushLongObjectMap(this.entries);
        return new InternalTermsStatsLongFacet(facetName, this.comparatorType, this.size, ordered, this.missing);
    }

    public static class ScriptAggregator
    extends Aggregator {
        private final SearchScript script;

        public ScriptAggregator(ExtTLongObjectHashMap<InternalTermsStatsLongFacet.LongEntry> entries, SearchScript script) {
            super(entries);
            this.script = script;
        }

        @Override
        public void onValue(int docId, long value) {
            InternalTermsStatsLongFacet.LongEntry longEntry = (InternalTermsStatsLongFacet.LongEntry)this.entries.get(value);
            if (longEntry == null) {
                longEntry = new InternalTermsStatsLongFacet.LongEntry(value, 1L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(value, longEntry);
            } else {
                ++longEntry.count;
            }
            this.script.setNextDocId(docId);
            double valueValue = this.script.runAsDouble();
            if (valueValue < longEntry.min) {
                longEntry.min = valueValue;
            }
            if (valueValue > longEntry.max) {
                longEntry.max = valueValue;
            }
            ++longEntry.totalCount;
            longEntry.total += valueValue;
        }
    }

    public static class Aggregator
    extends LongFacetAggregatorBase {
        final ExtTLongObjectHashMap<InternalTermsStatsLongFacet.LongEntry> entries;
        DoubleValues valueValues;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public Aggregator(ExtTLongObjectHashMap<InternalTermsStatsLongFacet.LongEntry> entries) {
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, long value) {
            InternalTermsStatsLongFacet.LongEntry longEntry = (InternalTermsStatsLongFacet.LongEntry)this.entries.get(value);
            if (longEntry == null) {
                longEntry = new InternalTermsStatsLongFacet.LongEntry(value, 0L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(value, longEntry);
            }
            ++longEntry.count;
            this.valueAggregator.longEntry = longEntry;
            this.valueAggregator.onDoc(docId, this.valueValues);
        }

        public static final class ValueAggregator
        extends DoubleFacetAggregatorBase {
            InternalTermsStatsLongFacet.LongEntry longEntry;

            @Override
            public void onValue(int docId, double value) {
                if (value < this.longEntry.min) {
                    this.longEntry.min = value;
                }
                if (value > this.longEntry.max) {
                    this.longEntry.max = value;
                }
                this.longEntry.total += value;
                ++this.longEntry.totalCount;
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final Aggregator aggregator;
        private LongValues keyValues;

        public Collector() {
            this.aggregator = TermsStatsLongFacetExecutor.this.script == null ? new Aggregator(TermsStatsLongFacetExecutor.this.entries) : new ScriptAggregator(TermsStatsLongFacetExecutor.this.entries, TermsStatsLongFacetExecutor.this.script);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (TermsStatsLongFacetExecutor.this.script != null) {
                TermsStatsLongFacetExecutor.this.script.setScorer(scorer);
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = ((AtomicNumericFieldData)TermsStatsLongFacetExecutor.this.keyIndexFieldData.load(context)).getLongValues();
            if (TermsStatsLongFacetExecutor.this.script != null) {
                TermsStatsLongFacetExecutor.this.script.setNextReader(context);
            } else {
                this.aggregator.valueValues = ((AtomicNumericFieldData)TermsStatsLongFacetExecutor.this.valueIndexFieldData.load(context)).getDoubleValues();
            }
        }

        public void collect(int doc) throws IOException {
            this.aggregator.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
            TermsStatsLongFacetExecutor.this.missing = this.aggregator.missing();
        }
    }
}

