/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TextFragment;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.highlight.CustomQueryScorer;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.Highlighter;
import org.elasticsearch.search.highlight.HighlighterContext;

public class PlainHighlighter
implements Highlighter {
    private static final String CACHE_KEY = "highlight-plain";

    @Override
    public String[] names() {
        return new String[]{"plain", "highlighter"};
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        field = highlighterContext.field;
        context = highlighterContext.context;
        hitContext = highlighterContext.hitContext;
        mapper = highlighterContext.mapper;
        v0 = encoder = field.encoder().equals("html") != false ? Encoders.HTML : Encoders.DEFAULT;
        if (!hitContext.cache().containsKey("highlight-plain")) {
            mappers = Maps.newHashMap();
            hitContext.cache().put("highlight-plain", mappers);
        }
        if ((entry = (org.apache.lucene.search.highlight.Highlighter)(cache = (Map)hitContext.cache().get("highlight-plain")).get(mapper)) == null) {
            query = context.parsedQuery().query();
            queryScorer = new CustomQueryScorer(query, field.requireFieldMatch() != false ? mapper.names().indexName() : null);
            queryScorer.setExpandMultiTermQuery(true);
            if (field.numberOfFragments() == 0) {
                fragmenter = new NullFragmenter();
            } else if (field.fragmenter() == null) {
                fragmenter = new SimpleSpanFragmenter((QueryScorer)queryScorer, field.fragmentCharSize());
            } else if ("simple".equals(field.fragmenter())) {
                fragmenter = new SimpleFragmenter(field.fragmentCharSize());
            } else if ("span".equals(field.fragmenter())) {
                fragmenter = new SimpleSpanFragmenter((QueryScorer)queryScorer, field.fragmentCharSize());
            } else {
                throw new ElasticSearchIllegalArgumentException("unknown fragmenter option [" + field.fragmenter() + "] for the field [" + highlighterContext.fieldName + "]");
            }
            formatter = new SimpleHTMLFormatter(field.preTags()[0], field.postTags()[0]);
            entry = new org.apache.lucene.search.highlight.Highlighter((Formatter)formatter, encoder, (Scorer)queryScorer);
            entry.setTextFragmenter((Fragmenter)fragmenter);
            entry.setMaxDocCharsToAnalyze(0x7FFFFFFF);
            cache.put(mapper, entry);
        }
        if (mapper.fieldType().stored()) {
            try {
                fieldVisitor = new CustomFieldsVisitor(ImmutableSet.of(mapper.names().indexName()), false);
                hitContext.reader().document(hitContext.docId(), (StoredFieldVisitor)fieldVisitor);
                textsToHighlight = fieldVisitor.fields().get(mapper.names().indexName());
                if (textsToHighlight != null) ** GOTO lbl47
                textsToHighlight = ImmutableList.of();
            }
            catch (Exception e) {
                throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
            }
        } else {
            lookup = context.lookup();
            lookup.setNextReader(hitContext.readerContext());
            lookup.setNextDocId(hitContext.docId());
            textsToHighlight = lookup.source().extractRawValues(mapper.names().sourcePath());
        }
lbl47:
        // 3 sources

        if (!PlainHighlighter.$assertionsDisabled && textsToHighlight == null) {
            throw new AssertionError();
        }
        numberOfFragments = field.numberOfFragments() == 0 ? 1 : field.numberOfFragments();
        fragsList = new ArrayList<TextFragment>();
        try {
            for (Object textToHighlight : textsToHighlight) {
                text = textToHighlight.toString();
                analyzer = context.mapperService().documentMapper(hitContext.hit().type()).mappers().indexAnalyzer();
                tokenStream = analyzer.tokenStream(mapper.names().indexName(), (Reader)new FastStringReader(text));
                tokenStream.reset();
                for (TextFragment bestTextFragment : bestTextFragments = entry.getBestTextFragments(tokenStream, text, false, numberOfFragments)) {
                    if (bestTextFragment == null || !(bestTextFragment.getScore() > 0.0f)) continue;
                    fragsList.add(bestTextFragment);
                }
            }
        }
        catch (Exception e) {
            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
        }
        if (field.scoreOrdered().booleanValue()) {
            Collections.sort(fragsList, new Comparator<TextFragment>(){

                @Override
                public int compare(TextFragment o1, TextFragment o2) {
                    return Math.round(o2.getScore() - o1.getScore());
                }
            });
        }
        fragments = null;
        if (field.numberOfFragments() == 0 && textsToHighlight.size() > 1 && fragsList.size() > 0) {
            fragments = new String[fragsList.size()];
            for (i = 0; i < fragsList.size(); ++i) {
                fragments[i] = ((TextFragment)fragsList.get(i)).toString();
            }
        } else {
            numberOfFragments = fragsList.size() < numberOfFragments ? fragsList.size() : numberOfFragments;
            fragments = new String[numberOfFragments];
            for (i = 0; i < fragments.length; ++i) {
                fragments[i] = ((TextFragment)fragsList.get(i)).toString();
            }
        }
        if (fragments != null && fragments.length > 0) {
            return new HighlightField(highlighterContext.fieldName, StringText.convertFromStringArray(fragments));
        }
        return null;
    }

    private static class Encoders {
        public static Encoder DEFAULT = new DefaultEncoder();
        public static Encoder HTML = new SimpleHTMLEncoder();

        private Encoders() {
        }
    }
}

