/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.ObjectMappers;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.search.nested.NestedFieldComparatorSource;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.GeoDistanceSortParser;
import org.elasticsearch.search.sort.ScriptSortParser;
import org.elasticsearch.search.sort.SortParser;

public class SortParseElement
implements SearchParseElement {
    private static final SortField SORT_SCORE = new SortField(null, SortField.Type.SCORE);
    private static final SortField SORT_SCORE_REVERSE = new SortField(null, SortField.Type.SCORE, true);
    private static final SortField SORT_DOC = new SortField(null, SortField.Type.DOC);
    private static final SortField SORT_DOC_REVERSE = new SortField(null, SortField.Type.DOC, true);
    public static final String SCORE_FIELD_NAME = "_score";
    public static final String DOC_FIELD_NAME = "_doc";
    private final ImmutableMap<String, SortParser> parsers;

    public SortParseElement() {
        ImmutableMap.Builder<String, SortParser> builder = ImmutableMap.builder();
        this.addParser(builder, new ScriptSortParser());
        this.addParser(builder, new GeoDistanceSortParser());
        this.parsers = builder.build();
    }

    private void addParser(ImmutableMap.Builder<String, SortParser> parsers, SortParser parser) {
        for (String name : parser.names()) {
            parsers.put(name, parser);
        }
    }

    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        SortField sortField;
        boolean sort;
        XContentParser.Token token = parser.currentToken();
        ArrayList<SortField> sortFields = Lists.newArrayListWithCapacity(2);
        if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.START_OBJECT) {
                    this.addCompoundSortField(parser, context, sortFields);
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    this.addSortField(context, sortFields, parser.text(), false, false, null, null, null, null);
                    continue;
                }
                throw new ElasticSearchIllegalArgumentException("malformed sort format, within the sort array, an object, or an actual string are allowed");
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            this.addSortField(context, sortFields, parser.text(), false, false, null, null, null, null);
        } else if (token == XContentParser.Token.START_OBJECT) {
            this.addCompoundSortField(parser, context, sortFields);
        } else {
            throw new ElasticSearchIllegalArgumentException("malformed sort format, either start with array, object, or an actual string");
        }
        if (!sortFields.isEmpty() && (sort = sortFields.size() > 1 ? true : (sortField = (SortField)sortFields.get(0)).getType() != SortField.Type.SCORE || sortField.getReverse())) {
            context.sort(new Sort(sortFields.toArray(new SortField[sortFields.size()])));
        }
    }

    private void addCompoundSortField(XContentParser parser, SearchContext context, List<SortField> sortFields) throws Exception {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String fieldName = parser.currentName();
            boolean reverse = false;
            String missing = null;
            String innerJsonName = null;
            boolean ignoreUnmapped = false;
            SortMode sortMode = null;
            Filter nestedFilter = null;
            String nestedPath = null;
            token = parser.nextToken();
            if (token == XContentParser.Token.VALUE_STRING) {
                String direction = parser.text();
                if (direction.equals("asc")) {
                    reverse = SCORE_FIELD_NAME.equals(fieldName);
                } else if (direction.equals("desc")) {
                    reverse = !SCORE_FIELD_NAME.equals(fieldName);
                } else {
                    throw new ElasticSearchIllegalArgumentException("sort direction [" + fieldName + "] not supported");
                }
                this.addSortField(context, sortFields, fieldName, reverse, ignoreUnmapped, missing, sortMode, nestedPath, nestedFilter);
                continue;
            }
            if (this.parsers.containsKey(fieldName)) {
                sortFields.add(this.parsers.get(fieldName).parse(parser, context));
                continue;
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    innerJsonName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("reverse".equals(innerJsonName)) {
                        reverse = parser.booleanValue();
                        continue;
                    }
                    if ("order".equals(innerJsonName)) {
                        if ("asc".equals(parser.text())) {
                            reverse = SCORE_FIELD_NAME.equals(fieldName);
                            continue;
                        }
                        if (!"desc".equals(parser.text())) continue;
                        reverse = !SCORE_FIELD_NAME.equals(fieldName);
                        continue;
                    }
                    if ("missing".equals(innerJsonName)) {
                        missing = parser.textOrNull();
                        continue;
                    }
                    if ("ignore_unmapped".equals(innerJsonName) || "ignoreUnmapped".equals(innerJsonName)) {
                        ignoreUnmapped = parser.booleanValue();
                        continue;
                    }
                    if ("mode".equals(innerJsonName)) {
                        sortMode = SortMode.fromString(parser.text());
                        continue;
                    }
                    if ("nested_path".equals(innerJsonName) || "nestedPath".equals(innerJsonName)) {
                        nestedPath = parser.text();
                        continue;
                    }
                    throw new ElasticSearchIllegalArgumentException("sort option [" + innerJsonName + "] not supported");
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if ("nested_filter".equals(innerJsonName) || "nestedFilter".equals(innerJsonName)) {
                    nestedFilter = context.queryParserService().parseInnerFilter(parser);
                    continue;
                }
                throw new ElasticSearchIllegalArgumentException("sort option [" + innerJsonName + "] not supported");
            }
            this.addSortField(context, sortFields, fieldName, reverse, ignoreUnmapped, missing, sortMode, nestedPath, nestedFilter);
        }
    }

    private void addSortField(SearchContext context, List<SortField> sortFields, String fieldName, boolean reverse, boolean ignoreUnmapped, @Nullable String missing, SortMode sortMode, String nestedPath, Filter nestedFilter) {
        if (SCORE_FIELD_NAME.equals(fieldName)) {
            if (reverse) {
                sortFields.add(SORT_SCORE_REVERSE);
            } else {
                sortFields.add(SORT_SCORE);
            }
        } else if (DOC_FIELD_NAME.equals(fieldName)) {
            if (reverse) {
                sortFields.add(SORT_DOC_REVERSE);
            } else {
                sortFields.add(SORT_DOC);
            }
        } else {
            ObjectMapper objectMapper;
            FieldMapper fieldMapper = context.smartNameFieldMapper(fieldName);
            if (fieldMapper == null) {
                if (ignoreUnmapped) {
                    return;
                }
                throw new SearchParseException(context, "No mapping found for [" + fieldName + "] in order to sort on");
            }
            if (!(fieldMapper instanceof NumberFieldMapper || sortMode != SortMode.SUM && sortMode != SortMode.AVG)) {
                sortMode = null;
            }
            if (sortMode == null) {
                sortMode = SortParseElement.resolveDefaultSortMode(reverse);
            }
            IndexFieldData.XFieldComparatorSource fieldComparatorSource = context.fieldData().getForField(fieldMapper).comparatorSource(missing, sortMode);
            if (nestedPath != null) {
                ObjectMappers objectMappers = context.mapperService().objectMapper(nestedPath);
                if (objectMappers == null) {
                    throw new ElasticSearchIllegalArgumentException("failed to find nested object mapping for explicit nested path [" + nestedPath + "]");
                }
                objectMapper = objectMappers.mapper();
                if (!objectMapper.nested().isNested()) {
                    throw new ElasticSearchIllegalArgumentException("mapping for explicit nested path is not mapped as nested: [" + nestedPath + "]");
                }
            } else {
                objectMapper = context.mapperService().resolveClosestNestedObjectMapper(fieldName);
            }
            if (objectMapper != null && objectMapper.nested().isNested()) {
                Filter rootDocumentsFilter = context.filterCache().cache(NonNestedDocsFilter.INSTANCE);
                Filter innerDocumentsFilter = nestedFilter != null ? context.filterCache().cache(nestedFilter) : context.filterCache().cache(objectMapper.nestedTypeFilter());
                fieldComparatorSource = new NestedFieldComparatorSource(sortMode, fieldComparatorSource, rootDocumentsFilter, innerDocumentsFilter);
            }
            sortFields.add(new SortField(fieldMapper.names().indexName(), (FieldComparatorSource)fieldComparatorSource, reverse));
        }
    }

    private static SortMode resolveDefaultSortMode(boolean reverse) {
        return reverse ? SortMode.MAX : SortMode.MIN;
    }
}

