/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionBuilder;
import org.elasticsearch.search.suggest.term.TermSuggestionBuilder;

public class SuggestBuilder
implements ToXContent {
    private final String name;
    private String globalText;
    private final List<SuggestionBuilder<?>> suggestions = new ArrayList();

    public SuggestBuilder() {
        this.name = null;
    }

    public SuggestBuilder(String name) {
        this.name = name;
    }

    public SuggestBuilder setText(String globalText) {
        this.globalText = globalText;
        return this;
    }

    public SuggestBuilder addSuggestion(SuggestionBuilder<?> suggestion) {
        this.suggestions.add(suggestion);
        return this;
    }

    public List<SuggestionBuilder<?>> getSuggestion() {
        return this.suggestions;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.name == null) {
            builder.startObject();
        } else {
            builder.startObject(this.name);
        }
        if (this.globalText != null) {
            builder.field("text", this.globalText);
        }
        for (SuggestionBuilder<?> suggestion : this.suggestions) {
            builder = suggestion.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static TermSuggestionBuilder termSuggestion(String name) {
        return new TermSuggestionBuilder(name);
    }

    public static PhraseSuggestionBuilder phraseSuggestion(String name) {
        return new PhraseSuggestionBuilder(name);
    }

    public static abstract class SuggestionBuilder<T>
    implements ToXContent {
        private String name;
        private String suggester;
        private String text;
        private String field;
        private String analyzer;
        private Integer size;
        private Integer shardSize;

        public SuggestionBuilder(String name, String suggester) {
            this.name = name;
            this.suggester = suggester;
        }

        public T text(String text) {
            this.text = text;
            return (T)this;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.name);
            if (this.text != null) {
                builder.field("text", this.text);
            }
            builder.startObject(this.suggester);
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.field != null) {
                builder.field("field", this.field);
            }
            if (this.size != null) {
                builder.field("size", this.size);
            }
            if (this.shardSize != null) {
                builder.field("shard_size", this.shardSize);
            }
            builder = this.innerToXContent(builder, params);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        protected abstract XContentBuilder innerToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

        public T field(String field) {
            this.field = field;
            return (T)this;
        }

        public T analyzer(String analyzer) {
            this.analyzer = analyzer;
            return (T)this;
        }

        public T size(int size) {
            if (size <= 0) {
                throw new ElasticSearchIllegalArgumentException("Size must be positive");
            }
            this.size = size;
            return (T)this;
        }

        public T shardSize(Integer shardSize) {
            this.shardSize = shardSize;
            return (T)this;
        }
    }
}

