/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;

public final class Correction {
    public static final Correction[] EMPTY = new Correction[0];
    public double score;
    public final DirectCandidateGenerator.Candidate[] candidates;

    public Correction(double score, DirectCandidateGenerator.Candidate[] candidates) {
        this.score = score;
        this.candidates = candidates;
    }

    public String toString() {
        return "Correction [score=" + this.score + ", candidates=" + Arrays.toString(this.candidates) + "]";
    }

    public BytesRef join(BytesRef separator) {
        return this.join(separator, new BytesRef());
    }

    public BytesRef join(BytesRef separator, BytesRef result) {
        BytesRef[] toJoin = new BytesRef[this.candidates.length];
        int len = separator.length * this.candidates.length - 1;
        for (int i = 0; i < toJoin.length; ++i) {
            toJoin[i] = this.candidates[i].term;
            len += toJoin[i].length;
        }
        result.offset = 0;
        result.grow(len);
        return SuggestUtils.joinPreAllocated(separator, result, toJoin);
    }
}

