/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.io.FastCharArrayReader;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.phrase.CandidateGenerator;
import org.elasticsearch.search.suggest.phrase.CandidateScorer;
import org.elasticsearch.search.suggest.phrase.Correction;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import org.elasticsearch.search.suggest.phrase.WordScorer;

public final class NoisyChannelSpellChecker {
    public static final double REAL_WORD_LIKELYHOOD = 0.95;
    private final double realWordLikelihood;
    private final boolean requireUnigram;

    public NoisyChannelSpellChecker() {
        this(0.95);
    }

    public NoisyChannelSpellChecker(double nonErrorLikelihood) {
        this(nonErrorLikelihood, true);
    }

    public NoisyChannelSpellChecker(double nonErrorLikelihood, boolean requireUnigram) {
        this.realWordLikelihood = nonErrorLikelihood;
        this.requireUnigram = requireUnigram;
    }

    public Correction[] getCorrections(TokenStream stream, final CandidateGenerator generator, float maxErrors, int numCorrections, IndexReader reader, WordScorer wordScorer, BytesRef separator, float confidence, int gramSize) throws IOException {
        final ArrayList candidateSetsList = new ArrayList();
        SuggestUtils.analyze(stream, new SuggestUtils.TokenConsumer(){
            DirectCandidateGenerator.CandidateSet currentSet = null;
            private TypeAttribute typeAttribute;
            private final BytesRef termsRef = new BytesRef();
            private boolean anyUnigram = false;
            private boolean anyTokens = false;

            @Override
            public void reset(TokenStream stream) {
                super.reset(stream);
                this.typeAttribute = (TypeAttribute)stream.addAttribute(TypeAttribute.class);
            }

            @Override
            public void nextToken() throws IOException {
                this.anyTokens = true;
                BytesRef term = this.fillBytesRef(this.termsRef);
                if (NoisyChannelSpellChecker.this.requireUnigram && this.typeAttribute.type() == "shingle") {
                    return;
                }
                this.anyUnigram = true;
                if (this.posIncAttr.getPositionIncrement() == 0 && this.typeAttribute.type() == "SYNONYM") {
                    assert (this.currentSet != null);
                    long freq = 0L;
                    freq = generator.frequency(term);
                    if (freq > 0L) {
                        this.currentSet.addOneCandidate(generator.createCandidate(BytesRef.deepCopyOf((BytesRef)term), freq, NoisyChannelSpellChecker.this.realWordLikelihood));
                    }
                } else {
                    if (this.currentSet != null) {
                        candidateSetsList.add(this.currentSet);
                    }
                    this.currentSet = new DirectCandidateGenerator.CandidateSet(DirectCandidateGenerator.Candidate.EMPTY, generator.createCandidate(BytesRef.deepCopyOf((BytesRef)term)));
                }
            }

            @Override
            public void end() {
                if (this.currentSet != null) {
                    candidateSetsList.add(this.currentSet);
                }
                if (NoisyChannelSpellChecker.this.requireUnigram && !this.anyUnigram && this.anyTokens) {
                    throw new IllegalStateException("At least one unigram is required but all tokens were ngrams");
                }
            }
        });
        if (candidateSetsList.isEmpty()) {
            return Correction.EMPTY;
        }
        for (DirectCandidateGenerator.CandidateSet candidateSet : candidateSetsList) {
            generator.drawCandidates(candidateSet);
        }
        double cutoffScore = Double.MIN_VALUE;
        CandidateScorer scorer = new CandidateScorer(wordScorer, numCorrections, gramSize);
        DirectCandidateGenerator.CandidateSet[] candidateSets = candidateSetsList.toArray(new DirectCandidateGenerator.CandidateSet[candidateSetsList.size()]);
        if ((double)confidence > 0.0) {
            DirectCandidateGenerator.Candidate[] candidates = new DirectCandidateGenerator.Candidate[candidateSets.length];
            for (int i = 0; i < candidates.length; ++i) {
                candidates[i] = candidateSets[i].originalTerm;
            }
            cutoffScore = scorer.score(candidates, candidateSets);
        }
        Correction[] findBestCandiates = scorer.findBestCandiates(candidateSets, maxErrors, cutoffScore * (double)confidence);
        return findBestCandiates;
    }

    public Correction[] getCorrections(Analyzer analyzer, BytesRef query, CandidateGenerator generator, float maxErrors, int numCorrections, IndexReader reader, String analysisField, WordScorer scorer, float confidence, int gramSize) throws IOException {
        return this.getCorrections(this.tokenStream(analyzer, query, new CharsRef(), analysisField), generator, maxErrors, numCorrections, reader, scorer, new BytesRef((CharSequence)" "), confidence, gramSize);
    }

    public TokenStream tokenStream(Analyzer analyzer, BytesRef query, CharsRef spare, String field) throws IOException {
        UnicodeUtil.UTF8toUTF16((BytesRef)query, (CharsRef)spare);
        return analyzer.tokenStream(field, (Reader)new FastCharArrayReader(spare.chars, spare.offset, spare.length));
    }
}

