/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.term;

import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.suggest.DirectSpellcheckerSettings;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.term.TermSuggester;
import org.elasticsearch.search.suggest.term.TermSuggestionContext;

public final class TermSuggestParser
implements SuggestContextParser {
    private final TermSuggester suggester = new TermSuggester();

    @Override
    public SuggestionSearchContext.SuggestionContext parse(XContentParser parser, MapperService mapperService) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        TermSuggestionContext suggestion = new TermSuggestionContext((Suggester<? extends TermSuggestionContext>)this.suggester);
        DirectSpellcheckerSettings settings = suggestion.getDirectSpellCheckerSettings();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                this.parseTokenValue(parser, mapperService, fieldName, suggestion, settings);
                continue;
            }
            throw new ElasticSearchIllegalArgumentException("suggester[term]  doesn't support field [" + fieldName + "]");
        }
        return suggestion;
    }

    private void parseTokenValue(XContentParser parser, MapperService mapperService, String fieldName, TermSuggestionContext suggestion, DirectSpellcheckerSettings settings) throws IOException {
        if (!SuggestUtils.parseSuggestContext(parser, mapperService, fieldName, suggestion) && !SuggestUtils.parseDirectSpellcheckerSettings(parser, fieldName, settings)) {
            throw new ElasticSearchIllegalArgumentException("suggester[term] doesn't support [" + fieldName + "]");
        }
    }
}

