/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Modules;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.local.LocalTransportModule;
import org.elasticsearch.transport.netty.NettyTransportModule;

public class TransportModule
extends AbstractModule
implements SpawnModules {
    private final Settings settings;

    public TransportModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    public Iterable<? extends Module> spawnModules() {
        Class defaultTransportModule = this.settings.getAsBoolean("node.local", (Boolean)false) != false ? LocalTransportModule.class : NettyTransportModule.class;
        return ImmutableList.of(Modules.createModule(this.settings.getAsClass("transport.type", defaultTransportModule, "org.elasticsearch.transport.", "TransportModule"), this.settings));
    }

    @Override
    protected void configure() {
        this.bind(TransportService.class).asEagerSingleton();
    }
}

