/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities;

import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;

public class ChangeAuthSpec {
    public static final String _rcsid = "@(#)$Id: ChangeAuthSpec.java 988245 2010-08-23 18:39:35Z kwright $";

    private ChangeAuthSpec() {
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: ChangeAuthSpec <connection_name> <connection_xml>");
            System.exit(1);
        }
        String connectionName = args[0];
        String connectionXML = args[1];
        try {
            ManifoldCF.initializeEnvironment();
            IThreadContext tc = ThreadContextFactory.make();
            IAuthorityConnectionManager connManager = AuthorityConnectionManagerFactory.make(tc);
            IAuthorityConnection conn = connManager.load(connectionName);
            if (conn == null) {
                System.err.println("No such connection: '" + connectionName + "'");
                System.exit(3);
            }
            conn.getConfigParams().fromXML(connectionXML);
            connManager.save(conn);
            System.out.println("Authority specification has been changed");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

