/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities;

import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnector;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.interfaces.UTF8Stdout;

public class CheckAll {
    public static final String _rcsid = "@(#)$Id: CheckAll.java 988245 2010-08-23 18:39:35Z kwright $";

    private CheckAll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 0) {
            System.err.println("Usage: CheckAll");
            System.exit(1);
        }
        try {
            ManifoldCF.initializeEnvironment();
            IThreadContext tc = ThreadContextFactory.make();
            IAuthorityConnectionManager mgr = AuthorityConnectionManagerFactory.make(tc);
            IAuthorityConnection[] connections = mgr.getAllConnections();
            int i = 0;
            while (i < connections.length) {
                String connectionStatus;
                String identifyingName;
                block11: {
                    IAuthorityConnection connection;
                    if ((identifyingName = (connection = connections[i++]).getDescription()) == null || identifyingName.length() == 0) {
                        identifyingName = connection.getName();
                    }
                    String className = connection.getClassName();
                    int maxCount = connection.getMaxConnections();
                    ConfigParams parameters = connection.getConfigParams();
                    try {
                        IAuthorityConnector c = AuthorityConnectorFactory.grab(tc, className, parameters, maxCount);
                        if (c != null) {
                            try {
                                connectionStatus = c.check();
                                break block11;
                            }
                            finally {
                                AuthorityConnectorFactory.release(c);
                            }
                        }
                        connectionStatus = "Connector not installed";
                    }
                    catch (ManifoldCFException e) {
                        connectionStatus = "Threw exception: '" + e.getMessage() + "'";
                    }
                }
                if (connectionStatus.startsWith("Connection working")) continue;
                UTF8Stdout.println((Object)(CheckAll.encode(identifyingName) + ":" + CheckAll.encode(connectionStatus)));
            }
            System.err.println("Done getting authority status");
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
            Logging.root.warn((Object)("Exception in CheckAll: " + e.getMessage()), (Throwable)e);
            System.exit(2);
        }
    }

    protected static String encode(String input) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) == ':') {
                sb.append('\\').append(x);
                continue;
            }
            if (x < ' ' && x >= '\u0000') {
                sb.append(' ');
                continue;
            }
            sb.append(x);
        }
        return sb.toString();
    }
}

