/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities;

import org.apache.manifoldcf.authorities.BaseAuthoritiesInitializationCommand;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorManager;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class UnRegisterAllAuthorities
extends BaseAuthoritiesInitializationCommand {
    public static final String _rcsid = "@(#)$Id: UnRegisterAllAuthorities.java 988245 2010-08-23 18:39:35Z kwright $";

    private UnRegisterAllAuthorities() {
    }

    protected void doExecute(IAuthorityConnectorManager mgr) throws ManifoldCFException {
        IResultSet classNames = mgr.getConnectors();
        int i = 0;
        while (i < classNames.getRowCount()) {
            IResultRow row = classNames.getRow(i++);
            mgr.unregisterConnector((String)row.getValue("classname"));
        }
        Logging.root.info((Object)"Successfully unregistered all connectors");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.err.println("Usage: UnRegisterAllAuthorities");
            System.exit(1);
        }
        try {
            UnRegisterAllAuthorities unRegisterAllAuthorities = new UnRegisterAllAuthorities();
            unRegisterAllAuthorities.execute();
            System.err.println("Successfully unregistered all connectors");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

