/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authority;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.manifoldcf.authorities.authority.AuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;

public class AuthorityConnectionManager
extends BaseTable
implements IAuthorityConnectionManager {
    public static final String _rcsid = "@(#)$Id: AuthorityConnectionManager.java 996524 2010-09-13 13:38:01Z kwright $";
    private static final String passwordSuffix = "password";
    protected static final String nameField = "authorityname";
    protected static final String descriptionField = "description";
    protected static final String classNameField = "classname";
    protected static final String maxCountField = "maxcount";
    protected static final String configField = "configxml";
    protected static Random random = new Random();
    ICacheManager cacheManager;
    IThreadContext threadContext;

    public AuthorityConnectionManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "authconnections");
        this.cacheManager = CacheManagerFactory.make((IThreadContext)threadContext);
        this.threadContext = threadContext;
    }

    public void install() throws ManifoldCFException {
        block0: {
            Map existing = this.getTableSchema(null, null);
            if (existing != null) break block0;
            HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
            map.put(nameField, new ColumnDescription("VARCHAR(32)", true, false, null, null, false));
            map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
            map.put(classNameField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
            map.put(maxCountField, new ColumnDescription("BIGINT", false, false, null, null, false));
            map.put(configField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
            this.performCreate(map, null);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public void exportConfiguration(OutputStream os) throws IOException, ManifoldCFException {
        ManifoldCF.writeDword((OutputStream)os, (int)1);
        IAuthorityConnection[] list = this.getAllConnections();
        ManifoldCF.writeDword((OutputStream)os, (int)list.length);
        int i = 0;
        while (i < list.length) {
            IAuthorityConnection conn = list[i++];
            ManifoldCF.writeString((OutputStream)os, (String)conn.getName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getDescription());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getClassName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getConfigParams().toXML());
            ManifoldCF.writeDword((OutputStream)os, (int)conn.getMaxConnections());
        }
    }

    public void importConfiguration(InputStream is) throws IOException, ManifoldCFException {
        int version = ManifoldCF.readDword((InputStream)is);
        if (version != 1) {
            throw new IOException("Unknown authority configuration version: " + Integer.toString(version));
        }
        int count = ManifoldCF.readDword((InputStream)is);
        for (int i = 0; i < count; ++i) {
            IAuthorityConnection conn = this.create();
            conn.setName(ManifoldCF.readString((InputStream)is));
            conn.setDescription(ManifoldCF.readString((InputStream)is));
            conn.setClassName(ManifoldCF.readString((InputStream)is));
            conn.getConfigParams().fromXML(ManifoldCF.readString((InputStream)is));
            conn.setMaxConnections(ManifoldCF.readDword((InputStream)is));
            this.save(conn);
        }
    }

    public IAuthorityConnection[] getAllConnections() throws ManifoldCFException {
        this.beginTransaction();
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(AuthorityConnectionManager.getAuthorityConnectionsKey());
            StringSet localCacheKeys = new StringSet(ssb);
            IResultSet set = this.performQuery("SELECT authorityname,lower(authorityname) AS sortfield FROM " + this.getTableName() + " ORDER BY sortfield ASC", null, localCacheKeys, null);
            String[] names = new String[set.getRowCount()];
            for (int i = 0; i < names.length; ++i) {
                IResultRow row = set.getRow(i);
                names[i] = row.getValue(nameField).toString();
            }
            IAuthorityConnection[] iAuthorityConnectionArray = this.loadMultiple(names);
            return iAuthorityConnectionArray;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public IAuthorityConnection load(String name) throws ManifoldCFException {
        return this.loadMultiple(new String[]{name})[0];
    }

    public IAuthorityConnection[] loadMultiple(String[] names) throws ManifoldCFException {
        AuthorityConnectionDescription[] objectDescriptions = new AuthorityConnectionDescription[names.length];
        StringSetBuffer ssb = new StringSetBuffer();
        for (int i = 0; i < names.length; ++i) {
            ssb.clear();
            ssb.add(AuthorityConnectionManager.getAuthorityConnectionKey(names[i]));
            objectDescriptions[i] = new AuthorityConnectionDescription(names[i], new StringSet(ssb));
        }
        AuthorityConnectionExecutor exec = new AuthorityConnectionExecutor(this, objectDescriptions);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        return exec.getResults();
    }

    public IAuthorityConnection create() throws ManifoldCFException {
        AuthorityConnection rval = new AuthorityConnection();
        return rval;
    }

    /*
     * Exception decompiling
     */
    public boolean save(IAuthorityConnection object) throws ManifoldCFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String name) throws ManifoldCFException {
        IRepositoryConnectionManager repoManager = RepositoryConnectionManagerFactory.make(this.threadContext);
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(AuthorityConnectionManager.getAuthorityConnectionsKey());
        ssb.add(AuthorityConnectionManager.getAuthorityConnectionKey(name));
        StringSet cacheKeys = new StringSet(ssb);
        ICacheHandle ch = this.cacheManager.enterCache(null, cacheKeys, this.getTransactionID());
        try {
            this.beginTransaction();
            try {
                if (repoManager.isReferenced(name)) {
                    throw new ManifoldCFException("Can't delete authority connection '" + name + "': existing repository connections refer to it");
                }
                ManifoldCF.noteConfigurationChange();
                ArrayList<String> params = new ArrayList<String>();
                params.add(name);
                this.performDelete("WHERE authorityname=?", params, null);
                this.cacheManager.invalidateKeys(ch);
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                throw e;
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            finally {
                this.endTransaction();
            }
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    public String getAuthorityNameColumn() {
        return nameField;
    }

    protected static String getAuthorityConnectionsKey() {
        return CacheKeyFactory.makeAuthorityConnectionsKey();
    }

    protected static String getAuthorityConnectionKey(String connectionName) {
        return CacheKeyFactory.makeAuthorityConnectionKey(connectionName);
    }

    protected AuthorityConnection[] getAuthorityConnectionsMultiple(String[] connectionNames) throws ManifoldCFException {
        int i;
        AuthorityConnection[] rval = new AuthorityConnection[connectionNames.length];
        HashMap<String, Integer> returnIndex = new HashMap<String, Integer>();
        for (i = 0; i < connectionNames.length; ++i) {
            rval[i] = null;
            returnIndex.put(connectionNames[i], new Integer(i));
        }
        this.beginTransaction();
        try {
            i = 0;
            StringBuffer sb = new StringBuffer();
            ArrayList<String> params = new ArrayList<String>();
            int j = 0;
            int maxIn = this.getMaxInClause();
            while (i < connectionNames.length) {
                if (j == maxIn) {
                    this.getAuthorityConnectionsChunk(rval, returnIndex, sb.toString(), params);
                    sb.setLength(0);
                    params.clear();
                    j = 0;
                }
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('?');
                params.add(connectionNames[i]);
                ++i;
                ++j;
            }
            if (j > 0) {
                this.getAuthorityConnectionsChunk(rval, returnIndex, sb.toString(), params);
            }
            AuthorityConnection[] authorityConnectionArray = rval;
            return authorityConnectionArray;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected void getAuthorityConnectionsChunk(AuthorityConnection[] rval, Map returnIndex, String idList, ArrayList params) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + nameField + " IN (" + idList + ")", params, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String name = row.getValue(nameField).toString();
            int index = (Integer)returnIndex.get(name);
            AuthorityConnection rc = new AuthorityConnection();
            rc.setIsNew(false);
            rc.setName(name);
            rc.setDescription((String)row.getValue(descriptionField));
            rc.setClassName((String)row.getValue(classNameField));
            rc.setMaxConnections((int)((Long)row.getValue(maxCountField)).longValue());
            String xml = (String)row.getValue(configField);
            if (xml != null && xml.length() > 0) {
                rc.getConfigParams().fromXML(xml);
            }
            rval[index] = rc;
        }
    }

    protected static class AuthorityConnectionExecutor
    extends ExecutorBase {
        protected AuthorityConnectionManager thisManager;
        protected AuthorityConnection[] returnValues;
        protected HashMap returnMap = new HashMap();

        public AuthorityConnectionExecutor(AuthorityConnectionManager manager, AuthorityConnectionDescription[] objectDescriptions) {
            this.thisManager = manager;
            this.returnValues = new AuthorityConnection[objectDescriptions.length];
            for (int i = 0; i < objectDescriptions.length; ++i) {
                this.returnMap.put(objectDescriptions[i].getConnectionName(), new Integer(i));
            }
        }

        public AuthorityConnection[] getResults() {
            return this.returnValues;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            String[] connectionNames = new String[objectDescriptions.length];
            for (int i = 0; i < connectionNames.length; ++i) {
                AuthorityConnectionDescription desc = (AuthorityConnectionDescription)objectDescriptions[i];
                connectionNames[i] = desc.getConnectionName();
            }
            return this.thisManager.getAuthorityConnectionsMultiple(connectionNames);
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            AuthorityConnectionDescription objectDesc = (AuthorityConnectionDescription)objectDescription;
            AuthorityConnection ci = (AuthorityConnection)cachedObject;
            if (ci != null) {
                ci = ci.duplicate();
            }
            this.returnValues[((Integer)this.returnMap.get((Object)objectDesc.getConnectionName())).intValue()] = ci;
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class AuthorityConnectionDescription
    extends BaseDescription {
        protected String connectionName;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public AuthorityConnectionDescription(String connectionName, StringSet invKeys) {
            super("authorityconnectioncache");
            this.connectionName = connectionName;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + connectionName;
            this.cacheKeys = invKeys;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public int hashCode() {
            return this.connectionName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorityConnectionDescription)) {
                return false;
            }
            AuthorityConnectionDescription d = (AuthorityConnectionDescription)((Object)o);
            return d.connectionName.equals(this.connectionName);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }
    }
}

