/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.interfaces;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnector;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorManager;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class AuthorityConnectorFactory {
    protected static Map poolHash = new HashMap();

    private AuthorityConnectorFactory() {
    }

    public static void install(IThreadContext threadContext, String className) throws ManifoldCFException {
        IAuthorityConnector connector = AuthorityConnectorFactory.getConnectorNoCheck(className);
        connector.install(threadContext);
    }

    public static void deinstall(IThreadContext threadContext, String className) throws ManifoldCFException {
        IAuthorityConnector connector = AuthorityConnectorFactory.getConnectorNoCheck(className);
        connector.deinstall(threadContext);
    }

    public static AuthorizationResponse getDefaultAuthorizationResponse(IThreadContext threadContext, String className, String userName) throws ManifoldCFException {
        IAuthorityConnector connector = AuthorityConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return null;
        }
        return connector.getDefaultAuthorizationResponse(userName);
    }

    public static void outputConfigurationHeader(IThreadContext threadContext, String className, IHTTPOutput out, ConfigParams parameters, ArrayList tabsArray) throws ManifoldCFException, IOException {
        IAuthorityConnector connector = AuthorityConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return;
        }
        connector.outputConfigurationHeader(threadContext, out, parameters, tabsArray);
    }

    public static void outputConfigurationBody(IThreadContext threadContext, String className, IHTTPOutput out, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        IAuthorityConnector connector = AuthorityConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return;
        }
        connector.outputConfigurationBody(threadContext, out, parameters, tabName);
    }

    public static String processConfigurationPost(IThreadContext threadContext, String className, IPostParameters variableContext, ConfigParams configParams) throws ManifoldCFException {
        IAuthorityConnector connector = AuthorityConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return null;
        }
        return connector.processConfigurationPost(threadContext, variableContext, configParams);
    }

    public static void viewConfiguration(IThreadContext threadContext, String className, IHTTPOutput out, ConfigParams configParams) throws ManifoldCFException, IOException {
        IAuthorityConnector connector = AuthorityConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return;
        }
        connector.viewConfiguration(threadContext, out, configParams);
    }

    public static IAuthorityConnector getConnectorNoCheck(String className) throws ManifoldCFException {
        try {
            Class theClass = ManifoldCF.findClass((String)className);
            Class[] argumentClasses = new Class[]{};
            Constructor c = theClass.getConstructor(argumentClasses);
            Object[] arguments = new Object[]{};
            Object o = c.newInstance(arguments);
            if (!(o instanceof IAuthorityConnector)) {
                throw new ManifoldCFException("Class '" + className + "' does not implement IAuthorityConnector.");
            }
            return (IAuthorityConnector)o;
        }
        catch (InvocationTargetException e) {
            Throwable z = e.getTargetException();
            if (z instanceof Error) {
                throw (Error)z;
            }
            throw (ManifoldCFException)z;
        }
        catch (ClassNotFoundException e) {
            throw new ManifoldCFException("No authority connector class '" + className + "' was found.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ManifoldCFException("No appropriate constructor for IAuthorityConnector implementation '" + className + "'.  Need xxx().", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ManifoldCFException("Protected constructor for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ManifoldCFException("Unavailable constructor for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ManifoldCFException("Shouldn't happen!!!", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ManifoldCFException("InstantiationException for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (ExceptionInInitializerError e) {
            throw new ManifoldCFException("ExceptionInInitializerError for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
        }
    }

    protected static IAuthorityConnector getConnector(IThreadContext threadContext, String className) throws ManifoldCFException {
        IAuthorityConnectorManager connMgr = AuthorityConnectorManagerFactory.make(threadContext);
        if (!connMgr.isInstalled(className)) {
            return null;
        }
        try {
            Class theClass = ManifoldCF.findClass((String)className);
            Class[] argumentClasses = new Class[]{};
            Constructor c = theClass.getConstructor(argumentClasses);
            Object[] arguments = new Object[]{};
            Object o = c.newInstance(arguments);
            if (!(o instanceof IAuthorityConnector)) {
                throw new ManifoldCFException("Class '" + className + "' does not implement IAuthorityConnector.");
            }
            return (IAuthorityConnector)o;
        }
        catch (InvocationTargetException e) {
            Throwable z = e.getTargetException();
            if (z instanceof Error) {
                throw (Error)z;
            }
            throw (ManifoldCFException)z;
        }
        catch (ClassNotFoundException e) {
            if (!connMgr.isInstalled(className)) {
                return null;
            }
            throw new ManifoldCFException("No authority connector class '" + className + "' was found.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ManifoldCFException("No appropriate constructor for IAuthorityConnector implementation '" + className + "'.  Need xxx().", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ManifoldCFException("Protected constructor for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ManifoldCFException("Unavailable constructor for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ManifoldCFException("Shouldn't happen!!!", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ManifoldCFException("InstantiationException for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (ExceptionInInitializerError e) {
            throw new ManifoldCFException("ExceptionInInitializerError for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IAuthorityConnector grab(IThreadContext threadContext, String className, ConfigParams configInfo, int maxPoolSize) throws ManifoldCFException {
        Pool p;
        PoolKey pk = new PoolKey(className, configInfo);
        Map map = poolHash;
        synchronized (map) {
            p = (Pool)poolHash.get(pk);
            if (p == null) {
                pk = new PoolKey(className, configInfo.duplicate());
                p = new Pool(pk, maxPoolSize);
                poolHash.put(pk, p);
            }
        }
        IAuthorityConnector rval = p.getConnector(threadContext);
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(IAuthorityConnector connector) throws ManifoldCFException {
        Pool p;
        if (connector == null) {
            return;
        }
        PoolKey pk = new PoolKey(connector.getClass().getName(), connector.getConfiguration());
        Map map = poolHash;
        synchronized (map) {
            p = (Pool)poolHash.get(pk);
        }
        p.releaseConnector(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollAllConnectors(IThreadContext threadContext) throws ManifoldCFException {
        Map map = poolHash;
        synchronized (map) {
            for (Pool p : poolHash.values()) {
                p.pollAll(threadContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllConnectors(IThreadContext threadContext) throws ManifoldCFException {
        Map map = poolHash;
        synchronized (map) {
            for (Pool p : poolHash.values()) {
                p.releaseAll(threadContext);
            }
        }
    }

    public static class Pool {
        protected ArrayList stack = new ArrayList();
        protected PoolKey key;
        protected int numFree;

        public Pool(PoolKey pk, int maxCount) {
            this.key = pk;
            this.numFree = maxCount;
        }

        public synchronized IAuthorityConnector getConnector(IThreadContext threadContext) throws ManifoldCFException {
            IAuthorityConnector rc;
            while (this.numFree == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException("Interrupted", (Throwable)e, 2);
                }
            }
            if (this.stack.size() == 0) {
                String className = this.key.getClassName();
                ConfigParams configParams = this.key.getParams();
                IAuthorityConnectorManager connMgr = AuthorityConnectorManagerFactory.make(threadContext);
                if (!connMgr.isInstalled(className)) {
                    return null;
                }
                try {
                    Class theClass = ManifoldCF.findClass((String)className);
                    Class[] argumentClasses = new Class[]{};
                    Constructor c = theClass.getConstructor(argumentClasses);
                    Object[] arguments = new Object[]{};
                    Object o = c.newInstance(arguments);
                    if (!(o instanceof IAuthorityConnector)) {
                        throw new ManifoldCFException("Class '" + className + "' does not implement IAuthorityConnector.");
                    }
                    rc = (IAuthorityConnector)o;
                    rc.connect(configParams);
                }
                catch (InvocationTargetException e) {
                    Throwable z = e.getTargetException();
                    if (z instanceof Error) {
                        throw (Error)z;
                    }
                    throw (ManifoldCFException)z;
                }
                catch (ClassNotFoundException e) {
                    if (!connMgr.isInstalled(className)) {
                        return null;
                    }
                    throw new ManifoldCFException("No authority connector class '" + className + "' was found.", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw new ManifoldCFException("No appropriate constructor for IAuthorityConnector implementation '" + className + "'.  Need xxx(ConfigParams).", (Throwable)e);
                }
                catch (SecurityException e) {
                    throw new ManifoldCFException("Protected constructor for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ManifoldCFException("Unavailable constructor for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw new ManifoldCFException("Shouldn't happen!!!", (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new ManifoldCFException("InstantiationException for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
                }
                catch (ExceptionInInitializerError e) {
                    throw new ManifoldCFException("ExceptionInInitializerError for IAuthorityConnector implementation '" + className + "'", (Throwable)e);
                }
            } else {
                rc = (IAuthorityConnector)this.stack.remove(this.stack.size() - 1);
            }
            --this.numFree;
            rc.setThreadContext(threadContext);
            return rc;
        }

        public synchronized void releaseConnector(IAuthorityConnector connector) throws ManifoldCFException {
            if (connector == null) {
                return;
            }
            connector.clearThreadContext();
            this.stack.add(connector);
            ++this.numFree;
            this.notifyAll();
        }

        public synchronized void pollAll(IThreadContext threadContext) throws ManifoldCFException {
            int i = 0;
            while (i < this.stack.size()) {
                IAuthorityConnector rc = (IAuthorityConnector)this.stack.get(i++);
                rc.setThreadContext(threadContext);
                rc.poll();
                rc.clearThreadContext();
            }
        }

        public synchronized void releaseAll(IThreadContext threadContext) throws ManifoldCFException {
            while (this.stack.size() > 0) {
                IAuthorityConnector rc = (IAuthorityConnector)this.stack.remove(this.stack.size() - 1);
                rc.setThreadContext(threadContext);
                rc.disconnect();
                rc.clearThreadContext();
            }
        }
    }

    public static class PoolKey {
        protected String className;
        protected ConfigParams configInfo;

        public PoolKey(String className, Map configInfo) {
            this.className = className;
            this.configInfo = new ConfigParams(configInfo);
        }

        public PoolKey(String className, ConfigParams configInfo) {
            this.className = className;
            this.configInfo = configInfo;
        }

        public String getClassName() {
            return this.className;
        }

        public ConfigParams getParams() {
            return this.configInfo;
        }

        public int hashCode() {
            return this.className.hashCode() + this.configInfo.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PoolKey)) {
                return false;
            }
            PoolKey pk = (PoolKey)o;
            return pk.className.equals(this.className) && pk.configInfo.equals((Object)this.configInfo);
        }
    }
}

