/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.system;

import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnector;
import org.apache.manifoldcf.authorities.system.AuthRequest;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.authorities.system.RequestQueue;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;

public class AuthCheckThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: AuthCheckThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected RequestQueue requestQueue;

    public AuthCheckThread(String id, RequestQueue requestQueue) throws ManifoldCFException {
        this.requestQueue = requestQueue;
        this.setName("Auth check thread " + id);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        IThreadContext threadContext = ThreadContextFactory.make();
        while (true) {
            try {
                while (true) {
                    Throwable exception;
                    AuthorizationResponse response;
                    AuthRequest theRequest;
                    block21: {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        theRequest = this.requestQueue.getRequest();
                        if (Logging.authorityService.isDebugEnabled()) {
                            Logging.authorityService.debug((Object)(" Calling connector class '" + theRequest.getClassName() + "'"));
                        }
                        response = null;
                        exception = null;
                        try {
                            IAuthorityConnector connector = AuthorityConnectorFactory.grab(threadContext, theRequest.getClassName(), theRequest.getConfigurationParams(), theRequest.getMaxConnections());
                            try {
                                if (connector == null) {
                                    exception = new ManifoldCFException("Authority connector " + theRequest.getClassName() + " is not registered.");
                                } else {
                                    try {
                                        response = connector.getAuthorizationResponse(theRequest.getUserID());
                                    }
                                    catch (ManifoldCFException e) {
                                        if (e.getErrorCode() == 2) {
                                            throw e;
                                        }
                                        Logging.authorityService.warn((Object)("Authority error: " + e.getMessage()), (Throwable)e);
                                        response = AuthorityConnectorFactory.getDefaultAuthorizationResponse(threadContext, theRequest.getClassName(), theRequest.getUserID());
                                    }
                                }
                            }
                            finally {
                                AuthorityConnectorFactory.release(connector);
                            }
                        }
                        catch (ManifoldCFException e) {
                            if (e.getErrorCode() == 2) {
                                throw e;
                            }
                            Logging.authorityService.warn((Object)("Authority connection exception: " + e.getMessage()), (Throwable)e);
                            response = AuthorityConnectorFactory.getDefaultAuthorizationResponse(threadContext, theRequest.getClassName(), theRequest.getUserID());
                            if (response == null) {
                                exception = e;
                            }
                        }
                        catch (Throwable e) {
                            Logging.authorityService.warn((Object)("Authority connection error: " + e.getMessage()), e);
                            response = AuthorityConnectorFactory.getDefaultAuthorizationResponse(threadContext, theRequest.getClassName(), theRequest.getUserID());
                            if (response != null) break block21;
                            exception = e;
                        }
                    }
                    theRequest.completeRequest(response, exception);
                }
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) break;
                Logging.authorityService.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                if (e.getErrorCode() != 3) continue;
                System.exit(1);
                continue;
            }
            catch (InterruptedException e) {
            }
            catch (Throwable e) {
                Logging.authorityService.fatal((Object)("Error tossed: " + e.getMessage()), e);
                continue;
            }
            break;
        }
    }
}

