/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.system;

import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.core.interfaces.ConfigParams;

public class AuthRequest {
    public static final String _rcsid = "@(#)$Id: AuthRequest.java 988245 2010-08-23 18:39:35Z kwright $";
    protected String userID;
    protected String className;
    protected String identifyingString;
    protected ConfigParams configParameters;
    protected int maxConnections;
    protected boolean answerComplete = false;
    protected AuthorizationResponse answerResponse = null;
    protected Throwable answerException = null;

    public AuthRequest(String userID, String className, String identifyingString, ConfigParams configParameters, int maxConnections) {
        this.userID = userID;
        this.className = className;
        this.identifyingString = identifyingString;
        this.configParameters = configParameters;
        this.maxConnections = maxConnections;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getClassName() {
        return this.className;
    }

    public String getIdentifyingString() {
        return this.identifyingString;
    }

    public ConfigParams getConfigurationParams() {
        return this.configParameters;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForComplete() throws InterruptedException {
        AuthRequest authRequest = this;
        synchronized (authRequest) {
            if (this.answerComplete) {
                return;
            }
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeRequest(AuthorizationResponse answerResponse, Throwable answerException) {
        AuthRequest authRequest = this;
        synchronized (authRequest) {
            if (this.answerComplete) {
                return;
            }
            this.answerComplete = true;
            this.answerResponse = answerResponse;
            this.answerException = answerException;
            this.notifyAll();
        }
    }

    public AuthorizationResponse getAnswerResponse() {
        return this.answerResponse;
    }

    public Throwable getAnswerException() {
        return this.answerException;
    }
}

