/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.system;

import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorManager;
import org.apache.manifoldcf.authorities.system.AuthCheckThread;
import org.apache.manifoldcf.authorities.system.IdleCleanupThread;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.authorities.system.RequestQueue;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class ManifoldCF
extends org.apache.manifoldcf.core.system.ManifoldCF {
    protected static boolean authoritiesInitialized = false;
    protected static IdleCleanupThread idleCleanupThread = null;
    protected static AuthCheckThread[] authCheckThreads = null;
    protected static int numAuthCheckThreads = 0;
    protected static final String authCheckThreadCountProperty = "org.apache.manifoldcf.authorityservice.threads";
    protected static RequestQueue requestQueue = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeEnvironment() throws ManifoldCFException {
        Integer n = initializeFlagLock;
        synchronized (n) {
            if (authoritiesInitialized) {
                return;
            }
            org.apache.manifoldcf.core.system.ManifoldCF.initializeEnvironment();
            Logging.initializeLoggers();
            Logging.setLogLevels();
            authoritiesInitialized = true;
        }
    }

    public static void installSystemTables(IThreadContext threadcontext) throws ManifoldCFException {
        IDBInterface mainDatabase = DBInterfaceFactory.make((IThreadContext)threadcontext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        IAuthorityConnectorManager connMgr = AuthorityConnectorManagerFactory.make(threadcontext);
        IAuthorityConnectionManager authConnMgr = AuthorityConnectionManagerFactory.make(threadcontext);
        mainDatabase.beginTransaction();
        try {
            connMgr.install();
            authConnMgr.install();
        }
        catch (ManifoldCFException e) {
            mainDatabase.signalRollback();
            throw e;
        }
        catch (Error e) {
            mainDatabase.signalRollback();
            throw e;
        }
        finally {
            mainDatabase.endTransaction();
        }
    }

    public static void deinstallSystemTables(IThreadContext threadcontext) throws ManifoldCFException {
        IDBInterface mainDatabase = DBInterfaceFactory.make((IThreadContext)threadcontext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        Object se = null;
        IAuthorityConnectorManager connMgr = AuthorityConnectorManagerFactory.make(threadcontext);
        IAuthorityConnectionManager authConnMgr = AuthorityConnectionManagerFactory.make(threadcontext);
        mainDatabase.beginTransaction();
        try {
            authConnMgr.deinstall();
            connMgr.deinstall();
        }
        catch (ManifoldCFException e) {
            mainDatabase.signalRollback();
            throw e;
        }
        catch (Error e) {
            mainDatabase.signalRollback();
            throw e;
        }
        finally {
            mainDatabase.endTransaction();
        }
        if (se != null) {
            throw se;
        }
    }

    public static void startSystem(IThreadContext threadContext) throws ManifoldCFException {
        String maxThreads = ManifoldCF.getProperty((String)authCheckThreadCountProperty);
        if (maxThreads == null) {
            maxThreads = "10";
        }
        if ((numAuthCheckThreads = new Integer(maxThreads).intValue()) < 1 || numAuthCheckThreads > 100) {
            throw new ManifoldCFException("Illegal value for the number of auth check threads");
        }
        idleCleanupThread = new IdleCleanupThread();
        idleCleanupThread.start();
        requestQueue = new RequestQueue();
        authCheckThreads = new AuthCheckThread[numAuthCheckThreads];
        for (int i = 0; i < numAuthCheckThreads; ++i) {
            ManifoldCF.authCheckThreads[i] = new AuthCheckThread(Integer.toString(i), requestQueue);
            authCheckThreads[i].start();
        }
    }

    public static void stopSystem(IThreadContext threadContext) throws ManifoldCFException {
        while (idleCleanupThread != null || authCheckThreads != null) {
            int i;
            if (idleCleanupThread != null) {
                idleCleanupThread.interrupt();
            }
            if (authCheckThreads != null) {
                i = 0;
                while (i < authCheckThreads.length) {
                    AuthCheckThread authCheckThread;
                    if ((authCheckThread = authCheckThreads[i++]) == null) continue;
                    authCheckThread.interrupt();
                }
            }
            if (idleCleanupThread != null && !idleCleanupThread.isAlive()) {
                idleCleanupThread = null;
            }
            if (authCheckThreads != null) {
                boolean isAlive = false;
                for (i = 0; i < authCheckThreads.length; ++i) {
                    AuthCheckThread authCheckThread = authCheckThreads[i];
                    if (authCheckThread == null) continue;
                    if (!authCheckThread.isAlive()) {
                        ManifoldCF.authCheckThreads[i] = null;
                        continue;
                    }
                    isAlive = true;
                }
                if (!isAlive) {
                    authCheckThreads = null;
                }
            }
            try {
                ManifoldCF.sleep((long)1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        AuthorityConnectorFactory.closeAllConnectors(threadContext);
        numAuthCheckThreads = 0;
        requestQueue = null;
    }

    public static RequestQueue getRequestQueue() {
        return requestQueue;
    }
}

