/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class ChangeJobDocSpec {
    public static final String _rcsid = "@(#)$Id: ChangeJobDocSpec.java 988245 2010-08-23 18:39:35Z kwright $";

    private ChangeJobDocSpec() {
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: ChangeJobDocSpec <jobid> <filespec_xml>");
            System.exit(1);
        }
        String jobID = args[0];
        String filespecXML = args[1];
        try {
            ManifoldCF.initializeEnvironment();
            IThreadContext tc = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(tc);
            IJobDescription desc = jobManager.load(new Long(jobID));
            if (desc == null) {
                System.err.println("No such job: " + jobID);
                System.exit(3);
            }
            desc.getSpecification().fromXML(filespecXML);
            jobManager.save(desc);
            System.err.println("Job doc spec has been changed");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

