/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import java.util.Iterator;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.interfaces.UTF8Stdout;
import org.apache.manifoldcf.crawler.interfaces.EnumeratedValues;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.ScheduleRecord;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class GetJobSchedule {
    public static final String _rcsid = "@(#)$Id: GetJobSchedule.java 988245 2010-08-23 18:39:35Z kwright $";

    private GetJobSchedule() {
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: GetJobSchedule <job_id>");
            System.err.println("");
            System.err.println("The result will be UTF-8 encoded and will consist of the following columns:");
            System.err.println("    daysofweek,years,months,days,hours,minutes,timezone,duration");
            System.exit(1);
        }
        String jobID = args[0];
        try {
            ManifoldCF.initializeEnvironment();
            IThreadContext tc = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(tc);
            IJobDescription job = jobManager.load(new Long(jobID));
            if (job == null) {
                throw new ManifoldCFException("No such job: " + jobID);
            }
            int i = 0;
            while (i < job.getScheduleRecordCount()) {
                ScheduleRecord sr = job.getScheduleRecord(i++);
                UTF8Stdout.println((Object)(GetJobSchedule.enumerate(sr.getDayOfWeek()) + "," + GetJobSchedule.enumerate(sr.getYear()) + "," + GetJobSchedule.enumerate(sr.getMonthOfYear()) + "," + GetJobSchedule.enumerate(sr.getDayOfMonth()) + "," + GetJobSchedule.enumerate(sr.getHourOfDay()) + "," + GetJobSchedule.enumerate(sr.getMinutesOfHour()) + "," + (sr.getTimezone() == null ? "" : sr.getTimezone()) + "," + GetJobSchedule.presentInterval(sr.getDuration())));
            }
            System.err.println("Schedule list done");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    protected static String enumerate(EnumeratedValues ev) {
        if (ev == null) {
            return "any";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = ev.getValues();
        boolean first = true;
        while (iter.hasNext()) {
            Integer val = (Integer)iter.next();
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            sb.append(val.toString());
        }
        return sb.toString();
    }

    protected static String presentInterval(Long interval) {
        if (interval == null) {
            return "infinite";
        }
        return interval.toString();
    }

    protected static String commaEscape(String input) {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) == '\\' || x == ',') {
                output.append("\\");
            }
            output.append(x);
        }
        return output.toString();
    }
}

