/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.interfaces.UTF8Stdout;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.JobStatus;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class ListJobStatuses {
    public static final String _rcsid = "@(#)$Id: ListJobStatuses.java 991295 2010-08-31 19:12:14Z kwright $";

    private ListJobStatuses() {
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            System.err.println("Usage: ListJobStatuses");
            System.err.println("");
            System.err.println("The result will be printed to standard out, UTF-8 encoded, and will contain the following columns:");
            System.err.println("    identifier,description,status,inqueue,outstanding,processed,starttime,endtime,errortext");
            System.exit(1);
        }
        try {
            ManifoldCF.initializeEnvironment();
            IThreadContext tc = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(tc);
            JobStatus[] jobStatuses = jobManager.getAllStatus();
            int i = 0;
            while (i < jobStatuses.length) {
                JobStatus jobStatus = jobStatuses[i++];
                UTF8Stdout.println((Object)(jobStatus.getJobID().toString() + "," + (jobStatus.getDescription() == null ? "" : ListJobStatuses.commaEscape(jobStatus.getDescription())) + "," + ListJobStatuses.statusMap(jobStatus.getStatus()) + "," + new Long(jobStatus.getDocumentsInQueue()).toString() + "," + new Long(jobStatus.getDocumentsOutstanding()).toString() + "," + new Long(jobStatus.getDocumentsProcessed()).toString() + "," + new Long(jobStatus.getStartTime()).toString() + "," + new Long(jobStatus.getEndTime()).toString() + "," + (jobStatus.getErrorText() == null ? "" : ListJobStatuses.commaEscape(jobStatus.getErrorText()))));
            }
            System.err.println("Job status list done");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    protected static String statusMap(int status) {
        switch (status) {
            case 0: {
                return "not yet run";
            }
            case 1: {
                return "running";
            }
            case 2: {
                return "paused";
            }
            case 3: {
                return "done";
            }
            case 4: {
                return "waiting";
            }
            case 5: {
                return "starting up";
            }
            case 6: {
                return "cleaning up";
            }
            case 7: {
                return "error";
            }
            case 8: {
                return "aborting";
            }
            case 9: {
                return "restarting";
            }
            case 10: {
                return "running no connector";
            }
            case 11: {
                return "terminating";
            }
            case 12: {
                return "notifying";
            }
        }
        return "unknown";
    }

    protected static String commaEscape(String input) {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) < ' ') {
                x = ' ';
            }
            if (x == '\\' || x == ',') {
                output.append("\\");
            }
            output.append(x);
        }
        return output.toString();
    }
}

