/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.BaseCrawlerInitializationCommand;
import org.apache.manifoldcf.crawler.interfaces.ConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.IConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class UnRegisterAll
extends BaseCrawlerInitializationCommand {
    public static final String _rcsid = "@(#)$Id: UnRegisterAll.java 988245 2010-08-23 18:39:35Z kwright $";

    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        IConnectorManager mgr = ConnectorManagerFactory.make(tc);
        IJobManager jobManager = JobManagerFactory.make(tc);
        IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make(tc);
        IResultSet classNames = mgr.getConnectors();
        int i = 0;
        while (i < classNames.getRowCount()) {
            IResultRow row = classNames.getRow(i++);
            String className = (String)row.getValue("classname");
            database.beginTransaction();
            try {
                String[] connectionNames = connManager.findConnectionsForConnector(className);
                jobManager.noteConnectorDeregistration(connectionNames);
                mgr.unregisterConnector(className);
            }
            catch (ManifoldCFException e) {
                database.signalRollback();
                throw e;
            }
            catch (Error e) {
                database.signalRollback();
                throw e;
            }
            finally {
                database.endTransaction();
            }
        }
        Logging.root.info((Object)"Successfully unregistered all connectors");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.err.println("Usage: UnRegisterAll");
            System.exit(1);
        }
        try {
            UnRegisterAll unRegisterAll = new UnRegisterAll();
            unRegisterAll.execute();
            System.err.println("Successfully unregistered all connectors");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

