/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.interfaces;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.PerformanceStatistics;
import org.apache.manifoldcf.crawler.system.Logging;

public class QueueTracker {
    public static final String _rcsid = "@(#)$Id: QueueTracker.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final double binReductionFactor = 1.0;
    protected PerformanceStatistics performanceStatistics = new PerformanceStatistics();
    protected HashMap binCounts = new HashMap();
    protected HashMap queuedBinCounts = new HashMap();
    protected HashMap activeBinCounts = new HashMap();
    protected double currentMinimumDepth = 0.0;
    protected boolean resetInProgress = false;
    protected HashMap availablePriorities = new HashMap();
    protected HashMap binDependencies = new HashMap();
    private static final double minMsPerFetch = 50.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginReset() {
        HashMap hashMap = this.binCounts;
        synchronized (hashMap) {
            this.binCounts.clear();
            this.currentMinimumDepth = 0.0;
            this.availablePriorities.clear();
            this.binDependencies.clear();
            this.resetInProgress = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endReset() {
        HashMap hashMap = this.binCounts;
        synchronized (hashMap) {
            this.resetInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(String[] binNames) {
        if (Logging.scheduling.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            int j = 0;
            while (j < binNames.length) {
                sb.append(binNames[j++]).append(" ");
            }
            Logging.scheduling.debug((Object)("Putting document with bins [" + sb.toString() + "] onto active queue"));
        }
        int i = 0;
        while (i < binNames.length) {
            String binName = binNames[i++];
            HashMap hashMap = this.queuedBinCounts;
            synchronized (hashMap) {
                BinCount value = (BinCount)this.queuedBinCounts.get(binName);
                if (value == null) {
                    value = new BinCount();
                    this.queuedBinCounts.put(binName, value);
                }
                value.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePriorityNotUsed(String[] binNames, IRepositoryConnection connection, double priority) {
        PriorityKey pk = new PriorityKey(binNames);
        HashMap hashMap = this.binCounts;
        synchronized (hashMap) {
            ArrayList<Double> value = (ArrayList<Double>)this.availablePriorities.get(pk);
            if (value == null) {
                value = new ArrayList<Double>();
                this.availablePriorities.put(pk, value);
            }
            int begin = 0;
            int end = value.size();
            while (true) {
                if (end == begin) break;
                int middle = begin + end >> 1;
                Double middleValue = (Double)value.get(middle);
                if (middleValue < priority) {
                    end = middle;
                    continue;
                }
                begin = middle + 1;
            }
            value.add(end, new Double(priority));
            int i = 0;
            while (i < binNames.length) {
                String binName;
                HashMap<PriorityKey, PriorityKey> hm;
                if ((hm = (HashMap<PriorityKey, PriorityKey>)this.binDependencies.get(binName = binNames[i++])) == null) {
                    hm = new HashMap<PriorityKey, PriorityKey>();
                    this.binDependencies.put(binName, hm);
                }
                hm.put(pk, pk);
            }
        }
    }

    public void noteConnectionPerformance(int docCount, String connectionName, long elapsedTime) {
        if (Logging.scheduling.isDebugEnabled()) {
            Logging.scheduling.debug((Object)("Worker thread for connection " + connectionName + " took " + new Long(elapsedTime).toString() + "ms to handle " + Integer.toString(docCount) + " documents"));
        }
        this.performanceStatistics.noteDocumentsCompleted(connectionName, docCount, elapsedTime);
    }

    public PerformanceStatistics getCurrentStatistics() {
        return this.performanceStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginProcessing(String[] binNames) {
        if (Logging.scheduling.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            int j = 0;
            while (j < binNames.length) {
                sb.append(binNames[j++]).append(" ");
            }
            Logging.scheduling.debug((Object)("Handing document with bins [" + sb.toString() + "] to worker thread"));
        }
        int i = 0;
        while (i < binNames.length) {
            BinCount value;
            String binName = binNames[i++];
            HashMap hashMap = this.queuedBinCounts;
            synchronized (hashMap) {
                value = (BinCount)this.queuedBinCounts.get(binName);
                if (value != null && value.decrement()) {
                    this.queuedBinCounts.remove(binName);
                }
            }
            hashMap = this.activeBinCounts;
            synchronized (hashMap) {
                value = (BinCount)this.activeBinCounts.get(binName);
                if (value == null) {
                    value = new BinCount();
                    this.activeBinCounts.put(binName, value);
                }
                value.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assessMinimumDepth(Double[] binNamesSet) {
        HashMap hashMap = this.binCounts;
        synchronized (hashMap) {
            if (!this.resetInProgress) {
                int j = 0;
                double newMinPriority = Double.MAX_VALUE;
                while (j < binNamesSet.length) {
                    int n = j++;
                    Double binValue = binNamesSet[n];
                    if (!(binValue < newMinPriority)) continue;
                    newMinPriority = binValue;
                }
                if (newMinPriority != Double.MAX_VALUE) {
                    double newMinDepth = Math.exp(newMinPriority) - 1.0;
                    if (newMinDepth > this.currentMinimumDepth) {
                        this.currentMinimumDepth = newMinDepth;
                        if (Logging.scheduling.isDebugEnabled()) {
                            Logging.scheduling.debug((Object)("Setting new minimum depth value to " + new Double(this.currentMinimumDepth).toString()));
                        }
                    } else if (newMinDepth < this.currentMinimumDepth && Logging.scheduling.isDebugEnabled()) {
                        Logging.scheduling.debug((Object)("Minimum depth value seems to have been set too high too early! currentMin = " + new Double(this.currentMinimumDepth).toString() + "; queue value = " + new Double(newMinDepth).toString()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endProcessing(String[] binNames) {
        if (Logging.scheduling.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            int j = 0;
            while (j < binNames.length) {
                sb.append(binNames[j++]).append(" ");
            }
            Logging.scheduling.debug((Object)("Worker thread done document with bins [" + sb.toString() + "]"));
        }
        int i = 0;
        while (i < binNames.length) {
            String binName = binNames[i++];
            HashMap hashMap = this.activeBinCounts;
            synchronized (hashMap) {
                BinCount value = (BinCount)this.activeBinCounts.get(binName);
                if (value != null && value.decrement()) {
                    this.activeBinCounts.remove(binName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double calculateAssignmentRating(String[] binNames, IRepositoryConnection connection) {
        double ratingLog = 0.0;
        int i = 0;
        while (i < binNames.length) {
            String binName = binNames[i++];
            int count = 0;
            HashMap hashMap = this.activeBinCounts;
            synchronized (hashMap) {
                BinCount value = (BinCount)this.activeBinCounts.get(binName);
                if (value != null) {
                    count = value.getValue();
                }
            }
            ratingLog -= Math.log(1.0 + (double)count);
        }
        double rval = ratingLog / (double)i;
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double calculatePriority(String[] binNames, IRepositoryConnection connection) {
        HashMap hashMap = this.binCounts;
        synchronized (hashMap) {
            double returnValue;
            int i;
            double[] maxFetchRates = this.calculateMaxFetchRates(binNames, connection);
            double[] binCountScaleFactors = new double[binNames.length];
            for (i = 0; i < binNames.length; ++i) {
                HashMap hm;
                String binName = binNames[i];
                double maxFetchRate = maxFetchRates[i];
                double binCountScaleFactor = maxFetchRate == 0.0 ? Double.POSITIVE_INFINITY : 1.0 + 1.0 / (50.0 * maxFetchRate);
                binCountScaleFactors[i] = binCountScaleFactor;
                double thisCount = 0.0;
                DoubleBinCount bc = (DoubleBinCount)this.binCounts.get(binName);
                if (bc != null) {
                    thisCount = bc.getValue();
                }
                if (!(thisCount * binCountScaleFactor < this.currentMinimumDepth)) continue;
                double weightedMinimumDepth = this.currentMinimumDepth / binCountScaleFactor;
                if (Logging.scheduling.isDebugEnabled()) {
                    Logging.scheduling.debug((Object)("Resetting value of bin '" + binName + "' to " + new Double(weightedMinimumDepth).toString() + "(scale factor is " + new Double(binCountScaleFactor) + ")"));
                }
                if ((hm = (HashMap)this.binDependencies.get(binName)) != null) {
                    for (PriorityKey pk : hm.keySet()) {
                        this.availablePriorities.remove(pk);
                    }
                    this.binDependencies.remove(binName);
                }
                if (bc == null) {
                    bc = new DoubleBinCount();
                    this.binCounts.put(binName, bc);
                }
                bc.setValue(weightedMinimumDepth);
            }
            PriorityKey pk2 = new PriorityKey(binNames);
            ArrayList queuedvalue = (ArrayList)this.availablePriorities.get(pk2);
            if (queuedvalue != null && queuedvalue.size() > 0) {
                returnValue = (Double)queuedvalue.remove(queuedvalue.size() - 1);
                if (queuedvalue.size() == 0) {
                    i = 0;
                    while (i < binNames.length) {
                        String binName;
                        HashMap hm;
                        if ((hm = (HashMap)this.binDependencies.get(binName = binNames[i++])) == null) continue;
                        hm.remove(pk2);
                        if (hm.size() != 0) continue;
                        this.binDependencies.remove(binName);
                    }
                    this.availablePriorities.remove(pk2);
                }
            } else {
                double highestAdjustedCount = 0.0;
                for (i = 0; i < binNames.length; ++i) {
                    double adjustedCount;
                    String binName = binNames[i];
                    double binCountScaleFactor = binCountScaleFactors[i];
                    double thisCount = 0.0;
                    DoubleBinCount bc = (DoubleBinCount)this.binCounts.get(binName);
                    if (bc != null) {
                        thisCount = bc.getValue();
                    }
                    if (!((adjustedCount = binCountScaleFactor == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : thisCount * binCountScaleFactor) > highestAdjustedCount)) continue;
                    highestAdjustedCount = adjustedCount;
                }
                returnValue = highestAdjustedCount == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : Math.log(1.0 + highestAdjustedCount);
                for (int j = 0; j < binNames.length; ++j) {
                    String binName = binNames[j];
                    DoubleBinCount bc = (DoubleBinCount)this.binCounts.get(binName);
                    if (bc == null) {
                        bc = new DoubleBinCount();
                        this.binCounts.put(binName, bc);
                    }
                    bc.increment();
                }
            }
            if (Logging.scheduling.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                int k = 0;
                while (k < binNames.length) {
                    sb.append(binNames[k++]).append(" ");
                }
                Logging.scheduling.debug((Object)("Document with bins [" + sb.toString() + "] given priority value " + new Double(returnValue).toString()));
            }
            return returnValue;
        }
    }

    protected double[] calculateMaxFetchRates(String[] binNames, IRepositoryConnection connection) {
        ThrottleLimits tl = new ThrottleLimits(connection);
        return tl.getMaximumRates(binNames);
    }

    protected static class DoubleBinCount {
        protected double count = 0.0;

        public DoubleBinCount duplicate() {
            DoubleBinCount rval = new DoubleBinCount();
            rval.count = this.count;
            return rval;
        }

        public void increment() {
            this.count += 1.0;
        }

        public void setValue(double count) {
            this.count = count;
        }

        public double getValue() {
            return this.count;
        }
    }

    protected static class BinCount {
        protected int count = 0;

        public BinCount duplicate() {
            BinCount rval = new BinCount();
            rval.count = this.count;
            return rval;
        }

        public void increment() {
            ++this.count;
        }

        public boolean decrement() {
            --this.count;
            return this.count == 0;
        }

        public void setValue(int count) {
            this.count = count;
        }

        public int getValue() {
            return this.count;
        }
    }

    protected static class PriorityKey {
        protected String[] binNames;

        public PriorityKey(String[] binNames) {
            this.binNames = new String[binNames.length];
            for (int i = 0; i < binNames.length; ++i) {
                this.binNames[i] = binNames[i];
            }
            Arrays.sort(this.binNames);
        }

        public int hashCode() {
            int rval = 0;
            int i = 0;
            while (i < this.binNames.length) {
                rval += this.binNames[i++].hashCode();
            }
            return rval;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PriorityKey)) {
                return false;
            }
            PriorityKey p = (PriorityKey)o;
            if (this.binNames.length != p.binNames.length) {
                return false;
            }
            for (int i = 0; i < this.binNames.length; ++i) {
                if (this.binNames[i].equals(p.binNames[i])) continue;
                return false;
            }
            return true;
        }
    }

    protected static class ThrottleLimitSpec {
        protected Pattern regexp;
        protected double maxRate;

        public ThrottleLimitSpec(String regexp, double maxRate) throws PatternSyntaxException {
            this.regexp = Pattern.compile(regexp);
            this.maxRate = maxRate;
        }

        public Pattern getRegexp() {
            return this.regexp;
        }

        public double getMaxRate() {
            return this.maxRate;
        }
    }

    protected static class ThrottleLimits {
        protected ArrayList specs = new ArrayList();

        public ThrottleLimits(IRepositoryConnection connection) {
            String[] throttles = connection.getThrottles();
            for (int i = 0; i < throttles.length; ++i) {
                try {
                    this.specs.add(new ThrottleLimitSpec(throttles[i], connection.getThrottleValue(throttles[i])));
                    continue;
                }
                catch (PatternSyntaxException e) {
                    // empty catch block
                }
            }
        }

        public double[] getMaximumRates(String[] binNames) {
            double[] rval = new double[binNames.length];
            for (int j = 0; j < binNames.length; ++j) {
                String binName = binNames[j];
                double maxRate = Double.POSITIVE_INFINITY;
                int i = 0;
                while (i < this.specs.size()) {
                    double rate;
                    ThrottleLimitSpec spec;
                    Pattern p;
                    Matcher m;
                    if (!(m = (p = (spec = (ThrottleLimitSpec)this.specs.get(i++)).getRegexp()).matcher(binName)).find() || !((rate = spec.getMaxRate()) < maxRate)) continue;
                    maxRate = rate;
                }
                rval[j] = maxRate;
            }
            return rval;
        }
    }
}

