/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.interfaces;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.ConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.IConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class RepositoryConnectorFactory {
    public static final String _rcsid = "@(#)$Id: RepositoryConnectorFactory.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static Map poolHash = new HashMap();

    private RepositoryConnectorFactory() {
    }

    public static void install(IThreadContext threadContext, String className) throws ManifoldCFException {
        IRepositoryConnector connector = RepositoryConnectorFactory.getConnectorNoCheck(className);
        connector.install(threadContext);
    }

    public static void deinstall(IThreadContext threadContext, String className) throws ManifoldCFException {
        IRepositoryConnector connector = RepositoryConnectorFactory.getConnectorNoCheck(className);
        connector.deinstall(threadContext);
    }

    public static String[] getActivitiesList(IThreadContext threadContext, String className) throws ManifoldCFException {
        IRepositoryConnector connector = RepositoryConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return null;
        }
        Object[] values = connector.getActivitiesList();
        Arrays.sort(values);
        return values;
    }

    public static String[] getRelationshipTypes(IThreadContext threadContext, String className) throws ManifoldCFException {
        IRepositoryConnector connector = RepositoryConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return null;
        }
        Object[] values = connector.getRelationshipTypes();
        Arrays.sort(values);
        return values;
    }

    public static int getConnectorModel(IThreadContext threadContext, String className) throws ManifoldCFException {
        IRepositoryConnector connector = RepositoryConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return -1;
        }
        return connector.getConnectorModel();
    }

    public static void outputConfigurationHeader(IThreadContext threadContext, String className, IHTTPOutput out, ConfigParams parameters, ArrayList tabsArray) throws ManifoldCFException, IOException {
        IRepositoryConnector connector = RepositoryConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return;
        }
        connector.outputConfigurationHeader(threadContext, out, parameters, tabsArray);
    }

    public static void outputConfigurationBody(IThreadContext threadContext, String className, IHTTPOutput out, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        IRepositoryConnector connector = RepositoryConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return;
        }
        connector.outputConfigurationBody(threadContext, out, parameters, tabName);
    }

    public static String processConfigurationPost(IThreadContext threadContext, String className, IPostParameters variableContext, ConfigParams configParams) throws ManifoldCFException {
        IRepositoryConnector connector = RepositoryConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return null;
        }
        return connector.processConfigurationPost(threadContext, variableContext, configParams);
    }

    public static void viewConfiguration(IThreadContext threadContext, String className, IHTTPOutput out, ConfigParams configParams) throws ManifoldCFException, IOException {
        IRepositoryConnector connector = RepositoryConnectorFactory.getConnector(threadContext, className);
        if (connector == null) {
            return;
        }
        connector.viewConfiguration(threadContext, out, configParams);
    }

    public static IRepositoryConnector getConnectorNoCheck(String className) throws ManifoldCFException {
        try {
            Class theClass = ManifoldCF.findClass((String)className);
            Class[] argumentClasses = new Class[]{};
            Constructor c = theClass.getConstructor(argumentClasses);
            Object[] arguments = new Object[]{};
            Object o = c.newInstance(arguments);
            if (!(o instanceof IRepositoryConnector)) {
                throw new ManifoldCFException("Class '" + className + "' does not implement IRepositoryConnector.");
            }
            return (IRepositoryConnector)o;
        }
        catch (InvocationTargetException e) {
            Throwable z = e.getTargetException();
            if (z instanceof Error) {
                throw (Error)z;
            }
            throw (ManifoldCFException)z;
        }
        catch (ClassNotFoundException e) {
            throw new ManifoldCFException("No repository connector class '" + className + "' was found.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ManifoldCFException("No appropriate constructor for IRepositoryConnector implementation '" + className + "'.  Need xxx(ConfigParams).", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ManifoldCFException("Protected constructor for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ManifoldCFException("Unavailable constructor for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ManifoldCFException("Shouldn't happen!!!", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ManifoldCFException("InstantiationException for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (ExceptionInInitializerError e) {
            throw new ManifoldCFException("ExceptionInInitializerError for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
        }
    }

    protected static IRepositoryConnector getConnector(IThreadContext threadContext, String className) throws ManifoldCFException {
        IConnectorManager connMgr = ConnectorManagerFactory.make(threadContext);
        if (!connMgr.isInstalled(className)) {
            return null;
        }
        try {
            Class theClass = ManifoldCF.findClass((String)className);
            Class[] argumentClasses = new Class[]{};
            Constructor c = theClass.getConstructor(argumentClasses);
            Object[] arguments = new Object[]{};
            Object o = c.newInstance(arguments);
            if (!(o instanceof IRepositoryConnector)) {
                throw new ManifoldCFException("Class '" + className + "' does not implement IRepositoryConnector.");
            }
            return (IRepositoryConnector)o;
        }
        catch (InvocationTargetException e) {
            Throwable z = e.getTargetException();
            if (z instanceof Error) {
                throw (Error)z;
            }
            throw (ManifoldCFException)z;
        }
        catch (ClassNotFoundException e) {
            if (!connMgr.isInstalled(className)) {
                return null;
            }
            throw new ManifoldCFException("No repository connector class '" + className + "' was found.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ManifoldCFException("No appropriate constructor for IRepositoryConnector implementation '" + className + "'.  Need xxx(ConfigParams).", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ManifoldCFException("Protected constructor for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ManifoldCFException("Unavailable constructor for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ManifoldCFException("Shouldn't happen!!!", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ManifoldCFException("InstantiationException for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
        }
        catch (ExceptionInInitializerError e) {
            throw new ManifoldCFException("ExceptionInInitializerError for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
        }
    }

    public static IRepositoryConnector[] grabMultiple(IThreadContext threadContext, String[] orderingKeys, String[] classNames, ConfigParams[] configInfos, int[] maxPoolSizes) throws ManifoldCFException {
        int i;
        IRepositoryConnector[] rval = new IRepositoryConnector[classNames.length];
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        for (i = 0; i < orderingKeys.length; ++i) {
            if (orderMap.get(orderingKeys[i]) != null) {
                throw new ManifoldCFException("Found duplicate order key");
            }
            orderMap.put(orderingKeys[i], new Integer(i));
        }
        Arrays.sort(orderingKeys);
        for (i = 0; i < orderingKeys.length; ++i) {
            String orderingKey = orderingKeys[i];
            int index = (Integer)orderMap.get(orderingKey);
            String className = classNames[index];
            ConfigParams cp = configInfos[index];
            int maxPoolSize = maxPoolSizes[index];
            try {
                IRepositoryConnector connector;
                rval[index] = connector = RepositoryConnectorFactory.grab(threadContext, className, cp, maxPoolSize);
                continue;
            }
            catch (Throwable e) {
                while (i > 0) {
                    orderingKey = orderingKeys[--i];
                    index = (Integer)orderMap.get(orderingKey);
                    try {
                        RepositoryConnectorFactory.release(rval[index]);
                    }
                    catch (ManifoldCFException e2) {}
                }
                if (e instanceof ManifoldCFException) {
                    throw (ManifoldCFException)e;
                }
                throw (Error)e;
            }
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepositoryConnector grab(IThreadContext threadContext, String className, ConfigParams configInfo, int maxPoolSize) throws ManifoldCFException {
        Pool p;
        PoolKey pk = new PoolKey(className, configInfo);
        Map map = poolHash;
        synchronized (map) {
            p = (Pool)poolHash.get(pk);
            if (p == null) {
                pk = new PoolKey(className, configInfo.duplicate());
                p = new Pool(pk, maxPoolSize);
                poolHash.put(pk, p);
            }
        }
        IRepositoryConnector rval = p.getConnector(threadContext);
        return rval;
    }

    public static void releaseMultiple(IRepositoryConnector[] connectors) throws ManifoldCFException {
        int i = 0;
        ManifoldCFException currentException = null;
        while (i < connectors.length) {
            IRepositoryConnector c = connectors[i++];
            try {
                RepositoryConnectorFactory.release(c);
            }
            catch (ManifoldCFException e) {
                if (currentException != null) continue;
                currentException = e;
            }
        }
        if (currentException != null) {
            throw currentException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(IRepositoryConnector connector) throws ManifoldCFException {
        Pool p;
        if (connector == null) {
            return;
        }
        PoolKey pk = new PoolKey(connector.getClass().getName(), connector.getConfiguration());
        Map map = poolHash;
        synchronized (map) {
            p = (Pool)poolHash.get(pk);
        }
        p.releaseConnector(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollAllConnectors(IThreadContext threadContext) throws ManifoldCFException {
        Map map = poolHash;
        synchronized (map) {
            for (Pool p : poolHash.values()) {
                p.pollAll(threadContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllConnectors(IThreadContext threadContext) throws ManifoldCFException {
        Map map = poolHash;
        synchronized (map) {
            for (Pool p : poolHash.values()) {
                p.releaseAll(threadContext);
            }
        }
    }

    protected static class ConnectorTracker {
        protected IRepositoryConnector theConnector;
        protected long checkoutTime;
        protected Exception theTrace;

        public ConnectorTracker(IRepositoryConnector theConnector) {
            this.theConnector = theConnector;
            this.checkoutTime = System.currentTimeMillis();
            this.theTrace = new Exception("Stack trace");
        }

        public boolean hasExpired(long currentTime) {
            return this.checkoutTime + 300000L < currentTime;
        }

        public void printDetails() {
            Logging.threads.error((Object)("Connector instance may have been abandoned: " + this.theConnector.toString()), (Throwable)this.theTrace);
        }
    }

    public static class Pool {
        protected ArrayList stack = new ArrayList();
        protected PoolKey key;
        protected int numFree;

        public Pool(PoolKey pk, int maxCount) {
            this.key = pk;
            this.numFree = maxCount;
        }

        public synchronized IRepositoryConnector getConnector(IThreadContext threadContext) throws ManifoldCFException {
            IRepositoryConnector rc;
            while (this.numFree == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
            }
            if (this.stack.size() == 0) {
                String className = this.key.getClassName();
                ConfigParams configParams = this.key.getParams();
                IConnectorManager connMgr = ConnectorManagerFactory.make(threadContext);
                if (!connMgr.isInstalled(className)) {
                    return null;
                }
                try {
                    Class theClass = ManifoldCF.findClass((String)className);
                    Class[] argumentClasses = new Class[]{};
                    Constructor c = theClass.getConstructor(argumentClasses);
                    Object[] arguments = new Object[]{};
                    Object o = c.newInstance(arguments);
                    if (!(o instanceof IRepositoryConnector)) {
                        throw new ManifoldCFException("Class '" + className + "' does not implement IRepositoryConnector.");
                    }
                    rc = (IRepositoryConnector)o;
                    rc.connect(configParams);
                }
                catch (InvocationTargetException e) {
                    Throwable z = e.getTargetException();
                    if (z instanceof Error) {
                        throw (Error)z;
                    }
                    throw (ManifoldCFException)z;
                }
                catch (ClassNotFoundException e) {
                    if (!connMgr.isInstalled(className)) {
                        return null;
                    }
                    throw new ManifoldCFException("No repository connector class '" + className + "' was found.", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw new ManifoldCFException("No appropriate constructor for IRepositoryConnector implementation '" + className + "'.  Need xxx(ConfigParams).", (Throwable)e);
                }
                catch (SecurityException e) {
                    throw new ManifoldCFException("Protected constructor for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ManifoldCFException("Unavailable constructor for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw new ManifoldCFException("Shouldn't happen!!!", (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new ManifoldCFException("InstantiationException for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
                }
                catch (ExceptionInInitializerError e) {
                    throw new ManifoldCFException("ExceptionInInitializerError for IRepositoryConnector implementation '" + className + "'", (Throwable)e);
                }
            } else {
                rc = (IRepositoryConnector)this.stack.remove(this.stack.size() - 1);
            }
            --this.numFree;
            rc.setThreadContext(threadContext);
            return rc;
        }

        public synchronized void releaseConnector(IRepositoryConnector connector) throws ManifoldCFException {
            if (connector == null) {
                return;
            }
            connector.clearThreadContext();
            this.stack.add(connector);
            ++this.numFree;
            this.notifyAll();
        }

        public synchronized void pollAll(IThreadContext threadContext) throws ManifoldCFException {
            int i = 0;
            while (i < this.stack.size()) {
                IRepositoryConnector rc = (IRepositoryConnector)this.stack.get(i++);
                rc.setThreadContext(threadContext);
                rc.poll();
                rc.clearThreadContext();
            }
        }

        public synchronized void releaseAll(IThreadContext threadContext) throws ManifoldCFException {
            while (this.stack.size() > 0) {
                IRepositoryConnector rc = (IRepositoryConnector)this.stack.remove(this.stack.size() - 1);
                rc.setThreadContext(threadContext);
                rc.disconnect();
                rc.clearThreadContext();
            }
        }

        public synchronized void printStats() {
            System.out.println(" Class name = " + this.key.getClassName() + "; Number free = " + Integer.toString(this.numFree));
        }
    }

    public static class PoolKey {
        protected String className;
        protected ConfigParams configInfo;

        public PoolKey(String className, Map configInfo) {
            this.className = className;
            this.configInfo = new ConfigParams(configInfo);
        }

        public PoolKey(String className, ConfigParams configInfo) {
            this.className = className;
            this.configInfo = configInfo;
        }

        public String getClassName() {
            return this.className;
        }

        public ConfigParams getParams() {
            return this.configInfo;
        }

        public int hashCode() {
            return this.className.hashCode() + this.configInfo.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PoolKey)) {
                return false;
            }
            PoolKey pk = (PoolKey)o;
            return pk.className.equals(this.className) && pk.configInfo.equals((Object)this.configInfo);
        }
    }
}

