/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.system.Logging;

public class IntrinsicLink
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: IntrinsicLink.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final int LINKSTATUS_BASE = 0;
    protected static final int LINKSTATUS_NEW = 1;
    protected static final int LINKSTATUS_EXISTING = 2;
    public static final String jobIDField = "jobid";
    public static final String linkTypeField = "linktype";
    public static final String parentIDHashField = "parentidhash";
    public static final String childIDHashField = "childidhash";
    public static final String newField = "isnew";
    protected static Map linkstatusMap = new HashMap();

    public IntrinsicLink(IDBInterface database) throws ManifoldCFException {
        super(database, "intrinsiclink");
    }

    public void install(String jobsTable, String jobsColumn) throws ManifoldCFException {
        block7: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(jobIDField, new ColumnDescription("BIGINT", false, false, jobsTable, jobsColumn, false));
                map.put(linkTypeField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(parentIDHashField, new ColumnDescription("VARCHAR(40)", false, false, null, null, false));
                map.put(childIDHashField, new ColumnDescription("VARCHAR(40)", false, true, null, null, false));
                map.put(newField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription uniqueIndex = new IndexDescription(true, new String[]{jobIDField, linkTypeField, parentIDHashField, childIDHashField});
            IndexDescription jobParentIndex = new IndexDescription(false, new String[]{jobIDField, parentIDHashField});
            IndexDescription jobChildNewIndex = new IndexDescription(false, new String[]{jobIDField, childIDHashField, newField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (uniqueIndex != null && id.equals((Object)uniqueIndex)) {
                    uniqueIndex = null;
                    continue;
                }
                if (jobParentIndex != null && id.equals((Object)jobParentIndex)) {
                    jobParentIndex = null;
                    continue;
                }
                if (jobChildNewIndex != null && id.equals((Object)jobChildNewIndex)) {
                    jobChildNewIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (jobParentIndex != null) {
                this.performAddIndex(null, jobParentIndex);
            }
            if (jobChildNewIndex != null) {
                this.performAddIndex(null, jobChildNewIndex);
            }
            if (uniqueIndex == null) break block7;
            this.performAddIndex(null, uniqueIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public void analyzeTables() throws ManifoldCFException {
        long startTime = System.currentTimeMillis();
        Logging.perf.debug((Object)"Beginning to analyze intrinsiclink table");
        this.analyzeTable();
        Logging.perf.debug((Object)("Done analyzing intrinsiclink table in " + new Long(System.currentTimeMillis() - startTime) + " ms"));
    }

    public void deleteOwner(Long jobID) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        this.performDelete("WHERE jobid=?", list, null);
        this.noteModifications(0, 0, 1);
    }

    public void reset() throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> list = new ArrayList<String>();
        map.put(newField, IntrinsicLink.statusToString(0));
        list.add(IntrinsicLink.statusToString(1));
        list.add(IntrinsicLink.statusToString(2));
        this.performUpdate(map, "WHERE isnew=? OR isnew=?", list, null);
    }

    public String[] recordReferences(Long jobID, String sourceDocumentIDHash, String[] targetDocumentIDHashes, String linkType) throws ManifoldCFException {
        this.beginTransaction();
        try {
            HashMap<String, String> duplicateRemoval = new HashMap<String, String>();
            int maxClause = this.getMaxOrClause();
            StringBuffer sb = new StringBuffer();
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            int k = 0;
            HashMap presentMap = new HashMap();
            while (k < targetDocumentIDHashes.length) {
                String targetDocumentIDHash;
                if (duplicateRemoval.get(targetDocumentIDHash = targetDocumentIDHashes[k++]) != null) continue;
                duplicateRemoval.put(targetDocumentIDHash, targetDocumentIDHash);
                if (i == maxClause) {
                    this.performExistsCheck(presentMap, sb.toString(), list);
                    i = 0;
                    sb.setLength(0);
                    list.clear();
                }
                if (i > 0) {
                    sb.append(" OR");
                }
                sb.append("(").append(jobIDField).append("=? AND ").append(linkTypeField).append("=? AND ").append(parentIDHashField).append("=? AND ").append(childIDHashField).append("=?)");
                list.add(jobID);
                list.add(linkType);
                list.add(targetDocumentIDHash);
                list.add(sourceDocumentIDHash);
                ++i;
            }
            if (i > 0) {
                this.performExistsCheck(presentMap, sb.toString(), list);
            }
            int count = 0;
            for (String targetDocumentIDHash : duplicateRemoval.keySet()) {
                if (presentMap.get(targetDocumentIDHash) != null) continue;
                ++count;
            }
            String[] newReferences = new String[count];
            int j = 0;
            for (String targetDocumentIDHash : duplicateRemoval.keySet()) {
                if (presentMap.get(targetDocumentIDHash) == null) {
                    newReferences[j++] = targetDocumentIDHash;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(jobIDField, jobID);
                    map.put(parentIDHashField, targetDocumentIDHash);
                    map.put(childIDHashField, sourceDocumentIDHash);
                    map.put(linkTypeField, linkType);
                    map.put(newField, IntrinsicLink.statusToString(1));
                    this.performInsert(map, null);
                    this.noteModifications(1, 0, 0);
                    continue;
                }
                ArrayList<Object> updateList = new ArrayList<Object>();
                updateList.add(jobID);
                updateList.add(linkType);
                updateList.add(targetDocumentIDHash);
                updateList.add(sourceDocumentIDHash);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(newField, IntrinsicLink.statusToString(2));
                this.performUpdate(map, "WHERE jobid=? AND linktype=? AND parentidhash=? AND childidhash=?", updateList, null);
                this.noteModifications(0, 1, 0);
            }
            String[] stringArray = newReferences;
            return stringArray;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected void performExistsCheck(Map presentMap, String query, ArrayList list) throws ManifoldCFException {
        IResultSet result = this.performQuery("SELECT parentidhash FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
        int i = 0;
        while (i < result.getRowCount()) {
            IResultRow row = result.getRow(i++);
            String parentIDHash = (String)row.getValue(parentIDHashField);
            presentMap.put(parentIDHash, parentIDHash);
        }
    }

    public void removeLinks(Long jobID, String commonNewExpression, ArrayList commonNewParams, String[] sourceDocumentIDHashes, String sourceTableName, String sourceTableIDColumn, String sourceTableJobColumn, String sourceTableCriteria, ArrayList sourceTableParams) throws ManifoldCFException {
        this.beginTransaction();
        try {
            if (sourceDocumentIDHashes != null) {
                int maxClause = this.getMaxOrClause();
                StringBuffer sb = new StringBuffer();
                ArrayList<Object> list = new ArrayList<Object>();
                int i = 0;
                int k = 0;
                while (i < sourceDocumentIDHashes.length) {
                    if (k == maxClause) {
                        this.performRemoveLinks(sb.toString(), list, commonNewExpression, commonNewParams);
                        sb.setLength(0);
                        list.clear();
                        k = 0;
                    }
                    if (k > 0) {
                        sb.append(" OR");
                    }
                    sb.append("(").append(jobIDField).append("=? AND ").append(childIDHashField).append("=?)");
                    String sourceDocumentIDHash = sourceDocumentIDHashes[i++];
                    list.add(jobID);
                    list.add(sourceDocumentIDHash);
                    ++k;
                }
                if (k > 0) {
                    this.performRemoveLinks(sb.toString(), list, commonNewExpression, commonNewParams);
                }
                this.noteModifications(0, 0, sourceDocumentIDHashes.length);
            } else {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(jobID);
                list.addAll(sourceTableParams);
                StringBuffer sb = new StringBuffer("WHERE EXISTS(SELECT 'x' FROM ");
                sb.append(sourceTableName).append(" WHERE ").append(sourceTableJobColumn).append("=? AND ").append(sourceTableIDColumn).append("=").append(this.getTableName()).append(".").append(childIDHashField).append(" AND ").append(sourceTableCriteria).append(")");
                this.performDelete(sb.toString(), list, null);
                this.noteModifications(0, 0, 1);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected void performRemoveLinks(String query, ArrayList list, String commonNewExpression, ArrayList commonNewParams) throws ManifoldCFException {
        ArrayList thisList = new ArrayList();
        thisList.addAll(list);
        StringBuffer sb = new StringBuffer("WHERE (");
        sb.append(query).append(")");
        if (commonNewExpression != null) {
            thisList.addAll(commonNewParams);
            sb.append(" AND ").append(commonNewExpression);
        }
        this.performDelete(sb.toString(), thisList, null);
    }

    public void restoreLinks(Long jobID, String[] sourceDocumentIDHashes) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int maxClause = this.getMaxOrClause();
            StringBuffer sb = new StringBuffer();
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            int k = 0;
            while (i < sourceDocumentIDHashes.length) {
                if (k == maxClause) {
                    this.performRestoreLinks(sb.toString(), list);
                    sb.setLength(0);
                    list.clear();
                    k = 0;
                }
                if (k > 0) {
                    sb.append(" OR");
                }
                sb.append("(").append(jobIDField).append("=? AND ").append(childIDHashField).append("=?)");
                String sourceDocumentIDHash = sourceDocumentIDHashes[i++];
                list.add(jobID);
                list.add(sourceDocumentIDHash);
                ++k;
            }
            if (k > 0) {
                this.performRestoreLinks(sb.toString(), list);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
        this.noteModifications(0, sourceDocumentIDHashes.length, 0);
    }

    protected void performRestoreLinks(String query, ArrayList list) throws ManifoldCFException {
        StringBuffer sb = new StringBuffer("WHERE (");
        sb.append(query).append(") AND (").append(newField).append("=? OR ").append(newField).append("=?)");
        list.add(IntrinsicLink.statusToString(2));
        list.add(IntrinsicLink.statusToString(1));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(newField, IntrinsicLink.statusToString(0));
        this.performUpdate(map, sb.toString(), list, null);
    }

    public IResultSet getDocumentChildren(Long jobID, String parentIDHash) throws ManifoldCFException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(jobID);
        list.add(parentIDHash);
        return this.performQuery("SELECT linktype AS linktype,childidhash AS childidentifier FROM " + this.getTableName() + " WHERE " + jobIDField + "=? AND " + parentIDHashField + "=?", list, null, null);
    }

    public String[] getDocumentUniqueParents(Long jobID, String childIDHash) throws ManifoldCFException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(jobID);
        list.add(childIDHash);
        IResultSet set = this.performQuery("SELECT DISTINCT parentidhash FROM " + this.getTableName() + " WHERE " + jobIDField + "=? AND " + childIDHashField + "=?", list, null, null);
        String[] rval = new String[set.getRowCount()];
        int i = 0;
        while (i < rval.length) {
            IResultRow row = set.getRow(i);
            rval[i++] = (String)row.getValue(parentIDHashField);
        }
        return rval;
    }

    public static int stringToStatus(String status) {
        Integer value = (Integer)linkstatusMap.get(status);
        return value;
    }

    public static String statusToString(int status) {
        switch (status) {
            case 0: {
                return "B";
            }
            case 1: {
                return "N";
            }
            case 2: {
                return "E";
            }
        }
        return null;
    }

    static {
        linkstatusMap.put("B", new Integer(0));
        linkstatusMap.put("N", new Integer(1));
        linkstatusMap.put("E", new Integer(2));
    }

    protected static class DuplicateFinder
    implements ILimitChecker {
        protected Long prevJobID = null;
        protected String prevLinkType = null;
        protected String prevParentIDHash = null;
        protected String prevChildIDHash = null;

        public boolean doesCompareWork() {
            return false;
        }

        public ILimitChecker duplicate() {
            DuplicateFinder df = new DuplicateFinder();
            df.prevJobID = this.prevJobID;
            df.prevLinkType = this.prevLinkType;
            df.prevParentIDHash = this.prevParentIDHash;
            df.prevChildIDHash = this.prevChildIDHash;
            return df;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }

        public boolean checkInclude(IResultRow row) throws ManifoldCFException {
            String childIDHash;
            Long jobID = (Long)row.getValue(IntrinsicLink.jobIDField);
            String linkType = (String)row.getValue(IntrinsicLink.linkTypeField);
            String parentIDHash = (String)row.getValue(IntrinsicLink.parentIDHashField);
            if (parentIDHash == null) {
                parentIDHash = "";
            }
            if ((childIDHash = (String)row.getValue(IntrinsicLink.childIDHashField)) == null) {
                childIDHash = "";
            }
            if (this.prevJobID != null && jobID.equals(this.prevJobID) && linkType.equals(this.prevLinkType) && parentIDHash.equals(this.prevParentIDHash) && childIDHash.equals(this.prevChildIDHash)) {
                return true;
            }
            this.prevJobID = jobID;
            this.prevLinkType = linkType;
            this.prevParentIDHash = parentIDHash;
            this.prevChildIDHash = childIDHash;
            return false;
        }

        public boolean checkContinue() throws ManifoldCFException {
            return true;
        }
    }
}

