/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.OutputSpecification;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.ScheduleRecord;
import org.apache.manifoldcf.crawler.jobs.ScheduleList;

public class JobDescription
implements IJobDescription {
    public static final String _rcsid = "@(#)$Id: JobDescription.java 988245 2010-08-23 18:39:35Z kwright $";
    protected boolean isNew = true;
    protected Long id = null;
    protected String description = null;
    protected String outputConnectionName = null;
    protected String connectionName = null;
    protected int type = 0;
    protected int startMethod = 0;
    protected int priority = 5;
    protected ScheduleList scheduleList = new ScheduleList();
    protected Float rate = null;
    protected Long interval = new Long(86400000L);
    protected Long expiration = null;
    protected Long reseedInterval = new Long(3600000L);
    protected OutputSpecification outputSpecification = new OutputSpecification();
    protected DocumentSpecification documentSpecification = new DocumentSpecification();
    protected HashMap hopCountFilters = new HashMap();
    protected int hopcountMode = 0;
    protected boolean readOnly = false;

    public JobDescription duplicate(boolean readOnly) {
        if (readOnly && this.readOnly) {
            return this;
        }
        JobDescription rval = new JobDescription();
        rval.id = this.id;
        rval.isNew = this.isNew;
        rval.outputConnectionName = this.outputConnectionName;
        rval.connectionName = this.connectionName;
        rval.description = this.description;
        rval.type = this.type;
        rval.scheduleList = this.scheduleList.duplicate();
        rval.interval = this.interval;
        rval.expiration = this.expiration;
        rval.reseedInterval = this.reseedInterval;
        rval.rate = this.rate;
        rval.priority = this.priority;
        rval.startMethod = this.startMethod;
        rval.hopcountMode = this.hopcountMode;
        for (String linkType : this.hopCountFilters.keySet()) {
            Long maxHops = (Long)this.hopCountFilters.get(linkType);
            rval.hopCountFilters.put(linkType, maxHops);
        }
        rval.outputSpecification = this.outputSpecification.duplicate(readOnly);
        rval.documentSpecification = this.documentSpecification.duplicate(readOnly);
        rval.readOnly = readOnly;
        return rval;
    }

    public void makeReadOnly() {
        if (this.readOnly) {
            return;
        }
        this.readOnly = true;
        this.outputSpecification.makeReadOnly();
        this.documentSpecification.makeReadOnly();
    }

    public void setIsNew(boolean isNew) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.isNew = isNew;
    }

    public boolean getIsNew() {
        return this.isNew;
    }

    public void setID(Long id) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.id = id;
    }

    public Long getID() {
        return this.id;
    }

    public void setDescription(String description) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setOutputConnectionName(String connectionName) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.outputConnectionName = connectionName;
    }

    public String getOutputConnectionName() {
        return this.outputConnectionName;
    }

    public void setConnectionName(String connectionName) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.connectionName = connectionName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setType(int type) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setStartMethod(int startMethod) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.startMethod = startMethod;
    }

    public int getStartMethod() {
        return this.startMethod;
    }

    public void clearScheduleRecords() {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.scheduleList.clear();
    }

    public void addScheduleRecord(ScheduleRecord record) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.scheduleList.addRecord(record);
    }

    public int getScheduleRecordCount() {
        return this.scheduleList.getRecordCount();
    }

    public ScheduleRecord getScheduleRecord(int index) {
        return this.scheduleList.getRecord(index);
    }

    public void deleteScheduleRecord(int index) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.scheduleList.deleteRecord(index);
    }

    public void setInterval(Long interval) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.interval = interval;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setExpiration(Long time) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.expiration = time;
    }

    public Long getExpiration() {
        return this.expiration;
    }

    public void setReseedInterval(Long interval) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.reseedInterval = interval;
    }

    public Long getReseedInterval() {
        return this.reseedInterval;
    }

    public OutputSpecification getOutputSpecification() {
        return this.outputSpecification;
    }

    public DocumentSpecification getSpecification() {
        return this.documentSpecification;
    }

    public void setPriority(int priority) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public Map getHopCountFilters() {
        return (Map)this.hopCountFilters.clone();
    }

    public void clearHopCountFilters() {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.hopCountFilters.clear();
    }

    public void addHopCountFilter(String linkType, Long maxHops) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.hopCountFilters.put(linkType, maxHops);
    }

    public int getHopcountMode() {
        return this.hopcountMode;
    }

    public void setHopcountMode(int mode) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.hopcountMode = mode;
    }
}

