/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.BlockingDocuments;
import org.apache.manifoldcf.crawler.interfaces.BucketDescription;
import org.apache.manifoldcf.crawler.interfaces.DepthStatistics;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.DocumentSetAndFlags;
import org.apache.manifoldcf.crawler.interfaces.EnumeratedValues;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.JobStartRecord;
import org.apache.manifoldcf.crawler.interfaces.JobStatus;
import org.apache.manifoldcf.crawler.interfaces.PerformanceStatistics;
import org.apache.manifoldcf.crawler.interfaces.RegExpCriteria;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorFactory;
import org.apache.manifoldcf.crawler.interfaces.ScheduleRecord;
import org.apache.manifoldcf.crawler.interfaces.SortOrder;
import org.apache.manifoldcf.crawler.interfaces.StatusFilterCriteria;
import org.apache.manifoldcf.crawler.jobs.Carrydown;
import org.apache.manifoldcf.crawler.jobs.EventManager;
import org.apache.manifoldcf.crawler.jobs.HopCount;
import org.apache.manifoldcf.crawler.jobs.JobQueue;
import org.apache.manifoldcf.crawler.jobs.Jobs;
import org.apache.manifoldcf.crawler.jobs.PrereqEventManager;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class JobManager
implements IJobManager {
    public static final String _rcsid = "@(#)$Id: JobManager.java 998576 2010-09-19 01:11:02Z kwright $";
    protected static final String hopLock = "_HOPLOCK_";
    protected IDBInterface database;
    protected IOutputConnectionManager outputMgr;
    protected IRepositoryConnectionManager connectionMgr;
    protected ILockManager lockManager;
    protected IThreadContext threadContext;
    protected JobQueue jobQueue;
    protected Jobs jobs;
    protected HopCount hopCount;
    protected Carrydown carryDown;
    protected EventManager eventManager;
    protected static Random random = new Random();
    private static int EXTRA_FACTOR = 2;

    public JobManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        this.database = database;
        this.threadContext = threadContext;
        this.jobs = new Jobs(threadContext, database);
        this.jobQueue = new JobQueue(threadContext, database);
        this.hopCount = new HopCount(threadContext, database);
        this.carryDown = new Carrydown(database);
        this.eventManager = new EventManager(database);
        this.outputMgr = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
        this.connectionMgr = RepositoryConnectionManagerFactory.make(threadContext);
        this.lockManager = LockManagerFactory.make((IThreadContext)threadContext);
    }

    public void install() throws ManifoldCFException {
        this.jobs.install(this.outputMgr.getTableName(), this.outputMgr.getConnectionNameColumn(), this.connectionMgr.getTableName(), this.connectionMgr.getConnectionNameColumn());
        this.jobQueue.install(this.jobs.getTableName(), "id");
        this.hopCount.install(this.jobs.getTableName(), "id");
        this.carryDown.install(this.jobs.getTableName(), "id");
        this.eventManager.install();
    }

    public void deinstall() throws ManifoldCFException {
        this.eventManager.deinstall();
        this.carryDown.deinstall();
        this.hopCount.deinstall();
        this.jobQueue.deinstall();
        this.jobs.deinstall();
    }

    public void exportConfiguration(OutputStream os) throws IOException, ManifoldCFException {
        ManifoldCF.writeDword((OutputStream)os, (int)2);
        IJobDescription[] list = this.getAllJobs();
        ManifoldCF.writeDword((OutputStream)os, (int)list.length);
        int i = 0;
        while (i < list.length) {
            IJobDescription job = list[i++];
            ManifoldCF.writeString((OutputStream)os, (String)job.getConnectionName());
            ManifoldCF.writeString((OutputStream)os, (String)job.getOutputConnectionName());
            ManifoldCF.writeString((OutputStream)os, (String)job.getDescription());
            ManifoldCF.writeDword((OutputStream)os, (int)job.getType());
            ManifoldCF.writeDword((OutputStream)os, (int)job.getStartMethod());
            ManifoldCF.writeLong((OutputStream)os, (Long)job.getInterval());
            ManifoldCF.writeLong((OutputStream)os, (Long)job.getExpiration());
            ManifoldCF.writeLong((OutputStream)os, (Long)job.getReseedInterval());
            ManifoldCF.writeDword((OutputStream)os, (int)job.getPriority());
            ManifoldCF.writeDword((OutputStream)os, (int)job.getHopcountMode());
            ManifoldCF.writeString((OutputStream)os, (String)job.getSpecification().toXML());
            ManifoldCF.writeString((OutputStream)os, (String)job.getOutputSpecification().toXML());
            int recCount = job.getScheduleRecordCount();
            ManifoldCF.writeDword((OutputStream)os, (int)recCount);
            int j = 0;
            while (j < recCount) {
                ScheduleRecord sr = job.getScheduleRecord(j++);
                JobManager.writeEnumeratedValues(os, sr.getDayOfWeek());
                JobManager.writeEnumeratedValues(os, sr.getMonthOfYear());
                JobManager.writeEnumeratedValues(os, sr.getDayOfMonth());
                JobManager.writeEnumeratedValues(os, sr.getYear());
                JobManager.writeEnumeratedValues(os, sr.getHourOfDay());
                JobManager.writeEnumeratedValues(os, sr.getMinutesOfHour());
                ManifoldCF.writeString((OutputStream)os, (String)sr.getTimezone());
                ManifoldCF.writeLong((OutputStream)os, (Long)sr.getDuration());
            }
            Map filters = job.getHopCountFilters();
            ManifoldCF.writeDword((OutputStream)os, (int)filters.size());
            for (String linkType : filters.keySet()) {
                Long hopcount = (Long)filters.get(linkType);
                ManifoldCF.writeString((OutputStream)os, (String)linkType);
                ManifoldCF.writeLong((OutputStream)os, (Long)hopcount);
            }
        }
    }

    protected static void writeEnumeratedValues(OutputStream os, EnumeratedValues ev) throws IOException {
        if (ev == null) {
            ManifoldCF.writeSdword((OutputStream)os, (int)-1);
            return;
        }
        int size = ev.size();
        ManifoldCF.writeSdword((OutputStream)os, (int)size);
        Iterator iter = ev.getValues();
        while (iter.hasNext()) {
            ManifoldCF.writeDword((OutputStream)os, (int)((Integer)iter.next()));
        }
    }

    public void importConfiguration(InputStream is) throws IOException, ManifoldCFException {
        int version = ManifoldCF.readDword((InputStream)is);
        if (version != 2) {
            throw new IOException("Unknown job configuration version: " + Integer.toString(version));
        }
        int count = ManifoldCF.readDword((InputStream)is);
        for (int i = 0; i < count; ++i) {
            int j;
            IJobDescription job = this.createJob();
            job.setConnectionName(ManifoldCF.readString((InputStream)is));
            job.setOutputConnectionName(ManifoldCF.readString((InputStream)is));
            job.setDescription(ManifoldCF.readString((InputStream)is));
            job.setType(ManifoldCF.readDword((InputStream)is));
            job.setStartMethod(ManifoldCF.readDword((InputStream)is));
            job.setInterval(ManifoldCF.readLong((InputStream)is));
            job.setExpiration(ManifoldCF.readLong((InputStream)is));
            job.setReseedInterval(ManifoldCF.readLong((InputStream)is));
            job.setPriority(ManifoldCF.readDword((InputStream)is));
            job.setHopcountMode(ManifoldCF.readDword((InputStream)is));
            job.getSpecification().fromXML(ManifoldCF.readString((InputStream)is));
            job.getOutputSpecification().fromXML(ManifoldCF.readString((InputStream)is));
            int recCount = ManifoldCF.readDword((InputStream)is);
            for (j = 0; j < recCount; ++j) {
                EnumeratedValues dayOfWeek = this.readEnumeratedValues(is);
                EnumeratedValues monthOfYear = this.readEnumeratedValues(is);
                EnumeratedValues dayOfMonth = this.readEnumeratedValues(is);
                EnumeratedValues year = this.readEnumeratedValues(is);
                EnumeratedValues hourOfDay = this.readEnumeratedValues(is);
                EnumeratedValues minutesOfHour = this.readEnumeratedValues(is);
                String timezone = ManifoldCF.readString((InputStream)is);
                Long duration = ManifoldCF.readLong((InputStream)is);
                ScheduleRecord sr = new ScheduleRecord(dayOfWeek, monthOfYear, dayOfMonth, year, hourOfDay, minutesOfHour, timezone, duration);
                job.addScheduleRecord(sr);
            }
            int hopFilterCount = ManifoldCF.readDword((InputStream)is);
            for (j = 0; j < hopFilterCount; ++j) {
                String linkType = ManifoldCF.readString((InputStream)is);
                Long hopcount = ManifoldCF.readLong((InputStream)is);
                job.addHopCountFilter(linkType, hopcount);
            }
            this.save(job);
        }
    }

    protected EnumeratedValues readEnumeratedValues(InputStream is) throws IOException {
        int size = ManifoldCF.readSdword((InputStream)is);
        if (size == -1) {
            return null;
        }
        int[] values = new int[size];
        int i = 0;
        while (i < size) {
            values[i++] = ManifoldCF.readDword((InputStream)is);
        }
        return new EnumeratedValues(values);
    }

    public void noteConnectorDeregistration(String[] connectionNames) throws ManifoldCFException {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.getMaxInClause();
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteConnectionDeregistration(sb.toString(), list);
                sb.setLength(0);
                list.clear();
                currentCount = 0;
            }
            if (currentCount > 0) {
                sb.append(",");
            }
            sb.append("?");
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteConnectionDeregistration(sb.toString(), list);
        }
    }

    protected void noteConnectionDeregistration(String query, ArrayList list) throws ManifoldCFException {
        IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "connectionname" + " IN (" + query + ") FOR UPDATE", list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteConnectorDeregistration(jobID, statusValue);
        }
    }

    public void noteConnectorRegistration(String[] connectionNames) throws ManifoldCFException {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.getMaxInClause();
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteConnectionRegistration(sb.toString(), list);
                sb.setLength(0);
                list.clear();
                currentCount = 0;
            }
            if (currentCount > 0) {
                sb.append(",");
            }
            sb.append("?");
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteConnectionRegistration(sb.toString(), list);
        }
    }

    protected void noteConnectionRegistration(String query, ArrayList list) throws ManifoldCFException {
        IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "connectionname" + " IN (" + query + ") FOR UPDATE", list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteConnectorRegistration(jobID, statusValue);
        }
    }

    public void noteConnectionChange(String connectionName) throws ManifoldCFException {
        this.jobs.noteConnectionChange(connectionName);
    }

    public void noteOutputConnectorDeregistration(String[] connectionNames) throws ManifoldCFException {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.getMaxInClause();
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteOutputConnectionDeregistration(sb.toString(), list);
                sb.setLength(0);
                list.clear();
                currentCount = 0;
            }
            if (currentCount > 0) {
                sb.append(",");
            }
            sb.append("?");
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteOutputConnectionDeregistration(sb.toString(), list);
        }
    }

    protected void noteOutputConnectionDeregistration(String query, ArrayList list) throws ManifoldCFException {
        IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "outputname" + " IN (" + query + ") FOR UPDATE", list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteOutputConnectorDeregistration(jobID, statusValue);
        }
    }

    public void noteOutputConnectorRegistration(String[] connectionNames) throws ManifoldCFException {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.getMaxInClause();
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteOutputConnectionRegistration(sb.toString(), list);
                sb.setLength(0);
                list.clear();
                currentCount = 0;
            }
            if (currentCount > 0) {
                sb.append(",");
            }
            sb.append("?");
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteOutputConnectionRegistration(sb.toString(), list);
        }
    }

    protected void noteOutputConnectionRegistration(String query, ArrayList list) throws ManifoldCFException {
        IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "outputname" + " IN (" + query + ") FOR UPDATE", list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteOutputConnectorRegistration(jobID, statusValue);
        }
    }

    public void noteOutputConnectionChange(String connectionName) throws ManifoldCFException {
        this.jobs.noteOutputConnectionChange(connectionName);
    }

    public IJobDescription[] getAllJobs() throws ManifoldCFException {
        return this.jobs.getAll();
    }

    public IJobDescription createJob() throws ManifoldCFException {
        return this.jobs.create();
    }

    protected String getHopLockName(Long jobID) {
        return hopLock + jobID;
    }

    public void deleteJob(Long id) throws ManifoldCFException {
        this.database.beginTransaction();
        try {
            int status;
            block15: {
                block14: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    list.add(id);
                    IResultSet set = this.database.performQuery("SELECT " + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "id" + "=? FOR UPDATE", list, null, null);
                    if (set.getRowCount() == 0) {
                        throw new ManifoldCFException("Attempting to delete a job that doesn't exist: " + id);
                    }
                    IResultRow row = set.getRow(0);
                    status = Jobs.stringToStatus(row.getValue("status").toString());
                    if (status == 1) break block14;
                    if (status == 11) break block14;
                    if (status == 23) break block14;
                    if (status == 24) break block14;
                    if (status == 25) break block14;
                    if (status == 26) break block14;
                    if (status == 27) break block14;
                    if (status != 28) break block15;
                }
                throw new ManifoldCFException("Job " + id + " is active; you must shut it down before deleting it");
            }
            if (status != 0) {
                throw new ManifoldCFException("Job " + id + " is busy; you must wait and/or shut it down before deleting it");
            }
            this.jobs.writeStatus(id, 10);
            if (Logging.jobs.isDebugEnabled()) {
                Logging.jobs.debug((Object)("Job " + id + " marked for deletion"));
            }
        }
        catch (ManifoldCFException e) {
            this.database.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.database.signalRollback();
            throw e;
        }
        finally {
            this.database.endTransaction();
        }
    }

    public IJobDescription load(Long id) throws ManifoldCFException {
        return this.jobs.load(id, false);
    }

    public IJobDescription load(Long id, boolean readOnly) throws ManifoldCFException {
        return this.jobs.load(id, readOnly);
    }

    public void save(IJobDescription jobDescription) throws ManifoldCFException {
        ManifoldCF.noteConfigurationChange();
        this.jobs.save(jobDescription);
    }

    public boolean checkIfReference(String connectionName) throws ManifoldCFException {
        return this.jobs.checkIfReference(connectionName);
    }

    public boolean checkIfOutputReference(String connectionName) throws ManifoldCFException {
        return this.jobs.checkIfOutputReference(connectionName);
    }

    public IJobDescription[] findJobsForConnection(String connectionName) throws ManifoldCFException {
        return this.jobs.findJobsForConnection(connectionName);
    }

    public void prepareForStart() throws ManifoldCFException {
        Logging.jobs.debug((Object)"Resetting due to restart");
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.eventManager.restart();
                this.jobQueue.restart();
                this.jobs.restart();
                this.hopCount.reset();
                this.carryDown.reset();
                Logging.jobs.debug((Object)"Reset complete");
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting for restart: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void resetDocumentWorkerStatus() throws ManifoldCFException {
        Logging.jobs.debug((Object)"Resetting document active status");
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobQueue.resetDocumentWorkerStatus();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting document active status: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.debug((Object)"Reset complete");
    }

    public void resetSeedingWorkerStatus() throws ManifoldCFException {
        Logging.jobs.debug((Object)"Resetting seeding status");
        this.jobs.resetSeedingWorkerStatus();
        Logging.jobs.debug((Object)"Reset complete");
    }

    public void resetDocDeleteWorkerStatus() throws ManifoldCFException {
        Logging.jobs.debug((Object)"Resetting doc deleting status");
        this.jobQueue.resetDocDeleteWorkerStatus();
        Logging.jobs.debug((Object)"Reset complete");
    }

    public void resetDocCleanupWorkerStatus() throws ManifoldCFException {
        Logging.jobs.debug((Object)"Resetting doc cleaning status");
        this.jobQueue.resetDocCleanupWorkerStatus();
        Logging.jobs.debug((Object)"Reset complete");
    }

    public void resetDeleteStartupWorkerStatus() throws ManifoldCFException {
        Logging.jobs.debug((Object)"Resetting job delete starting up status");
        this.jobs.resetDeleteStartupWorkerStatus();
        Logging.jobs.debug((Object)"Reset complete");
    }

    public void resetNotificationWorkerStatus() throws ManifoldCFException {
        Logging.jobs.debug((Object)"Resetting notification up status");
        this.jobs.resetNotificationWorkerStatus();
        Logging.jobs.debug((Object)"Reset complete");
    }

    public void resetStartupWorkerStatus() throws ManifoldCFException {
        Logging.jobs.debug((Object)"Resetting job starting up status");
        this.jobs.resetStartupWorkerStatus();
        Logging.jobs.debug((Object)"Reset complete");
    }

    public void deleteIngestedDocumentIdentifiers(DocumentDescription[] identifiers) throws ManifoldCFException {
        this.jobQueue.deleteIngestedDocumentIdentifiers(identifiers);
    }

    public DocumentSetAndFlags getNextCleanableDocuments(int maxCount, long currentTime) throws ManifoldCFException {
        if (!this.jobs.cleaningJobsPresent()) {
            return new DocumentSetAndFlags(new DocumentDescription[0], new boolean[0]);
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)"Waiting to find documents to put on the cleaning queue");
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                int i;
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("After " + new Long(System.currentTimeMillis() - startTime).toString() + " ms, beginning query to look for documents to put on cleaning queue"));
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(JobQueue.statusToString(5));
                list.add(new Long(currentTime));
                list.add(Jobs.statusToString(3));
                list.add(JobQueue.statusToString(1));
                list.add(JobQueue.statusToString(4));
                list.add(JobQueue.statusToString(7));
                list.add(JobQueue.statusToString(8));
                list.add(JobQueue.statusToString(6));
                list.add(JobQueue.statusToString(9));
                IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "jobid" + "," + "dochash" + "," + "docid" + "," + "failtime" + "," + "failcount" + " FROM " + this.jobQueue.getTableName() + " t0 WHERE t0." + "status" + "=? " + " AND (t0." + "checktime" + " IS NULL OR t0." + "checktime" + "<=?) " + " AND EXISTS(SELECT 'x' FROM " + this.jobs.getTableName() + " t1 WHERE t0." + "jobid" + "=t1." + "id" + " AND t1." + "status" + "=?" + ") AND NOT EXISTS(SELECT 'x' FROM " + this.jobQueue.getTableName() + " t2 WHERE t0." + "dochash" + "=t2." + "dochash" + " AND t0." + "jobid" + "!=t2." + "jobid" + " AND t2." + "status" + " IN (?,?,?,?,?,?)) " + this.database.constructOffsetLimitClause(0, maxCount), list, null, null, maxCount, null);
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Done getting docs to cleaning queue after " + new Long(System.currentTimeMillis() - startTime).toString() + " ms."));
                }
                HashMap connectionNameMap = new HashMap();
                HashMap<String, DocumentDescription> documentIDMap = new HashMap<String, DocumentDescription>();
                for (i = 0; i < set.getRowCount(); ++i) {
                    ArrayList<DocumentDescription> x;
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("jobid");
                    String documentIDHash = (String)row.getValue("dochash");
                    String documentID = (String)row.getValue("docid");
                    Long failTimeValue = (Long)row.getValue("failtime");
                    Long failCountValue = (Long)row.getValue("failcount");
                    long failTime = failTimeValue == null ? -1L : failTimeValue;
                    int failCount = failCountValue == null ? 0 : (int)failCountValue.longValue();
                    IJobDescription jobDesc = this.load(jobID);
                    String connectionName = jobDesc.getConnectionName();
                    String outputConnectionName = jobDesc.getOutputConnectionName();
                    DocumentDescription dd = new DocumentDescription((Long)row.getValue("id"), jobID, documentIDHash, documentID, failTime, failCount);
                    String compositeDocumentID = JobManager.makeCompositeID(documentIDHash, connectionName);
                    documentIDMap.put(compositeDocumentID, dd);
                    HashMap<String, ArrayList<DocumentDescription>> y = (HashMap<String, ArrayList<DocumentDescription>>)connectionNameMap.get(connectionName);
                    if (y == null) {
                        y = new HashMap<String, ArrayList<DocumentDescription>>();
                        connectionNameMap.put(connectionName, y);
                    }
                    if ((x = (ArrayList<DocumentDescription>)y.get(outputConnectionName)) == null) {
                        x = new ArrayList<DocumentDescription>();
                        y.put(outputConnectionName, x);
                    }
                    x.add(dd);
                }
                HashMap<String, String> allowedDocIds = new HashMap<String, String>();
                for (String connectionName : connectionNameMap.keySet()) {
                    Map y = (Map)connectionNameMap.get(connectionName);
                    for (String outputConnectionName : y.keySet()) {
                        int j;
                        ArrayList x = (ArrayList)y.get(outputConnectionName);
                        DocumentDescription[] descriptions = new DocumentDescription[x.size()];
                        for (j = 0; j < descriptions.length; ++j) {
                            descriptions[j] = (DocumentDescription)x.get(j);
                        }
                        String[] docIDHashes = this.getUnindexableDocumentIdentifiers(descriptions, connectionName, outputConnectionName);
                        j = 0;
                        while (j < docIDHashes.length) {
                            String docIDHash = docIDHashes[j++];
                            String key = JobManager.makeCompositeID(docIDHash, connectionName);
                            allowedDocIds.put(key, docIDHash);
                        }
                    }
                }
                Object[] compositeIDArray = new String[documentIDMap.size()];
                i = 0;
                Iterator iter = documentIDMap.keySet().iterator();
                while (iter.hasNext()) {
                    compositeIDArray[i++] = (String)iter.next();
                }
                Arrays.sort(compositeIDArray);
                DocumentDescription[] rval = new DocumentDescription[documentIDMap.size()];
                boolean[] rvalBoolean = new boolean[documentIDMap.size()];
                i = 0;
                while (i < compositeIDArray.length) {
                    Object compositeDocID = compositeIDArray[i];
                    DocumentDescription dd = (DocumentDescription)documentIDMap.get(compositeDocID);
                    rvalBoolean[i] = allowedDocIds.get(compositeDocID) != null;
                    rval[i++] = dd;
                    this.jobQueue.setCleaningStatus(dd.getID());
                }
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Done pruning unindexable docs after " + new Long(System.currentTimeMillis() - startTime).toString() + " ms."));
                }
                DocumentSetAndFlags documentSetAndFlags = new DocumentSetAndFlags(rval, rvalBoolean);
                return documentSetAndFlags;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction finding deleteable docs: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    protected static String makeCompositeID(String docIDHash, String connectionName) {
        return docIDHash + ":" + connectionName;
    }

    public DocumentDescription[] getNextDeletableDocuments(int maxCount, long currentTime) throws ManifoldCFException {
        if (!this.jobs.deletingJobsPresent()) {
            return new DocumentDescription[0];
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)"Waiting to find documents to put on the delete queue");
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                int i;
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("After " + new Long(System.currentTimeMillis() - startTime).toString() + " ms, beginning query to look for documents to put on delete queue"));
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(JobQueue.statusToString(10));
                list.add(new Long(currentTime));
                list.add(Jobs.statusToString(21));
                list.add(JobQueue.statusToString(1));
                list.add(JobQueue.statusToString(4));
                list.add(JobQueue.statusToString(7));
                list.add(JobQueue.statusToString(8));
                list.add(JobQueue.statusToString(6));
                list.add(JobQueue.statusToString(9));
                IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "jobid" + "," + "dochash" + "," + "docid" + "," + "failtime" + "," + "failcount" + " FROM " + this.jobQueue.getTableName() + " t0 WHERE t0." + "status" + "=? " + " AND t0." + "checktime" + "<=? " + " AND EXISTS(SELECT 'x' FROM " + this.jobs.getTableName() + " t1 WHERE t0." + "jobid" + "=t1." + "id" + " AND t1." + "status" + "=?" + ") AND NOT EXISTS(SELECT 'x' FROM " + this.jobQueue.getTableName() + " t2 WHERE t0." + "dochash" + "=t2." + "dochash" + " AND t0." + "jobid" + "!=t2." + "jobid" + " AND t2." + "status" + " IN (?,?,?,?,?,?)) " + this.database.constructOffsetLimitClause(0, maxCount), list, null, null, maxCount, null);
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Done getting docs to delete queue after " + new Long(System.currentTimeMillis() - startTime).toString() + " ms."));
                }
                HashMap connectionNameMap = new HashMap();
                HashMap<String, DocumentDescription> documentIDMap = new HashMap<String, DocumentDescription>();
                for (i = 0; i < set.getRowCount(); ++i) {
                    ArrayList<DocumentDescription> x;
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("jobid");
                    String documentIDHash = (String)row.getValue("dochash");
                    String documentID = (String)row.getValue("docid");
                    Long failTimeValue = (Long)row.getValue("failtime");
                    Long failCountValue = (Long)row.getValue("failcount");
                    long failTime = failTimeValue == null ? -1L : failTimeValue;
                    int failCount = failCountValue == null ? 0 : (int)failCountValue.longValue();
                    IJobDescription jobDesc = this.load(jobID);
                    String connectionName = jobDesc.getConnectionName();
                    String outputConnectionName = jobDesc.getOutputConnectionName();
                    DocumentDescription dd = new DocumentDescription((Long)row.getValue("id"), jobID, documentIDHash, documentID, failTime, failCount);
                    String compositeDocumentID = JobManager.makeCompositeID(documentIDHash, connectionName);
                    documentIDMap.put(compositeDocumentID, dd);
                    HashMap<String, ArrayList<DocumentDescription>> y = (HashMap<String, ArrayList<DocumentDescription>>)connectionNameMap.get(connectionName);
                    if (y == null) {
                        y = new HashMap<String, ArrayList<DocumentDescription>>();
                        connectionNameMap.put(connectionName, y);
                    }
                    if ((x = (ArrayList<DocumentDescription>)y.get(outputConnectionName)) == null) {
                        x = new ArrayList<DocumentDescription>();
                        y.put(outputConnectionName, x);
                    }
                    x.add(dd);
                }
                HashMap<String, String> allowedDocIds = new HashMap<String, String>();
                for (String connectionName : connectionNameMap.keySet()) {
                    Map y = (Map)connectionNameMap.get(connectionName);
                    for (String outputConnectionName : y.keySet()) {
                        int j;
                        ArrayList x = (ArrayList)y.get(outputConnectionName);
                        DocumentDescription[] descriptions = new DocumentDescription[x.size()];
                        for (j = 0; j < descriptions.length; ++j) {
                            descriptions[j] = (DocumentDescription)x.get(j);
                        }
                        String[] docIDHashes = this.getUnindexableDocumentIdentifiers(descriptions, connectionName, outputConnectionName);
                        j = 0;
                        while (j < docIDHashes.length) {
                            String docIDHash = docIDHashes[j++];
                            String key = JobManager.makeCompositeID(docIDHash, connectionName);
                            allowedDocIds.put(key, docIDHash);
                        }
                    }
                }
                Object[] compositeIDArray = new String[documentIDMap.size()];
                i = 0;
                Iterator iter = documentIDMap.keySet().iterator();
                while (iter.hasNext()) {
                    compositeIDArray[i++] = (String)iter.next();
                }
                Arrays.sort(compositeIDArray);
                DocumentDescription[] rval = new DocumentDescription[allowedDocIds.size()];
                int j = 0;
                for (i = 0; i < compositeIDArray.length; ++i) {
                    Object compositeDocumentID = compositeIDArray[i];
                    DocumentDescription dd = (DocumentDescription)documentIDMap.get(compositeDocumentID);
                    if (allowedDocIds.get(compositeDocumentID) == null) {
                        this.jobQueue.deleteRecord(dd.getID());
                        continue;
                    }
                    rval[j++] = dd;
                    this.jobQueue.setDeletingStatus(dd.getID());
                }
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Done pruning unindexable docs after " + new Long(System.currentTimeMillis() - startTime).toString() + " ms."));
                }
                DocumentDescription[] documentDescriptionArray = rval;
                return documentDescriptionArray;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction finding deleteable docs: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    protected String[] getUnindexableDocumentIdentifiers(DocumentDescription[] documentIdentifiers, String connectionName, String outputConnectionName) throws ManifoldCFException {
        MutableInteger mi;
        HashMap<String, MutableInteger> countMap = new HashMap<String, MutableInteger>();
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < documentIdentifiers.length) {
            String hash = documentIdentifiers[i++].getDocumentIdentifierHash();
            map.put(hash, hash);
            countMap.put(hash, new MutableInteger(0));
        }
        if (map.size() == 0) {
            return new String[0];
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        sb.append("SELECT t0.").append("dochash").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0 WHERE t0.").append("dochash").append(" IN(");
        boolean firstTime = true;
        for (String hashValue : map.keySet()) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(',');
            }
            sb.append('?');
            list.add(hashValue);
        }
        list.add(JobQueue.statusToString(5));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.statusToString(2));
        list.add(JobQueue.statusToString(10));
        list.add(connectionName);
        list.add(outputConnectionName);
        sb.append(") AND t0.").append("status").append(" IN (?,?,?,?) AND EXISTS(SELECT 'x' FROM ").append(this.jobs.getTableName()).append(" t1 WHERE t0.").append("jobid").append("=t1.").append("id").append(" AND t1.").append("connectionname").append("=? AND t1.").append("outputname").append("=?)");
        IResultSet results = this.database.performQuery(sb.toString(), list, null, null);
        i = 0;
        while (i < results.getRowCount()) {
            IResultRow row = results.getRow(i++);
            String docIDHash = (String)row.getValue("dochash");
            mi = (MutableInteger)countMap.get(docIDHash);
            if (mi == null) continue;
            mi.increment();
        }
        int count = 0;
        for (String docIDHash : countMap.keySet()) {
            mi = (MutableInteger)countMap.get(docIDHash);
            if (mi.intValue() != 1) continue;
            ++count;
        }
        String[] rval = new String[count];
        Iterator iter = countMap.keySet().iterator();
        count = 0;
        while (iter.hasNext()) {
            String docIDHash = (String)iter.next();
            MutableInteger mi2 = (MutableInteger)countMap.get(docIDHash);
            if (mi2.intValue() != 1) continue;
            rval[count++] = docIDHash;
        }
        return rval;
    }

    public DocumentDescription[] getNextAlreadyProcessedReprioritizationDocuments(long currentTime, int n) throws ManifoldCFException {
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Long(currentTime));
        list.add(JobQueue.statusToString(2));
        list.add(JobQueue.statusToString(5));
        sb.append("SELECT ").append("id").append(",").append("dochash").append(",").append("docid").append(",").append("jobid").append(" FROM ").append(this.jobQueue.getTableName()).append(" WHERE ").append("priorityset").append("<? AND ").append("status").append(" IN(?,?) ").append(this.database.constructOffsetLimitClause(0, n));
        IResultSet set = this.database.performQuery(sb.toString(), list, null, null, n, null);
        DocumentDescription[] rval = new DocumentDescription[set.getRowCount()];
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = new DocumentDescription((Long)row.getValue("id"), (Long)row.getValue("jobid"), (String)row.getValue("dochash"), (String)row.getValue("docid"));
        }
        return rval;
    }

    public DocumentDescription[] getNextNotYetProcessedReprioritizationDocuments(long currentTime, int n) throws ManifoldCFException {
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(Jobs.statusToString(1));
        list.add(Jobs.statusToString(2));
        list.add(Jobs.statusToString(4));
        list.add(Jobs.statusToString(5));
        list.add(Jobs.statusToString(1));
        list.add(Jobs.statusToString(9));
        list.add(Jobs.statusToString(7));
        list.add(Jobs.statusToString(18));
        list.add(Jobs.statusToString(8));
        list.add(Jobs.statusToString(11));
        list.add(Jobs.statusToString(13));
        list.add(Jobs.statusToString(14));
        list.add(Jobs.statusToString(15));
        list.add(Jobs.statusToString(6));
        list.add(Jobs.statusToString(16));
        list.add(Jobs.statusToString(17));
        list.add(new Long(currentTime));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.actionToString(0));
        sb.append("SELECT ").append("id").append(",").append("dochash").append(",").append("docid").append(",").append("jobid").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0 WHERE EXISTS(SELECT 'x' FROM ").append(this.jobs.getTableName()).append(" t1 WHERE t0.").append("jobid").append("=t1.").append("id").append(" AND t1.").append("status").append(" IN(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)) AND ").append("priorityset").append("<? AND ").append("status").append(" IN(?,?) AND (").append("checkaction").append(" IS NULL OR ").append("checkaction").append("=?").append(") ").append(this.database.constructOffsetLimitClause(0, n));
        this.jobQueue.unconditionallyAnalyzeTables();
        IResultSet set = this.database.performQuery(sb.toString(), list, null, null, n, null);
        DocumentDescription[] rval = new DocumentDescription[set.getRowCount()];
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = new DocumentDescription((Long)row.getValue("id"), (Long)row.getValue("jobid"), (String)row.getValue("dochash"), (String)row.getValue("docid"));
        }
        return rval;
    }

    public void writeDocumentPriorities(long currentTime, DocumentDescription[] documentDescriptions, double[] priorities) throws ManifoldCFException {
        while (true) {
            int i;
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            Object[] docIDHashes = new String[documentDescriptions.length];
            for (i = 0; i < documentDescriptions.length; ++i) {
                String documentIDHash = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
                docIDHashes[i] = documentIDHash;
                indexMap.put(documentIDHash, new Integer(i));
            }
            Arrays.sort(docIDHashes);
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (i = 0; i < docIDHashes.length; ++i) {
                    Object docIDHash = docIDHashes[i];
                    Integer x = (Integer)indexMap.remove(docIDHash);
                    if (x == null) {
                        throw new ManifoldCFException("Assertion failure: duplicate document identifier jobid/hash detected!");
                    }
                    int index = x;
                    DocumentDescription dd = documentDescriptions[index];
                    double priority = priorities[index];
                    this.jobQueue.writeDocPriority(currentTime, dd.getID(), priorities[index]);
                    if (!Logging.perf.isDebugEnabled()) continue;
                    Logging.perf.debug((Object)("Setting document priority for '" + dd.getDocumentIdentifier() + "' to " + new Double(priority).toString() + ", set time " + new Long(currentTime).toString()));
                }
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction writing doc priorities: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public DocumentSetAndFlags getExpiredDocuments(int n, long currentTime) throws ManifoldCFException {
        if (!this.jobs.activeJobsPresent()) {
            return new DocumentSetAndFlags(new DocumentDescription[0], new boolean[0]);
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)"Beginning query to look for documents to expire");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Long(currentTime));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(Jobs.statusToString(1));
        list.add(Jobs.statusToString(11));
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.statusToString(6));
        list.add(JobQueue.statusToString(9));
        StringBuffer sb = new StringBuffer("SELECT t0.");
        sb.append("id").append(",t0.");
        sb.append("jobid").append(",t0.");
        sb.append("dochash").append(",t0.");
        sb.append("docid").append(",t0.");
        sb.append("status").append(",t0.");
        sb.append("failtime").append(",t0.");
        sb.append("failcount").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0,").append(this.jobs.getTableName()).append(" t1 WHERE t0.");
        sb.append("checktime").append("<=? AND t0.");
        sb.append("checkaction").append("=? AND ");
        sb.append("t0.").append("status").append(" IN(?,?) AND t0.").append("jobid").append("=t1.").append("id").append(" AND t1.").append("status").append(" IN (?,?) AND ");
        sb.append("NOT EXISTS(SELECT 'x' FROM ").append(this.jobQueue.getTableName()).append(" t2 WHERE t0.").append("dochash").append("=t2.").append("dochash").append(" AND t0.").append("jobid").append("!=t2.").append("jobid").append(" AND t2.").append("status").append(" IN (?,?,?,?,?,?))");
        sb.append(" ").append(this.database.constructOffsetLimitClause(0, n));
        this.jobQueue.unconditionallyAnalyzeTables();
        ArrayList answers = new ArrayList();
        int repeatCount = 0;
        while (true) {
            long sleepAmt = 0L;
            if (Logging.perf.isDebugEnabled()) {
                Logging.perf.debug((Object)(" Attempt " + Integer.toString(++repeatCount) + " to expire documents, after " + new Long(System.currentTimeMillis() - startTime) + " ms"));
            }
            this.database.beginTransaction();
            try {
                int i;
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null, n, null);
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)(" Expiring " + Integer.toString(set.getRowCount()) + " documents"));
                }
                HashMap connectionNameMap = new HashMap();
                HashMap<String, DocumentDescription> documentIDMap = new HashMap<String, DocumentDescription>();
                HashMap<String, Integer> statusMap = new HashMap<String, Integer>();
                for (i = 0; i < set.getRowCount(); ++i) {
                    ArrayList<DocumentDescription> x;
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("jobid");
                    String documentIDHash = (String)row.getValue("dochash");
                    String documentID = (String)row.getValue("docid");
                    int status = JobQueue.stringToStatus(row.getValue("status").toString());
                    Long failTimeValue = (Long)row.getValue("failtime");
                    Long failCountValue = (Long)row.getValue("failcount");
                    long failTime = failTimeValue == null ? -1L : failTimeValue;
                    int failCount = failCountValue == null ? 0 : (int)failCountValue.longValue();
                    IJobDescription jobDesc = this.load(jobID);
                    String connectionName = jobDesc.getConnectionName();
                    String outputConnectionName = jobDesc.getOutputConnectionName();
                    DocumentDescription dd = new DocumentDescription((Long)row.getValue("id"), jobID, documentIDHash, documentID, failTime, failCount);
                    String compositeDocumentID = JobManager.makeCompositeID(documentIDHash, connectionName);
                    documentIDMap.put(compositeDocumentID, dd);
                    statusMap.put(compositeDocumentID, new Integer(status));
                    HashMap<String, ArrayList<DocumentDescription>> y = (HashMap<String, ArrayList<DocumentDescription>>)connectionNameMap.get(connectionName);
                    if (y == null) {
                        y = new HashMap<String, ArrayList<DocumentDescription>>();
                        connectionNameMap.put(connectionName, y);
                    }
                    if ((x = (ArrayList<DocumentDescription>)y.get(outputConnectionName)) == null) {
                        x = new ArrayList<DocumentDescription>();
                        y.put(outputConnectionName, x);
                    }
                    x.add(dd);
                }
                HashMap<String, String> allowedDocIds = new HashMap<String, String>();
                for (String connectionName : connectionNameMap.keySet()) {
                    Map y = (Map)connectionNameMap.get(connectionName);
                    for (String outputConnectionName : y.keySet()) {
                        int j;
                        ArrayList x = (ArrayList)y.get(outputConnectionName);
                        DocumentDescription[] descriptions = new DocumentDescription[x.size()];
                        for (j = 0; j < descriptions.length; ++j) {
                            descriptions[j] = (DocumentDescription)x.get(j);
                        }
                        String[] docIDHashes = this.getUnindexableDocumentIdentifiers(descriptions, connectionName, outputConnectionName);
                        j = 0;
                        while (j < docIDHashes.length) {
                            String docIDHash = docIDHashes[j++];
                            String key = JobManager.makeCompositeID(docIDHash, connectionName);
                            allowedDocIds.put(key, docIDHash);
                        }
                    }
                }
                Object[] compositeIDArray = new String[documentIDMap.size()];
                i = 0;
                Iterator iter = documentIDMap.keySet().iterator();
                while (iter.hasNext()) {
                    compositeIDArray[i++] = (String)iter.next();
                }
                Arrays.sort(compositeIDArray);
                DocumentDescription[] rval = new DocumentDescription[documentIDMap.size()];
                boolean[] rvalBoolean = new boolean[documentIDMap.size()];
                i = 0;
                while (i < compositeIDArray.length) {
                    Object compositeDocID = compositeIDArray[i];
                    DocumentDescription dd = (DocumentDescription)documentIDMap.get(compositeDocID);
                    rvalBoolean[i] = allowedDocIds.get(compositeDocID) != null;
                    rval[i++] = dd;
                    this.jobQueue.updateActiveRecord(dd.getID(), (Integer)statusMap.get(compositeDocID));
                }
                DocumentSetAndFlags documentSetAndFlags = new DocumentSetAndFlags(rval, rvalBoolean);
                return documentSetAndFlags;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction finding docs to expire: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public DocumentDescription[] getNextDocuments(int n, long currentTime, long interval, BlockingDocuments blockingDocuments, PerformanceStatistics statistics, DepthStatistics scanRecord) throws ManifoldCFException {
        if (!this.jobs.activeJobsPresent()) {
            return new DocumentDescription[0];
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)"Waiting to find documents to queue");
        }
        long prioritizationTime = currentTime - 600000L;
        ThrottleLimit vList = new ThrottleLimit(n, prioritizationTime);
        IResultSet jobconnections = this.jobs.getActiveJobConnections();
        HashMap<String, String> connectionSet = new HashMap<String, String>();
        int i = 0;
        while (i < jobconnections.getRowCount()) {
            IResultRow row = jobconnections.getRow(i++);
            Long jobid = (Long)row.getValue("jobid");
            String connectionName = (String)row.getValue("connectionname");
            vList.addJob(jobid, connectionName);
            connectionSet.put(connectionName, connectionName);
        }
        String[] activeConnectionNames = new String[connectionSet.size()];
        Iterator iter = connectionSet.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            activeConnectionNames[i++] = (String)iter.next();
        }
        IRepositoryConnection[] connections = this.connectionMgr.loadMultiple(activeConnectionNames);
        HashMap<String, Double> rawFetchCounts = new HashMap<String, Double>();
        double rawFetchCountTotal = 0.0;
        i = 0;
        while (i < connections.length) {
            IRepositoryConnection connection = connections[i++];
            String connectionName = connection.getName();
            int maxConnections = connection.getMaxConnections();
            double avgFetchRate = statistics.calculateConnectionFetchRate(connectionName);
            double weightedRawFetchCount = avgFetchRate * (double)maxConnections;
            rawFetchCounts.put(connectionName, new Double(weightedRawFetchCount));
            rawFetchCountTotal += weightedRawFetchCount;
        }
        double fetchCountAdjustmentFactor = (double)n / rawFetchCountTotal;
        i = 0;
        while (i < connections.length) {
            IRepositoryConnection connection = connections[i++];
            String connectionName = connection.getName();
            String[] throttles = connection.getThrottles();
            int k = 0;
            while (k < throttles.length) {
                String throttle = throttles[k++];
                float throttleValue = connection.getThrottleValue(throttle);
                double fetchesPerTimeInterval = (double)throttleValue * (double)interval;
                int fetches = (int)fetchesPerTimeInterval;
                fetchesPerTimeInterval -= (double)fetches;
                if (random.nextDouble() <= fetchesPerTimeInterval) {
                    ++fetches;
                }
                vList.addLimit(connectionName, throttle, fetches);
            }
            Double weightedRawFetchCount = (Double)rawFetchCounts.get(connectionName);
            double adjustedFetchCount = weightedRawFetchCount * fetchCountAdjustmentFactor;
            int fetchCount = (int)adjustedFetchCount + 5;
            vList.setConnectionLimit(connectionName, fetchCount);
        }
        if (Logging.perf.isDebugEnabled()) {
            Logging.perf.debug((Object)("After " + new Long(System.currentTimeMillis() - startTime).toString() + " ms, beginning query to look for documents to queue"));
        }
        ArrayList answers = new ArrayList();
        Long currentTimeValue = new Long(currentTime);
        this.jobQueue.unconditionallyAnalyzeTables();
        boolean isDone = false;
        for (int currentPriority = 1; !isDone && currentPriority <= 10; ++currentPriority) {
            if (!this.jobs.hasPriorityJobs(currentPriority)) continue;
            Long currentPriorityValue = new Long(currentPriority);
            this.fetchAndProcessDocuments(answers, currentTimeValue, currentPriorityValue, vList, connections);
            isDone = !vList.checkContinue();
        }
        vList.tallyBlockingDocuments(blockingDocuments);
        DocumentDescription[] rval = new DocumentDescription[answers.size()];
        for (i = 0; i < rval.length; ++i) {
            rval[i] = (DocumentDescription)answers.get(i);
        }
        StringBuffer sb = new StringBuffer("SELECT ");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(Jobs.statusToString(1));
        list.add(Jobs.statusToString(11));
        list.add(currentTimeValue);
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        sb.append("docpriority").append(",").append("jobid").append(",").append("dochash").append(",").append("docid").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0 WHERE EXISTS(SELECT 'x' FROM ").append(this.jobs.getTableName()).append(" t1 WHERE t0.").append("jobid").append("=t1.").append("id").append(" AND t1.").append("status").append(" IN(?,?)) AND ").append("checktime").append("<=? AND (").append("checkaction").append(" IS NULL OR ").append("checkaction").append("=?").append(") AND (").append("status").append("=? OR ").append("status").append("=?)").append(" ORDER BY ").append("docpriority").append(" ASC ").append(this.database.constructOffsetLimitClause(0, 1));
        IResultSet set = this.database.performQuery(sb.toString(), list, null, null, 1, null);
        if (set.getRowCount() > 0) {
            IResultRow row = set.getRow(0);
            Double docPriority = (Double)row.getValue("docpriority");
            scanRecord.addBins(docPriority);
        }
        return rval;
    }

    protected void addDocumentCriteria(StringBuffer sb, ArrayList list, Long currentTimeValue, Long currentPriorityValue) throws ManifoldCFException {
        list.add(currentTimeValue);
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(Jobs.statusToString(1));
        list.add(Jobs.statusToString(11));
        list.add(currentPriorityValue);
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.statusToString(6));
        list.add(JobQueue.statusToString(9));
        sb.append("t0.").append("checktime").append("<=? AND ");
        sb.append("(t0.").append("checkaction").append(" IS NULL OR t0.").append("checkaction").append("=?) AND ");
        sb.append("(t0.").append("status").append("=? OR t0.").append("status").append("=?) AND t0.").append("jobid").append("=t1.").append("id").append(" AND t1.").append("status").append(" IN (?,?) AND t1.").append("priority").append("=? AND ");
        sb.append("NOT EXISTS(SELECT 'x' FROM ").append(this.jobQueue.getTableName()).append(" t2 WHERE t0.").append("dochash").append("=t2.").append("dochash").append(" AND t0.").append("jobid").append("!=t2.").append("jobid").append(" AND t2.").append("status").append(" IN (?,?,?,?,?,?)) AND ");
        PrereqEventManager cfr_ignored_0 = this.jobQueue.prereqEventManager;
        PrereqEventManager cfr_ignored_1 = this.jobQueue.prereqEventManager;
        sb.append("NOT EXISTS(SELECT 'x' FROM ").append(this.jobQueue.prereqEventManager.getTableName()).append(" t3,").append(this.eventManager.getTableName()).append(" t4 WHERE t0.").append("id").append("=t3.").append("owner").append(" AND t3.").append("eventname").append("=t4.").append("name").append(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchAndProcessDocuments(ArrayList answers, Long currentTimeValue, Long currentPriorityValue, ThrottleLimit vList, IRepositoryConnection[] connections) throws ManifoldCFException {
        int k;
        ArrayList list = new ArrayList();
        StringBuffer sb = new StringBuffer("SELECT t0.");
        sb.append("id").append(",t0.");
        if (Logging.scheduling.isDebugEnabled()) {
            sb.append("docpriority").append(",t0.");
        }
        sb.append("jobid").append(",t0.");
        sb.append("dochash").append(",t0.");
        sb.append("docid").append(",t0.");
        sb.append("status").append(",t0.");
        sb.append("failtime").append(",t0.");
        sb.append("failcount").append(",t0.");
        sb.append("priorityset").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0,").append(this.jobs.getTableName()).append(" t1 WHERE ");
        this.addDocumentCriteria(sb, list, currentTimeValue, currentPriorityValue);
        sb.append(" ORDER BY t0.").append("docpriority").append(" ASC ");
        String[] orderingKeys = new String[connections.length];
        String[] classNames = new String[connections.length];
        ConfigParams[] configParams = new ConfigParams[connections.length];
        int[] maxConnections = new int[connections.length];
        for (k = 0; k < connections.length; ++k) {
            IRepositoryConnection connection = connections[k];
            orderingKeys[k] = connection.getName();
            classNames[k] = connection.getClassName();
            configParams[k] = connection.getConfigParams();
            maxConnections[k] = connection.getMaxConnections();
        }
        IRepositoryConnector[] connectors = RepositoryConnectorFactory.grabMultiple(this.threadContext, orderingKeys, classNames, configParams, maxConnections);
        try {
            for (k = 0; k < connections.length; ++k) {
                vList.addConnectionName(connections[k].getName(), connectors[k]);
            }
            int limitValue = vList.getRemainingDocuments();
            sb.append(this.database.constructOffsetLimitClause(0, limitValue));
            if (Logging.perf.isDebugEnabled()) {
                Logging.perf.debug((Object)("Queuing documents from time " + currentTimeValue.toString() + " job priority " + currentPriorityValue.toString() + " (up to " + Integer.toString(vList.getRemainingDocuments()) + " documents)"));
            }
            while (true) {
                long sleepAmt = 0L;
                this.database.beginTransaction();
                try {
                    int i;
                    IResultSet set = this.database.performQuery(sb.toString(), list, null, null, -1, (ILimitChecker)vList);
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)(" Queuing " + Integer.toString(set.getRowCount()) + " documents"));
                    }
                    Object[] docIDHashes = new String[set.getRowCount()];
                    HashMap<Object, DocumentDescription> storageMap = new HashMap<Object, DocumentDescription>();
                    HashMap<Object, Integer> statusMap = new HashMap<Object, Integer>();
                    for (i = 0; i < set.getRowCount(); ++i) {
                        IResultRow row = set.getRow(i);
                        Long id = (Long)row.getValue("id");
                        Long jobID = (Long)row.getValue("jobid");
                        String docIDHash = (String)row.getValue("dochash");
                        String docID = (String)row.getValue("docid");
                        int status = JobQueue.stringToStatus(row.getValue("status").toString());
                        Long failTimeValue = (Long)row.getValue("failtime");
                        Long failCountValue = (Long)row.getValue("failcount");
                        long failTime = failTimeValue == null ? -1L : failTimeValue;
                        int failCount = failCountValue == null ? -1 : (int)failCountValue.longValue();
                        DocumentDescription dd = new DocumentDescription(id, jobID, docIDHash, docID, failTime, failCount);
                        docIDHashes[i] = docIDHash + ":" + jobID;
                        storageMap.put(docIDHashes[i], dd);
                        statusMap.put(docIDHashes[i], new Integer(status));
                        if (!Logging.scheduling.isDebugEnabled()) continue;
                        Double docPriority = (Double)row.getValue("docpriority");
                        Logging.scheduling.debug((Object)("Stuffing document '" + docID + "' that has priority " + docPriority.toString() + " onto active list"));
                    }
                    Arrays.sort(docIDHashes);
                    for (i = 0; i < docIDHashes.length; ++i) {
                        Object docIDHash = docIDHashes[i];
                        DocumentDescription dd = (DocumentDescription)storageMap.get(docIDHash);
                        Long id = dd.getID();
                        int status = (Integer)statusMap.get(docIDHash);
                        this.jobQueue.updateActiveRecord(id, status);
                        answers.add(dd);
                    }
                }
                catch (ManifoldCFException e) {
                    this.database.signalRollback();
                    if (e.getErrorCode() == 6) {
                        if (Logging.perf.isDebugEnabled()) {
                            Logging.perf.debug((Object)("Aborted transaction finding docs to queue: " + e.getMessage()));
                        }
                        sleepAmt = this.getRandomAmount();
                        continue;
                    }
                    throw e;
                }
                catch (Error e) {
                    this.database.signalRollback();
                    throw e;
                }
                finally {
                    this.database.endTransaction();
                    this.sleepFor(sleepAmt);
                    continue;
                }
                break;
            }
        }
        finally {
            RepositoryConnectorFactory.releaseMultiple(connectors);
        }
    }

    public boolean checkJobActive(Long jobID) throws ManifoldCFException {
        return this.jobs.checkJobActive(jobID);
    }

    public boolean checkJobBusy(Long jobID) throws ManifoldCFException {
        return this.jobQueue.checkJobBusy(jobID);
    }

    public void markDocumentCompletedMultiple(DocumentDescription[] documentDescriptions) throws ManifoldCFException {
        int i;
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        Object[] docIDHashes = new String[documentDescriptions.length];
        for (i = 0; i < documentDescriptions.length; ++i) {
            String documentIDHash = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            docIDHashes[i] = documentIDHash;
            indexMap.put(documentIDHash, new Integer(i));
        }
        Arrays.sort(docIDHashes);
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (i = 0; i < docIDHashes.length; ++i) {
                    Object docIDHash = docIDHashes[i];
                    DocumentDescription dd = documentDescriptions[(Integer)indexMap.get(docIDHash)];
                    ArrayList<Long> list = new ArrayList<Long>();
                    list.add(dd.getID());
                    IResultSet set = this.database.performQuery("SELECT " + "status" + " FROM " + this.jobQueue.getTableName() + " WHERE " + "id" + "=? FOR UPDATE", list, null, null);
                    if (set.getRowCount() <= 0) continue;
                    IResultRow row = set.getRow(0);
                    int status = JobQueue.stringToStatus((String)row.getValue("status"));
                    this.jobQueue.updateCompletedRecord(dd.getID(), status);
                }
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction marking completed " + Integer.toString(docIDHashes.length) + " docs: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void markDocumentCompleted(DocumentDescription documentDescription) throws ManifoldCFException {
        this.markDocumentCompletedMultiple(new DocumentDescription[]{documentDescription});
    }

    public DocumentDescription[] markDocumentDeletedMultiple(Long jobID, String[] legalLinkTypes, DocumentDescription[] documentDescriptions, int hopcountMethod) throws ManifoldCFException {
        DocumentDescription[] rval;
        int i;
        if (documentDescriptions.length == 0) {
            return new DocumentDescription[0];
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)("Waiting to delete " + Integer.toString(documentDescriptions.length) + " docs and clean up hopcount for job " + jobID.toString()));
        }
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        Object[] docIDHashes = new String[documentDescriptions.length];
        for (i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            indexMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start deleting " + Integer.toString(docIDHashes.length) + " docs and clean up hopcount for job " + jobID.toString()));
                }
                String[] docIDSimpleHashes = new String[docIDHashes.length];
                for (i = 0; i < docIDHashes.length; ++i) {
                    Object docIDHash = docIDHashes[i];
                    DocumentDescription dd = documentDescriptions[(Integer)indexMap.get(docIDHash)];
                    this.jobQueue.deleteRecord(dd.getID());
                    docIDSimpleHashes[i] = dd.getDocumentIdentifierHash();
                }
                rval = this.calculateAffectedDeleteCarrydownChildren(jobID, docIDSimpleHashes);
                this.carryDown.deleteRecords(jobID, docIDSimpleHashes);
                if (legalLinkTypes.length > 0) {
                    this.hopCount.deleteDocumentIdentifiers(jobID, legalLinkTypes, docIDSimpleHashes, hopcountMethod);
                }
                if (!Logging.perf.isDebugEnabled()) break;
                Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to delete " + Integer.toString(docIDHashes.length) + " docs and clean up hopcount for job " + jobID.toString()));
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction deleting " + Integer.toString(docIDHashes.length) + " docs and clean up hopcount for job " + jobID.toString() + ": " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        return rval;
    }

    protected DocumentDescription[] calculateAffectedDeleteCarrydownChildren(Long jobID, String[] docIDHashes) throws ManifoldCFException {
        HashMap resultHash = new HashMap();
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.getMaxOrClause();
        int i = 0;
        int z = 0;
        while (i < docIDHashes.length) {
            if (z == maxCount) {
                this.processDeleteHashSet(jobID, resultHash, sb.toString(), list);
                list.clear();
                sb.setLength(0);
                z = 0;
            }
            if (z > 0) {
                sb.append(",");
            }
            sb.append("?");
            list.add(docIDHashes[i]);
            ++i;
            ++z;
        }
        if (z > 0) {
            this.processDeleteHashSet(jobID, resultHash, sb.toString(), list);
        }
        DocumentDescription[] rval = new DocumentDescription[resultHash.size()];
        i = 0;
        for (Long id : resultHash.keySet()) {
            DocumentDescription dd = (DocumentDescription)resultHash.get(id);
            rval[i++] = dd;
        }
        return rval;
    }

    protected void processDeleteHashSet(Long jobID, HashMap resultHash, String queryPart, ArrayList list) throws ManifoldCFException {
        String query = "SELECT t0." + "id" + ",t0." + "dochash" + ",t0." + "docid" + " FROM " + this.jobQueue.getTableName() + " t0 WHERE EXISTS(SELECT 'x' FROM " + this.carryDown.getTableName() + " t1 WHERE t1." + "parentidhash" + " IN (" + queryPart + ") AND t1." + "childidhash" + "=t0." + "dochash" + " AND t0." + "jobid" + "=t1." + "jobid" + ") AND t0." + "jobid" + "=?";
        list.add(jobID);
        IResultSet set = this.database.performQuery(query, list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long id = (Long)row.getValue("id");
            String documentIdentifierHash = (String)row.getValue("dochash");
            String documentIdentifier = (String)row.getValue("docid");
            resultHash.put(id, new DocumentDescription(id, jobID, documentIdentifierHash, documentIdentifier));
        }
    }

    public DocumentDescription[] markDocumentDeleted(Long jobID, String[] legalLinkTypes, DocumentDescription documentDescription, int hopcountMethod) throws ManifoldCFException {
        return this.markDocumentDeletedMultiple(jobID, legalLinkTypes, new DocumentDescription[]{documentDescription}, hopcountMethod);
    }

    public void requeueDocumentMultiple(DocumentDescription[] documentDescriptions, Long[] executeTimes, int[] actions) throws ManifoldCFException {
        int i;
        Object[] docIDHashes = new String[documentDescriptions.length];
        Long[] ids = new Long[documentDescriptions.length];
        Long[] executeTimesNew = new Long[documentDescriptions.length];
        int[] actionsNew = new int[documentDescriptions.length];
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        for (i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            indexMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        for (i = 0; i < docIDHashes.length; ++i) {
            Object docIDHash = docIDHashes[i];
            Integer x = (Integer)indexMap.remove(docIDHash);
            if (x == null) {
                throw new ManifoldCFException("Assertion failure: duplicate document identifier jobid/hash detected!");
            }
            int index = x;
            ids[i] = documentDescriptions[index].getID();
            executeTimesNew[i] = executeTimes[index];
            actionsNew[i] = actions[index];
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (i = 0; i < ids.length; ++i) {
                    this.jobQueue.setStatus(ids[i], 3, executeTimesNew[i], actionsNew[i], -1L, -1);
                }
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction requeuing documents: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void requeueDocument(DocumentDescription documentDescription, Long executeTime, int action) throws ManifoldCFException {
        this.requeueDocumentMultiple(new DocumentDescription[]{documentDescription}, new Long[]{executeTime}, new int[]{action});
    }

    public void resetDocumentMultiple(DocumentDescription[] documentDescriptions, long executeTime, int action, long failTime, int failCount) throws ManifoldCFException {
        int i;
        Long executeTimeLong = new Long(executeTime);
        Long[] ids = new Long[documentDescriptions.length];
        Object[] docIDHashes = new String[documentDescriptions.length];
        Long[] executeTimes = new Long[documentDescriptions.length];
        int[] actions = new int[documentDescriptions.length];
        long[] failTimes = new long[documentDescriptions.length];
        int[] failCounts = new int[documentDescriptions.length];
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        for (i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            indexMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        for (i = 0; i < docIDHashes.length; ++i) {
            Object docIDHash = docIDHashes[i];
            Integer x = (Integer)indexMap.remove(docIDHash);
            if (x == null) {
                throw new ManifoldCFException("Assertion failure: duplicate document identifier jobid/hash detected!");
            }
            int index = x;
            ids[i] = documentDescriptions[index].getID();
            executeTimes[i] = executeTimeLong;
            actions[i] = action;
            long oldFailTime = documentDescriptions[index].getFailTime();
            if (oldFailTime == -1L) {
                oldFailTime = failTime;
            }
            failTimes[i] = oldFailTime;
            int oldFailCount = documentDescriptions[index].getFailRetryCount();
            if (oldFailCount == -1) {
                oldFailCount = failCount;
            } else if (failCount != -1 && --oldFailCount > failCount) {
                oldFailCount = failCount;
            }
            failCounts[i] = oldFailCount;
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (i = 0; i < ids.length; ++i) {
                    this.jobQueue.setStatus(ids[i], 3, executeTimes[i], actions[i], failTimes == null ? -1L : failTimes[i], failCounts == null ? -1 : failCounts[i]);
                }
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting documents: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void resetCleaningDocumentMultiple(DocumentDescription[] documentDescriptions, long checkTime) throws ManifoldCFException {
        int i;
        Long[] ids = new Long[documentDescriptions.length];
        Object[] docIDHashes = new String[documentDescriptions.length];
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        for (i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            indexMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        for (i = 0; i < docIDHashes.length; ++i) {
            Object docIDHash = docIDHashes[i];
            Integer x = (Integer)indexMap.remove(docIDHash);
            if (x == null) {
                throw new ManifoldCFException("Assertion failure: duplicate document identifier jobid/hash detected!");
            }
            int index = x;
            ids[i] = documentDescriptions[index].getID();
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (i = 0; i < ids.length; ++i) {
                    this.jobQueue.setUncleaningStatus(ids[i], checkTime);
                }
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting cleaning documents: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void resetCleaningDocument(DocumentDescription documentDescription, long checkTime) throws ManifoldCFException {
        this.resetCleaningDocumentMultiple(new DocumentDescription[]{documentDescription}, checkTime);
    }

    public void resetDeletingDocumentMultiple(DocumentDescription[] documentDescriptions, long checkTime) throws ManifoldCFException {
        int i;
        Long[] ids = new Long[documentDescriptions.length];
        Object[] docIDHashes = new String[documentDescriptions.length];
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        for (i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            indexMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        for (i = 0; i < docIDHashes.length; ++i) {
            Object docIDHash = docIDHashes[i];
            Integer x = (Integer)indexMap.remove(docIDHash);
            if (x == null) {
                throw new ManifoldCFException("Assertion failure: duplicate document identifier jobid/hash detected!");
            }
            int index = x;
            ids[i] = documentDescriptions[index].getID();
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (i = 0; i < ids.length; ++i) {
                    this.jobQueue.setUndeletingStatus(ids[i], checkTime);
                }
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting documents: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void resetDeletingDocument(DocumentDescription documentDescription, long checkTime) throws ManifoldCFException {
        this.resetDeletingDocumentMultiple(new DocumentDescription[]{documentDescription}, checkTime);
    }

    public void resetDocument(DocumentDescription documentDescription, long executeTime, int action, long failTime, int failCount) throws ManifoldCFException {
        this.resetDocumentMultiple(new DocumentDescription[]{documentDescription}, executeTime, action, failTime, failCount);
    }

    protected static String[] eliminateDuplicates(String[] docIDHashes) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < docIDHashes.length) {
            String docIDHash = docIDHashes[i++];
            map.put(docIDHash, docIDHash);
        }
        Object[] rval = new String[map.size()];
        i = 0;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        Arrays.sort(rval);
        return rval;
    }

    protected static HashMap buildReorderMap(String[] originalIDHashes, String[] reorderedIDHashes) {
        HashMap<String, Integer> reorderSet = new HashMap<String, Integer>();
        for (int i = 0; i < reorderedIDHashes.length; ++i) {
            String reorderedIDHash = reorderedIDHashes[i];
            Integer position = new Integer(i);
            reorderSet.put(reorderedIDHash, position);
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int j = 0; j < originalIDHashes.length; ++j) {
            String originalIDHash = originalIDHashes[j];
            Integer position = (Integer)reorderSet.get(originalIDHash);
            if (position == null) continue;
            map.put(new Integer(j), position);
            reorderSet.remove(originalIDHash);
        }
        return map;
    }

    public boolean[] addDocumentsInitial(Long jobID, String[] legalLinkTypes, String[] docIDHashes, String[] docIDs, boolean overrideSchedule, int hopcountMethod, long currentTime, double[] documentPriorities, String[][] prereqEventNames) throws ManifoldCFException {
        int i;
        if (docIDHashes.length == 0) {
            return new boolean[0];
        }
        String[] reorderedDocIDHashes = JobManager.eliminateDuplicates(docIDHashes);
        HashMap reorderMap = JobManager.buildReorderMap(docIDHashes, reorderedDocIDHashes);
        double[] reorderedDocumentPriorities = new double[reorderedDocIDHashes.length];
        String[][] reorderedDocumentPrerequisites = new String[reorderedDocIDHashes.length][];
        String[] reorderedDocumentIdentifiers = new String[reorderedDocIDHashes.length];
        boolean[] rval = new boolean[docIDHashes.length];
        for (i = 0; i < docIDHashes.length; ++i) {
            Integer newPosition = (Integer)reorderMap.get(new Integer(i));
            if (newPosition != null) {
                reorderedDocumentPriorities[newPosition.intValue()] = documentPriorities[i];
                reorderedDocumentPrerequisites[newPosition.intValue()] = prereqEventNames != null ? prereqEventNames[i] : null;
                reorderedDocumentIdentifiers[newPosition.intValue()] = docIDs[i];
            }
            rval[i] = false;
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)("Waiting to add " + Integer.toString(reorderedDocIDHashes.length) + " initial docs and hopcounts for job " + jobID.toString()));
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start adding " + Integer.toString(reorderedDocIDHashes.length) + " initial docs and hopcounts for job " + jobID.toString()));
                }
                boolean[] reorderedRval = new boolean[reorderedDocIDHashes.length];
                int z = 0;
                while (z < reorderedDocIDHashes.length) {
                    boolean priorityUsed;
                    long executeTime;
                    String docIDHash = reorderedDocIDHashes[z];
                    double docPriority = reorderedDocumentPriorities[z];
                    String docID = reorderedDocumentIdentifiers[z];
                    String[] docPrereqs = reorderedDocumentPrerequisites[z];
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(jobID);
                    list.add(docIDHash);
                    IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "status" + "," + "checktime" + " FROM " + this.jobQueue.getTableName() + " WHERE " + "jobid" + "=? AND " + "dochash" + "=? FOR UPDATE", list, null, null);
                    long l = executeTime = overrideSchedule ? 0L : -1L;
                    if (set.getRowCount() > 0) {
                        IResultRow row = set.getRow(0);
                        Long rowID = (Long)row.getValue("id");
                        int status = JobQueue.stringToStatus((String)row.getValue("status"));
                        Long checkTimeValue = (Long)row.getValue("checktime");
                        priorityUsed = this.jobQueue.updateExistingRecordInitial(rowID, status, checkTimeValue, executeTime, currentTime, docPriority, docPrereqs);
                    } else {
                        this.jobQueue.insertNewRecordInitial(jobID, docIDHash, docID, docPriority, executeTime, currentTime, docPrereqs);
                        priorityUsed = true;
                    }
                    reorderedRval[z++] = priorityUsed;
                }
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to add " + Integer.toString(reorderedDocIDHashes.length) + " initial docs for job " + jobID.toString()));
                }
                if (legalLinkTypes.length > 0) {
                    this.hopCount.recordSeedReferences(jobID, legalLinkTypes, reorderedDocIDHashes, hopcountMethod);
                }
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to add " + Integer.toString(reorderedDocIDHashes.length) + " initial docs and hopcounts for job " + jobID.toString()));
                }
                for (i = 0; i < docIDs.length; ++i) {
                    Integer finalPosition = (Integer)reorderMap.get(new Integer(i));
                    if (finalPosition == null) continue;
                    rval[i] = reorderedRval[finalPosition];
                }
                boolean[] blArray = rval;
                return blArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction adding " + Integer.toString(reorderedDocIDHashes.length) + " initial docs for job " + jobID.toString() + ": " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void addRemainingDocumentsInitial(Long jobID, String[] legalLinkTypes, String[] docIDHashes, int hopcountMethod) throws ManifoldCFException {
        if (docIDHashes.length == 0) {
            return;
        }
        String[] reorderedDocIDHashes = JobManager.eliminateDuplicates(docIDHashes);
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)("Waiting to add " + Integer.toString(reorderedDocIDHashes.length) + " remaining docs and hopcounts for job " + jobID.toString()));
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start adding " + Integer.toString(reorderedDocIDHashes.length) + " remaining docs and hopcounts for job " + jobID.toString()));
                }
                this.jobQueue.addRemainingDocumentsInitial(jobID, reorderedDocIDHashes);
                if (legalLinkTypes.length > 0) {
                    this.hopCount.recordSeedReferences(jobID, legalLinkTypes, reorderedDocIDHashes, hopcountMethod);
                }
                if (!Logging.perf.isDebugEnabled()) continue;
                Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to add " + Integer.toString(reorderedDocIDHashes.length) + " remaining docs and hopcounts for job " + jobID.toString()));
                continue;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction adding " + Integer.toString(reorderedDocIDHashes.length) + " remaining docs and hopcounts for job " + jobID.toString() + ": " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void doneDocumentsInitial(Long jobID, String[] legalLinkTypes, boolean isPartial, int hopcountMethod) throws ManifoldCFException {
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)("Waiting to finish initial docs and hopcounts for job " + jobID.toString()));
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start finishing initial docs and hopcounts for job " + jobID.toString()));
                }
                this.jobQueue.doneDocumentsInitial(jobID, isPartial);
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to finish initial docs for job " + jobID.toString()));
                }
                if (legalLinkTypes.length > 0) {
                    this.hopCount.finishSeedReferences(jobID, legalLinkTypes, hopcountMethod);
                }
                if (!Logging.perf.isDebugEnabled()) break;
                Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to finish initial docs and hopcounts for job " + jobID.toString()));
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction finishing initial docs and hopcounts for job " + jobID.toString() + ": " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean[] findHopCounts(Long jobID, String[] legalLinkTypes, String[] docIDHashes, String linkType, int limit, int hopcountMethod) throws ManifoldCFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[] getAllSeeds(Long jobID) throws ManifoldCFException {
        return this.jobQueue.getAllSeeds(jobID);
    }

    public boolean[] addDocuments(Long jobID, String[] legalLinkTypes, String[] docIDHashes, String[] docIDs, String parentIdentifierHash, String relationshipType, int hopcountMethod, String[][] dataNames, Object[][][] dataValues, long currentTime, double[] documentPriorities, String[][] prereqEventNames) throws ManifoldCFException {
        int i;
        int k;
        if (docIDs.length == 0) {
            return new boolean[0];
        }
        HashMap nameMap = new HashMap();
        for (k = 0; k < docIDHashes.length; ++k) {
            String docIDHash = docIDHashes[k];
            HashMap names = (HashMap)nameMap.get(docIDHash);
            if (names == null) {
                names = new HashMap();
                nameMap.put(docIDHash, names);
            }
            String[] nameList = dataNames[k];
            Object[][] dataList = dataValues[k];
            for (int z = 0; z < nameList.length; ++z) {
                String name = nameList[z];
                Object[] values = dataList[z];
                HashMap<String, Object> valueMap = (HashMap<String, Object>)names.get(name);
                if (valueMap == null) {
                    valueMap = new HashMap<String, Object>();
                    names.put(name, valueMap);
                }
                for (int y = 0; y < values.length; ++y) {
                    String valueHash = values[y] instanceof CharacterInput ? ((CharacterInput)values[y]).getHashValue() : ManifoldCF.hash((String)((String)values[y]));
                    valueMap.put(valueHash, values[y]);
                }
            }
        }
        String[] reorderedDocIDHashes = JobManager.eliminateDuplicates(docIDHashes);
        HashMap reorderMap = JobManager.buildReorderMap(docIDHashes, reorderedDocIDHashes);
        double[] reorderedDocumentPriorities = new double[reorderedDocIDHashes.length];
        String[][] reorderedDocumentPrerequisites = new String[reorderedDocIDHashes.length][];
        String[] reorderedDocumentIdentifiers = new String[reorderedDocIDHashes.length];
        boolean[] rval = new boolean[docIDHashes.length];
        for (i = 0; i < docIDHashes.length; ++i) {
            Integer newPosition = (Integer)reorderMap.get(new Integer(i));
            if (newPosition != null) {
                reorderedDocumentPriorities[newPosition.intValue()] = documentPriorities[i];
                reorderedDocumentPrerequisites[newPosition.intValue()] = prereqEventNames != null ? prereqEventNames[i] : null;
                reorderedDocumentIdentifiers[newPosition.intValue()] = docIDs[i];
            }
            rval[i] = false;
        }
        dataNames = new String[reorderedDocIDHashes.length][];
        String[][][] dataHashValues = new String[reorderedDocIDHashes.length][][];
        dataValues = new Object[reorderedDocIDHashes.length][][];
        for (k = 0; k < reorderedDocIDHashes.length; ++k) {
            String docIDHash = reorderedDocIDHashes[k];
            HashMap names = (HashMap)nameMap.get(docIDHash);
            dataNames[k] = new String[names.size()];
            dataHashValues[k] = new String[names.size()][];
            dataValues[k] = new Object[names.size()][];
            Iterator iter = names.keySet().iterator();
            int z = 0;
            while (iter.hasNext()) {
                String dataName;
                dataNames[k][z] = dataName = (String)iter.next();
                HashMap values = (HashMap)names.get(dataName);
                dataHashValues[k][z] = new String[values.size()];
                dataValues[k][z] = new Object[values.size()];
                Iterator iter2 = values.keySet().iterator();
                int y = 0;
                while (iter2.hasNext()) {
                    String dataValueHash = (String)iter2.next();
                    Object dataValue = values.get(dataValueHash);
                    dataHashValues[k][z][y] = dataValueHash;
                    dataValues[k][z][y] = dataValue;
                    ++y;
                }
                ++z;
            }
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)("Waiting to add " + Integer.toString(reorderedDocIDHashes.length) + " docs and hopcounts for job " + jobID.toString() + " parent identifier " + parentIdentifierHash));
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                int z;
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start adding " + Integer.toString(reorderedDocIDHashes.length) + " docs and hopcounts for job " + jobID.toString() + " parent identifier hash " + parentIdentifierHash));
                }
                HashMap<String, JobqueueRecord> existingRows = new HashMap<String, JobqueueRecord>();
                for (z = 0; z < reorderedDocIDHashes.length; ++z) {
                    String docIDHash = reorderedDocIDHashes[z];
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(jobID);
                    list.add(docIDHash);
                    IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "status" + "," + "checktime" + " FROM " + this.jobQueue.getTableName() + " WHERE " + "jobid" + "=? AND " + "dochash" + "=? FOR UPDATE", list, null, null);
                    if (set.getRowCount() > 0) {
                        IResultRow row = set.getRow(0);
                        Long rowID = (Long)row.getValue("id");
                        int status = JobQueue.stringToStatus((String)row.getValue("status"));
                        Long checkTimeValue = (Long)row.getValue("checktime");
                        existingRows.put(docIDHash, new JobqueueRecord(rowID, status, checkTimeValue));
                        continue;
                    }
                    this.jobQueue.insertNewRecord(jobID, docIDHash, reorderedDocumentIdentifiers[z], reorderedDocumentPriorities[z], 0L, currentTime, reorderedDocumentPrerequisites[z]);
                }
                boolean[] carrydownChangesSeen = this.carryDown.recordCarrydownDataMultiple(jobID, parentIdentifierHash, reorderedDocIDHashes, dataNames, dataHashValues, dataValues);
                boolean[] reorderedRval = new boolean[reorderedDocIDHashes.length];
                for (z = 0; z < reorderedDocIDHashes.length; ++z) {
                    String docIDHash = reorderedDocIDHashes[z];
                    JobqueueRecord jr = (JobqueueRecord)existingRows.get(docIDHash);
                    reorderedRval[z] = jr == null ? true : this.jobQueue.updateExistingRecord(jr.getRecordID(), jr.getStatus(), jr.getCheckTimeValue(), 0L, currentTime, carrydownChangesSeen[z], reorderedDocumentPriorities[z], reorderedDocumentPrerequisites[z]);
                }
                if (parentIdentifierHash != null && relationshipType != null) {
                    this.hopCount.recordReferences(jobID, legalLinkTypes, parentIdentifierHash, reorderedDocIDHashes, relationshipType, hopcountMethod);
                }
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to add " + Integer.toString(reorderedDocIDHashes.length) + " docs and hopcounts for job " + jobID.toString() + " parent identifier hash " + parentIdentifierHash));
                }
                for (i = 0; i < docIDHashes.length; ++i) {
                    Integer finalPosition = (Integer)reorderMap.get(new Integer(i));
                    if (finalPosition == null) continue;
                    rval[i] = reorderedRval[finalPosition];
                }
                boolean[] blArray = rval;
                return blArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    sleepAmt = this.getRandomAmount();
                    if (!Logging.perf.isDebugEnabled()) continue;
                    Logging.perf.debug((Object)("Aborted transaction adding " + Integer.toString(reorderedDocIDHashes.length) + " docs and hopcounts for job " + jobID.toString() + " parent identifier hash " + parentIdentifierHash + ": " + e.getMessage() + "; sleeping for " + new Long(sleepAmt).toString() + " ms"), (Throwable)e);
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public boolean addDocument(Long jobID, String[] legalLinkTypes, String docIDHash, String docID, String parentIdentifierHash, String relationshipType, int hopcountMethod, String[] dataNames, Object[][] dataValues, long currentTime, double priority, String[] prereqEventNames) throws ManifoldCFException {
        return this.addDocuments(jobID, legalLinkTypes, new String[]{docIDHash}, new String[]{docID}, parentIdentifierHash, relationshipType, hopcountMethod, new String[][]{dataNames}, new Object[][][]{dataValues}, currentTime, new double[]{priority}, new String[][]{prereqEventNames})[0];
    }

    public DocumentDescription[] finishDocuments(Long jobID, String[] legalLinkTypes, String[] parentIdentifierHashes, int hopcountMethod) throws ManifoldCFException {
        DocumentDescription[] rval;
        block24: {
            if (parentIdentifierHashes.length == 0) {
                return new DocumentDescription[0];
            }
            if (legalLinkTypes.length == 0) {
                while (true) {
                    long sleepAmt = 0L;
                    this.database.beginTransaction(2);
                    try {
                        rval = this.calculateAffectedRestoreCarrydownChildren(jobID, parentIdentifierHashes);
                        this.carryDown.restoreRecords(jobID, parentIdentifierHashes);
                        break block24;
                    }
                    catch (ManifoldCFException e) {
                        this.database.signalRollback();
                        if (e.getErrorCode() == 6) {
                            if (Logging.perf.isDebugEnabled()) {
                                Logging.perf.debug((Object)("Aborted transaction finishing " + Integer.toString(parentIdentifierHashes.length) + " doc carrydown records for job " + jobID.toString() + ": " + e.getMessage()));
                            }
                            sleepAmt = this.getRandomAmount();
                            continue;
                        }
                        throw e;
                    }
                    catch (Error e) {
                        this.database.signalRollback();
                        throw e;
                    }
                    finally {
                        this.database.endTransaction();
                        this.sleepFor(sleepAmt);
                        continue;
                    }
                    break;
                }
            }
            long startTime = 0L;
            if (Logging.perf.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                Logging.perf.debug((Object)("Waiting to finish " + Integer.toString(parentIdentifierHashes.length) + " doc hopcounts for job " + jobID.toString()));
            }
            while (true) {
                long sleepAmt = 0L;
                this.database.beginTransaction(2);
                try {
                    rval = this.calculateAffectedRestoreCarrydownChildren(jobID, parentIdentifierHashes);
                    this.carryDown.restoreRecords(jobID, parentIdentifierHashes);
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start finishing " + Integer.toString(parentIdentifierHashes.length) + " doc hopcounts for job " + jobID.toString()));
                    }
                    this.hopCount.finishParents(jobID, legalLinkTypes, parentIdentifierHashes, hopcountMethod);
                    if (!Logging.perf.isDebugEnabled()) break;
                    Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to finish " + Integer.toString(parentIdentifierHashes.length) + " doc hopcounts for job " + jobID.toString()));
                }
                catch (ManifoldCFException e) {
                    this.database.signalRollback();
                    if (e.getErrorCode() == 6) {
                        if (Logging.perf.isDebugEnabled()) {
                            Logging.perf.debug((Object)("Aborted transaction finishing " + Integer.toString(parentIdentifierHashes.length) + " doc hopcounts for job " + jobID.toString() + ": " + e.getMessage()));
                        }
                        sleepAmt = this.getRandomAmount();
                        continue;
                    }
                    throw e;
                }
                catch (Error e) {
                    this.database.signalRollback();
                    throw e;
                }
                finally {
                    this.database.endTransaction();
                    this.sleepFor(sleepAmt);
                    continue;
                }
                break;
            }
        }
        return rval;
    }

    protected DocumentDescription[] calculateAffectedRestoreCarrydownChildren(Long jobID, String[] parentIDHashes) throws ManifoldCFException {
        HashMap resultHash = new HashMap();
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.getMaxOrClause();
        int i = 0;
        int z = 0;
        while (i < parentIDHashes.length) {
            if (z == maxCount) {
                this.processParentHashSet(jobID, resultHash, sb.toString(), list);
                list.clear();
                sb.setLength(0);
                z = 0;
            }
            if (z > 0) {
                sb.append(",");
            }
            sb.append("?");
            list.add(parentIDHashes[i]);
            ++i;
            ++z;
        }
        if (z > 0) {
            this.processParentHashSet(jobID, resultHash, sb.toString(), list);
        }
        DocumentDescription[] rval = new DocumentDescription[resultHash.size()];
        i = 0;
        for (Long id : resultHash.keySet()) {
            DocumentDescription dd = (DocumentDescription)resultHash.get(id);
            rval[i++] = dd;
        }
        return rval;
    }

    protected void processParentHashSet(Long jobID, HashMap resultHash, String queryPart, ArrayList list) throws ManifoldCFException {
        String query = "SELECT t0." + "id" + ",t0." + "dochash" + ",t0." + "docid" + " FROM " + this.jobQueue.getTableName() + " t0 WHERE EXISTS(SELECT 'x' FROM " + this.carryDown.getTableName() + " t1 WHERE " + "parentidhash" + " IN (" + queryPart + ") AND t1." + "childidhash" + "=t0." + "dochash" + " AND t0." + "jobid" + "=t1." + "jobid" + " AND t1." + "isnew" + "=?) AND t0." + "jobid" + "=?";
        list.add(Carrydown.statusToString(0));
        list.add(jobID);
        IResultSet set = this.database.performQuery(query, list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long id = (Long)row.getValue("id");
            String documentIdentifierHash = (String)row.getValue("dochash");
            String documentIdentifier = (String)row.getValue("docid");
            resultHash.put(id, new DocumentDescription(id, jobID, documentIdentifierHash, documentIdentifier));
        }
    }

    public boolean beginEventSequence(String eventName) throws ManifoldCFException {
        try {
            this.eventManager.createEvent(eventName);
            return true;
        }
        catch (ManifoldCFException e) {
            if (e.getErrorCode() == 6) {
                return false;
            }
            throw e;
        }
    }

    public void completeEventSequence(String eventName) throws ManifoldCFException {
        this.eventManager.destroyEvent(eventName);
    }

    public boolean[] carrydownChangeDocumentMultiple(DocumentDescription[] documentDescriptions, long currentTime, double[] docPriorities) throws ManifoldCFException {
        if (documentDescriptions.length == 0) {
            return new boolean[0];
        }
        HashMap<Object, Integer> docHashMap = new HashMap<Object, Integer>();
        Object[] docIDHashes = new String[documentDescriptions.length];
        for (int i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifier() + ":" + documentDescriptions[i].getJobID();
            docHashMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        boolean[] rval = new boolean[docIDHashes.length];
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                int originalIndex;
                Object docIDHash;
                int j;
                HashMap<Object, JobqueueRecord> existingRows = new HashMap<Object, JobqueueRecord>();
                for (j = 0; j < docIDHashes.length; ++j) {
                    docIDHash = docIDHashes[j];
                    originalIndex = (Integer)docHashMap.get(docIDHash);
                    DocumentDescription dd = documentDescriptions[originalIndex];
                    ArrayList<Long> list = new ArrayList<Long>();
                    list.add(dd.getID());
                    IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "status" + "," + "checktime" + " FROM " + this.jobQueue.getTableName() + " WHERE " + "id" + "=? FOR UPDATE", list, null, null);
                    if (set.getRowCount() <= 0) continue;
                    IResultRow row = set.getRow(0);
                    Long rowID = (Long)row.getValue("id");
                    int status = JobQueue.stringToStatus((String)row.getValue("status"));
                    Long checkTimeValue = (Long)row.getValue("checktime");
                    existingRows.put(docIDHash, new JobqueueRecord(rowID, status, checkTimeValue));
                }
                while (j < docIDHashes.length) {
                    docIDHash = docIDHashes[j];
                    originalIndex = (Integer)docHashMap.get(docIDHash);
                    JobqueueRecord jr = (JobqueueRecord)existingRows.get(docIDHash);
                    rval[originalIndex] = jr == null ? false : this.jobQueue.updateExistingRecord(jr.getRecordID(), jr.getStatus(), jr.getCheckTimeValue(), 0L, currentTime, true, docPriorities[originalIndex], null);
                    ++j;
                }
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction handling " + Integer.toString(docIDHashes.length) + " carrydown changes: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        return rval;
    }

    public boolean carrydownChangeDocument(DocumentDescription documentDescription, long currentTime, double docPriority) throws ManifoldCFException {
        return this.carrydownChangeDocumentMultiple(new DocumentDescription[]{documentDescription}, currentTime, new double[]{docPriority})[0];
    }

    protected long getRandomAmount() {
        return (long)(random.nextDouble() * 60000.0 + 500.0);
    }

    protected void sleepFor(long amt) throws ManifoldCFException {
        if (amt == 0L) {
            return;
        }
        try {
            ManifoldCF.sleep((long)amt);
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException("Interrupted", (Throwable)e, 2);
        }
    }

    public String[] retrieveParentData(Long jobID, String docIDHash, String dataName) throws ManifoldCFException {
        return this.carryDown.getDataValues(jobID, docIDHash, dataName);
    }

    public CharacterInput[] retrieveParentDataAsFiles(Long jobID, String docIDHash, String dataName) throws ManifoldCFException {
        return this.carryDown.getDataValuesAsFiles(jobID, docIDHash, dataName);
    }

    public void startJobs(long currentTime, ArrayList unwaitList) throws ManifoldCFException {
        this.database.beginTransaction();
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add(Jobs.statusToString(0));
            list.add(Jobs.statusToString(4));
            list.add(Jobs.statusToString(14));
            list.add(Jobs.statusToString(5));
            list.add(Jobs.statusToString(15));
            list.add(Jobs.startMethodToString(2));
            IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "lasttime" + "," + "status" + "," + "startmethod" + "," + "outputname" + "," + "connectionname" + " FROM " + this.jobs.getTableName() + " WHERE " + "status" + " IN (?,?,?,?,?) AND " + "startmethod" + "!=? FOR UPDATE", list, null, null);
            Long[] jobIDSet = new Long[set.getRowCount()];
            int i = 0;
            while (i < set.getRowCount()) {
                IResultRow row = set.getRow(i);
                int n = i++;
                jobIDSet[n] = (Long)row.getValue("id");
            }
            ScheduleRecord[][] srSet = this.jobs.readScheduleRecords(jobIDSet);
            i = 0;
            while (i < set.getRowCount()) {
                IResultRow row = set.getRow(i);
                Long jobID = (Long)row.getValue("id");
                int startMethod = Jobs.stringToStartMethod((String)row.getValue("startmethod"));
                String outputName = (String)row.getValue("outputname");
                String connectionName = (String)row.getValue("connectionname");
                ScheduleRecord[] thisSchedule = srSet[i++];
                long startInterval = (Long)row.getValue("lasttime") + 1L;
                if (Logging.jobs.isDebugEnabled()) {
                    Logging.jobs.debug((Object)("Checking if job " + jobID.toString() + " needs to be started; it was last checked at " + new Long(startInterval).toString() + ", and now it is " + new Long(currentTime).toString()));
                }
                int l = 0;
                Long matchTime = null;
                Long duration = null;
                while (l < thisSchedule.length) {
                    Long thisMatchTime;
                    long trialStart;
                    long trialStartInterval = startInterval;
                    ScheduleRecord sr = thisSchedule[l++];
                    Long thisDuration = sr.getDuration();
                    if (startMethod == 1 && thisDuration != null && (trialStart = currentTime - thisDuration) < trialStartInterval) {
                        trialStartInterval = trialStart;
                    }
                    if ((thisMatchTime = JobManager.checkTimeMatch(trialStartInterval, currentTime, sr.getDayOfWeek(), sr.getDayOfMonth(), sr.getMonthOfYear(), sr.getYear(), sr.getHourOfDay(), sr.getMinutesOfHour(), sr.getTimezone(), thisDuration)) == null) {
                        if (!Logging.jobs.isDebugEnabled()) continue;
                        Logging.jobs.debug((Object)(" No time match found within interval " + new Long(trialStartInterval).toString() + " to " + new Long(currentTime).toString()));
                        continue;
                    }
                    if (Logging.jobs.isDebugEnabled()) {
                        Logging.jobs.debug((Object)(" Time match FOUND within interval " + new Long(trialStartInterval).toString() + " to " + new Long(currentTime).toString()));
                    }
                    if (matchTime != null && thisDuration != null && (duration == null || thisMatchTime + thisDuration <= matchTime + duration)) continue;
                    matchTime = thisMatchTime;
                    duration = thisDuration;
                }
                if (matchTime == null) {
                    this.jobs.updateLastTime(jobID, currentTime);
                    continue;
                }
                int status = Jobs.stringToStatus(row.getValue("status").toString());
                Long windowEnd = null;
                if (duration != null) {
                    windowEnd = new Long(matchTime + duration);
                }
                if (Logging.jobs.isDebugEnabled()) {
                    Logging.jobs.debug((Object)("Job '" + jobID + "' is within run window at " + new Long(currentTime).toString() + " ms. (which starts at " + matchTime.toString() + " ms." + (duration == null ? "" : " and goes for " + duration.toString() + " ms.") + ")"));
                }
                switch (status) {
                    case 0: {
                        this.jobs.startJob(jobID, windowEnd);
                        this.jobQueue.clearFailTimes(jobID);
                        if (!Logging.jobs.isDebugEnabled()) break;
                        Logging.jobs.debug((Object)("Signalled for job start for job " + jobID));
                        break;
                    }
                    case 4: {
                        unwaitList.add(jobID);
                        int newJobState = this.connectionMgr.checkConnectorExists(connectionName) ? (this.outputMgr.checkConnectorExists(outputName) ? 1 : 25) : (this.outputMgr.checkConnectorExists(outputName) ? 23 : 27);
                        this.jobs.unwaitJob(jobID, newJobState, windowEnd);
                        this.jobQueue.clearFailTimes(jobID);
                        if (!Logging.jobs.isDebugEnabled()) break;
                        Logging.jobs.debug((Object)("Un-waited job " + jobID));
                        break;
                    }
                    case 14: {
                        unwaitList.add(jobID);
                        int newJobState = this.connectionMgr.checkConnectorExists(connectionName) ? (this.outputMgr.checkConnectorExists(outputName) ? 11 : 26) : (this.outputMgr.checkConnectorExists(outputName) ? 24 : 28);
                        this.jobs.unwaitJob(jobID, newJobState, windowEnd);
                        this.jobQueue.clearFailTimes(jobID);
                        if (!Logging.jobs.isDebugEnabled()) break;
                        Logging.jobs.debug((Object)("Un-waited job " + jobID));
                        break;
                    }
                    case 5: {
                        unwaitList.add(jobID);
                        this.jobs.unwaitJob(jobID, 2, windowEnd);
                        if (!Logging.jobs.isDebugEnabled()) break;
                        Logging.jobs.debug((Object)("Un-waited (but still paused) job " + jobID));
                        break;
                    }
                    case 15: {
                        unwaitList.add(jobID);
                        this.jobs.unwaitJob(jobID, 13, windowEnd);
                        if (!Logging.jobs.isDebugEnabled()) break;
                        Logging.jobs.debug((Object)("Un-waited (but still paused) job " + jobID));
                        break;
                    }
                }
            }
        }
        catch (ManifoldCFException e) {
            this.database.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.database.signalRollback();
            throw e;
        }
        finally {
            this.database.endTransaction();
        }
    }

    public void waitJobs(long currentTime, ArrayList waitList) throws ManifoldCFException {
        this.database.beginTransaction();
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add(Jobs.statusToString(1));
            list.add(Jobs.statusToString(11));
            list.add(Jobs.statusToString(23));
            list.add(Jobs.statusToString(24));
            list.add(Jobs.statusToString(25));
            list.add(Jobs.statusToString(26));
            list.add(Jobs.statusToString(27));
            list.add(Jobs.statusToString(28));
            list.add(Jobs.statusToString(2));
            list.add(Jobs.statusToString(13));
            IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "status" + " IN (?,?,?,?,?,?,?,?,?,?) AND " + "windowend" + "<" + new Long(currentTime).toString() + " FOR UPDATE", list, null, null);
            int i = 0;
            while (i < set.getRowCount()) {
                IResultRow row = set.getRow(i++);
                Long jobID = (Long)row.getValue("id");
                waitList.add(jobID);
                int status = Jobs.stringToStatus(row.getValue("status").toString());
                switch (status) {
                    case 1: 
                    case 23: 
                    case 25: 
                    case 27: {
                        this.jobs.waitJob(jobID, 4);
                        if (!Logging.jobs.isDebugEnabled()) break;
                        Logging.jobs.debug((Object)("Job " + jobID + " now in 'wait' state due to window end"));
                        break;
                    }
                    case 11: 
                    case 24: 
                    case 26: 
                    case 28: {
                        this.jobs.waitJob(jobID, 14);
                        if (!Logging.jobs.isDebugEnabled()) break;
                        Logging.jobs.debug((Object)("Job " + jobID + " now in 'wait' state due to window end"));
                        break;
                    }
                    case 2: {
                        this.jobs.waitJob(jobID, 5);
                        if (!Logging.jobs.isDebugEnabled()) break;
                        Logging.jobs.debug((Object)("Job " + jobID + " now in 'wait paused' state due to window end"));
                        break;
                    }
                    case 13: {
                        this.jobs.waitJob(jobID, 15);
                        if (!Logging.jobs.isDebugEnabled()) break;
                        Logging.jobs.debug((Object)("Job " + jobID + " now in 'wait paused' state due to window end"));
                        break;
                    }
                }
            }
        }
        catch (ManifoldCFException e) {
            this.database.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.database.signalRollback();
            throw e;
        }
        finally {
            this.database.endTransaction();
        }
    }

    public void resetJobSchedule(Long jobID) throws ManifoldCFException {
    }

    protected static Long checkTimeMatch(long startTime, long currentTimestamp, EnumeratedValues daysOfWeek, EnumeratedValues daysOfMonth, EnumeratedValues months, EnumeratedValues years, EnumeratedValues hours, EnumeratedValues minutes, String timezone, Long duration) {
        Calendar c = timezone == null ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(timezone));
        c.setTimeInMillis(startTime);
        while (c.getTimeInMillis() < currentTimestamp) {
            int amtToAdd;
            int amtToAdd2;
            int x = c.get(14);
            if (x != c.getMinimum(14)) {
                amtToAdd2 = c.getLeastMaximum(14) + 1 - x;
                if (amtToAdd2 < 1) {
                    amtToAdd2 = 1;
                }
                c.add(14, amtToAdd2);
                continue;
            }
            x = c.get(13);
            if (x != c.getMinimum(13)) {
                amtToAdd2 = c.getLeastMaximum(13) + 1 - x;
                if (amtToAdd2 < 1) {
                    amtToAdd2 = 1;
                }
                c.add(13, amtToAdd2);
                continue;
            }
            boolean startedToCareYet = false;
            x = c.get(12);
            if (minutes == null) {
                if (x != c.getMinimum(12)) {
                    amtToAdd = c.getLeastMaximum(12) + 1 - x;
                    if (amtToAdd < 1) {
                        amtToAdd = 1;
                    }
                    c.add(12, amtToAdd);
                    continue;
                }
            } else {
                if (!minutes.checkValue(x - c.getMinimum(12))) {
                    c.add(12, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            x = c.get(11);
            if (hours == null) {
                if (!startedToCareYet && x != c.getMinimum(11)) {
                    amtToAdd = c.getLeastMaximum(11) + 1 - x;
                    if (amtToAdd < 1) {
                        amtToAdd = 1;
                    }
                    c.add(11, amtToAdd);
                    continue;
                }
            } else {
                if (!hours.checkValue(x - c.getMinimum(11))) {
                    c.add(11, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            x = c.get(7);
            if (daysOfWeek != null) {
                if (!daysOfWeek.checkValue(x - c.getMinimum(7))) {
                    c.add(7, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            x = c.get(5);
            if (daysOfMonth == null) {
                if (!startedToCareYet && x != c.getMinimum(5)) {
                    amtToAdd = c.getLeastMaximum(5) + 1 - x;
                    if (amtToAdd < 1) {
                        amtToAdd = 1;
                    }
                    c.add(5, amtToAdd);
                    continue;
                }
            } else {
                if (!daysOfMonth.checkValue(x - c.getMinimum(5))) {
                    c.add(5, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            x = c.get(2);
            if (months == null) {
                if (!startedToCareYet && x != c.getMinimum(2)) {
                    amtToAdd = c.getLeastMaximum(2) + 1 - x;
                    if (amtToAdd < 1) {
                        amtToAdd = 1;
                    }
                    c.add(2, amtToAdd);
                    continue;
                }
            } else {
                if (!months.checkValue(x - c.getMinimum(2))) {
                    c.add(2, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            x = c.get(1);
            if (years != null) {
                if (!years.checkValue(x)) {
                    c.add(1, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            if (duration != null && c.getTimeInMillis() + duration <= currentTimestamp) {
                c.add(14, c.getLeastMaximum(14));
                continue;
            }
            return new Long(c.getTimeInMillis());
        }
        return null;
    }

    public void manualStart(Long jobID) throws ManifoldCFException {
        this.database.beginTransaction();
        try {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(jobID);
            IResultSet set = this.database.performQuery("SELECT " + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "id" + "=? FOR UPDATE", list, null, null);
            if (set.getRowCount() < 1) {
                throw new ManifoldCFException("No such job: " + jobID);
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus(row.getValue("status").toString());
            if (status != 0) {
                throw new ManifoldCFException("Job " + jobID + " is already running");
            }
            IJobDescription jobDescription = this.jobs.load(jobID, true);
            if (Logging.jobs.isDebugEnabled()) {
                Logging.jobs.debug((Object)("Manually starting job " + jobID));
            }
            this.jobs.startJob(jobID, null);
            this.jobQueue.clearFailTimes(jobID);
            if (Logging.jobs.isDebugEnabled()) {
                Logging.jobs.debug((Object)("Manual job start signal for job " + jobID + " successfully sent"));
            }
        }
        catch (ManifoldCFException e) {
            this.database.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.database.signalRollback();
            throw e;
        }
        finally {
            this.database.endTransaction();
        }
    }

    public void noteJobDeleteStarted(Long jobID, long startTime) throws ManifoldCFException {
        this.jobs.noteJobDeleteStarted(jobID, startTime);
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Job " + jobID + " delete is now started"));
        }
    }

    public void noteJobStarted(Long jobID, long startTime) throws ManifoldCFException {
        this.jobs.noteJobStarted(jobID, startTime);
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Job " + jobID + " is now started"));
        }
    }

    public void noteJobSeeded(Long jobID, long seedTime) throws ManifoldCFException {
        this.jobs.noteJobSeeded(jobID, seedTime);
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Job " + jobID + " has been successfully reseeded"));
        }
    }

    public void prepareDeleteScan(Long jobID) throws ManifoldCFException {
        this.jobQueue.prepareDeleteScan(jobID);
    }

    public void prepareFullScan(Long jobID, String[] legalLinkTypes, int hopcountMethod) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                if (legalLinkTypes.length > 0) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(JobQueue.statusToString(0));
                    this.hopCount.deleteMatchingDocuments(jobID, legalLinkTypes, this.jobQueue.getTableName() + " t99", "t99." + "dochash", "t99." + "jobid", "t99." + "status" + "=?", list, hopcountMethod);
                }
                this.jobQueue.prepareFullScan(jobID);
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction preparing full scan: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void prepareIncrementalScan(Long jobID, String[] legalLinkTypes, int hopcountMethod) throws ManifoldCFException {
        this.jobQueue.prepareIncrementalScan(jobID);
    }

    public void manualAbort(Long jobID) throws ManifoldCFException {
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Manually aborting job " + jobID));
        }
        this.jobs.abortJob(jobID, null);
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Job " + jobID + " abort signal successfully sent"));
        }
    }

    public void manualAbortRestart(Long jobID) throws ManifoldCFException {
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Manually restarting job " + jobID));
        }
        this.jobs.abortRestartJob(jobID);
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Job " + jobID + " restart signal successfully sent"));
        }
    }

    public boolean errorAbort(Long jobID, String errorText) throws ManifoldCFException {
        boolean rval;
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Aborting job " + jobID + " due to error '" + errorText + "'"));
        }
        if ((rval = this.jobs.abortJob(jobID, errorText)) && Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Job " + jobID + " abort signal successfully sent"));
        }
        return rval;
    }

    public void pauseJob(Long jobID) throws ManifoldCFException {
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Manually pausing job " + jobID));
        }
        this.jobs.pauseJob(jobID);
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Job " + jobID + " successfully paused"));
        }
    }

    public void restartJob(Long jobID) throws ManifoldCFException {
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Manually restarting paused job " + jobID));
        }
        this.database.beginTransaction();
        try {
            this.jobs.restartJob(jobID);
            this.jobQueue.clearFailTimes(jobID);
        }
        catch (ManifoldCFException e) {
            this.database.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.database.signalRollback();
            throw e;
        }
        finally {
            this.database.endTransaction();
        }
        if (Logging.jobs.isDebugEnabled()) {
            Logging.jobs.debug((Object)("Job " + jobID + " successfully restarted"));
        }
    }

    public JobStartRecord[] getJobsReadyForSeeding(long currentTime) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Jobs.statusToString(1));
                list.add(Jobs.typeToString(0));
                list.add(new Long(currentTime));
                IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "lastchecktime" + "," + "reseedinterval" + " FROM " + this.jobs.getTableName() + " WHERE " + "status" + "=? AND " + "type" + "=? AND (" + "reseedtime" + " IS NULL OR " + "reseedtime" + "<=?) FOR UPDATE", list, null, null);
                JobStartRecord[] rval = new JobStartRecord[set.getRowCount()];
                for (int i = 0; i < rval.length; ++i) {
                    Long r;
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("id");
                    Long x = (Long)row.getValue("lastchecktime");
                    long synchTime = 0L;
                    if (x != null) {
                        synchTime = x;
                    }
                    Long reseedTime = (r = (Long)row.getValue("reseedinterval")) != null ? new Long(currentTime + r) : null;
                    this.jobs.writeStatus(jobID, 11, reseedTime);
                    if (Logging.jobs.isDebugEnabled()) {
                        Logging.jobs.debug((Object)("Marked job " + jobID + " for seeding"));
                    }
                    rval[i] = new JobStartRecord(jobID, synchTime);
                }
                JobStartRecord[] jobStartRecordArray = rval;
                return jobStartRecordArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted getting jobs ready for seeding: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public JobStartRecord[] getJobsReadyForDelete() throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<String> list = new ArrayList<String>();
                list.add(Jobs.statusToString(10));
                IResultSet set = this.database.performQuery("SELECT " + "id" + " FROM " + this.jobs.getTableName() + " WHERE " + "status" + "=? FOR UPDATE", list, null, null);
                JobStartRecord[] rval = new JobStartRecord[set.getRowCount()];
                for (int i = 0; i < rval.length; ++i) {
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("id");
                    this.jobs.writeStatus(jobID, 22);
                    if (Logging.jobs.isDebugEnabled()) {
                        Logging.jobs.debug((Object)("Marked job " + jobID + " for delete startup"));
                    }
                    rval[i] = new JobStartRecord(jobID, 0L);
                }
                JobStartRecord[] jobStartRecordArray = rval;
                return jobStartRecordArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted getting jobs ready for startup: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public JobStartRecord[] getJobsReadyForStartup() throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<String> list = new ArrayList<String>();
                list.add(Jobs.statusToString(9));
                IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "lastchecktime" + " FROM " + this.jobs.getTableName() + " WHERE " + "status" + "=? FOR UPDATE", list, null, null);
                JobStartRecord[] rval = new JobStartRecord[set.getRowCount()];
                for (int i = 0; i < rval.length; ++i) {
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("id");
                    Long x = (Long)row.getValue("lastchecktime");
                    long synchTime = 0L;
                    if (x != null) {
                        synchTime = x;
                    }
                    this.jobs.writeStatus(jobID, 7);
                    if (Logging.jobs.isDebugEnabled()) {
                        Logging.jobs.debug((Object)("Marked job " + jobID + " for startup"));
                    }
                    rval[i] = new JobStartRecord(jobID, synchTime);
                }
                JobStartRecord[] jobStartRecordArray = rval;
                return jobStartRecordArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted getting jobs ready for startup: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inactivateJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(jobID);
                IResultSet set = this.database.performQuery("SELECT " + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "id" + "=? FOR UPDATE", list, null, null);
                if (set.getRowCount() == 0) {
                    throw new ManifoldCFException("No such job: " + jobID);
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 20: {
                        this.jobs.notificationComplete(jobID);
                        return;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() != 6) throw e;
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Aborted clearing notification state for job: " + e.getMessage()));
                }
                sleepAmt = this.getRandomAmount();
                continue;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetStartDeleteJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(jobID);
                IResultSet set = this.database.performQuery("SELECT " + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "id" + "=? FOR UPDATE", list, null, null);
                if (set.getRowCount() == 0) {
                    throw new ManifoldCFException("No such job: " + jobID);
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 22: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'ReadyForDelete' state"));
                        }
                        this.jobs.writeStatus(jobID, 10);
                        return;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() != 6) throw e;
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Aborted resetting start delete job: " + e.getMessage()));
                }
                sleepAmt = this.getRandomAmount();
                continue;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetNotifyJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(jobID);
                IResultSet set = this.database.performQuery("SELECT " + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "id" + "=? FOR UPDATE", list, null, null);
                if (set.getRowCount() == 0) {
                    throw new ManifoldCFException("No such job: " + jobID);
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 20: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'ReadyForNotify' state"));
                        }
                        this.jobs.writeStatus(jobID, 10);
                        return;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() != 6) throw e;
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Aborted resetting notify job: " + e.getMessage()));
                }
                sleepAmt = this.getRandomAmount();
                continue;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetStartupJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(jobID);
                IResultSet set = this.database.performQuery("SELECT " + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "id" + "=? FOR UPDATE", list, null, null);
                if (set.getRowCount() == 0) {
                    throw new ManifoldCFException("No such job: " + jobID);
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 7: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'ReadyForStartup' state"));
                        }
                        this.jobs.writeStatus(jobID, 9);
                        return;
                    }
                    case 8: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " to 'Aborting' state"));
                        }
                        this.jobs.writeStatus(jobID, 6);
                        return;
                    }
                    case 18: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " to 'AbortingForRestart' state"));
                        }
                        this.jobs.writeStatus(jobID, 16);
                        return;
                    }
                    case 6: 
                    case 9: 
                    case 16: {
                        return;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() != 6) throw e;
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Aborted resetting startup job: " + e.getMessage()));
                }
                sleepAmt = this.getRandomAmount();
                continue;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetSeedJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(jobID);
                IResultSet set = this.database.performQuery("SELECT " + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "id" + "=? FOR UPDATE", list, null, null);
                if (set.getRowCount() == 0) {
                    throw new ManifoldCFException("No such job: " + jobID);
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 24: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'Active_Uninstalled' state"));
                        }
                        this.jobs.writeStatus(jobID, 23);
                        return;
                    }
                    case 26: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'Active_NoOutput' state"));
                        }
                        this.jobs.writeStatus(jobID, 25);
                        return;
                    }
                    case 28: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'Active_Neither' state"));
                        }
                        this.jobs.writeStatus(jobID, 27);
                        return;
                    }
                    case 11: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'Active' state"));
                        }
                        this.jobs.writeStatus(jobID, 1);
                        return;
                    }
                    case 14: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'ActiveWait' state"));
                        }
                        this.jobs.writeStatus(jobID, 4);
                        return;
                    }
                    case 13: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'Paused' state"));
                        }
                        this.jobs.writeStatus(jobID, 2);
                        return;
                    }
                    case 15: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'PausedWait' state"));
                        }
                        this.jobs.writeStatus(jobID, 5);
                        return;
                    }
                    case 12: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'Aborting' state"));
                        }
                        this.jobs.writeStatus(jobID, 6);
                        return;
                    }
                    case 17: {
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)("Setting job " + jobID + " back to 'AbortingForRestart' state"));
                        }
                        this.jobs.writeStatus(jobID, 16);
                        return;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 23: 
                    case 25: 
                    case 27: {
                        return;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() != 6) throw e;
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Aborted resetting seeding job: " + e.getMessage()));
                }
                sleepAmt = this.getRandomAmount();
                continue;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void deleteJobsReadyForDelete() throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Jobs.statusToString(21));
                IResultSet set = this.database.performQuery("SELECT " + "id" + " FROM " + this.jobs.getTableName() + " WHERE " + "status" + "=? FOR UPDATE", list, null, null);
                int i = 0;
                while (i < set.getRowCount()) {
                    IResultRow row = set.getRow(i++);
                    Long jobID = (Long)row.getValue("id");
                    list.clear();
                    list.add(jobID);
                    list.add(JobQueue.statusToString(10));
                    list.add(JobQueue.statusToString(6));
                    IResultSet confirmSet = this.database.performQuery("SELECT " + "id" + " FROM " + this.jobQueue.getTableName() + " WHERE " + "jobid" + "=? AND " + "status" + " IN (?,?) " + this.database.constructOffsetLimitClause(0, 1), list, null, null, 1, null);
                    if (confirmSet.getRowCount() > 0) continue;
                    ManifoldCF.noteConfigurationChange();
                    this.jobQueue.deleteAllJobRecords(jobID);
                    this.carryDown.deleteOwner(jobID);
                    this.hopCount.deleteOwner(jobID);
                    this.jobs.delete(jobID);
                    if (!Logging.jobs.isDebugEnabled()) continue;
                    Logging.jobs.debug((Object)("Removed job " + jobID));
                }
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted deleting jobs ready for delete: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void finishJobs() throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Jobs.statusToString(1));
                list.add(Jobs.statusToString(4));
                list.add(Jobs.statusToString(23));
                list.add(Jobs.statusToString(25));
                list.add(Jobs.statusToString(27));
                IResultSet set = this.database.performQuery("SELECT " + "id" + " FROM " + this.jobs.getTableName() + " WHERE " + "status" + " IN (?,?,?,?,?) FOR UPDATE", list, null, null);
                int i = 0;
                while (i < set.getRowCount()) {
                    IResultRow row = set.getRow(i++);
                    Long jobID = (Long)row.getValue("id");
                    list.clear();
                    list.add(jobID);
                    list.add(JobQueue.statusToString(1));
                    list.add(jobID);
                    list.add(JobQueue.statusToString(7));
                    list.add(jobID);
                    list.add(JobQueue.statusToString(0));
                    list.add(jobID);
                    list.add(JobQueue.statusToString(4));
                    list.add(jobID);
                    list.add(JobQueue.statusToString(8));
                    list.add(jobID);
                    list.add(JobQueue.statusToString(3));
                    IResultSet confirmSet = this.database.performQuery("SELECT " + "id" + " FROM " + this.jobQueue.getTableName() + " WHERE " + "(" + "jobid" + "=? AND " + "status" + "=?) OR " + "(" + "jobid" + "=? AND " + "status" + "=?) OR " + "(" + "jobid" + "=? AND " + "status" + "=?) OR " + "(" + "jobid" + "=? AND " + "status" + "=?) OR " + "(" + "jobid" + "=? AND " + "status" + "=?) OR " + "(" + "jobid" + "=? AND " + "status" + "=?) " + this.database.constructOffsetLimitClause(0, 1), list, null, null, 1, null);
                    if (confirmSet.getRowCount() > 0) continue;
                    this.jobs.writeStatus(jobID, 3);
                    if (!Logging.jobs.isDebugEnabled()) continue;
                    Logging.jobs.debug((Object)("Marked job " + jobID + " for shutdown"));
                }
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted finishing jobs: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public JobStartRecord[] getJobsReadyForInactivity() throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<String> list = new ArrayList<String>();
                list.add(Jobs.statusToString(19));
                IResultSet set = this.database.performQuery("SELECT " + "id" + " FROM " + this.jobs.getTableName() + " WHERE " + "status" + "=?", list, null, null);
                JobStartRecord[] rval = new JobStartRecord[set.getRowCount()];
                int i = 0;
                while (i < rval.length) {
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("id");
                    this.jobs.writeStatus(jobID, 20);
                    if (Logging.jobs.isDebugEnabled()) {
                        Logging.jobs.debug((Object)("Found job " + jobID + " in need of notification"));
                    }
                    rval[i++] = new JobStartRecord(jobID, 0L);
                }
                JobStartRecord[] jobStartRecordArray = rval;
                return jobStartRecordArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted getting jobs ready for notify: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void finishJobAborts(long timestamp, ArrayList abortJobs) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Jobs.statusToString(6));
                list.add(Jobs.statusToString(16));
                IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + "status" + " IN (?,?) FOR UPDATE", list, null, null);
                int i = 0;
                block12: while (i < set.getRowCount()) {
                    IResultRow row = set.getRow(i++);
                    Long jobID = (Long)row.getValue("id");
                    list.clear();
                    list.add(jobID);
                    list.add(JobQueue.statusToString(1));
                    list.add(jobID);
                    list.add(JobQueue.statusToString(4));
                    list.add(jobID);
                    list.add(JobQueue.statusToString(7));
                    list.add(jobID);
                    list.add(JobQueue.statusToString(8));
                    IResultSet confirmSet = this.database.performQuery("SELECT " + "id" + " FROM " + this.jobQueue.getTableName() + " WHERE " + "(" + "jobid" + "=? AND " + "status" + "=?) OR " + "(" + "jobid" + "=? AND " + "status" + "=?) OR " + "(" + "jobid" + "=? AND " + "status" + "=?) OR " + "(" + "jobid" + "=? AND " + "status" + "=?) " + this.database.constructOffsetLimitClause(0, 1), list, null, null, 1, null);
                    if (confirmSet.getRowCount() > 0) continue;
                    int status = Jobs.stringToStatus((String)row.getValue("status"));
                    IJobDescription jobDesc = this.jobs.load(jobID, true);
                    abortJobs.add(jobDesc);
                    switch (status) {
                        case 6: {
                            this.jobs.finishAbortJob(jobID, timestamp);
                            if (!Logging.jobs.isDebugEnabled()) continue block12;
                            Logging.jobs.debug((Object)("Completed abort of job " + jobID));
                            continue block12;
                        }
                        case 16: {
                            this.jobs.startJob(jobID, null);
                            Logging.jobs.debug((Object)("Completed restart of job " + jobID));
                            continue block12;
                        }
                    }
                    throw new ManifoldCFException("Unexpected value for job status: " + Integer.toString(status));
                }
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted finishing job aborts: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public void resetJobs(long currentTime, ArrayList resetJobs) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Jobs.statusToString(3));
                IResultSet set = this.database.performQuery("SELECT " + "id" + " FROM " + this.jobs.getTableName() + " WHERE " + "status" + "=? FOR UPDATE", list, null, null);
                int i = 0;
                while (i < set.getRowCount()) {
                    IResultRow row = set.getRow(i++);
                    Long jobID = (Long)row.getValue("id");
                    list.clear();
                    list.add(jobID);
                    list.add(JobQueue.statusToString(5));
                    list.add(jobID);
                    list.add(JobQueue.statusToString(9));
                    IResultSet confirmSet = this.database.performQuery("SELECT " + "id" + " FROM " + this.jobQueue.getTableName() + " WHERE " + "(" + "jobid" + "=? AND " + "status" + "=?) OR " + "(" + "jobid" + "=? AND " + "status" + "=?) " + this.database.constructOffsetLimitClause(0, 1), list, null, null, 1, null);
                    if (confirmSet.getRowCount() > 0) continue;
                    list.clear();
                    list.add(jobID);
                    list.add(JobQueue.statusToString(0));
                    list.add(jobID);
                    list.add(JobQueue.statusToString(3));
                    confirmSet = this.database.performQuery("SELECT " + "id" + " FROM " + this.jobQueue.getTableName() + " WHERE " + "(" + "jobid" + "=? AND " + "status" + "=?) OR " + "(" + "jobid" + "=? AND " + "status" + "=?) " + this.database.constructOffsetLimitClause(0, 1), list, null, null, 1, null);
                    if (confirmSet.getRowCount() > 0) {
                        this.jobs.returnJobToActive(jobID);
                        if (!Logging.jobs.isDebugEnabled()) continue;
                        Logging.jobs.debug((Object)("Job " + jobID + " is re-entering active state"));
                        continue;
                    }
                    IJobDescription jobDesc = this.jobs.load(jobID, true);
                    resetJobs.add(jobDesc);
                    this.jobs.finishJob(jobID, currentTime);
                    if (!Logging.jobs.isDebugEnabled()) continue;
                    Logging.jobs.debug((Object)("Job " + jobID + " now completed"));
                }
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted resetting jobs: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    public JobStatus getStatus(Long jobID) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        String whereClause = "id=?";
        list.add(jobID);
        JobStatus[] records = this.makeJobStatus(whereClause, list);
        if (records.length == 0) {
            return null;
        }
        return records[0];
    }

    public JobStatus[] getAllStatus() throws ManifoldCFException {
        return this.makeJobStatus(null, null);
    }

    public JobStatus[] getRunningJobs() throws ManifoldCFException {
        ArrayList<String> whereParams = new ArrayList<String>();
        whereParams.add(Jobs.statusToString(1));
        whereParams.add(Jobs.statusToString(11));
        whereParams.add(Jobs.statusToString(23));
        whereParams.add(Jobs.statusToString(24));
        whereParams.add(Jobs.statusToString(25));
        whereParams.add(Jobs.statusToString(26));
        whereParams.add(Jobs.statusToString(27));
        whereParams.add(Jobs.statusToString(28));
        whereParams.add(Jobs.statusToString(2));
        whereParams.add(Jobs.statusToString(13));
        whereParams.add(Jobs.statusToString(4));
        whereParams.add(Jobs.statusToString(14));
        whereParams.add(Jobs.statusToString(5));
        whereParams.add(Jobs.statusToString(15));
        String whereClause = "status IN (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        return this.makeJobStatus(whereClause, whereParams);
    }

    public JobStatus[] getFinishedJobs() throws ManifoldCFException {
        ArrayList<String> whereParams = new ArrayList<String>();
        whereParams.add(Jobs.statusToString(0));
        String whereClause = "status=? AND endtimeIS NOT NULL";
        return this.makeJobStatus(whereClause, whereParams);
    }

    protected JobStatus[] makeJobStatus(String whereClause, ArrayList whereParams) throws ManifoldCFException {
        IResultSet set = this.database.performQuery("SELECT t0.id,t0.description,t0.status,t0.starttime,t0.endtime,t0.errortext FROM " + this.jobs.getTableName() + " t0 " + (whereClause == null ? "" : " WHERE " + whereClause) + " ORDER BY " + "description" + " ASC", whereParams, null, null);
        IResultSet set2 = this.database.performQuery("SELECT jobid,CAST(COUNT(dochash) AS BIGINT) AS doccount FROM " + this.jobQueue.getTableName() + " t1" + (whereClause == null ? "" : " WHERE EXISTS(SELECT 'x' FROM " + this.jobs.getTableName() + " t0 WHERE t0." + "id" + "=t1." + "jobid" + " AND " + whereClause + ")") + " GROUP BY " + "jobid", whereParams, null, null);
        ArrayList<String> list = new ArrayList<String>();
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.statusToString(3));
        if (whereParams != null) {
            list.addAll(whereParams);
        }
        IResultSet set3 = this.database.performQuery("SELECT jobid,CAST(COUNT(dochash) AS BIGINT) AS doccount FROM " + this.jobQueue.getTableName() + " t1 WHERE " + "status" + " IN (?,?,?,?,?,?)" + (whereClause == null ? "" : " AND EXISTS(SELECT 'x' FROM " + this.jobs.getTableName() + " t0 WHERE t0." + "id" + "=t1." + "jobid" + " AND " + whereClause + ")") + " GROUP BY " + "jobid", list, null, null);
        list.clear();
        list.add(JobQueue.statusToString(2));
        list.add(JobQueue.statusToString(5));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.statusToString(3));
        if (whereParams != null) {
            list.addAll(whereParams);
        }
        IResultSet set4 = this.database.performQuery("SELECT jobid,CAST(COUNT(dochash) AS BIGINT) AS doccount FROM " + this.jobQueue.getTableName() + " t1 WHERE " + "status" + " IN (?,?,?,?,?)" + (whereClause == null ? "" : " AND EXISTS(SELECT 'x' FROM " + this.jobs.getTableName() + " t0 WHERE t0." + "id" + "=t1." + "jobid" + " AND " + whereClause + ")") + " GROUP BY " + "jobid", list, null, null);
        HashMap<Object, Object> set2Hash = new HashMap<Object, Object>();
        int i = 0;
        while (i < set2.getRowCount()) {
            IResultRow row = set2.getRow(i++);
            set2Hash.put(row.getValue("jobid"), row.getValue("doccount"));
        }
        HashMap<Object, Object> set3Hash = new HashMap<Object, Object>();
        i = 0;
        while (i < set3.getRowCount()) {
            IResultRow row = set3.getRow(i++);
            set3Hash.put(row.getValue("jobid"), row.getValue("doccount"));
        }
        HashMap<Object, Object> set4Hash = new HashMap<Object, Object>();
        i = 0;
        while (i < set4.getRowCount()) {
            IResultRow row = set4.getRow(i++);
            set4Hash.put(row.getValue("jobid"), row.getValue("doccount"));
        }
        JobStatus[] rval = new JobStatus[set.getRowCount()];
        i = 0;
        while (i < rval.length) {
            String errorText;
            IResultRow row = set.getRow(i);
            Long jobID = (Long)row.getValue("id");
            String description = row.getValue("description").toString();
            int status = Jobs.stringToStatus(row.getValue("status").toString());
            Long startTimeValue = (Long)row.getValue("starttime");
            long startTime = -1L;
            if (startTimeValue != null) {
                startTime = startTimeValue;
            }
            Long endTimeValue = (Long)row.getValue("endtime");
            long endTime = -1L;
            if (endTimeValue != null) {
                endTime = endTimeValue;
            }
            if ((errorText = (String)row.getValue("errortext")) != null && errorText.length() == 0) {
                errorText = null;
            }
            int rstatus = 0;
            switch (status) {
                case 0: {
                    if (errorText != null) {
                        rstatus = 7;
                        break;
                    }
                    if (startTime >= 0L) {
                        rstatus = 3;
                        break;
                    }
                    rstatus = 0;
                    break;
                }
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    rstatus = 10;
                    break;
                }
                case 1: 
                case 11: {
                    rstatus = 1;
                    break;
                }
                case 3: {
                    rstatus = 11;
                    break;
                }
                case 19: 
                case 20: {
                    rstatus = 12;
                    break;
                }
                case 6: 
                case 8: 
                case 12: {
                    rstatus = 8;
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    rstatus = 9;
                    break;
                }
                case 2: 
                case 13: {
                    rstatus = 2;
                    break;
                }
                case 4: 
                case 14: {
                    rstatus = 4;
                    break;
                }
                case 5: 
                case 15: {
                    rstatus = 2;
                    break;
                }
                case 7: 
                case 9: {
                    rstatus = 5;
                    break;
                }
                case 10: 
                case 21: 
                case 29: {
                    rstatus = 6;
                    break;
                }
            }
            Long set2Value = (Long)set2Hash.get(jobID);
            Long set3Value = (Long)set3Hash.get(jobID);
            Long set4Value = (Long)set4Hash.get(jobID);
            rval[i++] = new JobStatus(jobID.toString(), description, rstatus, set2Value == null ? 0L : set2Value, set3Value == null ? 0L : set3Value, set4Value == null ? 0L : set4Value, startTime, endTime, errorText);
        }
        return rval;
    }

    public IResultSet genDocumentStatus(String connectionName, StatusFilterCriteria filterCriteria, SortOrder sortOrder, int startRow, int rowCount) throws ManifoldCFException {
        Long currentTime = new Long(System.currentTimeMillis());
        StringBuffer sb = new StringBuffer("SELECT ");
        ArrayList<String> list = new ArrayList<String>();
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.statusToString(2));
        list.add(JobQueue.statusToString(5));
        list.add(JobQueue.statusToString(6));
        list.add(JobQueue.statusToString(9));
        list.add(JobQueue.statusToString(10));
        list.add(JobQueue.statusToString(2));
        list.add(JobQueue.statusToString(5));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.statusToString(6));
        list.add(JobQueue.statusToString(9));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.actionToString(1));
        sb.append("t0.").append("id").append(" AS id,").append("t0.").append("docid").append(" AS identifier,").append("t1.").append("description").append(" AS job,").append("CASE").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Not yet processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Not yet processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Not yet processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Being removed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Being removed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Being removed'").append(" ELSE 'Unknown'").append(" END AS state,").append("CASE").append(" WHEN ").append("(").append("t0.").append("status").append("=? OR ").append("t0.").append("status").append("=?").append(")").append(" THEN 'Inactive'").append(" WHEN ").append("t0.").append("checktime").append("<=").append(currentTime.toString()).append(" AND (t0.").append("checkaction").append(" IS NULL OR t0.").append("checkaction").append("=?)").append(" AND (").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(")").append(" THEN 'Ready for processing'").append(" WHEN ").append("t0.").append("checktime").append("<=").append(currentTime.toString()).append(" AND t0.").append("checkaction").append("=?").append(" AND (").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(")").append(" THEN 'Ready for expiration'").append(" WHEN ").append("t0.").append("checktime").append(">").append(currentTime.toString()).append(" AND (t0.").append("checkaction").append(" IS NULL OR t0.").append("checkaction").append("=?)").append(" AND (").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(")").append(" THEN 'Waiting for processing'").append(" WHEN ").append("t0.").append("checktime").append(">").append(currentTime.toString()).append(" AND t0.").append("checkaction").append("=?").append(" AND (").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(")").append(" THEN 'Waiting for expiration'").append(" WHEN ").append("t0.").append("checktime").append(" IS NULL").append(" AND (").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(")").append(" THEN 'Waiting forever'").append(" WHEN (").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(")").append(" THEN 'Deleting'").append(" WHEN ").append("(t0.").append("checkaction").append(" IS NULL OR t0.").append("checkaction").append("=?)").append(" AND (").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(")").append(" THEN 'Processing'").append(" WHEN ").append("t0.").append("checkaction").append("=?").append(" AND (").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(" OR ").append("t0.").append("status").append("=?").append(")").append(" THEN 'Expiring'").append(" ELSE 'Unknown'").append(" END AS status,").append("t0.").append("checktime").append(" AS scheduled,").append("CASE").append(" WHEN ").append("(t0.").append("checkaction").append(" IS NULL OR t0.").append("checkaction").append("=?) THEN 'Process'").append(" WHEN ").append("t0.").append("checkaction").append("=? THEN 'Expire'").append(" ELSE 'Unknown'").append(" END AS action,").append("t0.").append("failcount").append(" AS retrycount,").append("t0.").append("failtime").append(" AS retrylimit").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0,").append(this.jobs.getTableName()).append(" t1 WHERE ").append("t0.").append("jobid").append("=t1.").append("id");
        this.addCriteria(sb, list, "t0.", connectionName, filterCriteria, true);
        this.addOrdering(sb, new String[]{"id"}, sortOrder);
        this.addLimits(sb, startRow, rowCount);
        return this.database.performQuery(sb.toString(), list, null, null, rowCount, null);
    }

    public IResultSet genQueueStatus(String connectionName, StatusFilterCriteria filterCriteria, SortOrder sortOrder, BucketDescription idBucketDescription, int startRow, int rowCount) throws ManifoldCFException {
        Long currentTime = new Long(System.currentTimeMillis());
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        sb.append("SELECT t1.idbucket,SUM(t1.inactive) AS inactive,SUM(t1.processing) AS processing,SUM(t1.expiring) AS expiring,SUM(t1.deleting) AS deleting,").append("SUM(t1.processready) AS processready,SUM(t1.expireready) AS expireready,SUM(t1.processwaiting) AS processwaiting,SUM(t1.expirewaiting) AS expirewaiting,").append("SUM(t1.waitingforever) AS waitingforever FROM (SELECT ");
        this.addBucketExtract(sb, list, "", "docid", idBucketDescription);
        list.add(JobQueue.statusToString(2));
        list.add(JobQueue.statusToString(5));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.statusToString(6));
        list.add(JobQueue.statusToString(9));
        list.add(JobQueue.statusToString(10));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(3));
        sb.append(" AS idbucket,").append("CASE").append(" WHEN ").append("(").append("status").append("=?").append(" OR ").append("status").append("=?").append(")").append(" THEN 1 ELSE 0").append(" END").append(" AS inactive,").append("CASE").append(" WHEN ").append("(").append("checkaction").append(" IS NULL OR ").append("checkaction").append("=?)").append(" AND (").append("status").append("=?").append(" OR ").append("status").append("=?").append(" OR ").append("status").append("=?").append(" OR ").append("status").append("=?").append(")").append(" THEN 1 ELSE 0").append(" END").append(" as processing,").append("CASE").append(" WHEN ").append("checkaction").append("=?").append(" AND (").append("status").append("=?").append(" OR ").append("status").append("=?").append(" OR ").append("status").append("=?").append(" OR ").append("status").append("=?").append(")").append(" THEN 1 ELSE 0").append(" END").append(" as expiring,").append("CASE").append(" WHEN ").append("status").append("=?").append(" OR ").append("status").append("=?").append(" OR ").append("status").append("=?").append(" THEN 1 ELSE 0").append(" END").append(" as deleting,").append("CASE").append(" WHEN ").append("checktime").append("<=").append(currentTime.toString()).append(" AND (").append("checkaction").append(" IS NULL OR ").append("checkaction").append("=?)").append(" AND (").append("status").append("=?").append(" OR ").append("status").append("=?").append(")").append(" THEN 1 ELSE 0").append(" END").append(" as processready,").append("CASE").append(" WHEN ").append("checktime").append("<=").append(currentTime.toString()).append(" AND ").append("checkaction").append("=?").append(" AND (").append("status").append("=?").append(" OR ").append("status").append("=?").append(")").append(" THEN 1 ELSE 0").append(" END").append(" as expireready,").append("CASE").append(" WHEN ").append("checktime").append(">").append(currentTime.toString()).append(" AND (").append("checkaction").append(" IS NULL OR ").append("checkaction").append("=?)").append(" AND (").append("status").append("=?").append(" OR ").append("status").append("=?").append(")").append(" THEN 1 ELSE 0").append(" END").append(" as processwaiting,").append("CASE").append(" WHEN ").append("checktime").append(">").append(currentTime.toString()).append(" AND ").append("checkaction").append("=?").append(" AND (").append("status").append("=?").append(" OR ").append("status").append("=?").append(")").append(" THEN 1 ELSE 0").append(" END").append(" as expirewaiting,").append("CASE").append(" WHEN ").append("checktime").append(" IS NULL").append(" AND (").append("status").append("=?").append(" OR ").append("status").append("=?").append(")").append(" THEN 1 ELSE 0").append(" END").append(" as waitingforever");
        sb.append(" FROM ").append(this.jobQueue.getTableName());
        this.addCriteria(sb, list, "", connectionName, filterCriteria, false);
        sb.append(") t1 GROUP BY idbucket");
        this.addOrdering(sb, new String[]{"idbucket", "inactive", "processing", "expiring", "deleting", "processready", "expireready", "processwaiting", "expirewaiting", "waitingforever"}, sortOrder);
        this.addLimits(sb, startRow, rowCount);
        return this.database.performQuery(sb.toString(), list, null, null, rowCount, null);
    }

    protected void addBucketExtract(StringBuffer sb, ArrayList list, String columnPrefix, String columnName, BucketDescription bucketDesc) {
        boolean isSensitive = bucketDesc.isSensitive();
        list.add(bucketDesc.getRegexp());
        sb.append(this.database.constructSubstringClause(columnPrefix + columnName, "?", !isSensitive));
    }

    protected boolean addCriteria(StringBuffer sb, ArrayList list, String fieldPrefix, String connectionName, StatusFilterCriteria criteria, boolean whereEmitted) throws ManifoldCFException {
        int stateValue;
        int k;
        RegExpCriteria identifierRegexp;
        Long[] matchingJobs = criteria.getJobs();
        if (matchingJobs != null) {
            whereEmitted = this.emitClauseStart(sb, whereEmitted);
            if (matchingJobs.length == 0) {
                sb.append("0>1");
            } else {
                sb.append(fieldPrefix).append("jobid").append(" IN(");
                int i = 0;
                while (i < matchingJobs.length) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    Long jobID = matchingJobs[i++];
                    sb.append(jobID.toString());
                }
                sb.append(")");
            }
        }
        if ((identifierRegexp = criteria.getIdentifierMatch()) != null) {
            whereEmitted = this.emitClauseStart(sb, whereEmitted);
            list.add(identifierRegexp.getRegexpString());
            sb.append(this.database.constructRegexpClause(fieldPrefix + "docid", "?", identifierRegexp.isInsensitive()));
        }
        Long nowTime = new Long(criteria.getNowTime());
        int[] states = criteria.getMatchingStates();
        int[] statuses = criteria.getMatchingStatuses();
        if (states.length == 0 || statuses.length == 0) {
            whereEmitted = this.emitClauseStart(sb, whereEmitted);
            sb.append("0>1");
            return whereEmitted;
        }
        whereEmitted = this.emitClauseStart(sb, whereEmitted);
        sb.append("(");
        block16: for (k = 0; k < states.length; ++k) {
            stateValue = states[k];
            if (k > 0) {
                sb.append(" OR ");
            }
            switch (stateValue) {
                case 0: {
                    list.add(JobQueue.statusToString(0));
                    list.add(JobQueue.statusToString(1));
                    list.add(JobQueue.statusToString(7));
                    sb.append(fieldPrefix).append("status").append(" IN (?,?,?)");
                    continue block16;
                }
                case 1: {
                    list.add(JobQueue.statusToString(3));
                    list.add(JobQueue.statusToString(4));
                    list.add(JobQueue.statusToString(8));
                    list.add(JobQueue.statusToString(10));
                    list.add(JobQueue.statusToString(6));
                    list.add(JobQueue.statusToString(9));
                    list.add(JobQueue.statusToString(2));
                    list.add(JobQueue.statusToString(5));
                    sb.append(fieldPrefix).append("status").append(" IN (?,?,?,?,?,?,?,?)");
                }
            }
        }
        sb.append(")");
        whereEmitted = this.emitClauseStart(sb, whereEmitted);
        sb.append("(");
        block17: for (k = 0; k < statuses.length; ++k) {
            stateValue = statuses[k];
            if (k > 0) {
                sb.append(" OR ");
            }
            switch (stateValue) {
                case 0: {
                    list.add(JobQueue.statusToString(2));
                    list.add(JobQueue.statusToString(5));
                    sb.append(fieldPrefix).append("status").append(" IN (?,?)");
                    continue block17;
                }
                case 1: {
                    list.add(JobQueue.statusToString(1));
                    list.add(JobQueue.statusToString(7));
                    list.add(JobQueue.statusToString(4));
                    list.add(JobQueue.statusToString(8));
                    list.add(JobQueue.actionToString(0));
                    sb.append(fieldPrefix).append("status").append(" IN (?,?,?,?)").append(" AND (").append(fieldPrefix).append("checkaction").append(" IS NULL OR ").append(fieldPrefix).append("checkaction").append("=?)");
                    continue block17;
                }
                case 2: {
                    list.add(JobQueue.statusToString(1));
                    list.add(JobQueue.statusToString(7));
                    list.add(JobQueue.statusToString(4));
                    list.add(JobQueue.statusToString(8));
                    list.add(JobQueue.actionToString(1));
                    sb.append(fieldPrefix).append("status").append(" IN (?,?,?,?)").append(" AND ").append(fieldPrefix).append("checkaction").append("=?");
                    continue block17;
                }
                case 3: {
                    list.add(JobQueue.statusToString(6));
                    list.add(JobQueue.statusToString(9));
                    list.add(JobQueue.statusToString(10));
                    sb.append(fieldPrefix).append("status").append(" IN (?,?,?)");
                    continue block17;
                }
                case 4: {
                    list.add(JobQueue.statusToString(0));
                    list.add(JobQueue.statusToString(3));
                    list.add(JobQueue.actionToString(0));
                    sb.append(fieldPrefix).append("status").append(" IN (?,?)").append(" AND (").append(fieldPrefix).append("checkaction").append(" IS NULL OR ").append(fieldPrefix).append("checkaction").append("=?)").append(" AND ").append(fieldPrefix).append("checktime").append("<=").append(nowTime.toString());
                    continue block17;
                }
                case 5: {
                    list.add(JobQueue.statusToString(0));
                    list.add(JobQueue.statusToString(3));
                    list.add(JobQueue.actionToString(1));
                    sb.append(fieldPrefix).append("status").append(" IN (?,?)").append(" AND ").append(fieldPrefix).append("checkaction").append("=?").append(" AND ").append(fieldPrefix).append("checktime").append("<=").append(nowTime.toString());
                    continue block17;
                }
                case 6: {
                    list.add(JobQueue.statusToString(0));
                    list.add(JobQueue.statusToString(3));
                    list.add(JobQueue.actionToString(0));
                    sb.append(fieldPrefix).append("status").append(" IN (?,?)").append(" AND (").append(fieldPrefix).append("checkaction").append(" IS NULL OR ").append(fieldPrefix).append("checkaction").append("=?)").append(" AND ").append(fieldPrefix).append("checktime").append(">").append(nowTime.toString());
                    continue block17;
                }
                case 7: {
                    list.add(JobQueue.statusToString(0));
                    list.add(JobQueue.statusToString(3));
                    list.add(JobQueue.actionToString(1));
                    sb.append(fieldPrefix).append("status").append(" IN (?,?)").append(" AND ").append(fieldPrefix).append("checkaction").append("=?").append(" AND ").append(fieldPrefix).append("checktime").append(">").append(nowTime.toString());
                    continue block17;
                }
                case 8: {
                    list.add(JobQueue.statusToString(0));
                    list.add(JobQueue.statusToString(3));
                    sb.append(fieldPrefix).append("status").append(" IN (?,?)").append(" AND ").append(fieldPrefix).append("checktime").append(" IS NULL");
                }
            }
        }
        sb.append(")");
        return whereEmitted;
    }

    protected boolean emitClauseStart(StringBuffer sb, boolean whereEmitted) {
        if (whereEmitted) {
            sb.append(" AND ");
        } else {
            sb.append(" WHERE ");
        }
        return true;
    }

    protected void addOrdering(StringBuffer sb, String[] completeFieldList, SortOrder sort) {
        int i;
        HashMap<String, String> hash = new HashMap<String, String>();
        sb.append(" ORDER BY ");
        int count = sort.getCount();
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            String column = sort.getColumn(i);
            sb.append(column);
            if (sort.getDirection(i) == 0) {
                sb.append(" ASC");
            } else {
                sb.append(" DESC");
            }
            hash.put(column, column);
        }
        for (int j = 0; j < completeFieldList.length; ++j) {
            String field = completeFieldList[j];
            if (hash.get(field) != null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append(field);
            sb.append(" DESC");
            ++i;
        }
    }

    protected void addLimits(StringBuffer sb, int startRow, int maxRowCount) {
        sb.append(" ").append(this.database.constructOffsetLimitClause(startRow, maxRowCount));
    }

    protected static class MutableInteger {
        int value;

        public MutableInteger(int value) {
            this.value = value;
        }

        public MutableInteger duplicate() {
            return new MutableInteger(this.value);
        }

        public void decrement() {
            --this.value;
        }

        public void increment() {
            ++this.value;
        }

        public int intValue() {
            return this.value;
        }
    }

    protected static class ThrottleLimitSpec {
        protected Pattern regexp;
        protected int maxCount;

        public ThrottleLimitSpec(String regexp, int maxCount) throws PatternSyntaxException {
            this.regexp = Pattern.compile(regexp);
            this.maxCount = maxCount;
        }

        public Pattern getRegexp() {
            return this.regexp;
        }

        public int getMaxCount() {
            return this.maxCount;
        }
    }

    protected static class ThrottleJobItem {
        protected ArrayList throttleLimits = new ArrayList();
        protected HashMap binCounts = new HashMap();

        public void addLimit(String regexp, int maxCount) {
            try {
                this.throttleLimits.add(new ThrottleLimitSpec(regexp, maxCount));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }

        public ThrottleJobItem duplicate() {
            ThrottleJobItem rval = new ThrottleJobItem();
            rval.throttleLimits = this.throttleLimits;
            for (String key : this.binCounts.keySet()) {
                this.binCounts.put(key, ((MutableInteger)this.binCounts.get(key)).duplicate());
            }
            return rval;
        }

        public boolean isEmpty(String binName) {
            int remaining;
            MutableInteger value = (MutableInteger)this.binCounts.get(binName);
            if (value == null) {
                int x = this.findMaxCount(binName);
                if (x == -1) {
                    return false;
                }
                remaining = x;
            } else {
                remaining = value.intValue();
            }
            return remaining == 0;
        }

        public void decrement(String binName) {
            MutableInteger value = (MutableInteger)this.binCounts.get(binName);
            if (value == null) {
                int x = this.findMaxCount(binName);
                if (x == -1) {
                    return;
                }
                value = new MutableInteger(x);
                this.binCounts.put(binName, value);
            }
            value.decrement();
        }

        protected int findMaxCount(String binName) {
            int maxCount = -1;
            int i = 0;
            while (i < this.throttleLimits.size()) {
                ThrottleLimitSpec spec;
                Pattern p;
                Matcher m;
                if (!(m = (p = (spec = (ThrottleLimitSpec)this.throttleLimits.get(i++)).getRegexp()).matcher(binName)).find()) continue;
                int limit = spec.getMaxCount();
                if (maxCount != -1 && limit >= maxCount) continue;
                maxCount = limit;
            }
            return maxCount;
        }
    }

    protected static class QueueHashItem {
        int itemsPerChunk;
        int chunkCount = 0;
        int currentDocumentCount = 0;

        public QueueHashItem(int itemsPerChunk) {
            this.itemsPerChunk = itemsPerChunk;
        }

        public QueueHashItem duplicate() {
            QueueHashItem rval = new QueueHashItem(this.itemsPerChunk);
            rval.chunkCount = this.chunkCount;
            rval.currentDocumentCount = this.currentDocumentCount;
            return rval;
        }

        public void addDocument() {
            ++this.currentDocumentCount;
            if (this.currentDocumentCount == 1) {
                ++this.chunkCount;
            }
            if (this.currentDocumentCount == this.itemsPerChunk) {
                this.currentDocumentCount = 0;
            }
        }

        public int getChunkCount() {
            return this.chunkCount;
        }
    }

    protected static class ThrottleLimit
    implements ILimitChecker {
        protected HashMap connectionMap = new HashMap();
        protected int n;
        protected HashMap jobQueueHash = new HashMap();
        protected HashMap jobConnection = new HashMap();
        protected HashMap activeConnections = new HashMap();
        protected HashMap setSizes = new HashMap();
        protected HashMap maxConnectionCounts = new HashMap();
        protected int maxSetSize = 0;
        protected int documentsProcessed = 0;
        protected ArrayList blockingDocumentArray = new ArrayList();
        protected long prioritizationTime;

        public ThrottleLimit(int n, long prioritizationTime) {
            this.n = n;
            this.prioritizationTime = prioritizationTime;
            Logging.perf.debug((Object)"Limit instance created");
        }

        public void tallyBlockingDocuments(BlockingDocuments blockingDocuments) {
            int i = 0;
            while (i < this.blockingDocumentArray.size()) {
                DocumentDescription dd = (DocumentDescription)this.blockingDocumentArray.get(i++);
                blockingDocuments.addBlockingDocument(dd);
            }
            this.blockingDocumentArray.clear();
        }

        public void addJob(Long jobID, String connectionName) {
            this.jobConnection.put(jobID, connectionName);
        }

        public void addConnectionName(String connectionName, IRepositoryConnector connectorInstance) throws ManifoldCFException {
            this.activeConnections.put(connectionName, connectorInstance);
            int setSize = connectorInstance.getMaxDocumentRequest();
            this.setSizes.put(connectionName, new Integer(setSize));
            if (setSize > this.maxSetSize) {
                this.maxSetSize = setSize;
            }
        }

        public void addLimit(String connectionName, String regexp, int upperLimit) {
            ThrottleJobItem ji;
            if (Logging.perf.isDebugEnabled()) {
                Logging.perf.debug((Object)(" Adding fetch limit of " + Integer.toString(upperLimit) + " fetches for expression '" + regexp + "' for connection '" + connectionName + "'"));
            }
            if ((ji = (ThrottleJobItem)this.connectionMap.get(connectionName)) == null) {
                ji = new ThrottleJobItem();
                this.connectionMap.put(connectionName, ji);
            }
            ji.addLimit(regexp, upperLimit);
        }

        public void setConnectionLimit(String connectionName, int maxDocuments) {
            if (Logging.perf.isDebugEnabled()) {
                Logging.perf.debug((Object)(" Setting connection limit of " + Integer.toString(maxDocuments) + " for connection " + connectionName));
            }
            this.maxConnectionCounts.put(connectionName, new MutableInteger(maxDocuments));
        }

        public boolean doesCompareWork() {
            return false;
        }

        public ILimitChecker duplicate() {
            return this.makeDeepCopy();
        }

        public ThrottleLimit makeDeepCopy() {
            ThrottleLimit rval = new ThrottleLimit(this.n, this.prioritizationTime);
            rval.activeConnections = this.activeConnections;
            rval.setSizes = this.setSizes;
            rval.maxConnectionCounts = this.maxConnectionCounts;
            rval.maxSetSize = this.maxSetSize;
            rval.jobConnection = this.jobConnection;
            rval.documentsProcessed = this.documentsProcessed;
            for (Object key : this.connectionMap.keySet()) {
                rval.connectionMap.put(key, ((ThrottleJobItem)this.connectionMap.get(key)).duplicate());
            }
            for (Object key : this.jobQueueHash.keySet()) {
                rval.jobQueueHash.put(key, ((QueueHashItem)this.jobQueueHash.get(key)).duplicate());
            }
            return rval;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }

        public int getRemainingDocuments() {
            return EXTRA_FACTOR * this.n * this.maxSetSize - this.documentsProcessed;
        }

        public boolean checkInclude(IResultRow row) throws ManifoldCFException {
            int j;
            QueueHashItem queueItem;
            Logging.perf.debug((Object)"Checking if row should be included");
            Long jobIDValue = (Long)row.getValue("jobid");
            String connectionName = (String)this.jobConnection.get(jobIDValue);
            if (connectionName == null) {
                Logging.perf.debug((Object)" Row does not have an eligible job - excluding");
                return false;
            }
            IRepositoryConnector connectorInstance = (IRepositoryConnector)this.activeConnections.get(connectionName);
            if (connectorInstance == null) {
                Logging.perf.debug((Object)" Row does not have an eligible connector instance - excluding");
                return false;
            }
            MutableInteger connectionLimit = (MutableInteger)this.maxConnectionCounts.get(connectionName);
            if (connectionLimit != null) {
                if (connectionLimit.intValue() == 0) {
                    Logging.perf.debug((Object)" Row exceeds its connection limit - excluding");
                    return false;
                }
                connectionLimit.decrement();
            }
            if ((queueItem = (QueueHashItem)this.jobQueueHash.get(jobIDValue)) == null) {
                int maxCount = (Integer)this.setSizes.get(connectionName);
                queueItem = new QueueHashItem(maxCount);
                this.jobQueueHash.put(jobIDValue, queueItem);
            }
            String docIDHash = (String)row.getValue("dochash");
            String docID = (String)row.getValue("docid");
            String[] binNames = ManifoldCF.calculateBins(connectorInstance, docID);
            ++this.documentsProcessed;
            ThrottleJobItem item = (ThrottleJobItem)this.connectionMap.get(connectionName);
            if (item == null) {
                queueItem.addDocument();
                Logging.perf.debug((Object)" Row has no throttling - including");
                return true;
            }
            for (j = 0; j < binNames.length; ++j) {
                Object o;
                if (!item.isEmpty(binNames[j])) continue;
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)(" Bin " + binNames[j] + " has no more available fetches - excluding"));
                }
                if ((o = row.getValue("priorityset")) == null || (Long)o <= this.prioritizationTime) {
                    Long id = (Long)row.getValue("id");
                    Long jobID = (Long)row.getValue("jobid");
                    DocumentDescription dd = new DocumentDescription(id, jobID, docIDHash, docID);
                    this.blockingDocumentArray.add(dd);
                }
                return false;
            }
            j = 0;
            while (j < binNames.length) {
                item.decrement(binNames[j++]);
            }
            queueItem.addDocument();
            Logging.perf.debug((Object)" Including!");
            return true;
        }

        public boolean checkContinue() throws ManifoldCFException {
            if (this.documentsProcessed >= EXTRA_FACTOR * this.n * this.maxSetSize) {
                return false;
            }
            Iterator iter = this.jobQueueHash.keySet().iterator();
            int count = 0;
            while (iter.hasNext()) {
                Long jobID = (Long)iter.next();
                QueueHashItem item = (QueueHashItem)this.jobQueueHash.get(jobID);
                if ((count += item.getChunkCount()) <= this.n) continue;
                return false;
            }
            return true;
        }
    }

    protected static class JobqueueRecord {
        protected Long recordID;
        protected int status;
        protected Long checkTimeValue;

        public JobqueueRecord(Long recordID, int status, Long checkTimeValue) {
            this.recordID = recordID;
            this.status = status;
            this.checkTimeValue = checkTimeValue;
        }

        public Long getRecordID() {
            return this.recordID;
        }

        public int getStatus() {
            return this.status;
        }

        public Long getCheckTimeValue() {
            return this.checkTimeValue;
        }
    }
}

