/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.jobs.PrereqEventManager;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class JobQueue
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: JobQueue.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final int SEEDSTATUS_NOTSEED = 0;
    public static final int SEEDSTATUS_SEED = 1;
    public static final int SEEDSTATUS_NEWSEED = 2;
    public static final int STATUS_PENDING = 0;
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_COMPLETE = 2;
    public static final int STATUS_PENDINGPURGATORY = 3;
    public static final int STATUS_ACTIVEPURGATORY = 4;
    public static final int STATUS_PURGATORY = 5;
    public static final int STATUS_BEINGDELETED = 6;
    public static final int STATUS_ACTIVENEEDRESCAN = 7;
    public static final int STATUS_ACTIVENEEDRESCANPURGATORY = 8;
    public static final int STATUS_BEINGCLEANED = 9;
    public static final int STATUS_ELIGIBLEFORDELETE = 10;
    public static final int ACTION_RESCAN = 0;
    public static final int ACTION_REMOVE = 1;
    public static final String idField = "id";
    public static final String jobIDField = "jobid";
    public static final String docHashField = "dochash";
    public static final String docIDField = "docid";
    public static final String checkTimeField = "checktime";
    public static final String statusField = "status";
    public static final String failTimeField = "failtime";
    public static final String failCountField = "failcount";
    public static final String isSeedField = "isseed";
    public static final String docPriorityField = "docpriority";
    public static final String prioritySetField = "priorityset";
    public static final String checkActionField = "checkaction";
    protected static Map statusMap = new HashMap();
    protected static Map seedstatusMap;
    protected static Map actionMap;
    protected PrereqEventManager prereqEventManager;
    protected IThreadContext threadContext;

    public JobQueue(IThreadContext tc, IDBInterface database) throws ManifoldCFException {
        super(database, "jobqueue");
        this.threadContext = tc;
        this.prereqEventManager = new PrereqEventManager(database);
    }

    public void install(String jobsTable, String jobsColumn) throws ManifoldCFException {
        block17: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(idField, new ColumnDescription("BIGINT", true, false, null, null, false));
                map.put(jobIDField, new ColumnDescription("BIGINT", false, false, jobsTable, jobsColumn, false));
                map.put(docHashField, new ColumnDescription("VARCHAR(40)", false, false, null, null, false));
                map.put(docIDField, new ColumnDescription("LONGTEXT", false, false, null, null, false));
                map.put(checkTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(failTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(failCountField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(statusField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(isSeedField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                map.put(docPriorityField, new ColumnDescription("FLOAT", false, true, null, null, false));
                map.put(prioritySetField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(checkActionField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                this.performCreate(map, null);
            }
            this.prereqEventManager.install(this.getTableName(), idField);
            IndexDescription uniqueIndex = new IndexDescription(true, new String[]{docHashField, jobIDField});
            IndexDescription jobStatusIndex = new IndexDescription(false, new String[]{jobIDField, statusField});
            IndexDescription jobSeedIndex = new IndexDescription(false, new String[]{jobIDField, isSeedField});
            IndexDescription jobHashStatusIndex = new IndexDescription(false, new String[]{jobIDField, docHashField, statusField});
            IndexDescription statusIndex = new IndexDescription(false, new String[]{statusField});
            IndexDescription actionTimeStatusIndex = new IndexDescription(false, new String[]{checkActionField, checkTimeField, statusField});
            IndexDescription prioritysetStatusIndex = new IndexDescription(false, new String[]{prioritySetField, statusField});
            IndexDescription docpriorityIndex = new IndexDescription(false, new String[]{docPriorityField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (uniqueIndex != null && id.equals((Object)uniqueIndex)) {
                    uniqueIndex = null;
                    continue;
                }
                if (jobStatusIndex != null && id.equals((Object)jobStatusIndex)) {
                    jobStatusIndex = null;
                    continue;
                }
                if (jobSeedIndex != null && id.equals((Object)jobSeedIndex)) {
                    jobSeedIndex = null;
                    continue;
                }
                if (jobHashStatusIndex != null && id.equals((Object)jobHashStatusIndex)) {
                    jobHashStatusIndex = null;
                    continue;
                }
                if (statusIndex != null && id.equals((Object)statusIndex)) {
                    statusIndex = null;
                    continue;
                }
                if (actionTimeStatusIndex != null && id.equals((Object)actionTimeStatusIndex)) {
                    actionTimeStatusIndex = null;
                    continue;
                }
                if (prioritysetStatusIndex != null && id.equals((Object)prioritysetStatusIndex)) {
                    prioritysetStatusIndex = null;
                    continue;
                }
                if (docpriorityIndex != null && id.equals((Object)docpriorityIndex)) {
                    docpriorityIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (jobStatusIndex != null) {
                this.performAddIndex(null, jobStatusIndex);
            }
            if (jobSeedIndex != null) {
                this.performAddIndex(null, jobSeedIndex);
            }
            if (jobHashStatusIndex != null) {
                this.performAddIndex(null, jobHashStatusIndex);
            }
            if (statusIndex != null) {
                this.performAddIndex(null, statusIndex);
            }
            if (actionTimeStatusIndex != null) {
                this.performAddIndex(null, actionTimeStatusIndex);
            }
            if (prioritysetStatusIndex != null) {
                this.performAddIndex(null, prioritysetStatusIndex);
            }
            if (docpriorityIndex != null) {
                this.performAddIndex(null, docpriorityIndex);
            }
            if (uniqueIndex == null) break block17;
            this.performAddIndex(null, uniqueIndex);
        }
    }

    public void unconditionallyAnalyzeTables() throws ManifoldCFException {
        long startTime = System.currentTimeMillis();
        Logging.perf.debug((Object)"Beginning to analyze jobqueue table");
        this.analyzeTable();
        Logging.perf.debug((Object)("Done analyzing jobqueue table in " + new Long(System.currentTimeMillis() - startTime) + " ms"));
    }

    public void deinstall() throws ManifoldCFException {
        this.beginTransaction();
        try {
            this.prereqEventManager.deinstall();
            this.performDrop(null);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void restart() throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(0));
        ArrayList<String> list = new ArrayList<String>();
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(7));
        this.performUpdate(map, "WHERE status=? OR status=?", list, null);
        map.put(statusField, JobQueue.statusToString(3));
        list.clear();
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(8));
        this.performUpdate(map, "WHERE status=? OR status=?", list, null);
        map.put(statusField, JobQueue.statusToString(10));
        map.put(checkTimeField, new Long(0L));
        list.clear();
        list.add(JobQueue.statusToString(6));
        this.performUpdate(map, "WHERE status=?", list, null);
        map.put(statusField, JobQueue.statusToString(5));
        map.put(checkTimeField, new Long(0L));
        list.clear();
        list.add(JobQueue.statusToString(9));
        this.performUpdate(map, "WHERE status=?", list, null);
        map.put(isSeedField, JobQueue.seedstatusToString(1));
        list.clear();
        list.add(JobQueue.seedstatusToString(2));
        this.performUpdate(map, "WHERE isseed=?", list, null);
        map = new HashMap();
        map.put(failTimeField, null);
        this.performUpdate(map, "WHERE failtime IS NOT NULL", null, null);
        this.reindexTable();
        this.unconditionallyAnalyzeTables();
    }

    public void clearFailTimes(Long jobID) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(failTimeField, null);
        this.performUpdate(map, "WHERE jobid=? AND failtime IS NOT NULL", list, null);
    }

    public void resetDocumentWorkerStatus() throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, JobQueue.statusToString(0));
        ArrayList<String> list = new ArrayList<String>();
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(7));
        this.performUpdate(map, "WHERE status=? OR status=?", list, null);
        map.put(statusField, JobQueue.statusToString(3));
        list.clear();
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(8));
        this.performUpdate(map, "WHERE status=? OR status=?", list, null);
    }

    public void resetDocDeleteWorkerStatus() throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        map.put(statusField, JobQueue.statusToString(10));
        map.put(checkTimeField, new Long(0L));
        list.clear();
        list.add(JobQueue.statusToString(6));
        this.performUpdate(map, "WHERE status=?", list, null);
    }

    public void resetDocCleanupWorkerStatus() throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        map.put(statusField, JobQueue.statusToString(5));
        map.put(checkTimeField, new Long(0L));
        list.clear();
        list.add(JobQueue.statusToString(9));
        this.performUpdate(map, "WHERE status=?", list, null);
    }

    public void prepareDeleteScan(Long jobID) throws ManifoldCFException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(jobID);
        list.add(JobQueue.statusToString(0));
        this.prereqEventManager.deleteRows(this.getTableName() + " t0", "t0.id", "t0.jobid=? AND t0.status=?", list);
        this.performDelete("WHERE jobid=? AND status=?", list, null);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(10));
        map.put(checkTimeField, new Long(0L));
        map.put(checkActionField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        list.clear();
        list.add(jobID);
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.statusToString(2));
        list.add(JobQueue.statusToString(5));
        this.performUpdate(map, "WHERE jobid=? AND status IN (?,?,?)", list, null);
        this.noteModifications(0, 2, 0);
        this.unconditionallyAnalyzeTables();
    }

    public void prepareFullScan(Long jobID) throws ManifoldCFException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(jobID);
        list.add(JobQueue.statusToString(0));
        this.prereqEventManager.deleteRows(this.getTableName() + " t0", "t0.id", "t0.jobid=? AND t0.status=?", list);
        this.performDelete("WHERE jobid=? AND status=?", list, null);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(5));
        map.put(checkTimeField, new Long(0L));
        map.put(checkActionField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        list.clear();
        list.add(jobID);
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.statusToString(2));
        this.performUpdate(map, "WHERE jobid=? AND status IN (?,?)", list, null);
        this.noteModifications(0, 2, 0);
        this.unconditionallyAnalyzeTables();
    }

    public void prepareIncrementalScan(Long jobID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(3));
        map.put(checkTimeField, new Long(0L));
        map.put(checkActionField, JobQueue.actionToString(0));
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(jobID);
        list.add(JobQueue.statusToString(2));
        this.performUpdate(map, "WHERE jobid=? AND status=?", list, null);
        this.noteModifications(0, 1, 0);
        this.unconditionallyAnalyzeTables();
    }

    public void deleteIngestedDocumentIdentifiers(DocumentDescription[] identifiers) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < identifiers.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('?');
            list.add(identifiers[i].getID());
        }
        this.doDeletes(list, sb.toString());
        this.noteModifications(0, 0, identifiers.length);
    }

    public boolean checkJobBusy(Long jobID) throws ManifoldCFException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(jobID);
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(8));
        IResultSet set = this.performQuery("SELECT dochash FROM " + this.getTableName() + " WHERE " + jobIDField + "=? AND " + statusField + " IN (?,?,?,?) " + this.constructOffsetLimitClause(0, 1), list, null, null, 1);
        return set.getRowCount() > 0;
    }

    public void deleteAllJobRecords(Long jobID) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        this.prereqEventManager.deleteRows(this.getTableName() + " t0", "t0.id", "t0.jobid=?", list);
        this.performDelete("WHERE jobid=?", list, null);
        this.noteModifications(0, 0, 1);
    }

    public void writeDocPriority(long currentTime, Long rowID, double priority) throws ManifoldCFException {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put(prioritySetField, new Long(currentTime));
        map.put(docPriorityField, new Double(priority));
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(rowID);
        this.performUpdate(map, "WHERE id=?", list, null);
        this.noteModifications(0, 1, 0);
    }

    public void updateCompletedRecord(Long recID, int currentStatus) throws ManifoldCFException {
        Long checkTimeValue;
        String actionFieldValue;
        int newStatus;
        switch (currentStatus) {
            case 1: 
            case 4: {
                newStatus = 2;
                actionFieldValue = null;
                checkTimeValue = null;
                break;
            }
            case 7: 
            case 8: {
                newStatus = 3;
                actionFieldValue = JobQueue.actionToString(0);
                checkTimeValue = new Long(0L);
                break;
            }
            default: {
                throw new ManifoldCFException("Unexpected jobqueue status - record id " + recID.toString() + ", expecting active status");
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(newStatus));
        map.put(checkTimeField, checkTimeValue);
        map.put(checkActionField, actionFieldValue);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(recID);
        this.performUpdate(map, "WHERE id=?", list, null);
    }

    public void updateActiveRecord(Long id, int currentStatus) throws ManifoldCFException {
        int newStatus;
        switch (currentStatus) {
            case 0: {
                newStatus = 1;
                break;
            }
            case 3: {
                newStatus = 4;
                break;
            }
            default: {
                throw new ManifoldCFException("Unexpected status value for jobqueue record " + id.toString() + "; got " + Integer.toString(currentStatus));
            }
        }
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(id);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, JobQueue.statusToString(newStatus));
        this.performUpdate(map, "WHERE id=?", list, null);
        this.noteModifications(0, 1, 0);
    }

    public void setStatus(Long id, int status, Long checkTime, int action, long failTime, int failCount) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(id);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(status));
        map.put(checkTimeField, checkTime);
        map.put(checkActionField, JobQueue.actionToString(action));
        if (failTime == -1L) {
            map.put(failTimeField, null);
        } else {
            map.put(failTimeField, new Long(failTime));
        }
        if (failCount == -1) {
            map.put(failCountField, null);
        } else {
            map.put(failCountField, new Long(failCount));
        }
        this.performUpdate(map, "WHERE id=?", list, null);
        this.noteModifications(0, 1, 0);
    }

    public void setDeletingStatus(Long id) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(id);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, JobQueue.statusToString(6));
        this.performUpdate(map, "WHERE id=?", list, null);
        this.noteModifications(0, 1, 0);
    }

    public void setUndeletingStatus(Long id, long checkTime) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(10));
        map.put(checkTimeField, new Long(checkTime));
        map.put(checkActionField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(id);
        this.performUpdate(map, "WHERE id=?", list, null);
    }

    public void setCleaningStatus(Long id) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(id);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, JobQueue.statusToString(9));
        this.performUpdate(map, "WHERE id=?", list, null);
        this.noteModifications(0, 1, 0);
    }

    public void setUncleaningStatus(Long id, long checkTime) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(5));
        map.put(checkTimeField, new Long(checkTime));
        map.put(checkActionField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(id);
        this.performUpdate(map, "WHERE id=?", list, null);
    }

    public void deleteRecordMultiple(Long[] ids) throws ManifoldCFException {
        int maxInClause = this.getMaxInClause();
        ArrayList<Long> list = new ArrayList<Long>();
        StringBuffer sb = new StringBuffer();
        int j = 0;
        int i = 0;
        while (i < ids.length) {
            if (j == maxInClause) {
                this.doDeletes(list, sb.toString());
                list.clear();
                sb.setLength(0);
                j = 0;
            }
            if (j > 0) {
                sb.append(',');
            }
            sb.append('?');
            list.add(ids[i++]);
            ++j;
        }
        if (j > 0) {
            this.doDeletes(list, sb.toString());
        }
        this.noteModifications(0, 0, ids.length);
    }

    protected void doDeletes(ArrayList list, String queryPart) throws ManifoldCFException {
        this.prereqEventManager.deleteRows(queryPart, list);
        this.performDelete("WHERE id IN(" + queryPart + ")", list, null);
    }

    public void deleteRecord(Long id) throws ManifoldCFException {
        this.deleteRecordMultiple(new Long[]{id});
    }

    public boolean updateExistingRecordInitial(Long recordID, int currentStatus, Long checkTimeValue, long desiredExecuteTime, long currentTime, double desiredPriority, String[] prereqEvents) throws ManifoldCFException {
        boolean rval = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        switch (currentStatus) {
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 5: {
                map.put(statusField, JobQueue.statusToString(3));
                if (desiredExecuteTime == -1L) {
                    map.put(checkTimeField, new Long(0L));
                } else {
                    map.put(checkTimeField, new Long(desiredExecuteTime));
                }
                map.put(checkActionField, JobQueue.actionToString(0));
                map.put(failTimeField, null);
                map.put(failCountField, null);
                map.put(docPriorityField, new Double(desiredPriority));
                map.put(prioritySetField, new Long(currentTime));
                rval = true;
                break;
            }
            case 0: {
                Long cv = checkTimeValue;
                if (cv != null) {
                    long currentExecuteTime = cv;
                    if (desiredExecuteTime == -1L || currentExecuteTime <= desiredExecuteTime) {
                        break;
                    }
                } else if (desiredExecuteTime == -1L) break;
                map.put(checkTimeField, new Long(desiredExecuteTime));
                map.put(checkActionField, JobQueue.actionToString(0));
                map.put(failTimeField, null);
                map.put(failCountField, null);
                break;
            }
            case 3: {
                break;
            }
        }
        map.put(isSeedField, JobQueue.seedstatusToString(2));
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(recordID);
        this.prereqEventManager.deleteRows(recordID);
        this.performUpdate(map, "WHERE id=?", list, null);
        this.prereqEventManager.addRows(recordID, prereqEvents);
        this.noteModifications(0, 1, 0);
        return rval;
    }

    public void insertNewRecordInitial(Long jobID, String docHash, String docID, double desiredDocPriority, long desiredExecuteTime, long currentTime, String[] prereqEvents) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long recordID = new Long(IDFactory.make((IThreadContext)this.threadContext));
        map.put(idField, recordID);
        if (desiredExecuteTime == -1L) {
            map.put(checkTimeField, new Long(0L));
        } else {
            map.put(checkTimeField, new Long(desiredExecuteTime));
        }
        map.put(checkActionField, JobQueue.actionToString(0));
        map.put(jobIDField, jobID);
        map.put(docHashField, docHash);
        map.put(docIDField, docID);
        map.put(statusField, JobQueue.statusToString(0));
        map.put(isSeedField, JobQueue.seedstatusToString(2));
        map.put(docPriorityField, new Double(desiredDocPriority));
        map.put(prioritySetField, new Long(currentTime));
        this.performInsert(map, null);
        this.prereqEventManager.addRows(recordID, prereqEvents);
        this.noteModifications(1, 0, 0);
    }

    public void addRemainingDocumentsInitial(Long jobID, String[] docIDHashes) throws ManifoldCFException {
        if (docIDHashes.length == 0) {
            return;
        }
        HashMap<String, String> inSet = new HashMap<String, String>();
        int j = 0;
        while (j < docIDHashes.length) {
            String docIDHash = docIDHashes[j++];
            inSet.put(docIDHash, docIDHash);
        }
        HashMap idMap = new HashMap();
        int k = 0;
        int maxInClause = this.getMaxInClause();
        int maxClause = 1;
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> list = new ArrayList<Object>();
        j = 0;
        while (j < docIDHashes.length) {
            String docIDHash = docIDHashes[j++];
            if (k == maxClause) {
                this.processRemainingDocuments(idMap, sb.toString(), list, inSet);
                sb.setLength(0);
                k = 0;
                list.clear();
            }
            if (k > 0) {
                sb.append(" OR");
            }
            sb.append("(").append(jobIDField).append("=? AND ").append(docHashField).append("=? AND ").append(isSeedField).append("=?)");
            list.add(jobID);
            list.add(docIDHash);
            list.add(JobQueue.seedstatusToString(1));
            ++k;
        }
        if (k > 0) {
            this.processRemainingDocuments(idMap, sb.toString(), list, inSet);
        }
        k = 0;
        sb.setLength(0);
        list.clear();
        Iterator idValues = idMap.keySet().iterator();
        while (idValues.hasNext()) {
            if (k == maxInClause) {
                this.updateRemainingDocuments(sb.toString(), list);
                sb.setLength(0);
                k = 0;
                list.clear();
            }
            Long idValue = (Long)idValues.next();
            if (k > 0) {
                sb.append(",");
            }
            sb.append("?");
            list.add(idValue);
            ++k;
        }
        if (k > 0) {
            this.updateRemainingDocuments(sb.toString(), list);
        }
        this.noteModifications(0, docIDHashes.length, 0);
    }

    protected void processRemainingDocuments(Map idMap, String query, ArrayList list, Map inSet) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT id,dochash FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row;
            String docIDHash;
            if (inSet.get(docIDHash = (String)(row = set.getRow(i++)).getValue(docHashField)) == null) continue;
            Long idValue = (Long)row.getValue(idField);
            idMap.put(idValue, idValue);
        }
    }

    protected void updateRemainingDocuments(String query, ArrayList list) throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(isSeedField, JobQueue.seedstatusToString(2));
        this.performUpdate(map, "WHERE id IN(" + query + ")", list, null);
    }

    public void doneDocumentsInitial(Long jobID, boolean isPartial) throws ManifoldCFException {
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (!isPartial) {
            list.add(jobID);
            list.add(JobQueue.seedstatusToString(1));
            map.put(isSeedField, JobQueue.seedstatusToString(0));
            this.performUpdate(map, "WHERE jobid=? AND isseed=?", list, null);
            list.clear();
        }
        list.add(jobID);
        list.add(JobQueue.seedstatusToString(2));
        map.put(isSeedField, JobQueue.seedstatusToString(1));
        this.performUpdate(map, "WHERE jobid=? AND isseed=?", list, null);
    }

    public String[] getAllSeeds(Long jobID) throws ManifoldCFException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(jobID);
        list.add(JobQueue.seedstatusToString(1));
        IResultSet set = this.performQuery("SELECT dochash FROM " + this.getTableName() + " WHERE " + jobIDField + "=? AND " + isSeedField + "=?", list, null, null);
        String[] rval = new String[set.getRowCount()];
        int i = 0;
        while (i < rval.length) {
            IResultRow row = set.getRow(i);
            rval[i++] = (String)row.getValue(docHashField);
        }
        return rval;
    }

    public boolean updateExistingRecord(Long recordID, int currentStatus, Long checkTimeValue, long desiredExecuteTime, long currentTime, boolean otherChangesSeen, double desiredPriority, String[] prereqEvents) throws ManifoldCFException {
        boolean rval = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        switch (currentStatus) {
            case 5: {
                map.put(statusField, JobQueue.statusToString(3));
                map.put(checkTimeField, new Long(desiredExecuteTime));
                map.put(checkActionField, JobQueue.actionToString(0));
                map.put(failTimeField, null);
                map.put(failCountField, null);
                map.put(docPriorityField, new Double(desiredPriority));
                map.put(prioritySetField, new Long(currentTime));
                rval = true;
                break;
            }
            case 2: 
            case 9: {
                if (otherChangesSeen) {
                    map.put(statusField, JobQueue.statusToString(3));
                    map.put(checkTimeField, new Long(desiredExecuteTime));
                    map.put(checkActionField, JobQueue.actionToString(0));
                    map.put(failTimeField, null);
                    map.put(failCountField, null);
                    map.put(docPriorityField, new Double(desiredPriority));
                    map.put(prioritySetField, new Long(currentTime));
                    rval = true;
                    break;
                }
                return rval;
            }
            case 7: 
            case 8: {
                return rval;
            }
            case 1: {
                if (otherChangesSeen) {
                    map.put(statusField, JobQueue.statusToString(7));
                    map.put(checkTimeField, new Long(desiredExecuteTime));
                    map.put(checkActionField, JobQueue.actionToString(0));
                    map.put(failTimeField, null);
                    map.put(failCountField, null);
                    map.put(docPriorityField, new Double(desiredPriority));
                    map.put(prioritySetField, new Long(currentTime));
                    rval = true;
                    break;
                }
                return rval;
            }
            case 4: {
                if (otherChangesSeen) {
                    map.put(statusField, JobQueue.statusToString(8));
                    map.put(checkTimeField, new Long(desiredExecuteTime));
                    map.put(checkActionField, JobQueue.actionToString(0));
                    map.put(failTimeField, null);
                    map.put(failCountField, null);
                    map.put(docPriorityField, new Double(desiredPriority));
                    map.put(prioritySetField, new Long(currentTime));
                    rval = true;
                    break;
                }
                return rval;
            }
            case 0: {
                long currentExecuteTime;
                Long cv = checkTimeValue;
                if (cv != null && (currentExecuteTime = cv.longValue()) <= desiredExecuteTime) {
                    return rval;
                }
                map.put(checkTimeField, new Long(desiredExecuteTime));
                map.put(checkActionField, JobQueue.actionToString(0));
                map.put(failTimeField, null);
                map.put(failCountField, null);
                break;
            }
            default: {
                return rval;
            }
        }
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(recordID);
        this.prereqEventManager.deleteRows(recordID);
        this.performUpdate(map, "WHERE id=?", list, null);
        this.prereqEventManager.addRows(recordID, prereqEvents);
        this.noteModifications(0, 1, 0);
        return rval;
    }

    public void insertNewRecord(Long jobID, String docIDHash, String docID, double desiredDocPriority, long desiredExecuteTime, long currentTime, String[] prereqEvents) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long recordID = new Long(IDFactory.make((IThreadContext)this.threadContext));
        map.put(idField, recordID);
        map.put(checkTimeField, new Long(desiredExecuteTime));
        map.put(checkActionField, JobQueue.actionToString(0));
        map.put(jobIDField, jobID);
        map.put(docHashField, docIDHash);
        map.put(docIDField, docID);
        map.put(statusField, JobQueue.statusToString(0));
        map.put(docPriorityField, new Double(desiredDocPriority));
        map.put(prioritySetField, new Long(currentTime));
        this.performInsert(map, null);
        this.prereqEventManager.addRows(recordID, prereqEvents);
        this.noteModifications(1, 0, 0);
    }

    public static String seedstatusToString(int status) throws ManifoldCFException {
        switch (status) {
            case 0: {
                return "F";
            }
            case 1: {
                return "S";
            }
            case 2: {
                return "N";
            }
        }
        throw new ManifoldCFException("Invalid seed status: " + Integer.toString(status));
    }

    public static int stringToSeedstatus(String x) throws ManifoldCFException {
        if (x == null || x.length() == 0) {
            return 0;
        }
        Integer y = (Integer)seedstatusMap.get(x);
        if (y == null) {
            throw new ManifoldCFException("Unknown seed status code: " + x);
        }
        return y;
    }

    public static int stringToAction(String value) throws ManifoldCFException {
        Integer x = (Integer)actionMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Unknown action string: '" + value + "'");
        }
        return x;
    }

    public static String actionToString(int action) throws ManifoldCFException {
        switch (action) {
            case 0: {
                return "R";
            }
            case 1: {
                return "D";
            }
        }
        throw new ManifoldCFException("Bad action value: " + Integer.toString(action));
    }

    public static int stringToStatus(String value) throws ManifoldCFException {
        Integer x = (Integer)statusMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Unknown status string: '" + value + "'");
        }
        return x;
    }

    public static String statusToString(int status) throws ManifoldCFException {
        switch (status) {
            case 0: {
                return "P";
            }
            case 1: {
                return "A";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "G";
            }
            case 4: {
                return "F";
            }
            case 5: {
                return "Z";
            }
            case 10: {
                return "E";
            }
            case 6: {
                return "D";
            }
            case 7: {
                return "a";
            }
            case 8: {
                return "f";
            }
            case 9: {
                return "d";
            }
        }
        throw new ManifoldCFException("Bad status value: " + Integer.toString(status));
    }

    public static String getHashCode(String documentIdentifier) throws ManifoldCFException {
        return ManifoldCF.hash((String)documentIdentifier);
    }

    static {
        statusMap.put("P", new Integer(0));
        statusMap.put("A", new Integer(1));
        statusMap.put("C", new Integer(2));
        statusMap.put("G", new Integer(3));
        statusMap.put("F", new Integer(4));
        statusMap.put("Z", new Integer(5));
        statusMap.put("E", new Integer(10));
        statusMap.put("D", new Integer(6));
        statusMap.put("a", new Integer(7));
        statusMap.put("f", new Integer(8));
        statusMap.put("d", new Integer(9));
        seedstatusMap = new HashMap();
        seedstatusMap.put("F", new Integer(0));
        seedstatusMap.put("S", new Integer(1));
        seedstatusMap.put("N", new Integer(2));
        actionMap = new HashMap();
        actionMap.put("R", new Integer(0));
        actionMap.put("D", new Integer(1));
    }

    protected static class DuplicateFinder
    implements ILimitChecker {
        protected Long prevJobID = null;
        protected String prevDocIDHash = null;

        public boolean doesCompareWork() {
            return false;
        }

        public ILimitChecker duplicate() {
            DuplicateFinder df = new DuplicateFinder();
            df.prevJobID = this.prevJobID;
            df.prevDocIDHash = this.prevDocIDHash;
            return df;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }

        public boolean checkInclude(IResultRow row) throws ManifoldCFException {
            Long jobID = (Long)row.getValue(JobQueue.jobIDField);
            String docIDHash = (String)row.getValue(JobQueue.docHashField);
            if (this.prevJobID != null && jobID.equals(this.prevJobID) && docIDHash.equals(this.prevDocIDHash)) {
                return true;
            }
            this.prevJobID = jobID;
            this.prevDocIDHash = docIDHash;
            return false;
        }

        public boolean checkContinue() throws ManifoldCFException {
            return true;
        }
    }
}

