/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.crawler.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.crawler.interfaces.EnumeratedValues;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.ScheduleRecord;
import org.apache.manifoldcf.crawler.jobs.HopFilterManager;
import org.apache.manifoldcf.crawler.jobs.JobDescription;
import org.apache.manifoldcf.crawler.jobs.ScheduleManager;

public class Jobs
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: Jobs.java 991295 2010-08-31 19:12:14Z kwright $";
    public static final int STATUS_INACTIVE = 0;
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_PAUSED = 2;
    public static final int STATUS_SHUTTINGDOWN = 3;
    public static final int STATUS_ACTIVEWAIT = 4;
    public static final int STATUS_PAUSEDWAIT = 5;
    public static final int STATUS_ABORTING = 6;
    public static final int STATUS_STARTINGUP = 7;
    public static final int STATUS_ABORTINGSTARTINGUP = 8;
    public static final int STATUS_READYFORSTARTUP = 9;
    public static final int STATUS_READYFORDELETE = 10;
    public static final int STATUS_ACTIVESEEDING = 11;
    public static final int STATUS_ABORTINGSEEDING = 12;
    public static final int STATUS_PAUSEDSEEDING = 13;
    public static final int STATUS_ACTIVEWAITSEEDING = 14;
    public static final int STATUS_PAUSEDWAITSEEDING = 15;
    public static final int STATUS_ABORTINGFORRESTART = 16;
    public static final int STATUS_ABORTINGFORRESTARTSEEDING = 17;
    public static final int STATUS_ABORTINGSTARTINGUPFORRESTART = 18;
    public static final int STATUS_READYFORNOTIFY = 19;
    public static final int STATUS_NOTIFYINGOFCOMPLETION = 20;
    public static final int STATUS_DELETING = 21;
    public static final int STATUS_DELETESTARTINGUP = 22;
    public static final int STATUS_ACTIVE_UNINSTALLED = 23;
    public static final int STATUS_ACTIVESEEDING_UNINSTALLED = 24;
    public static final int STATUS_ACTIVE_NOOUTPUT = 25;
    public static final int STATUS_ACTIVESEEDING_NOOUTPUT = 26;
    public static final int STATUS_ACTIVE_NEITHER = 27;
    public static final int STATUS_ACTIVESEEDING_NEITHER = 28;
    public static final int STATUS_DELETING_NOOUTPUT = 29;
    public static final int TYPE_CONTINUOUS = 0;
    public static final int TYPE_SPECIFIED = 1;
    public static final int START_WINDOWBEGIN = 0;
    public static final int START_WINDOWINSIDE = 1;
    public static final int START_DISABLE = 2;
    public static final int HOPCOUNT_ACCURATE = 0;
    public static final int HOPCOUNT_NODELETE = 1;
    public static final int HOPCOUNT_NEVERDELETE = 2;
    public static final String idField = "id";
    public static final String descriptionField = "description";
    public static final String documentSpecField = "docspec";
    public static final String connectionNameField = "connectionname";
    public static final String outputSpecField = "outputspec";
    public static final String outputNameField = "outputname";
    public static final String typeField = "type";
    public static final String intervalField = "intervaltime";
    public static final String expirationField = "expirationtime";
    public static final String priorityField = "priority";
    public static final String startMethodField = "startmethod";
    public static final String reseedIntervalField = "reseedinterval";
    public static final String statusField = "status";
    public static final String lastTimeField = "lasttime";
    public static final String startTimeField = "starttime";
    public static final String lastCheckTimeField = "lastchecktime";
    public static final String endTimeField = "endtime";
    public static final String windowEndField = "windowend";
    public static final String errorField = "errortext";
    public static final String reseedTimeField = "reseedtime";
    public static final String hopcountModeField = "hopcountmode";
    protected static Map statusMap = new HashMap();
    protected static Map typeMap;
    protected static Map startMap;
    protected static Map hopmodeMap;
    protected ICacheManager cacheManager;
    protected ScheduleManager scheduleManager;
    protected HopFilterManager hopFilterManager;
    protected IOutputConnectionManager outputMgr;
    protected IRepositoryConnectionManager connectionMgr;
    protected IThreadContext threadContext;

    public Jobs(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "jobs");
        this.threadContext = threadContext;
        this.scheduleManager = new ScheduleManager(threadContext, database);
        this.hopFilterManager = new HopFilterManager(threadContext, database);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)threadContext);
        this.outputMgr = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
        this.connectionMgr = RepositoryConnectionManagerFactory.make(threadContext);
    }

    public void install(String outputTableName, String outputNameField, String connectionTableName, String connectionNameField) throws ManifoldCFException {
        block3: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(idField, new ColumnDescription("BIGINT", true, false, null, null, false));
                map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(statusField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(lastTimeField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(startTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(lastCheckTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(endTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(documentSpecField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(outputSpecField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(connectionNameField, new ColumnDescription("VARCHAR(32)", false, false, connectionTableName, connectionNameField, false));
                map.put(outputNameField, new ColumnDescription("VARCHAR(32)", false, false, outputTableName, outputNameField, false));
                map.put(typeField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(intervalField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(expirationField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(windowEndField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(priorityField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(startMethodField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(errorField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(reseedIntervalField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(reseedTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(hopcountModeField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                this.performCreate(map, null);
            }
            this.scheduleManager.install(this.getTableName(), idField);
            this.hopFilterManager.install(this.getTableName(), idField);
            IndexDescription statusIndex = new IndexDescription(false, new String[]{statusField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (statusIndex != null && id.equals((Object)statusIndex)) {
                    statusIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (statusIndex == null) break block3;
            this.performAddIndex(null, statusIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.beginTransaction();
        try {
            this.hopFilterManager.deinstall();
            this.scheduleManager.deinstall();
            this.performDrop(null);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public int getAnalyzeTime() throws ManifoldCFException {
        return 1440;
    }

    public void analyzeTables() throws ManifoldCFException {
        this.analyzeTable();
    }

    public ScheduleRecord[][] readScheduleRecords(Long[] jobIDs) throws ManifoldCFException {
        HashMap<Long, Long> uniqueIDs = new HashMap<Long, Long>();
        int i = 0;
        while (i < jobIDs.length) {
            Long jobID = jobIDs[i++];
            uniqueIDs.put(jobID, jobID);
        }
        HashMap returnValues = new HashMap();
        this.beginTransaction();
        try {
            StringBuffer sb = new StringBuffer();
            ArrayList<Long> params = new ArrayList<Long>();
            int j = 0;
            int maxIn = this.getMaxInClause();
            Iterator iter = uniqueIDs.keySet().iterator();
            while (iter.hasNext()) {
                if (j == maxIn) {
                    this.scheduleManager.getRowsAlternate(returnValues, sb.toString(), params);
                    sb.setLength(0);
                    params.clear();
                    j = 0;
                }
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('?');
                params.add((Long)iter.next());
                ++j;
            }
            if (j > 0) {
                this.scheduleManager.getRowsAlternate(returnValues, sb.toString(), params);
            }
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
        ScheduleRecord[][] rval = new ScheduleRecord[jobIDs.length][];
        i = 0;
        while (i < jobIDs.length) {
            ScheduleRecord[] srList;
            ArrayList al = (ArrayList)returnValues.get(jobIDs[i]);
            if (al == null) {
                srList = new ScheduleRecord[]{};
            } else {
                srList = new ScheduleRecord[al.size()];
                for (int k = 0; k < srList.length; ++k) {
                    srList[k] = (ScheduleRecord)al.get(k);
                }
            }
            rval[i++] = srList;
        }
        return rval;
    }

    public IJobDescription[] getAll() throws ManifoldCFException {
        this.beginTransaction();
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(Jobs.getJobsKey());
            ssb.add(Jobs.getJobStatusKey());
            StringSet cacheKeys = new StringSet(ssb);
            ArrayList<String> list = new ArrayList<String>();
            list.add(Jobs.statusToString(10));
            list.add(Jobs.statusToString(22));
            list.add(Jobs.statusToString(21));
            list.add(Jobs.statusToString(29));
            IResultSet set = this.performQuery("SELECT id,description FROM " + this.getTableName() + " WHERE " + statusField + "!=? AND " + statusField + "!=? AND " + statusField + "!=? AND " + statusField + "!=?" + " ORDER BY " + descriptionField + " ASC", list, cacheKeys, null);
            Long[] ids = new Long[set.getRowCount()];
            boolean[] readOnlies = new boolean[set.getRowCount()];
            int i = 0;
            while (i < ids.length) {
                IResultRow row = set.getRow(i);
                ids[i] = (Long)row.getValue(idField);
                readOnlies[i++] = true;
            }
            IJobDescription[] iJobDescriptionArray = this.loadMultiple(ids, readOnlies);
            return iJobDescriptionArray;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public IResultSet getActiveJobConnections() throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Jobs.statusToString(1));
        list.add(Jobs.statusToString(11));
        return this.performQuery("SELECT id AS jobid,connectionname AS connectionname FROM " + this.getTableName() + " WHERE " + statusField + " IN (?,?)", list, null, null);
    }

    public String[] getActiveConnectionNames() throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Jobs.statusToString(1));
        list.add(Jobs.statusToString(11));
        IResultSet set = this.performQuery("SELECT DISTINCT connectionname FROM " + this.getTableName() + " WHERE " + statusField + " IN (?,?)", list, null, null);
        String[] rval = new String[set.getRowCount()];
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (String)row.getValue(connectionNameField);
        }
        return rval;
    }

    public boolean hasPriorityJobs(int priority) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Jobs.statusToString(1));
        list.add(Jobs.statusToString(11));
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + priorityField + "=" + Integer.toString(priority) + " AND " + statusField + " IN (?,?) " + this.constructOffsetLimitClause(0, 1), list, null, null, 1);
        return set.getRowCount() > 0;
    }

    public IJobDescription create() throws ManifoldCFException {
        JobDescription rval = new JobDescription();
        rval.setIsNew(true);
        rval.setID(new Long(IDFactory.make((IThreadContext)this.threadContext)));
        return rval;
    }

    public void delete(Long id) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(Jobs.getJobsKey());
        ssb.add(Jobs.getJobStatusKey());
        ssb.add(Jobs.getJobIDKey(id));
        StringSet cacheKeys = new StringSet(ssb);
        this.beginTransaction();
        try {
            this.scheduleManager.deleteRows(id);
            this.hopFilterManager.deleteRows(id);
            ArrayList<Long> params = new ArrayList<Long>();
            params.add(id);
            this.performDelete("WHERE id=?", params, cacheKeys);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public IJobDescription load(Long id, boolean readOnly) throws ManifoldCFException {
        return this.loadMultiple(new Long[]{id}, new boolean[]{readOnly})[0];
    }

    public IJobDescription[] loadMultiple(Long[] ids, boolean[] readOnlies) throws ManifoldCFException {
        JobObjectDescription[] objectDescriptions = new JobObjectDescription[ids.length];
        StringSetBuffer ssb = new StringSetBuffer();
        for (int i = 0; i < ids.length; ++i) {
            ssb.clear();
            ssb.add(Jobs.getJobIDKey(ids[i]));
            objectDescriptions[i] = new JobObjectDescription(ids[i], new StringSet(ssb));
        }
        JobObjectExecutor exec = new JobObjectExecutor(this, objectDescriptions);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        return exec.getResults(readOnlies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IJobDescription jobDescription) throws ManifoldCFException {
        Long id = jobDescription.getID();
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(Jobs.getJobsKey());
        ssb.add(Jobs.getJobStatusKey());
        ssb.add(Jobs.getJobIDKey(id));
        StringSet invKeys = new StringSet(ssb);
        ICacheHandle ch = this.cacheManager.enterCache(null, invKeys, this.getTransactionID());
        try {
            this.beginTransaction();
            try {
                this.performLock();
                ArrayList<Long> params = new ArrayList<Long>();
                params.add(id);
                IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + idField + "=? FOR UPDATE", params, null, null);
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put(descriptionField, jobDescription.getDescription());
                values.put(outputNameField, jobDescription.getOutputConnectionName());
                values.put(connectionNameField, jobDescription.getConnectionName());
                String newOutputXML = jobDescription.getOutputSpecification().toXML();
                values.put(outputSpecField, newOutputXML);
                String newXML = jobDescription.getSpecification().toXML();
                values.put(documentSpecField, newXML);
                values.put(typeField, Jobs.typeToString(jobDescription.getType()));
                values.put(startMethodField, Jobs.startMethodToString(jobDescription.getStartMethod()));
                values.put(intervalField, jobDescription.getInterval());
                values.put(reseedIntervalField, jobDescription.getReseedInterval());
                values.put(expirationField, jobDescription.getExpiration());
                values.put(priorityField, new Integer(jobDescription.getPriority()));
                values.put(hopcountModeField, Jobs.hopcountModeToString(jobDescription.getHopcountMode()));
                if (set.getRowCount() > 0) {
                    String oldDocSpecXML;
                    String oldOutputSpecXML;
                    IResultRow row = set.getRow(0);
                    boolean isSame = true;
                    if (isSame && !(oldOutputSpecXML = (String)row.getValue(outputSpecField)).equals(newOutputXML)) {
                        isSame = false;
                    }
                    if (isSame && !(oldDocSpecXML = (String)row.getValue(documentSpecField)).equals(newXML)) {
                        isSame = false;
                    }
                    if (!isSame) {
                        values.put(lastCheckTimeField, null);
                    }
                    params.clear();
                    params.add(id);
                    this.performUpdate(values, " WHERE id=?", params, null);
                    this.scheduleManager.deleteRows(id);
                    this.hopFilterManager.deleteRows(id);
                } else {
                    values.put(startTimeField, null);
                    values.put(lastCheckTimeField, null);
                    values.put(endTimeField, null);
                    values.put(statusField, Jobs.statusToString(0));
                    values.put(lastTimeField, new Long(System.currentTimeMillis()));
                    values.put(idField, id);
                    this.performInsert(values, null);
                }
                this.scheduleManager.writeRows(id, jobDescription);
                this.hopFilterManager.writeRows(id, jobDescription);
                this.cacheManager.invalidateKeys(ch);
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                throw e;
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            finally {
                this.endTransaction();
            }
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    public void restart() throws ManifoldCFException {
        this.beginTransaction();
        try {
            StringSet invKey = new StringSet(Jobs.getJobStatusKey());
            ArrayList<String> list = new ArrayList<String>();
            list.add(Jobs.statusToString(22));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(statusField, Jobs.statusToString(10));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(20));
            map.put(statusField, Jobs.statusToString(19));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(7));
            list.add(Jobs.statusToString(8));
            map.put(statusField, Jobs.statusToString(9));
            this.performUpdate(map, "WHERE status=? OR status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(18));
            map.put(statusField, Jobs.statusToString(16));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(11));
            map.put(statusField, Jobs.statusToString(1));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(12));
            map.put(statusField, Jobs.statusToString(6));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(17));
            map.put(statusField, Jobs.statusToString(16));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(13));
            map.put(statusField, Jobs.statusToString(2));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(14));
            map.put(statusField, Jobs.statusToString(4));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(15));
            map.put(statusField, Jobs.statusToString(5));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(24));
            map.put(statusField, Jobs.statusToString(23));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(26));
            map.put(statusField, Jobs.statusToString(25));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(28));
            map.put(statusField, Jobs.statusToString(27));
            this.performUpdate(map, "WHERE status=?", list, invKey);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void noteOutputConnectorDeregistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
        int newStatusValue;
        switch (oldStatusValue) {
            case 1: {
                newStatusValue = 25;
                break;
            }
            case 11: {
                newStatusValue = 26;
                break;
            }
            case 23: {
                newStatusValue = 27;
                break;
            }
            case 24: {
                newStatusValue = 28;
                break;
            }
            case 21: {
                newStatusValue = 29;
                break;
            }
            default: {
                newStatusValue = oldStatusValue;
            }
        }
        if (newStatusValue == oldStatusValue) {
            return;
        }
        StringSet invKey = new StringSet(Jobs.getJobStatusKey());
        HashMap<String, String> newValues = new HashMap<String, String>();
        newValues.put(statusField, Jobs.statusToString(newStatusValue));
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        this.performUpdate(newValues, "WHERE id=?", list, invKey);
    }

    public void noteOutputConnectorRegistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
        int newStatusValue;
        switch (oldStatusValue) {
            case 25: {
                newStatusValue = 1;
                break;
            }
            case 26: {
                newStatusValue = 11;
                break;
            }
            case 27: {
                newStatusValue = 23;
                break;
            }
            case 28: {
                newStatusValue = 24;
                break;
            }
            case 29: {
                newStatusValue = 21;
                break;
            }
            default: {
                newStatusValue = oldStatusValue;
            }
        }
        if (newStatusValue == oldStatusValue) {
            return;
        }
        StringSet invKey = new StringSet(Jobs.getJobStatusKey());
        HashMap<String, String> newValues = new HashMap<String, String>();
        newValues.put(statusField, Jobs.statusToString(newStatusValue));
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        this.performUpdate(newValues, "WHERE id=?", list, invKey);
    }

    public void noteConnectorDeregistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
        int newStatusValue;
        switch (oldStatusValue) {
            case 1: {
                newStatusValue = 23;
                break;
            }
            case 11: {
                newStatusValue = 24;
                break;
            }
            case 25: {
                newStatusValue = 27;
                break;
            }
            case 26: {
                newStatusValue = 28;
                break;
            }
            default: {
                newStatusValue = oldStatusValue;
            }
        }
        if (newStatusValue == oldStatusValue) {
            return;
        }
        StringSet invKey = new StringSet(Jobs.getJobStatusKey());
        HashMap<String, String> newValues = new HashMap<String, String>();
        newValues.put(statusField, Jobs.statusToString(newStatusValue));
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        this.performUpdate(newValues, "WHERE id=?", list, invKey);
    }

    public void noteConnectorRegistration(Long jobID, int oldStatusValue) throws ManifoldCFException {
        int newStatusValue;
        switch (oldStatusValue) {
            case 23: {
                newStatusValue = 1;
                break;
            }
            case 24: {
                newStatusValue = 11;
                break;
            }
            case 27: {
                newStatusValue = 25;
                break;
            }
            case 28: {
                newStatusValue = 26;
                break;
            }
            default: {
                newStatusValue = oldStatusValue;
            }
        }
        if (newStatusValue == oldStatusValue) {
            return;
        }
        StringSet invKey = new StringSet(Jobs.getJobStatusKey());
        HashMap<String, String> newValues = new HashMap<String, String>();
        newValues.put(statusField, Jobs.statusToString(newStatusValue));
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        this.performUpdate(newValues, "WHERE id=?", list, invKey);
    }

    public void noteConnectionChange(String connectionName) throws ManifoldCFException {
        HashMap<String, Object> newValues = new HashMap<String, Object>();
        newValues.put(lastCheckTimeField, null);
        ArrayList<String> list = new ArrayList<String>();
        list.add(connectionName);
        this.performUpdate(newValues, "WHERE connectionname=?", list, null);
    }

    public void noteOutputConnectionChange(String connectionName) throws ManifoldCFException {
        HashMap<String, Object> newValues = new HashMap<String, Object>();
        newValues.put(lastCheckTimeField, null);
        ArrayList<String> list = new ArrayList<String>();
        list.add(connectionName);
        this.performUpdate(newValues, "WHERE outputname=?", list, null);
    }

    public boolean checkJobActive(Long jobID) throws ManifoldCFException {
        StringSet cacheKeys = new StringSet(Jobs.getJobStatusKey());
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + idField + "=?", list, cacheKeys, null);
        if (set.getRowCount() == 0) {
            return false;
        }
        IResultRow row = set.getRow(0);
        String statusValue = (String)row.getValue(statusField);
        int status = Jobs.stringToStatus(statusValue);
        return status == 1 || status == 11 || status == 7;
    }

    public void resetDeleteStartupWorkerStatus() throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Jobs.statusToString(22));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(10));
        this.performUpdate(map, "WHERE status=?", list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void resetNotificationWorkerStatus() throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Jobs.statusToString(20));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(19));
        this.performUpdate(map, "WHERE status=?", list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void resetStartupWorkerStatus() throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Jobs.statusToString(7));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(9));
        this.performUpdate(map, "WHERE status=?", list, new StringSet(Jobs.getJobStatusKey()));
        list.clear();
        list.add(Jobs.statusToString(8));
        map.put(statusField, Jobs.statusToString(6));
        this.performUpdate(map, "WHERE status=?", list, new StringSet(Jobs.getJobStatusKey()));
        list.clear();
        list.add(Jobs.statusToString(18));
        map.put(statusField, Jobs.statusToString(16));
        this.performUpdate(map, "WHERE status=?", list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void resetSeedingWorkerStatus() throws ManifoldCFException {
        this.beginTransaction();
        try {
            StringSet invKey = new StringSet(Jobs.getJobStatusKey());
            ArrayList<String> list = new ArrayList<String>();
            HashMap<String, String> map = new HashMap<String, String>();
            list.clear();
            list.add(Jobs.statusToString(11));
            map.put(statusField, Jobs.statusToString(1));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(12));
            map.put(statusField, Jobs.statusToString(6));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(17));
            map.put(statusField, Jobs.statusToString(16));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(13));
            map.put(statusField, Jobs.statusToString(2));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(14));
            map.put(statusField, Jobs.statusToString(4));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(15));
            map.put(statusField, Jobs.statusToString(5));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(24));
            map.put(statusField, Jobs.statusToString(23));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(26));
            map.put(statusField, Jobs.statusToString(25));
            this.performUpdate(map, "WHERE status=?", list, invKey);
            list.clear();
            list.add(Jobs.statusToString(28));
            map.put(statusField, Jobs.statusToString(27));
            this.performUpdate(map, "WHERE status=?", list, invKey);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void startJob(Long jobID, Long windowEnd) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, Jobs.statusToString(9));
        map.put(endTimeField, null);
        map.put(errorField, null);
        map.put(windowEndField, windowEnd);
        this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void returnJobToActive(Long jobID) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(jobID);
            IResultSet set = this.performQuery("SELECT status,connectionname,outputname FROM " + this.getTableName() + " WHERE " + idField + "=? FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Can't find job " + jobID.toString());
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus((String)row.getValue(statusField));
            switch (status) {
                case 3: {
                    if (this.connectionMgr.checkConnectorExists((String)row.getValue(connectionNameField))) {
                        if (this.outputMgr.checkConnectorExists((String)row.getValue(outputNameField))) {
                            newStatus = 1;
                            break;
                        }
                        newStatus = 25;
                        break;
                    }
                    if (this.outputMgr.checkConnectorExists((String)row.getValue(outputNameField))) {
                        newStatus = 23;
                        break;
                    }
                    newStatus = 27;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Unexpected job status encountered: " + Integer.toString(status));
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(statusField, Jobs.statusToString(newStatus));
            this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void noteJobDeleteStarted(Long jobID, long startTime) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(jobID);
            IResultSet set = this.performQuery("SELECT status,connectionname,outputname FROM " + this.getTableName() + " WHERE " + idField + "=? FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Can't find job " + jobID.toString());
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus((String)row.getValue(statusField));
            switch (status) {
                case 22: {
                    if (this.outputMgr.checkConnectorExists((String)row.getValue(outputNameField))) {
                        newStatus = 21;
                        break;
                    }
                    newStatus = 29;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Unexpected job status encountered: " + Integer.toString(status));
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(statusField, Jobs.statusToString(newStatus));
            if (newStatus == 21 || newStatus == 29) {
                map.put(startTimeField, new Long(startTime));
            }
            map.put(lastCheckTimeField, new Long(startTime));
            this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void noteJobStarted(Long jobID, long startTime) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(jobID);
            IResultSet set = this.performQuery("SELECT status,connectionname,outputname FROM " + this.getTableName() + " WHERE " + idField + "=? FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Can't find job " + jobID.toString());
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus((String)row.getValue(statusField));
            switch (status) {
                case 7: {
                    if (this.connectionMgr.checkConnectorExists((String)row.getValue(connectionNameField))) {
                        if (this.outputMgr.checkConnectorExists((String)row.getValue(outputNameField))) {
                            newStatus = 1;
                            break;
                        }
                        newStatus = 25;
                        break;
                    }
                    if (this.outputMgr.checkConnectorExists((String)row.getValue(outputNameField))) {
                        newStatus = 23;
                        break;
                    }
                    newStatus = 27;
                    break;
                }
                case 8: {
                    newStatus = 6;
                    break;
                }
                case 18: {
                    newStatus = 16;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Unexpected job status encountered: " + Integer.toString(status));
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(statusField, Jobs.statusToString(newStatus));
            if (newStatus == 1 || newStatus == 23 || newStatus == 25 || newStatus == 27) {
                map.put(startTimeField, new Long(startTime));
            }
            this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void noteJobSeeded(Long jobID, long seedTime) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(jobID);
            IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + idField + "=? FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Can't find job " + jobID.toString());
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus((String)row.getValue(statusField));
            switch (status) {
                case 11: {
                    newStatus = 1;
                    break;
                }
                case 24: {
                    newStatus = 23;
                    break;
                }
                case 26: {
                    newStatus = 25;
                    break;
                }
                case 28: {
                    newStatus = 27;
                    break;
                }
                case 14: {
                    newStatus = 4;
                    break;
                }
                case 13: {
                    newStatus = 2;
                    break;
                }
                case 15: {
                    newStatus = 5;
                    break;
                }
                case 12: {
                    newStatus = 6;
                    break;
                }
                case 17: {
                    newStatus = 16;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Unexpected job status encountered: " + Integer.toString(status));
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(statusField, Jobs.statusToString(newStatus));
            map.put(lastCheckTimeField, new Long(seedTime));
            this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void unwaitJob(Long jobID, int newStatus, Long windowEnd) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, Jobs.statusToString(newStatus));
        map.put(windowEndField, windowEnd);
        this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void waitJob(Long jobID, int newStatus) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(newStatus));
        map.put(windowEndField, null);
        this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
    }

    public boolean abortJob(Long jobID, String errorText) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(jobID);
            IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + idField + "=? FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Job does not exist: " + jobID);
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus(row.getValue(statusField).toString());
            if (status == 6 || status == 12 || status == 8) {
                boolean bl = false;
                return bl;
            }
            switch (status) {
                case 7: 
                case 18: {
                    newStatus = 8;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 9: 
                case 16: 
                case 23: 
                case 25: 
                case 27: {
                    newStatus = 6;
                    break;
                }
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 24: 
                case 26: 
                case 28: {
                    newStatus = 12;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Job " + jobID + " is not active");
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(statusField, Jobs.statusToString(newStatus));
            map.put(errorField, errorText);
            this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
            boolean bl = true;
            return bl;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void abortRestartJob(Long jobID) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(jobID);
            IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + idField + "=? FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Job does not exist: " + jobID);
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus(row.getValue(statusField).toString());
            if (status == 16 || status == 17 || status == 18) {
                return;
            }
            switch (status) {
                case 7: {
                    newStatus = 18;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 9: 
                case 23: 
                case 25: 
                case 27: {
                    newStatus = 16;
                    break;
                }
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 24: 
                case 26: 
                case 28: {
                    newStatus = 17;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Job " + jobID + " is not restartable");
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(statusField, Jobs.statusToString(newStatus));
            this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void pauseJob(Long jobID) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(jobID);
            IResultSet set = this.performQuery("SELECT status FROM " + this.getTableName() + " WHERE " + idField + "=? FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Job does not exist: " + jobID);
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus(row.getValue(statusField).toString());
            switch (status) {
                case 1: 
                case 23: 
                case 25: 
                case 27: {
                    newStatus = 2;
                    break;
                }
                case 4: {
                    newStatus = 5;
                    break;
                }
                case 11: 
                case 24: 
                case 26: 
                case 28: {
                    newStatus = 13;
                    break;
                }
                case 14: {
                    newStatus = 15;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Job " + jobID + " is not active");
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(statusField, Jobs.statusToString(newStatus));
            this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void restartJob(Long jobID) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int newStatus;
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(jobID);
            IResultSet set = this.performQuery("SELECT status,connectionname,outputname FROM " + this.getTableName() + " WHERE " + idField + "=? FOR UPDATE", list, null, null);
            if (set.getRowCount() == 0) {
                throw new ManifoldCFException("Job does not exist: " + jobID);
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus(row.getValue(statusField).toString());
            String connectionName = (String)row.getValue(connectionNameField);
            String outputName = (String)row.getValue(outputNameField);
            switch (status) {
                case 2: {
                    if (this.connectionMgr.checkConnectorExists(connectionName)) {
                        if (this.outputMgr.checkConnectorExists(outputName)) {
                            newStatus = 1;
                            break;
                        }
                        newStatus = 25;
                        break;
                    }
                    if (this.outputMgr.checkConnectorExists(outputName)) {
                        newStatus = 23;
                        break;
                    }
                    newStatus = 27;
                    break;
                }
                case 5: {
                    newStatus = 4;
                    break;
                }
                case 13: {
                    if (this.connectionMgr.checkConnectorExists(connectionName)) {
                        if (this.outputMgr.checkConnectorExists(outputName)) {
                            newStatus = 11;
                            break;
                        }
                        newStatus = 26;
                        break;
                    }
                    if (this.outputMgr.checkConnectorExists(outputName)) {
                        newStatus = 24;
                        break;
                    }
                    newStatus = 28;
                    break;
                }
                case 15: {
                    newStatus = 14;
                    break;
                }
                default: {
                    throw new ManifoldCFException("Job " + jobID + " is not paused");
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(statusField, Jobs.statusToString(newStatus));
            this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void writeStatus(Long jobID, int status, Long reseedTime) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, Jobs.statusToString(status));
        map.put(reseedTimeField, reseedTime);
        this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void writeStatus(Long jobID, int status) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(status));
        this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void updateLastTime(Long jobID, long currentTime) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(lastTimeField, new Long(currentTime));
        this.performUpdate(map, "WHERE id=?", list, null);
    }

    public void finishJob(Long jobID, long finishTime) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, Jobs.statusToString(19));
        map.put(errorField, null);
        map.put(endTimeField, new Long(finishTime));
        map.put(lastTimeField, new Long(finishTime));
        map.put(windowEndField, null);
        map.put(reseedTimeField, null);
        this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void finishAbortJob(Long jobID, long abortTime) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, Jobs.statusToString(19));
        map.put(endTimeField, null);
        map.put(lastTimeField, new Long(abortTime));
        map.put(windowEndField, null);
        map.put(reseedTimeField, null);
        this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
    }

    public void notificationComplete(Long jobID) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, Jobs.statusToString(0));
        this.performUpdate(map, "WHERE id=?", list, new StringSet(Jobs.getJobStatusKey()));
    }

    public boolean checkIfReference(String connectionName) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(connectionName);
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + connectionNameField + "=?", list, new StringSet(Jobs.getJobsKey()), null);
        return set.getRowCount() > 0;
    }

    public boolean checkIfOutputReference(String connectionName) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(connectionName);
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + outputNameField + "=?", list, new StringSet(Jobs.getJobsKey()), null);
        return set.getRowCount() > 0;
    }

    public IJobDescription[] findJobsForConnection(String connectionName) throws ManifoldCFException {
        this.beginTransaction();
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(Jobs.getJobsKey());
            StringSet cacheKeys = new StringSet(ssb);
            ArrayList<String> list = new ArrayList<String>();
            list.add(connectionName);
            IResultSet set = this.performQuery("SELECT id,description FROM " + this.getTableName() + " WHERE " + connectionNameField + "=?" + " ORDER BY " + descriptionField + " ASC", list, cacheKeys, null);
            Long[] ids = new Long[set.getRowCount()];
            boolean[] readOnlies = new boolean[set.getRowCount()];
            int i = 0;
            while (i < ids.length) {
                IResultRow row = set.getRow(i);
                ids[i] = (Long)row.getValue(idField);
                readOnlies[i++] = true;
            }
            IJobDescription[] iJobDescriptionArray = this.loadMultiple(ids, readOnlies);
            return iJobDescriptionArray;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public boolean deletingJobsPresent() throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Jobs.statusToString(21));
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + statusField + "=? " + this.constructOffsetLimitClause(0, 1), list, new StringSet(Jobs.getJobStatusKey()), null, 1);
        return set.getRowCount() > 0;
    }

    public boolean cleaningJobsPresent() throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Jobs.statusToString(3));
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + statusField + "=? " + this.constructOffsetLimitClause(0, 1), list, new StringSet(Jobs.getJobStatusKey()), null, 1);
        return set.getRowCount() > 0;
    }

    public boolean activeJobsPresent() throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Jobs.statusToString(1));
        list.add(Jobs.statusToString(11));
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + statusField + " IN (?,?) " + this.constructOffsetLimitClause(0, 1), list, new StringSet(Jobs.getJobStatusKey()), null, 1);
        return set.getRowCount() > 0;
    }

    public static int stringToStatus(String value) throws ManifoldCFException {
        Integer x = (Integer)statusMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Bad status value: '" + value + "'");
        }
        return x;
    }

    public static String statusToString(int status) throws ManifoldCFException {
        switch (status) {
            case 0: {
                return "N";
            }
            case 1: {
                return "A";
            }
            case 2: {
                return "P";
            }
            case 3: {
                return "S";
            }
            case 20: {
                return "n";
            }
            case 19: {
                return "s";
            }
            case 4: {
                return "W";
            }
            case 5: {
                return "Z";
            }
            case 6: {
                return "X";
            }
            case 16: {
                return "Y";
            }
            case 7: {
                return "B";
            }
            case 8: {
                return "Q";
            }
            case 18: {
                return "T";
            }
            case 9: {
                return "C";
            }
            case 10: {
                return "E";
            }
            case 22: {
                return "V";
            }
            case 21: {
                return "e";
            }
            case 11: {
                return "a";
            }
            case 12: {
                return "x";
            }
            case 13: {
                return "p";
            }
            case 14: {
                return "w";
            }
            case 15: {
                return "z";
            }
            case 17: {
                return "y";
            }
            case 23: {
                return "R";
            }
            case 24: {
                return "r";
            }
            case 25: {
                return "O";
            }
            case 26: {
                return "o";
            }
            case 27: {
                return "U";
            }
            case 28: {
                return "u";
            }
            case 29: {
                return "D";
            }
        }
        throw new ManifoldCFException("Bad status value: " + Integer.toString(status));
    }

    public static int stringToType(String value) throws ManifoldCFException {
        Integer x = (Integer)typeMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Bad type value: '" + value + "'");
        }
        return x;
    }

    public static String typeToString(int type) throws ManifoldCFException {
        switch (type) {
            case 0: {
                return "C";
            }
            case 1: {
                return "S";
            }
        }
        throw new ManifoldCFException("Bad type: " + Integer.toString(type));
    }

    public static int stringToHopcountMode(String value) throws ManifoldCFException {
        if (value == null || value.length() == 0) {
            return 0;
        }
        Integer x = (Integer)hopmodeMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Bad hopcount mode value: '" + value + "'");
        }
        return x;
    }

    public static String hopcountModeToString(int value) throws ManifoldCFException {
        switch (value) {
            case 0: {
                return "A";
            }
            case 1: {
                return "N";
            }
            case 2: {
                return "V";
            }
        }
        throw new ManifoldCFException("Unknown hopcount mode value " + Integer.toString(value));
    }

    public static int stringToStartMethod(String value) throws ManifoldCFException {
        Integer x = (Integer)startMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Bad start method value: '" + value + "'");
        }
        return x;
    }

    public static String startMethodToString(int startMethod) throws ManifoldCFException {
        switch (startMethod) {
            case 0: {
                return "B";
            }
            case 1: {
                return "I";
            }
            case 2: {
                return "D";
            }
        }
        throw new ManifoldCFException("Bad start method: " + Integer.toString(startMethod));
    }

    public static EnumeratedValues stringToEnumeratedValue(String value) throws ManifoldCFException {
        if (value == null) {
            return null;
        }
        try {
            ArrayList<Integer> valStore = new ArrayList<Integer>();
            if (!value.equals("*")) {
                int curpos = 0;
                while (true) {
                    int newpos;
                    if ((newpos = value.indexOf(",", curpos)) == -1) {
                        valStore.add(new Integer(value.substring(curpos)));
                        break;
                    }
                    valStore.add(new Integer(value.substring(curpos, newpos)));
                    curpos = newpos + 1;
                }
            }
            return new EnumeratedValues(valStore);
        }
        catch (NumberFormatException e) {
            throw new ManifoldCFException("Bad number: '" + value + "'", (Throwable)e);
        }
    }

    public static String enumeratedValueToString(EnumeratedValues values) {
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return "*";
        }
        StringBuffer rval = new StringBuffer();
        Iterator iter = values.getValues();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                rval.append(',');
            }
            rval.append(((Integer)iter.next()).toString());
        }
        return rval.toString();
    }

    protected static String getJobsKey() {
        return CacheKeyFactory.makeJobsKey();
    }

    protected static String getJobIDKey(Long jobID) {
        return CacheKeyFactory.makeJobIDKey(jobID.toString());
    }

    protected static String getJobStatusKey() {
        return CacheKeyFactory.makeJobStatusKey();
    }

    protected JobDescription[] getJobsMultiple(Long[] ids) throws ManifoldCFException {
        int i;
        HashMap<Long, Long> uniqueIDs = new HashMap<Long, Long>();
        for (i = 0; i < ids.length; ++i) {
            uniqueIDs.put(ids[i], ids[i]);
        }
        HashMap returnValues = new HashMap();
        this.beginTransaction();
        try {
            StringBuffer sb = new StringBuffer();
            ArrayList<Long> params = new ArrayList<Long>();
            int j = 0;
            int maxIn = this.getMaxInClause();
            Iterator iter = uniqueIDs.keySet().iterator();
            while (iter.hasNext()) {
                if (j == maxIn) {
                    this.getJobsChunk(returnValues, sb.toString(), params);
                    sb.setLength(0);
                    params.clear();
                    j = 0;
                }
                if (j > 0) {
                    sb.append(',');
                }
                sb.append('?');
                params.add((Long)iter.next());
                ++j;
            }
            if (j > 0) {
                this.getJobsChunk(returnValues, sb.toString(), params);
            }
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
        JobDescription[] rval = new JobDescription[ids.length];
        for (i = 0; i < rval.length; ++i) {
            Long id = ids[i];
            JobDescription jd = (JobDescription)returnValues.get(id);
            if (jd != null) {
                jd.makeReadOnly();
            }
            rval[i] = jd;
        }
        return rval;
    }

    protected void getJobsChunk(Map returnValues, String idList, ArrayList params) throws ManifoldCFException {
        try {
            IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + idField + " IN (" + idList + ")", params, null, null);
            int i = 0;
            while (i < set.getRowCount()) {
                IResultRow row = set.getRow(i++);
                Long id = (Long)row.getValue(idField);
                JobDescription rc = new JobDescription();
                rc.setID(id);
                rc.setIsNew(false);
                rc.setDescription(row.getValue(descriptionField).toString());
                rc.setOutputConnectionName(row.getValue(outputNameField).toString());
                rc.setConnectionName(row.getValue(connectionNameField).toString());
                rc.setType(Jobs.stringToType(row.getValue(typeField).toString()));
                rc.setStartMethod(Jobs.stringToStartMethod(row.getValue(startMethodField).toString()));
                rc.setHopcountMode(Jobs.stringToHopcountMode((String)row.getValue(hopcountModeField)));
                rc.getOutputSpecification().fromXML(row.getValue(outputSpecField).toString());
                rc.getSpecification().fromXML(row.getValue(documentSpecField).toString());
                rc.setInterval((Long)row.getValue(intervalField));
                rc.setReseedInterval((Long)row.getValue(reseedIntervalField));
                rc.setExpiration((Long)row.getValue(expirationField));
                rc.setPriority(Integer.parseInt(row.getValue(priorityField).toString()));
                returnValues.put(id, rc);
            }
            this.scheduleManager.getRows(returnValues, idList, params);
            this.hopFilterManager.getRows(returnValues, idList, params);
        }
        catch (NumberFormatException e) {
            throw new ManifoldCFException("Bad number", (Throwable)e);
        }
    }

    static {
        statusMap.put("N", new Integer(0));
        statusMap.put("A", new Integer(1));
        statusMap.put("P", new Integer(2));
        statusMap.put("S", new Integer(3));
        statusMap.put("s", new Integer(19));
        statusMap.put("n", new Integer(20));
        statusMap.put("W", new Integer(4));
        statusMap.put("Z", new Integer(5));
        statusMap.put("X", new Integer(6));
        statusMap.put("B", new Integer(7));
        statusMap.put("Q", new Integer(8));
        statusMap.put("C", new Integer(9));
        statusMap.put("E", new Integer(10));
        statusMap.put("V", new Integer(22));
        statusMap.put("e", new Integer(21));
        statusMap.put("Y", new Integer(16));
        statusMap.put("T", new Integer(18));
        statusMap.put("a", new Integer(11));
        statusMap.put("x", new Integer(12));
        statusMap.put("p", new Integer(13));
        statusMap.put("w", new Integer(14));
        statusMap.put("z", new Integer(15));
        statusMap.put("y", new Integer(17));
        statusMap.put("R", new Integer(23));
        statusMap.put("r", new Integer(24));
        statusMap.put("O", new Integer(25));
        statusMap.put("o", new Integer(26));
        statusMap.put("U", new Integer(27));
        statusMap.put("u", new Integer(28));
        statusMap.put("D", new Integer(29));
        typeMap = new HashMap();
        typeMap.put("C", new Integer(0));
        typeMap.put("S", new Integer(1));
        startMap = new HashMap();
        startMap.put("B", new Integer(0));
        startMap.put("I", new Integer(1));
        startMap.put("D", new Integer(2));
        hopmodeMap = new HashMap();
        hopmodeMap.put("A", new Integer(0));
        hopmodeMap.put("N", new Integer(1));
        hopmodeMap.put("V", new Integer(2));
    }

    protected static class JobObjectExecutor
    extends ExecutorBase {
        protected Jobs thisManager;
        protected JobDescription[] returnValues;
        protected HashMap returnMap = new HashMap();

        public JobObjectExecutor(Jobs manager, JobObjectDescription[] objectDescriptions) {
            this.thisManager = manager;
            this.returnValues = new JobDescription[objectDescriptions.length];
            for (int i = 0; i < objectDescriptions.length; ++i) {
                this.returnMap.put(objectDescriptions[i].getJobID(), new Integer(i));
            }
        }

        public JobDescription[] getResults(boolean[] readOnlies) {
            JobDescription[] rval = new JobDescription[this.returnValues.length];
            for (int i = 0; i < rval.length; ++i) {
                JobDescription jd = this.returnValues[i];
                rval[i] = jd != null ? jd.duplicate(readOnlies[i]) : null;
            }
            return rval;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            Long[] ids = new Long[objectDescriptions.length];
            for (int i = 0; i < ids.length; ++i) {
                JobObjectDescription desc = (JobObjectDescription)objectDescriptions[i];
                ids[i] = desc.getJobID();
            }
            return this.thisManager.getJobsMultiple(ids);
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            JobDescription ci;
            JobObjectDescription objectDesc = (JobObjectDescription)objectDescription;
            this.returnValues[((Integer)this.returnMap.get((Object)objectDesc.getJobID())).intValue()] = ci = (JobDescription)cachedObject;
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class JobObjectDescription
    extends BaseDescription {
        protected Long jobID;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public JobObjectDescription(Long jobID, StringSet invKeys) {
            super("jobdescriptioncache");
            this.jobID = jobID;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + jobID.toString();
            this.cacheKeys = invKeys;
        }

        public Long getJobID() {
            return this.jobID;
        }

        public int hashCode() {
            return this.jobID.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof JobObjectDescription)) {
                return false;
            }
            JobObjectDescription d = (JobObjectDescription)((Object)o);
            return d.jobID.equals(this.jobID);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }
    }
}

