/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.repository;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;

public class RepositoryConnection
implements IRepositoryConnection {
    public static final String _rcsid = "@(#)$Id: RepositoryConnection.java 988245 2010-08-23 18:39:35Z kwright $";
    protected boolean isNew = true;
    protected String name = null;
    protected String description = null;
    protected String className = null;
    protected String authorityName = null;
    protected ConfigParams configParams = new ConfigParams();
    protected int maxCount = 100;
    protected HashMap throttles = new HashMap();

    public RepositoryConnection duplicate() {
        RepositoryConnection rval = new RepositoryConnection();
        rval.isNew = this.isNew;
        rval.name = this.name;
        rval.description = this.description;
        rval.className = this.className;
        rval.authorityName = this.authorityName;
        rval.maxCount = this.maxCount;
        rval.configParams = this.configParams.duplicate();
        for (String key : this.throttles.keySet()) {
            ThrottleItem ti = (ThrottleItem)this.throttles.get(key);
            rval.throttles.put(key, ti);
        }
        return rval;
    }

    public void setIsNew(boolean isnew) {
        this.isNew = isnew;
    }

    public boolean getIsNew() {
        return this.isNew;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setACLAuthority(String authorityName) {
        this.authorityName = authorityName;
    }

    public String getACLAuthority() {
        return this.authorityName;
    }

    public ConfigParams getConfigParams() {
        return this.configParams;
    }

    public void setMaxConnections(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getMaxConnections() {
        return this.maxCount;
    }

    public void clearThrottleValues() {
        this.throttles.clear();
    }

    public void addThrottleValue(String match, String description, float throttle) {
        this.throttles.put(match, new ThrottleItem(match, description, throttle));
    }

    public void deleteThrottleValue(String match) {
        this.throttles.remove(match);
    }

    public String[] getThrottles() {
        Object[] rval = new String[this.throttles.size()];
        Iterator iter = this.throttles.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        Arrays.sort(rval);
        return rval;
    }

    public String getThrottleDescription(String match) {
        ThrottleItem i = (ThrottleItem)this.throttles.get(match);
        if (i == null) {
            return null;
        }
        return i.getDescription();
    }

    public float getThrottleValue(String match) {
        ThrottleItem i = (ThrottleItem)this.throttles.get(match);
        if (i == null) {
            return 0.0f;
        }
        return i.getValue();
    }

    public void setThrottle(Float rate) {
        if (rate == null) {
            this.deleteThrottleValue(".*");
        } else {
            this.addThrottleValue(".*", "All bins", rate.floatValue());
        }
    }

    public Float getThrottle() {
        float rate = this.getThrottleValue(".*");
        if (rate == 0.0f) {
            return null;
        }
        return new Float(rate);
    }

    protected static class ThrottleItem {
        protected String match;
        protected String description;
        protected float value;

        public ThrottleItem(String match, String description, float value) {
            this.match = match;
            this.description = description;
            this.value = value;
        }

        public String getMatch() {
            return this.match;
        }

        public String getDescription() {
            return this.description;
        }

        public float getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.match.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ThrottleItem)) {
                return false;
            }
            ThrottleItem other = (ThrottleItem)o;
            return this.match.equals(other.match);
        }
    }
}

