/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.DeleteQueuedDocument;
import org.apache.manifoldcf.crawler.system.DocDeleteResetManager;
import org.apache.manifoldcf.crawler.system.DocumentDeleteQueue;
import org.apache.manifoldcf.crawler.system.DocumentDeleteSet;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class DocumentDeleteStufferThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: DocumentDeleteStufferThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected DocumentDeleteQueue documentDeleteQueue;
    protected DocDeleteResetManager resetManager;
    int n;

    public DocumentDeleteStufferThread(DocumentDeleteQueue documentDeleteQueue, int n, DocDeleteResetManager resetManager) throws ManifoldCFException {
        this.documentDeleteQueue = documentDeleteQueue;
        this.n = n;
        this.resetManager = resetManager;
        this.setName("Document delete stuffer thread");
        this.setDaemon(true);
    }

    public void run() {
        this.resetManager.registerMe();
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IRepositoryConnectionManager mgr = RepositoryConnectionManagerFactory.make(threadContext);
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            ArrayList docList = new ArrayList();
            IDBInterface database = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            int deleteChunkSize = database.getMaxInClause();
            while (true) {
                try {
                    while (true) {
                        int k;
                        this.resetManager.waitForReset(threadContext);
                        if (!this.documentDeleteQueue.checkIfEmpty(this.n)) {
                            ManifoldCF.sleep((long)100L);
                            continue;
                        }
                        Logging.threads.debug((Object)"Document delete stuffer thread woke up");
                        long currentTime = System.currentTimeMillis();
                        DocumentDescription[] descs = jobManager.getNextDeletableDocuments(deleteChunkSize, currentTime);
                        if (descs.length == 0) {
                            Logging.threads.debug((Object)"Document delete stuffer thread found nothing to do");
                            ManifoldCF.sleep((long)1000L);
                            continue;
                        }
                        if (Logging.threads.isDebugEnabled()) {
                            Logging.threads.debug((Object)("Document delete stuffer thread found " + Integer.toString(descs.length) + " documents"));
                        }
                        HashMap<Long, ArrayList<DeleteQueuedDocument>> jobMap = new HashMap<Long, ArrayList<DeleteQueuedDocument>>();
                        for (k = 0; k < descs.length; ++k) {
                            DeleteQueuedDocument x = new DeleteQueuedDocument(descs[k]);
                            Long jobID = descs[k].getJobID();
                            ArrayList<DeleteQueuedDocument> y = (ArrayList<DeleteQueuedDocument>)jobMap.get(jobID);
                            if (y == null) {
                                y = new ArrayList<DeleteQueuedDocument>();
                                jobMap.put(jobID, y);
                            }
                            y.add(x);
                        }
                        for (Long jobID : jobMap.keySet()) {
                            IJobDescription jobDescription = jobManager.load(jobID, true);
                            List y = (List)jobMap.get(jobID);
                            DeleteQueuedDocument[] docDescs = new DeleteQueuedDocument[y.size()];
                            for (k = 0; k < docDescs.length; ++k) {
                                docDescs[k] = (DeleteQueuedDocument)y.get(k);
                            }
                            DocumentDeleteSet set = new DocumentDeleteSet(docDescs, jobDescription);
                            this.documentDeleteQueue.addDocuments(set);
                        }
                        DocumentDeleteStufferThread.yield();
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        this.documentDeleteQueue.reset();
                        Logging.threads.error((Object)"Delete stuffer thread aborting and restarting due to database connection reset", (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("DocumentDeleteStufferThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }
}

