/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.system.QueuedDocumentSet;

public class DocumentQueue {
    public static final String _rcsid = "@(#)$Id: DocumentQueue.java 988245 2010-08-23 18:39:35Z kwright $";
    protected ArrayList queue = new ArrayList();
    protected boolean resetFlag = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList arrayList = this.queue;
        synchronized (arrayList) {
            this.resetFlag = true;
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.clear();
            this.resetFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfEmpty(int n) {
        ArrayList arrayList = this.queue;
        synchronized (arrayList) {
            if (this.queue.size() <= n) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(QueuedDocumentSet dd) {
        ArrayList arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.add(dd);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuedDocumentSet getDocument(QueueTracker overlapCalculator) throws InterruptedException {
        ArrayList arrayList = this.queue;
        synchronized (arrayList) {
            if (this.resetFlag) {
                return null;
            }
            while (this.queue.size() == 0 && !this.resetFlag) {
                this.queue.wait();
            }
            if (this.queue.size() == 0) {
                return null;
            }
            int bestIndex = -1;
            double bestRating = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.queue.size(); ++i) {
                QueuedDocumentSet dd = (QueuedDocumentSet)this.queue.get(i);
                double rating = dd.calculateAssignmentRating(overlapCalculator);
                if (bestIndex != -1 && !(rating > bestRating)) continue;
                bestIndex = i;
                bestRating = rating;
            }
            QueuedDocumentSet rval = (QueuedDocumentSet)this.queue.remove(bestIndex);
            return rval;
        }
    }
}

