/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import org.apache.manifoldcf.agents.interfaces.IIncrementalIngester;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.IncrementalIngesterFactory;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorFactory;
import org.apache.manifoldcf.crawler.system.CleanupQueuedDocument;
import org.apache.manifoldcf.crawler.system.DocumentCleanupQueue;
import org.apache.manifoldcf.crawler.system.DocumentCleanupSet;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.WorkerResetManager;

public class ExpireThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: ExpireThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected String id;
    protected DocumentCleanupQueue documentQueue;
    protected WorkerResetManager resetManager;
    protected QueueTracker queueTracker;

    public ExpireThread(String id, DocumentCleanupQueue documentQueue, QueueTracker queueTracker, WorkerResetManager resetManager) throws ManifoldCFException {
        this.id = id;
        this.documentQueue = documentQueue;
        this.resetManager = resetManager;
        this.queueTracker = queueTracker;
        this.setName("Expiration thread '" + id + "'");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.resetManager.registerMe();
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IIncrementalIngester ingester = IncrementalIngesterFactory.make((IThreadContext)threadContext);
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            IRepositoryConnectionManager connMgr = RepositoryConnectionManagerFactory.make(threadContext);
            while (true) {
                try {
                    DocumentCleanupSet dds;
                    block23: while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        this.resetManager.waitForReset(threadContext);
                        dds = this.documentQueue.getDocuments();
                        if (dds == null) continue;
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        IJobDescription job = dds.getJobDescription();
                        String connectionName = job.getConnectionName();
                        String outputConnectionName = job.getOutputConnectionName();
                        try {
                            long currentTime = System.currentTimeMillis();
                            IRepositoryConnection connection = connMgr.load(connectionName);
                            ArrayList<String> arrayDocHashes = new ArrayList<String>();
                            ArrayList<CleanupQueuedDocument> arrayDocsToDelete = new ArrayList<CleanupQueuedDocument>();
                            ArrayList<String[]> arrayRelationshipTypes = new ArrayList<String[]>();
                            ArrayList<Integer> hopcountMethods = new ArrayList<Integer>();
                            for (int j = 0; j < dds.getCount(); ++j) {
                                String[] legalLinkTypes;
                                CleanupQueuedDocument dqd = dds.getDocument(j);
                                DocumentDescription ddd = dqd.getDocumentDescription();
                                if (job == null || connection == null || (legalLinkTypes = RepositoryConnectorFactory.getRelationshipTypes(threadContext, connection.getClassName())) == null) continue;
                                arrayDocHashes.add(ddd.getDocumentIdentifierHash());
                                arrayDocsToDelete.add(dqd);
                                arrayRelationshipTypes.add(legalLinkTypes);
                                hopcountMethods.add(new Integer(job.getHopcountMode()));
                            }
                            try {
                                IRepositoryConnector connector = RepositoryConnectorFactory.grab(threadContext, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
                                try {
                                    int k;
                                    boolean[] deleteFromQueue = new boolean[arrayDocHashes.size()];
                                    int removeCount = 0;
                                    for (k = 0; k < arrayDocHashes.size(); ++k) {
                                        if (((CleanupQueuedDocument)arrayDocsToDelete.get(k)).shouldBeRemovedFromIndex()) {
                                            deleteFromQueue[k] = false;
                                            ++removeCount;
                                            continue;
                                        }
                                        deleteFromQueue[k] = true;
                                    }
                                    String[] docClassesToRemove = new String[removeCount];
                                    String[] hashedDocsToRemove = new String[removeCount];
                                    removeCount = 0;
                                    for (k = 0; k < arrayDocHashes.size(); ++k) {
                                        if (!((CleanupQueuedDocument)arrayDocsToDelete.get(k)).shouldBeRemovedFromIndex()) continue;
                                        docClassesToRemove[removeCount] = connectionName;
                                        hashedDocsToRemove[removeCount] = (String)arrayDocHashes.get(k);
                                        ++removeCount;
                                    }
                                    OutputRemoveActivity activities = new OutputRemoveActivity(connectionName, connMgr, outputConnectionName);
                                    try {
                                        ingester.documentDeleteMultiple(outputConnectionName, docClassesToRemove, hashedDocsToRemove, (IOutputRemoveActivity)activities);
                                        for (k = 0; k < arrayDocHashes.size(); ++k) {
                                            if (!((CleanupQueuedDocument)arrayDocsToDelete.get(k)).shouldBeRemovedFromIndex()) continue;
                                            deleteFromQueue[k] = true;
                                        }
                                    }
                                    catch (ServiceInterruption e) {
                                        for (k = 0; k < arrayDocHashes.size(); ++k) {
                                            CleanupQueuedDocument cqd = (CleanupQueuedDocument)arrayDocsToDelete.get(k);
                                            if (!cqd.shouldBeRemovedFromIndex()) continue;
                                            DocumentDescription dd = cqd.getDocumentDescription();
                                            if (dd.getFailTime() != -1L && dd.getFailTime() < e.getRetryTime() || dd.getFailRetryCount() == 0) {
                                                if (!e.isAbortOnFail()) continue;
                                                throw new ManifoldCFException("Repeated service interruptions - failure expiring document" + (e.getCause() != null ? ": " + e.getCause().getMessage() : ""), e.getCause());
                                            }
                                            jobManager.resetDocument(dd, e.getRetryTime(), 1, e.getFailTime(), e.getFailRetryCount());
                                            cqd.setProcessed();
                                        }
                                    }
                                    k = 0;
                                    while (true) {
                                        if (k >= arrayDocHashes.size()) continue block23;
                                        if (deleteFromQueue[k]) {
                                            CleanupQueuedDocument dqd = (CleanupQueuedDocument)arrayDocsToDelete.get(k);
                                            DocumentDescription ddd = dqd.getDocumentDescription();
                                            Long jobID = ddd.getJobID();
                                            int hopcountMethod = (Integer)hopcountMethods.get(k);
                                            String[] legalLinkTypes = (String[])arrayRelationshipTypes.get(k);
                                            DocumentDescription[] requeueCandidates = jobManager.markDocumentDeleted(jobID, legalLinkTypes, ddd, hopcountMethod);
                                            ManifoldCF.requeueDocumentsDueToCarrydown(jobManager, requeueCandidates, connector, connection, this.queueTracker, currentTime);
                                            dqd.setProcessed();
                                        }
                                        ++k;
                                    }
                                }
                                finally {
                                    RepositoryConnectorFactory.release(connector);
                                    continue;
                                }
                            }
                            catch (ManifoldCFException e) {
                                if (e.getErrorCode() == 5) {
                                    Logging.threads.warn((Object)("Expire thread couldn't establish necessary connections, retrying later: " + e.getMessage()), (Throwable)e);
                                    continue;
                                }
                                throw e;
                            }
                        }
                        catch (ManifoldCFException e) {
                            if (e.getErrorCode() == 2) {
                            }
                            if (e.getErrorCode() == 4) {
                                throw e;
                            }
                            if (jobManager.errorAbort(dds.getJobDescription().getID(), e.getMessage())) {
                                Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                            }
                        }
                        break;
                    }
                    finally {
                        for (int j = 0; j < dds.getCount(); ++j) {
                            CleanupQueuedDocument dqd = dds.getDocument(j);
                            if (dqd.wasProcessed()) continue;
                            DocumentDescription ddd = dqd.getDocumentDescription();
                            jobManager.resetDocument(ddd, 0L, 1, -1L, -1);
                            dqd.setProcessed();
                        }
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        this.documentQueue.reset();
                        Logging.threads.error((Object)("Expiration thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("ExpirationThread " + this.id + " initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }

    protected static class OutputRemoveActivity
    implements IOutputRemoveActivity {
        protected String connectionName;
        protected IRepositoryConnectionManager connMgr;
        protected String outputConnectionName;

        public OutputRemoveActivity(String connectionName, IRepositoryConnectionManager connMgr, String outputConnectionName) {
            this.connectionName = connectionName;
            this.connMgr = connMgr;
            this.outputConnectionName = outputConnectionName;
        }

        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityURI, String resultCode, String resultDescription) throws ManifoldCFException {
            this.connMgr.recordHistory(this.connectionName, startTime, ManifoldCF.qualifyOutputActivityName(activityType, this.outputConnectionName), dataSize, entityURI, resultCode, resultDescription, null);
        }
    }
}

