/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class JobResetThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: JobResetThread.java 991295 2010-08-31 19:12:14Z kwright $";
    protected QueueTracker queueTracker;

    public JobResetThread(QueueTracker queueTracker) throws ManifoldCFException {
        this.setName("Job reset thread");
        this.setDaemon(true);
        this.queueTracker = queueTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(threadContext);
            while (true) {
                try {
                    while (true) {
                        long currentTime = System.currentTimeMillis();
                        ArrayList jobAborts = new ArrayList();
                        jobManager.finishJobAborts(currentTime, jobAborts);
                        int k = 0;
                        while (k < jobAborts.size()) {
                            IJobDescription desc = (IJobDescription)jobAborts.get(k++);
                            connectionManager.recordHistory(desc.getConnectionName(), null, "job abort", null, desc.getID().toString() + "(" + desc.getDescription() + ")", null, null, null);
                        }
                        ArrayList jobCompletions = new ArrayList();
                        jobManager.resetJobs(currentTime, jobCompletions);
                        k = 0;
                        while (k < jobCompletions.size()) {
                            IJobDescription desc = (IJobDescription)jobCompletions.get(k++);
                            connectionManager.recordHistory(desc.getConnectionName(), null, "job end", null, desc.getID().toString() + "(" + desc.getDescription() + ")", null, null, null);
                        }
                        if (jobAborts.size() > 0) {
                            Logging.threads.debug((Object)"Job reset thread reprioritizing documents...");
                            this.queueTracker.beginReset();
                            try {
                                HashMap connectionMap = new HashMap();
                                HashMap jobDescriptionMap = new HashMap();
                                while (true) {
                                    long startTime = System.currentTimeMillis();
                                    DocumentDescription[] docs = jobManager.getNextNotYetProcessedReprioritizationDocuments(currentTime, 10000);
                                    if (docs.length == 0) {
                                        break;
                                    }
                                    ManifoldCF.writeDocumentPriorities(threadContext, connectionManager, jobManager, docs, connectionMap, jobDescriptionMap, this.queueTracker, currentTime);
                                    Logging.threads.debug((Object)("Reprioritized " + Integer.toString(docs.length) + " not-yet-processed documents in " + new Long(System.currentTimeMillis() - startTime) + " ms"));
                                }
                            }
                            finally {
                                this.queueTracker.endReset();
                            }
                            Logging.threads.debug((Object)"Job reset thread done reprioritizing documents.");
                        }
                        ManifoldCF.sleep((long)10000L);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        Logging.threads.error((Object)("Job reset thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("JobResetThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }
}

