/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnector;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputSpecification;
import org.apache.manifoldcf.agents.outputconnection.OutputConnection;
import org.apache.manifoldcf.authorities.authority.AuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnector;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorManager;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.BlockingDocuments;
import org.apache.manifoldcf.crawler.interfaces.ConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.EnumeratedValues;
import org.apache.manifoldcf.crawler.interfaces.IConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.JobStatus;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorFactory;
import org.apache.manifoldcf.crawler.interfaces.ScheduleRecord;
import org.apache.manifoldcf.crawler.jobs.JobDescription;
import org.apache.manifoldcf.crawler.repository.RepositoryConnection;
import org.apache.manifoldcf.crawler.system.DocCleanupResetManager;
import org.apache.manifoldcf.crawler.system.DocDeleteResetManager;
import org.apache.manifoldcf.crawler.system.DocumentCleanupQueue;
import org.apache.manifoldcf.crawler.system.DocumentCleanupStufferThread;
import org.apache.manifoldcf.crawler.system.DocumentCleanupThread;
import org.apache.manifoldcf.crawler.system.DocumentDeleteQueue;
import org.apache.manifoldcf.crawler.system.DocumentDeleteStufferThread;
import org.apache.manifoldcf.crawler.system.DocumentDeleteThread;
import org.apache.manifoldcf.crawler.system.DocumentQueue;
import org.apache.manifoldcf.crawler.system.ExpireStufferThread;
import org.apache.manifoldcf.crawler.system.ExpireThread;
import org.apache.manifoldcf.crawler.system.FinisherThread;
import org.apache.manifoldcf.crawler.system.IdleCleanupThread;
import org.apache.manifoldcf.crawler.system.JobDeleteThread;
import org.apache.manifoldcf.crawler.system.JobNotificationThread;
import org.apache.manifoldcf.crawler.system.JobResetThread;
import org.apache.manifoldcf.crawler.system.JobStartThread;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.SeedingThread;
import org.apache.manifoldcf.crawler.system.SetPriorityThread;
import org.apache.manifoldcf.crawler.system.StartDeleteThread;
import org.apache.manifoldcf.crawler.system.StartupThread;
import org.apache.manifoldcf.crawler.system.StufferThread;
import org.apache.manifoldcf.crawler.system.WorkerResetManager;
import org.apache.manifoldcf.crawler.system.WorkerThread;

public class ManifoldCF
extends org.apache.manifoldcf.agents.system.ManifoldCF {
    public static final String _rcsid = "@(#)$Id: ManifoldCF.java 996524 2010-09-13 13:38:01Z kwright $";
    protected static boolean crawlerInitialized = false;
    protected static InitializationThread initializationThread = null;
    protected static JobStartThread jobStartThread = null;
    protected static StufferThread stufferThread = null;
    protected static FinisherThread finisherThread = null;
    protected static JobNotificationThread notificationThread = null;
    protected static StartupThread startupThread = null;
    protected static StartDeleteThread startDeleteThread = null;
    protected static JobDeleteThread jobDeleteThread = null;
    protected static WorkerThread[] workerThreads = null;
    protected static ExpireStufferThread expireStufferThread = null;
    protected static ExpireThread[] expireThreads = null;
    protected static DocumentDeleteStufferThread deleteStufferThread = null;
    protected static DocumentDeleteThread[] deleteThreads = null;
    protected static DocumentCleanupStufferThread cleanupStufferThread = null;
    protected static DocumentCleanupThread[] cleanupThreads = null;
    protected static JobResetThread jobResetThread = null;
    protected static SeedingThread seedingThread = null;
    protected static IdleCleanupThread idleCleanupThread = null;
    protected static SetPriorityThread setPriorityThread = null;
    protected static WorkerResetManager workerResetManager = null;
    protected static DocDeleteResetManager docDeleteResetManager = null;
    protected static DocCleanupResetManager docCleanupResetManager = null;
    protected static int numWorkerThreads = 0;
    protected static int numDeleteThreads = 0;
    protected static int numCleanupThreads = 0;
    protected static int numExpireThreads = 0;
    protected static float lowWaterFactor = 5.0f;
    protected static float stuffAmtFactor = 0.5f;
    protected static final String workerThreadCountProperty = "org.apache.manifoldcf.crawler.threads";
    protected static final String deleteThreadCountProperty = "org.apache.manifoldcf.crawler.deletethreads";
    protected static final String cleanupThreadCountProperty = "org.apache.manifoldcf.crawler.cleanupthreads";
    protected static final String expireThreadCountProperty = "org.apache.manifoldcf.crawler.expirethreads";
    protected static final String lowWaterFactorProperty = "org.apache.manifoldcf.crawler.lowwaterfactor";
    protected static final String stuffAmtFactorProperty = "org.apache.manifoldcf.crawler.stuffamountfactor";
    protected static Integer startupLock = new Integer(0);
    protected static final String API_JOBNODE = "job";
    protected static final String API_JOBSTATUSNODE = "jobstatus";
    protected static final String API_REPOSITORYCONNECTORNODE = "repositoryconnector";
    protected static final String API_OUTPUTCONNECTORNODE = "outputconnector";
    protected static final String API_AUTHORITYCONNECTORNODE = "authorityconnector";
    protected static final String API_REPOSITORYCONNECTIONNODE = "repositoryconnection";
    protected static final String API_OUTPUTCONNECTIONNODE = "outputconnection";
    protected static final String API_AUTHORITYCONNECTIONNODE = "authorityconnection";
    protected static final String API_CHECKRESULTNODE = "check_result";
    protected static final String API_JOBIDNODE = "job_id";
    protected static final String API_CONNECTIONNAMENODE = "connection_name";
    protected static final String CONNECTORNODE_DESCRIPTION = "description";
    protected static final String CONNECTORNODE_CLASSNAME = "class_name";
    public static final int WRITERESULT_NOTFOUND = 0;
    public static final int WRITERESULT_FOUND = 1;
    public static final int WRITERESULT_CREATED = 2;
    protected static final String JOBNODE_ID = "id";
    protected static final String JOBNODE_DESCRIPTION = "description";
    protected static final String JOBNODE_CONNECTIONNAME = "repository_connection";
    protected static final String JOBNODE_OUTPUTNAME = "output_connection";
    protected static final String JOBNODE_DOCUMENTSPECIFICATION = "document_specification";
    protected static final String JOBNODE_OUTPUTSPECIFICATION = "output_specification";
    protected static final String JOBNODE_STARTMODE = "start_mode";
    protected static final String JOBNODE_RUNMODE = "run_mode";
    protected static final String JOBNODE_HOPCOUNTMODE = "hopcount_mode";
    protected static final String JOBNODE_PRIORITY = "priority";
    protected static final String JOBNODE_RECRAWLINTERVAL = "recrawl_interval";
    protected static final String JOBNODE_EXPIRATIONINTERVAL = "expiration_interval";
    protected static final String JOBNODE_RESEEDINTERVAL = "reseed_interval";
    protected static final String JOBNODE_HOPCOUNT = "hopcount";
    protected static final String JOBNODE_SCHEDULE = "schedule";
    protected static final String JOBNODE_LINKTYPE = "link_type";
    protected static final String JOBNODE_COUNT = "count";
    protected static final String JOBNODE_TIMEZONE = "timezone";
    protected static final String JOBNODE_DURATION = "duration";
    protected static final String JOBNODE_DAYOFWEEK = "dayofweek";
    protected static final String JOBNODE_MONTHOFYEAR = "monthofyear";
    protected static final String JOBNODE_DAYOFMONTH = "dayofmonth";
    protected static final String JOBNODE_YEAR = "year";
    protected static final String JOBNODE_HOUROFDAY = "hourofday";
    protected static final String JOBNODE_MINUTESOFHOUR = "minutesofhour";
    protected static final String JOBNODE_ENUMVALUE = "value";
    protected static final String JOBSTATUSNODE_JOBID = "job_id";
    protected static final String JOBSTATUSNODE_STATUS = "status";
    protected static final String JOBSTATUSNODE_ERRORTEXT = "errortext";
    protected static final String JOBSTATUSNODE_STARTTIME = "start_time";
    protected static final String JOBSTATUSNODE_ENDTIME = "end_time";
    protected static final String JOBSTATUSNODE_DOCUMENTSINQUEUE = "documents_in_queue";
    protected static final String JOBSTATUSNODE_DOCUMENTSOUTSTANDING = "documents_outstanding";
    protected static final String JOBSTATUSNODE_DOCUMENTSPROCESSED = "documents_processed";
    protected static final String CONNECTIONNODE_ISNEW = "isnew";
    protected static final String CONNECTIONNODE_NAME = "name";
    protected static final String CONNECTIONNODE_CLASSNAME = "class_name";
    protected static final String CONNECTIONNODE_MAXCONNECTIONS = "max_connections";
    protected static final String CONNECTIONNODE_DESCRIPTION = "description";
    protected static final String CONNECTIONNODE_CONFIGURATION = "configuration";
    protected static final String CONNECTIONNODE_ACLAUTHORITY = "acl_authority";
    protected static final String CONNECTIONNODE_THROTTLE = "throttle";
    protected static final String CONNECTIONNODE_MATCH = "match";
    protected static final String CONNECTIONNODE_MATCHDESCRIPTION = "match_description";
    protected static final String CONNECTIONNODE_RATE = "rate";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeEnvironment() throws ManifoldCFException {
        Integer n = initializeFlagLock;
        synchronized (n) {
            org.apache.manifoldcf.authorities.system.ManifoldCF.initializeEnvironment();
            if (crawlerInitialized) {
                return;
            }
            org.apache.manifoldcf.agents.system.ManifoldCF.initializeEnvironment();
            Logging.initializeLoggers();
            Logging.setLogLevels();
            crawlerInitialized = true;
        }
    }

    public static void installSystemTables(IThreadContext threadcontext) throws ManifoldCFException {
        IConnectorManager repConnMgr = ConnectorManagerFactory.make(threadcontext);
        IRepositoryConnectionManager repCon = RepositoryConnectionManagerFactory.make(threadcontext);
        IJobManager jobManager = JobManagerFactory.make(threadcontext);
        org.apache.manifoldcf.authorities.system.ManifoldCF.installSystemTables(threadcontext);
        repConnMgr.install();
        repCon.install();
        jobManager.install();
    }

    public static void deinstallSystemTables(IThreadContext threadcontext) throws ManifoldCFException {
        Object se = null;
        IConnectorManager repConnMgr = ConnectorManagerFactory.make(threadcontext);
        IRepositoryConnectionManager repCon = RepositoryConnectionManagerFactory.make(threadcontext);
        IJobManager jobManager = JobManagerFactory.make(threadcontext);
        jobManager.deinstall();
        repCon.deinstall();
        repConnMgr.deinstall();
        org.apache.manifoldcf.authorities.system.ManifoldCF.deinstallSystemTables(threadcontext);
        if (se != null) {
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSystem(IThreadContext threadContext) throws ManifoldCFException {
        Logging.root.info((Object)"Starting up pull-agent...");
        Integer n = startupLock;
        synchronized (n) {
            int i;
            String maxExpireThreads;
            String maxCleanupThreads;
            String maxThreads = ManifoldCF.getProperty((String)workerThreadCountProperty);
            if (maxThreads == null) {
                maxThreads = "100";
            }
            if ((numWorkerThreads = new Integer(maxThreads).intValue()) < 1 || numWorkerThreads > 300) {
                throw new ManifoldCFException("Illegal value for the number of worker threads");
            }
            String maxDeleteThreads = ManifoldCF.getProperty((String)deleteThreadCountProperty);
            if (maxDeleteThreads == null) {
                maxDeleteThreads = "10";
            }
            if ((maxCleanupThreads = ManifoldCF.getProperty((String)cleanupThreadCountProperty)) == null) {
                maxCleanupThreads = "10";
            }
            if ((maxExpireThreads = ManifoldCF.getProperty((String)expireThreadCountProperty)) == null) {
                maxExpireThreads = "10";
            }
            if ((numDeleteThreads = new Integer(maxDeleteThreads).intValue()) < 1 || numDeleteThreads > 300) {
                throw new ManifoldCFException("Illegal value for the number of delete threads");
            }
            numCleanupThreads = new Integer(maxCleanupThreads);
            if (numCleanupThreads < 1 || numCleanupThreads > 300) {
                throw new ManifoldCFException("Illegal value for the number of cleanup threads");
            }
            numExpireThreads = new Integer(maxExpireThreads);
            if (numExpireThreads < 1 || numExpireThreads > 300) {
                throw new ManifoldCFException("Illegal value for the number of expire threads");
            }
            String lowWaterFactorString = ManifoldCF.getProperty((String)lowWaterFactorProperty);
            if (lowWaterFactorString == null) {
                lowWaterFactorString = "5";
            }
            if ((double)(lowWaterFactor = new Float(lowWaterFactorString).floatValue()) < 1.0 || (double)lowWaterFactor > 1000.0) {
                throw new ManifoldCFException("Illegal value for the low water factor");
            }
            String stuffAmtFactorString = ManifoldCF.getProperty((String)stuffAmtFactorProperty);
            if (stuffAmtFactorString == null) {
                stuffAmtFactorString = "2";
            }
            if ((double)(stuffAmtFactor = new Float(stuffAmtFactorString).floatValue()) < 0.1 || (double)stuffAmtFactor > 1000.0) {
                throw new ManifoldCFException("Illegal value for the stuffing amount factor");
            }
            QueueTracker queueTracker = new QueueTracker();
            DocumentQueue documentQueue = new DocumentQueue();
            DocumentDeleteQueue documentDeleteQueue = new DocumentDeleteQueue();
            DocumentCleanupQueue documentCleanupQueue = new DocumentCleanupQueue();
            DocumentCleanupQueue expireQueue = new DocumentCleanupQueue();
            BlockingDocuments blockingDocuments = new BlockingDocuments();
            workerResetManager = new WorkerResetManager(documentQueue, expireQueue);
            docDeleteResetManager = new DocDeleteResetManager(documentDeleteQueue);
            docCleanupResetManager = new DocCleanupResetManager(documentCleanupQueue);
            jobStartThread = new JobStartThread();
            startupThread = new StartupThread(queueTracker);
            startDeleteThread = new StartDeleteThread();
            finisherThread = new FinisherThread();
            notificationThread = new JobNotificationThread();
            jobDeleteThread = new JobDeleteThread();
            stufferThread = new StufferThread(documentQueue, numWorkerThreads, workerResetManager, queueTracker, blockingDocuments, lowWaterFactor, stuffAmtFactor);
            expireStufferThread = new ExpireStufferThread(expireQueue, numExpireThreads, workerResetManager);
            setPriorityThread = new SetPriorityThread(queueTracker, numWorkerThreads, blockingDocuments);
            workerThreads = new WorkerThread[numWorkerThreads];
            for (i = 0; i < numWorkerThreads; ++i) {
                ManifoldCF.workerThreads[i] = new WorkerThread(Integer.toString(i), documentQueue, workerResetManager, queueTracker);
            }
            expireThreads = new ExpireThread[numExpireThreads];
            for (i = 0; i < numExpireThreads; ++i) {
                ManifoldCF.expireThreads[i] = new ExpireThread(Integer.toString(i), expireQueue, queueTracker, workerResetManager);
            }
            deleteStufferThread = new DocumentDeleteStufferThread(documentDeleteQueue, numDeleteThreads, docDeleteResetManager);
            deleteThreads = new DocumentDeleteThread[numDeleteThreads];
            for (i = 0; i < numDeleteThreads; ++i) {
                ManifoldCF.deleteThreads[i] = new DocumentDeleteThread(Integer.toString(i), documentDeleteQueue, docDeleteResetManager);
            }
            cleanupStufferThread = new DocumentCleanupStufferThread(documentCleanupQueue, numCleanupThreads, docCleanupResetManager);
            cleanupThreads = new DocumentCleanupThread[numCleanupThreads];
            for (i = 0; i < numCleanupThreads; ++i) {
                ManifoldCF.cleanupThreads[i] = new DocumentCleanupThread(Integer.toString(i), documentCleanupQueue, queueTracker, docCleanupResetManager);
            }
            jobResetThread = new JobResetThread(queueTracker);
            seedingThread = new SeedingThread(queueTracker);
            idleCleanupThread = new IdleCleanupThread();
            initializationThread = new InitializationThread(queueTracker);
            initializationThread.start();
        }
        Logging.root.info((Object)"Pull-agent started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopSystem(IThreadContext threadContext) throws ManifoldCFException {
        Logging.root.info((Object)"Shutting down pull-agent...");
        Integer n = startupLock;
        synchronized (n) {
            while (initializationThread != null || jobDeleteThread != null || startupThread != null || startDeleteThread != null || jobStartThread != null || stufferThread != null || finisherThread != null || notificationThread != null || workerThreads != null || expireStufferThread != null || expireThreads != null || deleteStufferThread != null || deleteThreads != null || cleanupStufferThread != null || cleanupThreads != null || jobResetThread != null || seedingThread != null || idleCleanupThread != null || setPriorityThread != null) {
                int i;
                if (initializationThread != null) {
                    initializationThread.interrupt();
                }
                if (setPriorityThread != null) {
                    setPriorityThread.interrupt();
                }
                if (jobStartThread != null) {
                    jobStartThread.interrupt();
                }
                if (jobDeleteThread != null) {
                    jobDeleteThread.interrupt();
                }
                if (startupThread != null) {
                    startupThread.interrupt();
                }
                if (startDeleteThread != null) {
                    startDeleteThread.interrupt();
                }
                if (stufferThread != null) {
                    stufferThread.interrupt();
                }
                if (expireStufferThread != null) {
                    expireStufferThread.interrupt();
                }
                if (finisherThread != null) {
                    finisherThread.interrupt();
                }
                if (notificationThread != null) {
                    notificationThread.interrupt();
                }
                if (workerThreads != null) {
                    i = 0;
                    while (i < workerThreads.length) {
                        WorkerThread workerThread;
                        if ((workerThread = workerThreads[i++]) == null) continue;
                        workerThread.interrupt();
                    }
                }
                if (expireThreads != null) {
                    i = 0;
                    while (i < expireThreads.length) {
                        ExpireThread expireThread;
                        if ((expireThread = expireThreads[i++]) == null) continue;
                        expireThread.interrupt();
                    }
                }
                if (cleanupStufferThread != null) {
                    cleanupStufferThread.interrupt();
                }
                if (cleanupThreads != null) {
                    i = 0;
                    while (i < cleanupThreads.length) {
                        DocumentCleanupThread cleanupThread;
                        if ((cleanupThread = cleanupThreads[i++]) == null) continue;
                        cleanupThread.interrupt();
                    }
                }
                if (deleteStufferThread != null) {
                    deleteStufferThread.interrupt();
                }
                if (deleteThreads != null) {
                    i = 0;
                    while (i < deleteThreads.length) {
                        DocumentDeleteThread deleteThread;
                        if ((deleteThread = deleteThreads[i++]) == null) continue;
                        deleteThread.interrupt();
                    }
                }
                if (jobResetThread != null) {
                    jobResetThread.interrupt();
                }
                if (seedingThread != null) {
                    seedingThread.interrupt();
                }
                if (idleCleanupThread != null) {
                    idleCleanupThread.interrupt();
                }
                try {
                    ManifoldCF.sleep((long)1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (initializationThread != null && !initializationThread.isAlive()) {
                    initializationThread = null;
                }
                if (setPriorityThread != null && !setPriorityThread.isAlive()) {
                    setPriorityThread = null;
                }
                if (jobDeleteThread != null && !jobDeleteThread.isAlive()) {
                    jobDeleteThread = null;
                }
                if (startupThread != null && !startupThread.isAlive()) {
                    startupThread = null;
                }
                if (startDeleteThread != null && !startDeleteThread.isAlive()) {
                    startDeleteThread = null;
                }
                if (jobStartThread != null && !jobStartThread.isAlive()) {
                    jobStartThread = null;
                }
                if (stufferThread != null && !stufferThread.isAlive()) {
                    stufferThread = null;
                }
                if (expireStufferThread != null && !expireStufferThread.isAlive()) {
                    expireStufferThread = null;
                }
                if (finisherThread != null && !finisherThread.isAlive()) {
                    finisherThread = null;
                }
                if (notificationThread != null && !notificationThread.isAlive()) {
                    notificationThread = null;
                }
                if (workerThreads != null) {
                    boolean isAlive = false;
                    for (int i2 = 0; i2 < workerThreads.length; ++i2) {
                        WorkerThread workerThread = workerThreads[i2];
                        if (workerThread == null) continue;
                        if (!workerThread.isAlive()) {
                            ManifoldCF.workerThreads[i2] = null;
                            continue;
                        }
                        isAlive = true;
                    }
                    if (!isAlive) {
                        workerThreads = null;
                    }
                }
                if (expireThreads != null) {
                    boolean isAlive = false;
                    for (int i3 = 0; i3 < expireThreads.length; ++i3) {
                        ExpireThread expireThread = expireThreads[i3];
                        if (expireThread == null) continue;
                        if (!expireThread.isAlive()) {
                            ManifoldCF.expireThreads[i3] = null;
                            continue;
                        }
                        isAlive = true;
                    }
                    if (!isAlive) {
                        expireThreads = null;
                    }
                }
                if (cleanupStufferThread != null && !cleanupStufferThread.isAlive()) {
                    cleanupStufferThread = null;
                }
                if (cleanupThreads != null) {
                    boolean isAlive = false;
                    for (int i4 = 0; i4 < cleanupThreads.length; ++i4) {
                        DocumentCleanupThread cleanupThread = cleanupThreads[i4];
                        if (cleanupThread == null) continue;
                        if (!cleanupThread.isAlive()) {
                            ManifoldCF.cleanupThreads[i4] = null;
                            continue;
                        }
                        isAlive = true;
                    }
                    if (!isAlive) {
                        cleanupThreads = null;
                    }
                }
                if (deleteStufferThread != null && !deleteStufferThread.isAlive()) {
                    deleteStufferThread = null;
                }
                if (deleteThreads != null) {
                    boolean isAlive = false;
                    for (int i5 = 0; i5 < deleteThreads.length; ++i5) {
                        DocumentDeleteThread deleteThread = deleteThreads[i5];
                        if (deleteThread == null) continue;
                        if (!deleteThread.isAlive()) {
                            ManifoldCF.deleteThreads[i5] = null;
                            continue;
                        }
                        isAlive = true;
                    }
                    if (!isAlive) {
                        deleteThreads = null;
                    }
                }
                if (jobResetThread != null && !jobResetThread.isAlive()) {
                    jobResetThread = null;
                }
                if (seedingThread != null && !seedingThread.isAlive()) {
                    seedingThread = null;
                }
                if (idleCleanupThread == null || idleCleanupThread.isAlive()) continue;
                idleCleanupThread = null;
            }
            RepositoryConnectorFactory.closeAllConnectors(threadContext);
            numWorkerThreads = 0;
            numDeleteThreads = 0;
            numExpireThreads = 0;
        }
        Logging.root.info((Object)"Pull-agent successfully shut down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportConfiguration(IThreadContext threadContext, String exportFilename) throws ManifoldCFException {
        IDBInterface database = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        IOutputConnectionManager outputManager = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
        IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make(threadContext);
        IAuthorityConnectionManager authManager = AuthorityConnectionManagerFactory.make(threadContext);
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        File outputFile = new File(exportFilename);
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            try {
                ZipOutputStream zos = new ZipOutputStream(os);
                try {
                    database.beginTransaction();
                    try {
                        ZipEntry outputEntry = new ZipEntry("outputs");
                        zos.putNextEntry(outputEntry);
                        outputManager.exportConfiguration((OutputStream)zos);
                        zos.closeEntry();
                        ZipEntry authEntry = new ZipEntry("authorities");
                        zos.putNextEntry(authEntry);
                        authManager.exportConfiguration(zos);
                        zos.closeEntry();
                        ZipEntry connEntry = new ZipEntry("connections");
                        zos.putNextEntry(connEntry);
                        connManager.exportConfiguration(zos);
                        zos.closeEntry();
                        ZipEntry jobsEntry = new ZipEntry("jobs");
                        zos.putNextEntry(jobsEntry);
                        jobManager.exportConfiguration(zos);
                        zos.closeEntry();
                    }
                    catch (ManifoldCFException e) {
                        database.signalRollback();
                        throw e;
                    }
                    catch (Error e) {
                        database.signalRollback();
                        throw e;
                    }
                    finally {
                        database.endTransaction();
                    }
                }
                finally {
                    zos.close();
                }
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            outputFile.delete();
            throw new ManifoldCFException("Error creating configuration file: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importConfiguration(IThreadContext threadContext, String importFilename) throws ManifoldCFException {
        IDBInterface database = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        IOutputConnectionManager outputManager = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
        IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make(threadContext);
        IAuthorityConnectionManager authManager = AuthorityConnectionManagerFactory.make(threadContext);
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        File inputFile = new File(importFilename);
        try {
            FileInputStream is = new FileInputStream(inputFile);
            try {
                ZipInputStream zis = new ZipInputStream(is);
                try {
                    database.beginTransaction();
                    try {
                        ZipEntry z;
                        while ((z = zis.getNextEntry()) != null) {
                            String name = z.getName();
                            if (name.equals("outputs")) {
                                outputManager.importConfiguration((InputStream)zis);
                            } else if (name.equals("authorities")) {
                                authManager.importConfiguration(zis);
                            } else if (name.equals("connections")) {
                                connManager.importConfiguration(zis);
                            } else if (name.equals("jobs")) {
                                jobManager.importConfiguration(zis);
                            } else {
                                throw new ManifoldCFException("Configuration file has an entry named '" + name + "' that I do not recognize");
                            }
                            zis.closeEntry();
                        }
                    }
                    catch (ManifoldCFException e) {
                        database.signalRollback();
                        throw e;
                    }
                    catch (Error e) {
                        database.signalRollback();
                        throw e;
                    }
                    finally {
                        database.endTransaction();
                    }
                }
                finally {
                    zis.close();
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            throw new ManifoldCFException("Error reading configuration file: " + e.getMessage(), (Throwable)e);
        }
    }

    public static int getMaxWorkerThreads() {
        return numWorkerThreads;
    }

    public static int getMaxDeleteThreads() {
        return numDeleteThreads;
    }

    public static int getMaxExpireThreads() {
        return numExpireThreads;
    }

    public static void requeueDocumentsDueToCarrydown(IJobManager jobManager, DocumentDescription[] requeueCandidates, IRepositoryConnector connector, IRepositoryConnection connection, QueueTracker queueTracker, long currentTime) throws ManifoldCFException {
        String[] bins;
        int q;
        double[] docPriorities = new double[requeueCandidates.length];
        String[][] binNames = new String[requeueCandidates.length][];
        for (q = 0; q < requeueCandidates.length; ++q) {
            DocumentDescription dd = requeueCandidates[q];
            bins = ManifoldCF.calculateBins(connector, dd.getDocumentIdentifier());
            binNames[q] = bins;
            docPriorities[q] = queueTracker.calculatePriority(bins, connection);
            if (!Logging.scheduling.isDebugEnabled()) continue;
            Logging.scheduling.debug((Object)("Document '" + dd.getDocumentIdentifier() + " given priority " + new Double(docPriorities[q]).toString()));
        }
        boolean[] trackerNote = jobManager.carrydownChangeDocumentMultiple(requeueCandidates, currentTime, docPriorities);
        for (q = 0; q < trackerNote.length; ++q) {
            if (trackerNote[q]) continue;
            bins = binNames[q];
            queueTracker.notePriorityNotUsed(bins, connection, docPriorities[q]);
        }
    }

    public static String colonStuff(String input) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) == ':' || x == '\\') {
                sb.append('\\');
            }
            sb.append(x);
        }
        return sb.toString();
    }

    public static String createGlobalString(String simpleString) {
        return ":" + simpleString;
    }

    public static String createConnectionSpecificString(String connectionName, String simpleString) {
        return "C " + ManifoldCF.colonStuff(connectionName) + ":" + simpleString;
    }

    public static String createJobSpecificString(Long jobID, String simpleString) {
        return "J " + jobID.toString() + ":" + simpleString;
    }

    public static String[] calculateBins(IRepositoryConnector connector, String documentIdentifier) {
        return connector.getBinNames(documentIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocumentPriorities(IThreadContext threadContext, IRepositoryConnectionManager mgr, IJobManager jobManager, DocumentDescription[] descs, HashMap connectionMap, HashMap jobDescriptionMap, QueueTracker queueTracker, long currentTime) throws ManifoldCFException {
        if (Logging.scheduling.isDebugEnabled()) {
            Logging.scheduling.debug((Object)("Reprioritizing " + Integer.toString(descs.length) + " documents"));
        }
        double[] priorities = new double[descs.length];
        for (int i = 0; i < descs.length; ++i) {
            String[] binNames;
            String connectionName;
            IRepositoryConnection connection;
            DocumentDescription dd = descs[i];
            IJobDescription job = (IJobDescription)jobDescriptionMap.get(dd.getJobID());
            if (job == null) {
                job = jobManager.load(dd.getJobID(), true);
                jobDescriptionMap.put(dd.getJobID(), job);
            }
            if ((connection = (IRepositoryConnection)connectionMap.get(connectionName = job.getConnectionName())) == null) {
                connection = mgr.load(connectionName);
                connectionMap.put(connectionName, connection);
            }
            try {
                IRepositoryConnector connector = RepositoryConnectorFactory.grab(threadContext, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
                try {
                    binNames = connector == null ? new String[]{""} : connector.getBinNames(descs[i].getDocumentIdentifier());
                }
                finally {
                    RepositoryConnectorFactory.release(connector);
                }
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 5) {
                    binNames = new String[]{""};
                }
                throw e;
            }
            priorities[i] = queueTracker.calculatePriority(binNames, connection);
            if (!Logging.scheduling.isDebugEnabled()) continue;
            Logging.scheduling.debug((Object)("Document '" + dd.getDocumentIdentifier() + "' given priority " + new Double(priorities[i]).toString()));
        }
        jobManager.writeDocumentPriorities(currentTime, descs, priorities);
    }

    public static boolean isOutputConnectionInUse(IThreadContext threadContext, String connName) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        return jobManager.checkIfOutputReference(connName);
    }

    public static void noteOutputConnectorDeregistration(IThreadContext threadContext, String[] connectionNames) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.noteOutputConnectorDeregistration(connectionNames);
    }

    public static void noteOutputConnectorRegistration(IThreadContext threadContext, String[] connectionNames) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.noteOutputConnectorRegistration(connectionNames);
    }

    public static void noteOutputConnectionChange(IThreadContext threadContext, String connectionName) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.noteOutputConnectionChange(connectionName);
    }

    public static String qualifyOutputActivityName(String outputActivityName, String outputConnectionName) {
        return outputActivityName + " (" + outputConnectionName + ")";
    }

    public static String decodeAPIPathElement(String startingPathElement) throws ManifoldCFException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < startingPathElement.length()) {
            char x;
            if ((x = startingPathElement.charAt(i++)) == '.') {
                if (i == startingPathElement.length()) {
                    throw new ManifoldCFException("Element decoding failed; illegal '.' character in '" + startingPathElement + "'");
                }
                if ((x = startingPathElement.charAt(i++)) == '.') {
                    sb.append(x);
                    continue;
                }
                if (x == '+') {
                    sb.append('/');
                    continue;
                }
                throw new ManifoldCFException("Element decoding failed; illegal post-'.' character in '" + startingPathElement + "'");
            }
            sb.append(x);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean executeReadCommand(IThreadContext tc, Configuration output, String path) throws ManifoldCFException {
        if (path.equals("jobs")) {
            try {
                IJobManager jobManager = JobManagerFactory.make(tc);
                IJobDescription[] jobs = jobManager.getAllJobs();
                int i = 0;
                while (i < jobs.length) {
                    ConfigurationNode jobNode = new ConfigurationNode(API_JOBNODE);
                    ManifoldCF.formatJobDescription(jobNode, jobs[i++]);
                    output.addChild(output.getChildCount(), jobNode);
                }
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.startsWith("jobs/")) {
            Long jobID = new Long(path.substring("jobs/".length()));
            try {
                IJobManager jobManager = JobManagerFactory.make(tc);
                IJobDescription job = jobManager.load(jobID);
                if (job == null) return false;
                ConfigurationNode jobNode = new ConfigurationNode(API_JOBNODE);
                ManifoldCF.formatJobDescription(jobNode, job);
                output.addChild(output.getChildCount(), jobNode);
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.startsWith("status/")) {
            int firstSeparator = "status/".length();
            int secondSeparator = path.indexOf("/", firstSeparator);
            if (secondSeparator == -1) {
                ConfigurationNode error = new ConfigurationNode("error");
                error.setValue("Need connection name.");
                output.addChild(output.getChildCount(), error);
                return false;
            }
            String connectionType = path.substring(firstSeparator, secondSeparator);
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(secondSeparator + 1));
            if (connectionType.equals("outputconnections")) {
                try {
                    String results;
                    IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
                    IOutputConnection connection = connectionManager.load(connectionName);
                    if (connection == null) {
                        ConfigurationNode error = new ConfigurationNode("error");
                        error.setValue("Connection '" + connectionName + "' does not exist");
                        output.addChild(output.getChildCount(), error);
                        return false;
                    }
                    IOutputConnector connector = OutputConnectorFactory.grab((IThreadContext)tc, (String)connection.getClassName(), (ConfigParams)connection.getConfigParams(), (int)connection.getMaxConnections());
                    try {
                        results = connector.check();
                    }
                    catch (ManifoldCFException e) {
                        results = e.getMessage();
                    }
                    finally {
                        OutputConnectorFactory.release((IOutputConnector)connector);
                    }
                    ConfigurationNode response = new ConfigurationNode(API_CHECKRESULTNODE);
                    response.setValue(results);
                    output.addChild(output.getChildCount(), response);
                    return true;
                }
                catch (ManifoldCFException e) {
                    ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                    return true;
                }
            }
            if (connectionType.equals("authorityconnections")) {
                try {
                    String results;
                    IAuthorityConnectionManager connectionManager = AuthorityConnectionManagerFactory.make(tc);
                    IAuthorityConnection connection = connectionManager.load(connectionName);
                    if (connection == null) {
                        ConfigurationNode error = new ConfigurationNode("error");
                        error.setValue("Connection '" + connectionName + "' does not exist");
                        output.addChild(output.getChildCount(), error);
                        return false;
                    }
                    IAuthorityConnector connector = AuthorityConnectorFactory.grab(tc, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
                    try {
                        results = connector.check();
                    }
                    catch (ManifoldCFException e) {
                        results = e.getMessage();
                    }
                    finally {
                        AuthorityConnectorFactory.release(connector);
                    }
                    ConfigurationNode response = new ConfigurationNode(API_CHECKRESULTNODE);
                    response.setValue(results);
                    output.addChild(output.getChildCount(), response);
                    return true;
                }
                catch (ManifoldCFException e) {
                    ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                    return true;
                }
            }
            if (!connectionType.equals("repositoryconnections")) {
                ConfigurationNode error = new ConfigurationNode("error");
                error.setValue("Unknown connection type '" + connectionType + "'.");
                output.addChild(output.getChildCount(), error);
                return false;
            }
            try {
                String results;
                IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
                IRepositoryConnection connection = connectionManager.load(connectionName);
                if (connection == null) {
                    ConfigurationNode error = new ConfigurationNode("error");
                    error.setValue("Connection '" + connectionName + "' does not exist");
                    output.addChild(output.getChildCount(), error);
                    return false;
                }
                IRepositoryConnector connector = RepositoryConnectorFactory.grab(tc, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
                try {
                    results = connector.check();
                }
                catch (ManifoldCFException e) {
                    results = e.getMessage();
                }
                finally {
                    RepositoryConnectorFactory.release(connector);
                }
                ConfigurationNode response = new ConfigurationNode(API_CHECKRESULTNODE);
                response.setValue(results);
                output.addChild(output.getChildCount(), response);
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.startsWith("info/")) {
            int firstSeparator = "info/".length();
            int secondSeparator = path.indexOf("/", firstSeparator);
            if (secondSeparator == -1) {
                ConfigurationNode error = new ConfigurationNode("error");
                error.setValue("Need connection type and connection name.");
                output.addChild(output.getChildCount(), error);
                return false;
            }
            int thirdSeparator = path.indexOf("/", secondSeparator + 1);
            if (thirdSeparator == -1) {
                ConfigurationNode error = new ConfigurationNode("error");
                error.setValue("Need connection name.");
                output.addChild(output.getChildCount(), error);
                return false;
            }
            String connectionType = path.substring(firstSeparator, secondSeparator);
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(secondSeparator + 1, thirdSeparator));
            String command = path.substring(thirdSeparator + 1);
            if (connectionType.equals("outputconnections")) {
                try {
                    IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
                    IOutputConnection connection = connectionManager.load(connectionName);
                    if (connection == null) {
                        ConfigurationNode error = new ConfigurationNode("error");
                        error.setValue("Connection '" + connectionName + "' does not exist");
                        output.addChild(output.getChildCount(), error);
                        return false;
                    }
                    IOutputConnector connector = OutputConnectorFactory.grab((IThreadContext)tc, (String)connection.getClassName(), (ConfigParams)connection.getConfigParams(), (int)connection.getMaxConnections());
                    try {
                        boolean bl = connector.requestInfo(output, command);
                        return bl;
                    }
                    finally {
                        OutputConnectorFactory.release((IOutputConnector)connector);
                    }
                }
                catch (ManifoldCFException e) {
                    ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                    return true;
                }
            }
            if (!connectionType.equals("repositoryconnections")) {
                ConfigurationNode error = new ConfigurationNode("error");
                error.setValue("Unknown connection type '" + connectionType + "'.");
                output.addChild(output.getChildCount(), error);
                return false;
            }
            try {
                IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
                IRepositoryConnection connection = connectionManager.load(connectionName);
                if (connection == null) {
                    ConfigurationNode error = new ConfigurationNode("error");
                    error.setValue("Connection '" + connectionName + "' does not exist");
                    output.addChild(output.getChildCount(), error);
                    return false;
                }
                IRepositoryConnector connector = RepositoryConnectorFactory.grab(tc, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
                try {
                    boolean bl = connector.requestInfo(output, command);
                    return bl;
                }
                finally {
                    RepositoryConnectorFactory.release(connector);
                }
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.equals("jobstatuses")) {
            try {
                IJobManager jobManager = JobManagerFactory.make(tc);
                JobStatus[] jobStatuses = jobManager.getAllStatus();
                int i = 0;
                while (i < jobStatuses.length) {
                    ConfigurationNode jobStatusNode = new ConfigurationNode(API_JOBSTATUSNODE);
                    ManifoldCF.formatJobStatus(jobStatusNode, jobStatuses[i++]);
                    output.addChild(output.getChildCount(), jobStatusNode);
                }
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.startsWith("jobstatuses/")) {
            String jobID = path.substring("jobstatuses/".length());
            try {
                IJobManager jobManager = JobManagerFactory.make(tc);
                JobStatus status = jobManager.getStatus(new Long(jobID));
                if (status == null) return true;
                ConfigurationNode jobStatusNode = new ConfigurationNode(API_JOBSTATUSNODE);
                ManifoldCF.formatJobStatus(jobStatusNode, status);
                output.addChild(output.getChildCount(), jobStatusNode);
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.equals("outputconnections")) {
            try {
                IOutputConnectionManager connManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
                IOutputConnection[] connections = connManager.getAllConnections();
                int i = 0;
                while (i < connections.length) {
                    ConfigurationNode connectionNode = new ConfigurationNode(API_OUTPUTCONNECTIONNODE);
                    ManifoldCF.formatOutputConnection(connectionNode, connections[i++]);
                    output.addChild(output.getChildCount(), connectionNode);
                }
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.startsWith("outputconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("outputconnections/".length()));
            try {
                IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
                IOutputConnection connection = connectionManager.load(connectionName);
                if (connection == null) return false;
                ConfigurationNode connectionNode = new ConfigurationNode(API_OUTPUTCONNECTIONNODE);
                ManifoldCF.formatOutputConnection(connectionNode, connection);
                output.addChild(output.getChildCount(), connectionNode);
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.equals("authorityconnections")) {
            try {
                IAuthorityConnectionManager connManager = AuthorityConnectionManagerFactory.make(tc);
                IAuthorityConnection[] connections = connManager.getAllConnections();
                int i = 0;
                while (i < connections.length) {
                    ConfigurationNode connectionNode = new ConfigurationNode(API_AUTHORITYCONNECTIONNODE);
                    ManifoldCF.formatAuthorityConnection(connectionNode, connections[i++]);
                    output.addChild(output.getChildCount(), connectionNode);
                }
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.startsWith("authorityconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("authorityconnections/".length()));
            try {
                IAuthorityConnectionManager connectionManager = AuthorityConnectionManagerFactory.make(tc);
                IAuthorityConnection connection = connectionManager.load(connectionName);
                if (connection == null) return false;
                ConfigurationNode connectionNode = new ConfigurationNode(API_AUTHORITYCONNECTIONNODE);
                ManifoldCF.formatAuthorityConnection(connectionNode, connection);
                output.addChild(output.getChildCount(), connectionNode);
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.equals("repositoryconnections")) {
            try {
                IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make(tc);
                IRepositoryConnection[] connections = connManager.getAllConnections();
                int i = 0;
                while (i < connections.length) {
                    ConfigurationNode connectionNode = new ConfigurationNode(API_REPOSITORYCONNECTIONNODE);
                    ManifoldCF.formatRepositoryConnection(connectionNode, connections[i++]);
                    output.addChild(output.getChildCount(), connectionNode);
                }
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.startsWith("repositoryconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("repositoryconnections/".length()));
            try {
                IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
                IRepositoryConnection connection = connectionManager.load(connectionName);
                if (connection == null) return false;
                ConfigurationNode connectionNode = new ConfigurationNode(API_REPOSITORYCONNECTIONNODE);
                ManifoldCF.formatRepositoryConnection(connectionNode, connection);
                output.addChild(output.getChildCount(), connectionNode);
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.equals("outputconnectors")) {
            try {
                IOutputConnectorManager manager = OutputConnectorManagerFactory.make((IThreadContext)tc);
                IResultSet resultSet = manager.getConnectors();
                int j = 0;
                while (j < resultSet.getRowCount()) {
                    ConfigurationNode node;
                    IResultRow row = resultSet.getRow(j++);
                    ConfigurationNode child = new ConfigurationNode(API_OUTPUTCONNECTORNODE);
                    String description = (String)row.getValue("description");
                    String className = (String)row.getValue("classname");
                    if (description != null) {
                        node = new ConfigurationNode("description");
                        node.setValue(description);
                        child.addChild(child.getChildCount(), node);
                    }
                    node = new ConfigurationNode("class_name");
                    node.setValue(className);
                    child.addChild(child.getChildCount(), node);
                    output.addChild(output.getChildCount(), child);
                }
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (path.equals("authorityconnectors")) {
            try {
                IAuthorityConnectorManager manager = AuthorityConnectorManagerFactory.make(tc);
                IResultSet resultSet = manager.getConnectors();
                int j = 0;
                while (j < resultSet.getRowCount()) {
                    ConfigurationNode node;
                    IResultRow row = resultSet.getRow(j++);
                    ConfigurationNode child = new ConfigurationNode(API_AUTHORITYCONNECTORNODE);
                    String description = (String)row.getValue("description");
                    String className = (String)row.getValue("classname");
                    if (description != null) {
                        node = new ConfigurationNode("description");
                        node.setValue(description);
                        child.addChild(child.getChildCount(), node);
                    }
                    node = new ConfigurationNode("class_name");
                    node.setValue(className);
                    child.addChild(child.getChildCount(), node);
                    output.addChild(output.getChildCount(), child);
                }
                return true;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return true;
            }
        }
        if (!path.equals("repositoryconnectors")) {
            ConfigurationNode error = new ConfigurationNode("error");
            error.setValue("Unrecognized resource.");
            output.addChild(output.getChildCount(), error);
            return false;
        }
        try {
            IConnectorManager manager = ConnectorManagerFactory.make(tc);
            IResultSet resultSet = manager.getConnectors();
            int j = 0;
            while (j < resultSet.getRowCount()) {
                ConfigurationNode node;
                IResultRow row = resultSet.getRow(j++);
                ConfigurationNode child = new ConfigurationNode(API_REPOSITORYCONNECTORNODE);
                String description = (String)row.getValue("description");
                String className = (String)row.getValue("classname");
                if (description != null) {
                    node = new ConfigurationNode("description");
                    node.setValue(description);
                    child.addChild(child.getChildCount(), node);
                }
                node = new ConfigurationNode("class_name");
                node.setValue(className);
                child.addChild(child.getChildCount(), node);
                output.addChild(output.getChildCount(), child);
            }
            return true;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return true;
        }
    }

    public static int executePostCommand(IThreadContext tc, Configuration output, String path, Configuration input) throws ManifoldCFException {
        if (path.equals("jobs")) {
            ConfigurationNode jobNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_JOBNODE);
            if (jobNode == null) {
                throw new ManifoldCFException("Input must have 'job' field");
            }
            JobDescription job = new JobDescription();
            ManifoldCF.processJobDescription(job, jobNode);
            if (job.getID() != null) {
                throw new ManifoldCFException("Input job cannot supply an ID field for create");
            }
            try {
                Long jobID = new Long(IDFactory.make((IThreadContext)tc));
                job.setID(jobID);
                job.setIsNew(true);
                IJobManager jobManager = JobManagerFactory.make(tc);
                jobManager.save(job);
                ConfigurationNode idNode = new ConfigurationNode("job_id");
                idNode.setValue(jobID.toString());
                output.addChild(output.getChildCount(), idNode);
                return 2;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else {
            ConfigurationNode error = new ConfigurationNode("error");
            error.setValue("Unrecognized resource.");
            output.addChild(output.getChildCount(), error);
            return 0;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int executeWriteCommand(IThreadContext tc, Configuration output, String path, Configuration input) throws ManifoldCFException {
        if (path.startsWith("start/")) {
            Long jobID = new Long(path.substring("start/".length()));
            try {
                IJobManager jobManager = JobManagerFactory.make(tc);
                jobManager.manualStart(jobID);
                return 2;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        if (path.startsWith("abort/")) {
            Long jobID = new Long(path.substring("abort/".length()));
            try {
                IJobManager jobManager = JobManagerFactory.make(tc);
                jobManager.manualAbort(jobID);
                return 2;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        if (path.startsWith("restart/")) {
            Long jobID = new Long(path.substring("restart/".length()));
            try {
                IJobManager jobManager = JobManagerFactory.make(tc);
                jobManager.manualAbortRestart(jobID);
                return 2;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        if (path.startsWith("pause/")) {
            Long jobID = new Long(path.substring("pause/".length()));
            try {
                IJobManager jobManager = JobManagerFactory.make(tc);
                jobManager.pauseJob(jobID);
                return 2;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        if (path.startsWith("resume/")) {
            Long jobID = new Long(path.substring("resume/".length()));
            try {
                IJobManager jobManager = JobManagerFactory.make(tc);
                jobManager.restartJob(jobID);
                return 2;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        if (path.startsWith("jobs/")) {
            Long jobID = new Long(path.substring("jobs/".length()));
            ConfigurationNode jobNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_JOBNODE);
            if (jobNode == null) {
                throw new ManifoldCFException("Input must have 'job' field");
            }
            JobDescription job = new JobDescription();
            ManifoldCF.processJobDescription(job, jobNode);
            try {
                if (job.getID() == null) {
                    job.setID(jobID);
                } else if (!job.getID().equals(jobID)) {
                    throw new ManifoldCFException("Job identifier must agree within object and within path");
                }
                job.setIsNew(false);
                IJobManager jobManager = JobManagerFactory.make(tc);
                jobManager.save(job);
                return 1;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        if (path.startsWith("outputconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("outputconnections/".length()));
            ConfigurationNode connectionNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_OUTPUTCONNECTIONNODE);
            if (connectionNode == null) {
                throw new ManifoldCFException("Input argument must have 'outputconnection' field");
            }
            OutputConnection outputConnection = new OutputConnection();
            ManifoldCF.processOutputConnection(outputConnection, connectionNode);
            if (outputConnection.getName() == null) {
                outputConnection.setName(connectionName);
            } else if (!outputConnection.getName().equals(connectionName)) {
                throw new ManifoldCFException("Connection name in path and in object must agree");
            }
            try {
                IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
                if (!connectionManager.save((IOutputConnection)outputConnection)) return 1;
                return 2;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        if (path.startsWith("authorityconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("authorityconnections/".length()));
            ConfigurationNode connectionNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_AUTHORITYCONNECTIONNODE);
            if (connectionNode == null) {
                throw new ManifoldCFException("Input argument must have 'authorityconnection' field");
            }
            AuthorityConnection authorityConnection = new AuthorityConnection();
            ManifoldCF.processAuthorityConnection(authorityConnection, connectionNode);
            if (authorityConnection.getName() == null) {
                authorityConnection.setName(connectionName);
            } else if (!authorityConnection.getName().equals(connectionName)) {
                throw new ManifoldCFException("Connection name in path and in object must agree");
            }
            try {
                IAuthorityConnectionManager connectionManager = AuthorityConnectionManagerFactory.make(tc);
                if (!connectionManager.save(authorityConnection)) return 1;
                return 2;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        if (path.startsWith("repositoryconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("repositoryconnections/".length()));
            ConfigurationNode connectionNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_REPOSITORYCONNECTIONNODE);
            if (connectionNode == null) {
                throw new ManifoldCFException("Input argument must have 'repositoryconnection' field");
            }
            RepositoryConnection repositoryConnection = new RepositoryConnection();
            ManifoldCF.processRepositoryConnection(repositoryConnection, connectionNode);
            if (repositoryConnection.getName() == null) {
                repositoryConnection.setName(connectionName);
            } else if (!repositoryConnection.getName().equals(connectionName)) {
                throw new ManifoldCFException("Connection name in path and in object must agree");
            }
            try {
                IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
                if (!connectionManager.save(repositoryConnection)) return 1;
                return 2;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        if (!path.startsWith("reset/")) {
            ConfigurationNode error = new ConfigurationNode("error");
            error.setValue("Unrecognized resource.");
            output.addChild(output.getChildCount(), error);
            return 0;
        }
        int firstSeparator = "reset/".length();
        int secondSeparator = path.indexOf("/", firstSeparator);
        if (secondSeparator == -1) {
            ConfigurationNode error = new ConfigurationNode("error");
            error.setValue("Need connection name.");
            output.addChild(output.getChildCount(), error);
            return 0;
        }
        String connectionType = path.substring(firstSeparator, secondSeparator);
        String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(secondSeparator + 1));
        if (!connectionType.equals("outputconnections")) {
            ConfigurationNode error = new ConfigurationNode("error");
            error.setValue("Unknown connection type '" + connectionType + "'.");
            output.addChild(output.getChildCount(), error);
            return 0;
        }
        try {
            ManifoldCF.signalOutputConnectionRedo((IThreadContext)tc, (String)connectionName);
            return 2;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return 1;
        }
    }

    public static boolean executeDeleteCommand(IThreadContext tc, Configuration output, String path) throws ManifoldCFException {
        if (path.startsWith("jobs/")) {
            Long jobID = new Long(path.substring("jobs/".length()));
            try {
                IJobManager jobManager = JobManagerFactory.make(tc);
                jobManager.deleteJob(jobID);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (path.startsWith("outputconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("outputconnections/".length()));
            try {
                IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
                connectionManager.delete(connectionName);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (path.startsWith("authorityconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("authorityconnections/".length()));
            try {
                IAuthorityConnectionManager connectionManager = AuthorityConnectionManagerFactory.make(tc);
                connectionManager.delete(connectionName);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (path.startsWith("repositoryconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("repositoryconnections/".length()));
            try {
                IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
                connectionManager.delete(connectionName);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else {
            ConfigurationNode error = new ConfigurationNode("error");
            error.setValue("Unrecognized resource.");
            output.addChild(output.getChildCount(), error);
            return false;
        }
        return true;
    }

    protected static void processJobDescription(JobDescription jobDescription, ConfigurationNode jobNode) throws ManifoldCFException {
        int i = 0;
        while (i < jobNode.getChildCount()) {
            ConfigurationNode child;
            String childType;
            if ((childType = (child = jobNode.findChild(i++)).getType()).equals(JOBNODE_ID)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Job id node requires a value");
                }
                jobDescription.setID(new Long(child.getValue()));
                continue;
            }
            if (childType.equals("description")) {
                jobDescription.setDescription(child.getValue());
                continue;
            }
            if (childType.equals(JOBNODE_CONNECTIONNAME)) {
                jobDescription.setConnectionName(child.getValue());
                continue;
            }
            if (childType.equals(JOBNODE_OUTPUTNAME)) {
                jobDescription.setOutputConnectionName(child.getValue());
                continue;
            }
            if (childType.equals(JOBNODE_DOCUMENTSPECIFICATION)) {
                DocumentSpecification ds = jobDescription.getSpecification();
                ds.clearChildren();
                int j = 0;
                while (j < child.getChildCount()) {
                    ConfigurationNode cn = child.findChild(j++);
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)new SpecificationNode(cn));
                }
                continue;
            }
            if (childType.equals(JOBNODE_OUTPUTSPECIFICATION)) {
                OutputSpecification os = jobDescription.getOutputSpecification();
                os.clearChildren();
                int j = 0;
                while (j < child.getChildCount()) {
                    ConfigurationNode cn = child.findChild(j++);
                    os.addChild(os.getChildCount(), (ConfigurationNode)new SpecificationNode(cn));
                }
                continue;
            }
            if (childType.equals(JOBNODE_STARTMODE)) {
                jobDescription.setStartMethod(ManifoldCF.mapToStartMode(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_RUNMODE)) {
                jobDescription.setType(ManifoldCF.mapToRunMode(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_HOPCOUNTMODE)) {
                jobDescription.setHopcountMode(ManifoldCF.mapToHopcountMode(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_PRIORITY)) {
                try {
                    jobDescription.setPriority(Integer.parseInt(child.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
            }
            if (childType.equals(JOBNODE_RECRAWLINTERVAL)) {
                jobDescription.setInterval(ManifoldCF.interpretInterval(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_EXPIRATIONINTERVAL)) {
                jobDescription.setExpiration(ManifoldCF.interpretInterval(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_RESEEDINTERVAL)) {
                jobDescription.setReseedInterval(ManifoldCF.interpretInterval(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_HOPCOUNT)) {
                String linkType = null;
                String hopCount = null;
                int q = 0;
                while (q < child.getChildCount()) {
                    ConfigurationNode cn;
                    if ((cn = child.findChild(q++)).getType().equals(JOBNODE_LINKTYPE)) {
                        linkType = cn.getValue();
                        continue;
                    }
                    if (cn.getType().equals(JOBNODE_COUNT)) {
                        hopCount = cn.getValue();
                        continue;
                    }
                    throw new ManifoldCFException("Found an unexpected node type: '" + cn.getType() + "'");
                }
                if (linkType == null) {
                    throw new ManifoldCFException("Missing required field: 'link_type'");
                }
                if (hopCount == null) {
                    throw new ManifoldCFException("Missing required field: 'count'");
                }
                jobDescription.addHopCountFilter(linkType, new Long(hopCount));
                continue;
            }
            if (childType.equals(JOBNODE_SCHEDULE)) {
                String timezone = null;
                Long duration = null;
                EnumeratedValues dayOfWeek = null;
                EnumeratedValues monthOfYear = null;
                EnumeratedValues dayOfMonth = null;
                EnumeratedValues year = null;
                EnumeratedValues hourOfDay = null;
                EnumeratedValues minutesOfHour = null;
                int q = 0;
                while (q < child.getChildCount()) {
                    ConfigurationNode scheduleField;
                    String fieldType;
                    if ((fieldType = (scheduleField = child.findChild(q++)).getType()).equals(JOBNODE_TIMEZONE)) {
                        timezone = scheduleField.getValue();
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_DURATION)) {
                        duration = new Long(scheduleField.getValue());
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_DAYOFWEEK)) {
                        dayOfWeek = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_MONTHOFYEAR)) {
                        monthOfYear = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_YEAR)) {
                        year = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_DAYOFMONTH)) {
                        dayOfMonth = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_HOUROFDAY)) {
                        hourOfDay = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_MINUTESOFHOUR)) {
                        minutesOfHour = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    throw new ManifoldCFException("Unrecognized field in schedule record: '" + fieldType + "'");
                }
                ScheduleRecord sr = new ScheduleRecord(dayOfWeek, monthOfYear, dayOfMonth, year, hourOfDay, minutesOfHour, timezone, duration);
                jobDescription.addScheduleRecord(sr);
                continue;
            }
            throw new ManifoldCFException("Unrecognized job field: '" + childType + "'");
        }
    }

    protected static void formatJobDescription(ConfigurationNode jobNode, IJobDescription job) {
        ConfigurationNode child;
        if (job.getID() != null) {
            child = new ConfigurationNode(JOBNODE_ID);
            child.setValue(job.getID().toString());
            jobNode.addChild(jobNode.getChildCount(), child);
        }
        if (job.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(job.getDescription());
            jobNode.addChild(jobNode.getChildCount(), child);
        }
        if (job.getConnectionName() != null) {
            child = new ConfigurationNode(JOBNODE_CONNECTIONNAME);
            child.setValue(job.getConnectionName());
            jobNode.addChild(jobNode.getChildCount(), child);
        }
        if (job.getOutputConnectionName() != null) {
            child = new ConfigurationNode(JOBNODE_OUTPUTNAME);
            child.setValue(job.getOutputConnectionName());
            jobNode.addChild(jobNode.getChildCount(), child);
        }
        DocumentSpecification ds = job.getSpecification();
        child = new ConfigurationNode(JOBNODE_DOCUMENTSPECIFICATION);
        int j = 0;
        while (j < ds.getChildCount()) {
            SpecificationNode cn = ds.getChild(j++);
            child.addChild(child.getChildCount(), (ConfigurationNode)cn);
        }
        jobNode.addChild(jobNode.getChildCount(), child);
        OutputSpecification os = job.getOutputSpecification();
        child = new ConfigurationNode(JOBNODE_OUTPUTSPECIFICATION);
        j = 0;
        while (j < os.getChildCount()) {
            SpecificationNode cn = os.getChild(j++);
            child.addChild(child.getChildCount(), (ConfigurationNode)cn);
        }
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_STARTMODE);
        child.setValue(ManifoldCF.startModeMap(job.getStartMethod()));
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_RUNMODE);
        child.setValue(ManifoldCF.runModeMap(job.getType()));
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_HOPCOUNTMODE);
        child.setValue(ManifoldCF.hopcountModeMap(job.getHopcountMode()));
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_PRIORITY);
        child.setValue(Integer.toString(job.getPriority()));
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_RECRAWLINTERVAL);
        child.setValue(job.getInterval() == null ? "infinite" : job.getInterval().toString());
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_EXPIRATIONINTERVAL);
        child.setValue(job.getExpiration() == null ? "infinite" : job.getExpiration().toString());
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_RESEEDINTERVAL);
        child.setValue(job.getReseedInterval() == null ? "infinite" : job.getReseedInterval().toString());
        jobNode.addChild(jobNode.getChildCount(), child);
        Map filters = job.getHopCountFilters();
        for (String linkType : filters.keySet()) {
            Long hopCount = (Long)filters.get(linkType);
            child = new ConfigurationNode(JOBNODE_HOPCOUNT);
            ConfigurationNode cn = new ConfigurationNode(JOBNODE_LINKTYPE);
            cn.setValue(linkType);
            child.addChild(child.getChildCount(), cn);
            cn = new ConfigurationNode(JOBNODE_COUNT);
            cn.setValue(hopCount.toString());
            child.addChild(child.getChildCount(), cn);
            jobNode.addChild(jobNode.getChildCount(), child);
        }
        child = new ConfigurationNode(JOBNODE_SCHEDULE);
        j = 0;
        while (j < job.getScheduleRecordCount()) {
            ConfigurationNode recordChild;
            ScheduleRecord sr;
            if ((sr = job.getScheduleRecord(j++)).getTimezone() != null) {
                recordChild = new ConfigurationNode(JOBNODE_TIMEZONE);
                recordChild.setValue(sr.getTimezone());
                child.addChild(child.getChildCount(), recordChild);
            }
            if (sr.getDuration() != null) {
                recordChild = new ConfigurationNode(JOBNODE_DURATION);
                recordChild.setValue(sr.getDuration().toString());
                child.addChild(child.getChildCount(), recordChild);
            }
            if (sr.getDayOfWeek() != null) {
                ManifoldCF.formatEnumeratedValues(child, JOBNODE_DAYOFWEEK, sr.getDayOfWeek());
            }
            if (sr.getMonthOfYear() != null) {
                ManifoldCF.formatEnumeratedValues(child, JOBNODE_MONTHOFYEAR, sr.getMonthOfYear());
            }
            if (sr.getDayOfMonth() != null) {
                ManifoldCF.formatEnumeratedValues(child, JOBNODE_DAYOFMONTH, sr.getDayOfMonth());
            }
            if (sr.getYear() != null) {
                ManifoldCF.formatEnumeratedValues(child, JOBNODE_YEAR, sr.getYear());
            }
            if (sr.getHourOfDay() != null) {
                ManifoldCF.formatEnumeratedValues(child, JOBNODE_HOUROFDAY, sr.getHourOfDay());
            }
            if (sr.getMinutesOfHour() == null) continue;
            ManifoldCF.formatEnumeratedValues(child, JOBNODE_MINUTESOFHOUR, sr.getMinutesOfHour());
        }
        jobNode.addChild(jobNode.getChildCount(), child);
    }

    protected static void formatEnumeratedValues(ConfigurationNode recordNode, String childType, EnumeratedValues value) {
        ConfigurationNode child = new ConfigurationNode(childType);
        Iterator iter = value.getValues();
        while (iter.hasNext()) {
            Integer theValue = (Integer)iter.next();
            ConfigurationNode valueNode = new ConfigurationNode(JOBNODE_ENUMVALUE);
            valueNode.setValue(theValue.toString());
            child.addChild(child.getChildCount(), valueNode);
        }
        recordNode.addChild(recordNode.getChildCount(), child);
    }

    protected static EnumeratedValues processEnumeratedValues(ConfigurationNode fieldNode) throws ManifoldCFException {
        ArrayList<Integer> values = new ArrayList<Integer>();
        int i = 0;
        while (i < fieldNode.getChildCount()) {
            ConfigurationNode cn;
            if ((cn = fieldNode.findChild(i++)).getType().equals(JOBNODE_ENUMVALUE)) {
                try {
                    values.add(new Integer(cn.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Error processing enumerated value node: " + e.getMessage(), (Throwable)e);
                }
            }
            throw new ManifoldCFException("Error processing enumerated value nodes: Unrecognized node type '" + cn.getType() + "'");
        }
        return new EnumeratedValues(values);
    }

    protected static String presentInterval(Long interval) {
        if (interval == null) {
            return "infinite";
        }
        return interval.toString();
    }

    protected static Long interpretInterval(String interval) throws ManifoldCFException {
        if (interval == null || interval.equals("infinite")) {
            return null;
        }
        return new Long(interval);
    }

    protected static String startModeMap(int startMethod) {
        switch (startMethod) {
            case 0: {
                return "schedule window start";
            }
            case 1: {
                return "schedule window anytime";
            }
            case 2: {
                return "manual";
            }
        }
        return "unknown";
    }

    protected static int mapToStartMode(String startMethod) throws ManifoldCFException {
        if (startMethod.equals("schedule window start")) {
            return 0;
        }
        if (startMethod.equals("schedule window anytime")) {
            return 1;
        }
        if (startMethod.equals("manual")) {
            return 2;
        }
        throw new ManifoldCFException("Unrecognized start method: '" + startMethod + "'");
    }

    protected static String runModeMap(int type) {
        switch (type) {
            case 0: {
                return "continuous";
            }
            case 1: {
                return "scan once";
            }
        }
        return "unknown";
    }

    protected static int mapToRunMode(String mode) throws ManifoldCFException {
        if (mode.equals("continuous")) {
            return 0;
        }
        if (mode.equals("scan once")) {
            return 1;
        }
        throw new ManifoldCFException("Unrecognized run method: '" + mode + "'");
    }

    protected static String hopcountModeMap(int mode) {
        switch (mode) {
            case 0: {
                return "accurate";
            }
            case 1: {
                return "no delete";
            }
            case 2: {
                return "never delete";
            }
        }
        return "unknown";
    }

    protected static int mapToHopcountMode(String mode) throws ManifoldCFException {
        if (mode.equals("accurate")) {
            return 0;
        }
        if (mode.equals("no delete")) {
            return 1;
        }
        if (mode.equals("never delete")) {
            return 2;
        }
        throw new ManifoldCFException("Unrecognized hopcount method: '" + mode + "'");
    }

    protected static void formatJobStatus(ConfigurationNode jobStatusNode, JobStatus jobStatus) {
        ConfigurationNode child = new ConfigurationNode("job_id");
        child.setValue(jobStatus.getJobID().toString());
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        child = new ConfigurationNode(JOBSTATUSNODE_STATUS);
        child.setValue(ManifoldCF.statusMap(jobStatus.getStatus()));
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        if (jobStatus.getErrorText() != null) {
            child = new ConfigurationNode(JOBSTATUSNODE_ERRORTEXT);
            child.setValue(jobStatus.getErrorText());
            jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        }
        if (jobStatus.getStartTime() != -1L) {
            child = new ConfigurationNode(JOBSTATUSNODE_STARTTIME);
            child.setValue(new Long(jobStatus.getStartTime()).toString());
            jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        }
        if (jobStatus.getEndTime() != -1L) {
            child = new ConfigurationNode(JOBSTATUSNODE_ENDTIME);
            child.setValue(new Long(jobStatus.getEndTime()).toString());
            jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        }
        child = new ConfigurationNode(JOBSTATUSNODE_DOCUMENTSINQUEUE);
        child.setValue(new Long(jobStatus.getDocumentsInQueue()).toString());
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        child = new ConfigurationNode(JOBSTATUSNODE_DOCUMENTSOUTSTANDING);
        child.setValue(new Long(jobStatus.getDocumentsOutstanding()).toString());
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        child = new ConfigurationNode(JOBSTATUSNODE_DOCUMENTSPROCESSED);
        child.setValue(new Long(jobStatus.getDocumentsProcessed()).toString());
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
    }

    protected static String statusMap(int status) {
        switch (status) {
            case 0: {
                return "not yet run";
            }
            case 1: {
                return "running";
            }
            case 2: {
                return "paused";
            }
            case 3: {
                return "done";
            }
            case 4: {
                return "waiting";
            }
            case 5: {
                return "starting up";
            }
            case 6: {
                return "cleaning up";
            }
            case 7: {
                return "error";
            }
            case 8: {
                return "aborting";
            }
            case 9: {
                return "restarting";
            }
            case 10: {
                return "running no connector";
            }
            case 11: {
                return "terminating";
            }
            case 12: {
                return "notifying";
            }
        }
        return "unknown";
    }

    protected static void processOutputConnection(OutputConnection connection, ConfigurationNode connectionNode) throws ManifoldCFException {
        int i = 0;
        while (i < connectionNode.getChildCount()) {
            ConfigurationNode child;
            String childType;
            if ((childType = (child = connectionNode.findChild(i++)).getType()).equals(CONNECTIONNODE_ISNEW)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection isnew node requires a value");
                }
                connection.setIsNew(child.getValue().equals("true"));
                continue;
            }
            if (childType.equals(CONNECTIONNODE_NAME)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection name node requires a value");
                }
                connection.setName(child.getValue());
                continue;
            }
            if (childType.equals("class_name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection classname node requires a value");
                }
                connection.setClassName(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_MAXCONNECTIONS)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection maxconnections node requires a value");
                }
                try {
                    connection.setMaxConnections(Integer.parseInt(child.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Error parsing max connections: " + e.getMessage(), (Throwable)e);
                }
            }
            if (childType.equals("description")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection description node requires a value");
                }
                connection.setDescription(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_CONFIGURATION)) {
                ConfigParams cp = connection.getConfigParams();
                cp.clearChildren();
                int j = 0;
                while (j < child.getChildCount()) {
                    ConfigurationNode cn = child.findChild(j++);
                    cp.addChild(cp.getChildCount(), (ConfigurationNode)new ConfigNode(cn));
                }
                continue;
            }
            throw new ManifoldCFException("Unrecognized output connection field: '" + childType + "'");
        }
        if (connection.getClassName() == null) {
            throw new ManifoldCFException("Missing connection field: 'class_name'");
        }
    }

    protected static void formatOutputConnection(ConfigurationNode connectionNode, IOutputConnection connection) {
        ConfigurationNode child = new ConfigurationNode(CONNECTIONNODE_ISNEW);
        child.setValue(connection.getIsNew() ? "true" : "false");
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_NAME);
        child.setValue(connection.getName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("class_name");
        child.setValue(connection.getClassName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_MAXCONNECTIONS);
        child.setValue(Integer.toString(connection.getMaxConnections()));
        connectionNode.addChild(connectionNode.getChildCount(), child);
        if (connection.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(connection.getDescription());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        ConfigParams cp = connection.getConfigParams();
        child = new ConfigurationNode(CONNECTIONNODE_CONFIGURATION);
        int j = 0;
        while (j < cp.getChildCount()) {
            ConfigurationNode cn = cp.findChild(j++);
            child.addChild(child.getChildCount(), cn);
        }
        connectionNode.addChild(connectionNode.getChildCount(), child);
    }

    protected static void processAuthorityConnection(AuthorityConnection connection, ConfigurationNode connectionNode) throws ManifoldCFException {
        int i = 0;
        while (i < connectionNode.getChildCount()) {
            ConfigurationNode child;
            String childType;
            if ((childType = (child = connectionNode.findChild(i++)).getType()).equals(CONNECTIONNODE_ISNEW)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection isnew node requires a value");
                }
                connection.setIsNew(child.getValue().equals("true"));
                continue;
            }
            if (childType.equals(CONNECTIONNODE_NAME)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection name node requires a value");
                }
                connection.setName(child.getValue());
                continue;
            }
            if (childType.equals("class_name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection classname node requires a value");
                }
                connection.setClassName(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_MAXCONNECTIONS)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection maxconnections node requires a value");
                }
                try {
                    connection.setMaxConnections(Integer.parseInt(child.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Error parsing max connections: " + e.getMessage(), (Throwable)e);
                }
            }
            if (childType.equals("description")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection description node requires a value");
                }
                connection.setDescription(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_CONFIGURATION)) {
                ConfigParams cp = connection.getConfigParams();
                cp.clearChildren();
                int j = 0;
                while (j < child.getChildCount()) {
                    ConfigurationNode cn = child.findChild(j++);
                    cp.addChild(cp.getChildCount(), (ConfigurationNode)new ConfigNode(cn));
                }
                continue;
            }
            throw new ManifoldCFException("Unrecognized authority connection field: '" + childType + "'");
        }
        if (connection.getClassName() == null) {
            throw new ManifoldCFException("Missing connection field: 'class_name'");
        }
    }

    protected static void formatAuthorityConnection(ConfigurationNode connectionNode, IAuthorityConnection connection) {
        ConfigurationNode child = new ConfigurationNode(CONNECTIONNODE_ISNEW);
        child.setValue(connection.getIsNew() ? "true" : "false");
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_NAME);
        child.setValue(connection.getName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("class_name");
        child.setValue(connection.getClassName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_MAXCONNECTIONS);
        child.setValue(Integer.toString(connection.getMaxConnections()));
        connectionNode.addChild(connectionNode.getChildCount(), child);
        if (connection.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(connection.getDescription());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        ConfigParams cp = connection.getConfigParams();
        child = new ConfigurationNode(CONNECTIONNODE_CONFIGURATION);
        int j = 0;
        while (j < cp.getChildCount()) {
            ConfigurationNode cn = cp.findChild(j++);
            child.addChild(child.getChildCount(), cn);
        }
        connectionNode.addChild(connectionNode.getChildCount(), child);
    }

    protected static void processRepositoryConnection(RepositoryConnection connection, ConfigurationNode connectionNode) throws ManifoldCFException {
        int i = 0;
        while (i < connectionNode.getChildCount()) {
            ConfigurationNode child;
            String childType;
            if ((childType = (child = connectionNode.findChild(i++)).getType()).equals(CONNECTIONNODE_ISNEW)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection isnew node requires a value");
                }
                connection.setIsNew(child.getValue().equals("true"));
                continue;
            }
            if (childType.equals(CONNECTIONNODE_NAME)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection name node requires a value");
                }
                connection.setName(child.getValue());
                continue;
            }
            if (childType.equals("class_name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection classname node requires a value");
                }
                connection.setClassName(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_MAXCONNECTIONS)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection maxconnections node requires a value");
                }
                try {
                    connection.setMaxConnections(Integer.parseInt(child.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Error parsing max connections: " + e.getMessage(), (Throwable)e);
                }
            }
            if (childType.equals("description")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection description node requires a value");
                }
                connection.setDescription(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_CONFIGURATION)) {
                ConfigParams cp = connection.getConfigParams();
                cp.clearChildren();
                int j = 0;
                while (j < child.getChildCount()) {
                    ConfigurationNode cn = child.findChild(j++);
                    cp.addChild(cp.getChildCount(), (ConfigurationNode)new ConfigNode(cn));
                }
                continue;
            }
            if (childType.equals(CONNECTIONNODE_ACLAUTHORITY)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection aclauthority node requires a value");
                }
                connection.setACLAuthority(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_THROTTLE)) {
                String match = null;
                String description = null;
                Float rate = null;
                int q = 0;
                while (q < child.getChildCount()) {
                    ConfigurationNode throttleField;
                    String fieldType;
                    if ((fieldType = (throttleField = child.findChild(q++)).getType()).equals(CONNECTIONNODE_MATCH)) {
                        match = throttleField.getValue();
                        continue;
                    }
                    if (fieldType.equals(CONNECTIONNODE_MATCHDESCRIPTION)) {
                        description = throttleField.getValue();
                        continue;
                    }
                    if (fieldType.equals(CONNECTIONNODE_RATE)) {
                        rate = new Float(throttleField.getValue());
                        continue;
                    }
                    throw new ManifoldCFException("Unrecognized throttle field: '" + fieldType + "'");
                }
                if (match == null) {
                    throw new ManifoldCFException("Missing throttle field: 'match'");
                }
                if (rate == null) {
                    throw new ManifoldCFException("Missing throttle field: 'rate'");
                }
                connection.addThrottleValue(match, description, rate.floatValue());
                continue;
            }
            throw new ManifoldCFException("Unrecognized repository connection field: '" + childType + "'");
        }
        if (connection.getClassName() == null) {
            throw new ManifoldCFException("Missing connection field: 'class_name'");
        }
    }

    protected static void formatRepositoryConnection(ConfigurationNode connectionNode, IRepositoryConnection connection) {
        ConfigurationNode child = new ConfigurationNode(CONNECTIONNODE_ISNEW);
        child.setValue(connection.getIsNew() ? "true" : "false");
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_NAME);
        child.setValue(connection.getName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("class_name");
        child.setValue(connection.getClassName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_MAXCONNECTIONS);
        child.setValue(Integer.toString(connection.getMaxConnections()));
        connectionNode.addChild(connectionNode.getChildCount(), child);
        if (connection.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(connection.getDescription());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        ConfigParams cp = connection.getConfigParams();
        child = new ConfigurationNode(CONNECTIONNODE_CONFIGURATION);
        int j = 0;
        while (j < cp.getChildCount()) {
            ConfigurationNode cn = cp.findChild(j++);
            child.addChild(child.getChildCount(), cn);
        }
        connectionNode.addChild(connectionNode.getChildCount(), child);
        if (connection.getACLAuthority() != null) {
            child = new ConfigurationNode(CONNECTIONNODE_ACLAUTHORITY);
            child.setValue(connection.getACLAuthority());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        String[] throttles = connection.getThrottles();
        j = 0;
        while (j < throttles.length) {
            String match = throttles[j++];
            String description = connection.getThrottleDescription(match);
            float rate = connection.getThrottleValue(match);
            child = new ConfigurationNode(CONNECTIONNODE_THROTTLE);
            ConfigurationNode throttleChildNode = new ConfigurationNode(CONNECTIONNODE_MATCH);
            throttleChildNode.setValue(match);
            child.addChild(child.getChildCount(), throttleChildNode);
            if (description != null) {
                throttleChildNode = new ConfigurationNode(CONNECTIONNODE_MATCHDESCRIPTION);
                throttleChildNode.setValue(description);
                child.addChild(child.getChildCount(), throttleChildNode);
            }
            throttleChildNode = new ConfigurationNode(CONNECTIONNODE_RATE);
            throttleChildNode.setValue(new Float(rate).toString());
            child.addChild(child.getChildCount(), throttleChildNode);
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
    }

    protected static class InitializationThread
    extends Thread {
        protected QueueTracker queueTracker;

        public InitializationThread(QueueTracker queueTracker) {
            this.queueTracker = queueTracker;
        }

        public void run() {
            try {
                int i;
                IThreadContext threadContext = ThreadContextFactory.make();
                IJobManager jobManager = JobManagerFactory.make(threadContext);
                IRepositoryConnectionManager mgr = RepositoryConnectionManagerFactory.make(threadContext);
                Logging.threads.debug((Object)"Agents process starting initialization...");
                jobManager.prepareForStart();
                Logging.threads.debug((Object)"Agents process reprioritizing documents...");
                HashMap connectionMap = new HashMap();
                HashMap jobDescriptionMap = new HashMap();
                long currentTime = System.currentTimeMillis();
                while (true) {
                    long startTime = System.currentTimeMillis();
                    DocumentDescription[] docs = jobManager.getNextNotYetProcessedReprioritizationDocuments(currentTime, 10000);
                    if (docs.length == 0) break;
                    ManifoldCF.writeDocumentPriorities(threadContext, mgr, jobManager, docs, connectionMap, jobDescriptionMap, this.queueTracker, currentTime);
                    Logging.threads.debug((Object)("Reprioritized " + Integer.toString(docs.length) + " not-yet-processed documents in " + new Long(System.currentTimeMillis() - startTime) + " ms"));
                }
                Logging.threads.debug((Object)"Agents process initialization complete!");
                jobStartThread.start();
                startupThread.start();
                startDeleteThread.start();
                finisherThread.start();
                notificationThread.start();
                jobDeleteThread.start();
                stufferThread.start();
                expireStufferThread.start();
                setPriorityThread.start();
                for (i = 0; i < numWorkerThreads; ++i) {
                    workerThreads[i].start();
                }
                for (i = 0; i < numExpireThreads; ++i) {
                    expireThreads[i].start();
                }
                cleanupStufferThread.start();
                for (i = 0; i < numCleanupThreads; ++i) {
                    cleanupThreads[i].start();
                }
                deleteStufferThread.start();
                for (i = 0; i < numDeleteThreads; ++i) {
                    deleteThreads[i].start();
                }
                jobResetThread.start();
                seedingThread.start();
                idleCleanupThread.start();
            }
            catch (Throwable e) {
                if (e instanceof ManifoldCFException && ((ManifoldCFException)e).getErrorCode() == 2) {
                    return;
                }
                System.err.println("agents process could not start - shutting down");
                Logging.threads.fatal((Object)("Startup initialization error tossed: " + e.getMessage()), e);
                System.exit(-300);
            }
        }
    }
}

