/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.system.QueuedDocument;

public class QueuedDocumentSet {
    public static final String _rcsid = "@(#)$Id: QueuedDocumentSet.java 988245 2010-08-23 18:39:35Z kwright $";
    protected QueuedDocument[] documents;
    protected IJobDescription jobDescription;
    protected IRepositoryConnection connection;

    public QueuedDocumentSet(ArrayList documents, IJobDescription jobDescription, IRepositoryConnection connection) {
        this.documents = new QueuedDocument[documents.size()];
        for (int i = 0; i < this.documents.length; ++i) {
            this.documents[i] = (QueuedDocument)documents.get(i);
        }
        this.jobDescription = jobDescription;
        this.connection = connection;
    }

    public int getCount() {
        return this.documents.length;
    }

    public QueuedDocument getDocument(int index) {
        return this.documents[index];
    }

    public void beginProcessing(QueueTracker queueTracker) {
        int l = 0;
        while (l < this.documents.length) {
            QueuedDocument d = this.documents[l++];
            queueTracker.beginProcessing(d.getBinNames());
        }
    }

    public void endProcessing(QueueTracker queueTracker) {
        int l = 0;
        while (l < this.documents.length) {
            QueuedDocument d = this.documents[l++];
            queueTracker.endProcessing(d.getBinNames());
        }
    }

    public double calculateAssignmentRating(QueueTracker overlapCalculator) {
        double ratingAccumulator = 0.0;
        int i = 0;
        while (i < this.documents.length) {
            String[] binNames = this.documents[i++].getBinNames();
            ratingAccumulator += overlapCalculator.calculateAssignmentRating(binNames, this.connection);
        }
        return ratingAccumulator / (double)this.documents.length;
    }

    public IJobDescription getJobDescription() {
        return this.jobDescription;
    }

    public IRepositoryConnection getConnection() {
        return this.connection;
    }
}

