/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public abstract class ResetManager {
    public static final String _rcsid = "@(#)$Id: ResetManager.java 988245 2010-08-23 18:39:35Z kwright $";
    protected boolean resetRequired = false;
    protected int involvedThreadCount = 0;
    protected int waitingThreads = 0;

    public synchronized void registerMe() {
        ++this.involvedThreadCount;
    }

    public synchronized void noteEvent() {
        this.resetRequired = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean waitForReset(IThreadContext tc) throws ManifoldCFException, InterruptedException {
        if (!this.resetRequired) {
            return false;
        }
        ++this.waitingThreads;
        if (this.waitingThreads == this.involvedThreadCount) {
            try {
                this.performResetLogic(tc);
            }
            finally {
                this.waitingThreads = 0;
                this.resetRequired = false;
                this.notifyAll();
            }
            return true;
        }
        this.wait();
        return true;
    }

    protected abstract void performResetLogic(IThreadContext var1) throws ManifoldCFException;
}

