/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class SeedingActivity
implements ISeedingActivity {
    public static final String _rcsid = "@(#)$Id: SeedingActivity.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final int MAX_COUNT = 100;
    protected String connectionName;
    protected IRepositoryConnectionManager connManager;
    protected IJobManager jobManager;
    protected QueueTracker queueTracker;
    protected IRepositoryConnection connection;
    protected IRepositoryConnector connector;
    protected Long jobID;
    protected String[] legalLinkTypes;
    protected boolean overrideSchedule;
    protected int hopcountMethod;
    protected String[] documentHashList = new String[100];
    protected String[] documentList = new String[100];
    protected String[][] documentPrereqList = new String[100][];
    protected int documentCount = 0;
    protected String[] remainingDocumentHashList = new String[100];
    protected int remainingDocumentCount = 0;

    public SeedingActivity(String connectionName, IRepositoryConnectionManager connManager, IJobManager jobManager, QueueTracker queueTracker, IRepositoryConnection connection, IRepositoryConnector connector, Long jobID, String[] legalLinkTypes, boolean overrideSchedule, int hopcountMethod) {
        this.connectionName = connectionName;
        this.connManager = connManager;
        this.jobManager = jobManager;
        this.queueTracker = queueTracker;
        this.connection = connection;
        this.connector = connector;
        this.jobID = jobID;
        this.legalLinkTypes = legalLinkTypes;
        this.overrideSchedule = overrideSchedule;
        this.hopcountMethod = hopcountMethod;
    }

    public void addSeedDocument(String documentIdentifier, String[] prereqEventNames) throws ManifoldCFException {
        if (this.documentCount == 100) {
            this.writeSeedDocuments(this.documentHashList, this.documentList, this.documentPrereqList);
            this.documentCount = 0;
        }
        this.documentHashList[this.documentCount] = ManifoldCF.hash((String)documentIdentifier);
        this.documentList[this.documentCount] = documentIdentifier;
        this.documentPrereqList[this.documentCount] = prereqEventNames != null ? prereqEventNames : null;
        ++this.documentCount;
    }

    public void addSeedDocument(String documentIdentifier) throws ManifoldCFException {
        this.addSeedDocument(documentIdentifier, null);
    }

    public void addUnqueuedSeedDocument(String documentIdentifier) throws ManifoldCFException {
        if (this.remainingDocumentCount == 100) {
            this.jobManager.addRemainingDocumentsInitial(this.jobID, this.legalLinkTypes, this.remainingDocumentHashList, this.hopcountMethod);
            this.remainingDocumentCount = 0;
        }
        this.remainingDocumentHashList[this.remainingDocumentCount++] = ManifoldCF.hash((String)documentIdentifier);
    }

    public void doneSeeding(boolean isPartial) throws ManifoldCFException {
        if (this.documentCount > 0) {
            String[] documentHashes = new String[this.documentCount];
            String[] documents = new String[this.documentCount];
            String[][] documentPrereqs = new String[this.documentCount][];
            for (int i = 0; i < documentHashes.length; ++i) {
                documentHashes[i] = this.documentHashList[i];
                documents[i] = this.documentList[i];
                documentPrereqs[i] = this.documentPrereqList[i];
            }
            this.writeSeedDocuments(documentHashes, documents, documentPrereqs);
            this.documentCount = 0;
        }
        if (this.remainingDocumentCount > 0) {
            String[] documents = new String[this.remainingDocumentCount];
            for (int i = 0; i < documents.length; ++i) {
                documents[i] = this.remainingDocumentHashList[i];
            }
            this.jobManager.addRemainingDocumentsInitial(this.jobID, this.legalLinkTypes, documents, this.hopcountMethod);
            this.remainingDocumentCount = 0;
        }
        this.jobManager.doneDocumentsInitial(this.jobID, this.legalLinkTypes, isPartial, this.hopcountMethod);
    }

    public void recordActivity(Long startTime, String activityType, Long dataSize, String entityIdentifier, String resultCode, String resultDescription, String[] childIdentifiers) throws ManifoldCFException {
        this.connManager.recordHistory(this.connectionName, startTime, activityType, dataSize, entityIdentifier, resultCode, resultDescription, childIdentifiers);
    }

    protected void writeSeedDocuments(String[] docIDHashes, String[] docIDs, String[][] prereqEventNames) throws ManifoldCFException {
        long prioritizationTime = System.currentTimeMillis();
        double[] docPriorities = new double[docIDHashes.length];
        String[][] binNames = new String[docIDHashes.length][];
        for (int i = 0; i < docIDHashes.length; ++i) {
            String[] bins = this.connector.getBinNames(docIDs[i]);
            binNames[i] = bins;
            docPriorities[i] = this.queueTracker.calculatePriority(bins, this.connection);
            if (!Logging.scheduling.isDebugEnabled()) continue;
            Logging.scheduling.debug((Object)("Giving document '" + docIDs[i] + "' priority " + new Double(docPriorities[i]).toString()));
        }
        boolean[] trackerNote = this.jobManager.addDocumentsInitial(this.jobID, this.legalLinkTypes, docIDHashes, docIDs, this.overrideSchedule, this.hopcountMethod, prioritizationTime, docPriorities, prereqEventNames);
        for (int j = 0; j < trackerNote.length; ++j) {
            if (trackerNote[j]) continue;
            String[] bins = binNames[j];
            this.queueTracker.notePriorityNotUsed(bins, this.connection, docPriorities[j]);
        }
    }

    public void checkJobStillActive() throws ManifoldCFException, ServiceInterruption {
        if (!this.jobManager.checkJobActive(this.jobID)) {
            throw new ServiceInterruption("Job no longer active", System.currentTimeMillis());
        }
    }

    public String createGlobalString(String simpleString) {
        return ManifoldCF.createGlobalString(simpleString);
    }

    public String createConnectionSpecificString(String simpleString) {
        return ManifoldCF.createConnectionSpecificString(this.connection.getName(), simpleString);
    }

    public String createJobSpecificString(String simpleString) {
        return ManifoldCF.createJobSpecificString(this.jobID, simpleString);
    }
}

