/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.ResetManager;
import org.apache.manifoldcf.crawler.system.SeedingActivity;

public class SeedingThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: SeedingThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static SeedingResetManager resetManager = new SeedingResetManager();
    protected QueueTracker queueTracker;
    protected static final int MAX_COUNT = 100;

    public SeedingThread(QueueTracker queueTracker) throws ManifoldCFException {
        this.setName("Seeding thread");
        this.setDaemon(true);
        this.queueTracker = queueTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        SeedingThread.resetManager.registerMe();
        try {
            threadContext = ThreadContextFactory.make();
            jobManager = JobManagerFactory.make(threadContext);
            connectionMgr = RepositoryConnectionManagerFactory.make(threadContext);
            database = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            identifiers = new String[100];
            while (true) lbl-1000:
            // 6 sources

            {
                try {
                    while (true) {
                        SeedingThread.resetManager.waitForReset(threadContext);
                        currentTime = System.currentTimeMillis();
                        waitTime = 60000L;
                        Logging.threads.debug((Object)"Seeding thread woke up");
                        seedJobs = jobManager.getJobsReadyForSeeding(currentTime);
                        try {
                            if (seedJobs.length == 0) {
                                Logging.threads.debug((Object)"Seeding thread found nothing to do");
                                ManifoldCF.sleep((long)waitTime);
                                var29_31 = null;
                                exception = null;
                                i = 0;
                                while (i < seedJobs.length) {
                                    if ((jsr = seedJobs[i++]).wasStarted()) continue;
                                    if (Logging.threads.isDebugEnabled()) {
                                        Logging.threads.debug((Object)("Seeding thread: aborting reseed for " + jsr.getJobID().toString()));
                                    }
                                    try {
                                        jobManager.resetSeedJob(jsr.getJobID());
                                    }
                                    catch (ManifoldCFException e) {
                                        exception = e;
                                    }
                                }
                                if (exception == null) continue;
                                throw exception;
                            }
                            if (Logging.threads.isDebugEnabled()) {
                                Logging.threads.debug((Object)("Seeding thread: Found " + Integer.toString(seedJobs.length) + " jobs to seed"));
                            }
                            i = 0;
                            while (i < seedJobs.length) {
                                jsr = seedJobs[i++];
                                jobID = jsr.getJobID();
                                try {
                                    lastJobTime = jsr.getSynchTime();
                                    jobDescription = jobManager.load(jobID, true);
                                    jobType = jobDescription.getType();
                                    hopcountMethod = jobDescription.getHopcountMode();
                                    connection = connectionMgr.load(jobDescription.getConnectionName());
                                    connector = RepositoryConnectorFactory.grab(threadContext, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
                                    if (connector == null) continue;
                                    try {
                                        block42: {
                                            legalLinkTypes = connector.getRelationshipTypes();
                                            model = connector.getConnectorModel();
                                            try {
                                                activity = new SeedingActivity(connection.getName(), connectionMgr, jobManager, this.queueTracker, connection, connector, jobID, legalLinkTypes, false, hopcountMethod);
                                                if (Logging.threads.isDebugEnabled()) {
                                                    Logging.threads.debug((Object)("Seeding thread: Getting seeds for job " + jobID.toString()));
                                                }
                                                connector.addSeedDocuments(activity, jobDescription.getSpecification(), lastJobTime, currentTime, jobType);
                                                activity.doneSeeding(model == 4);
                                                if (!Logging.threads.isDebugEnabled()) break block42;
                                                Logging.threads.debug((Object)("Seeding thread: Done processing seeds from job " + jobID.toString()));
                                            }
                                            catch (ServiceInterruption e) {
                                                Logging.threads.error((Object)("Service interruption for job " + jobID), (Throwable)e);
                                                retryInterval = e.getRetryTime() - currentTime;
                                                if (retryInterval >= 0L && retryInterval < waitTime) {
                                                    waitTime = retryInterval;
                                                }
                                                var27_30 = null;
                                                RepositoryConnectorFactory.release(connector);
                                                continue;
                                            }
                                        }
                                        var27_30 = null;
                                    }
                                    catch (Throwable var26_36) {
                                        var27_30 = null;
                                        RepositoryConnectorFactory.release(connector);
                                        throw var26_36;
                                    }
                                    RepositoryConnectorFactory.release(connector);
                                    if (Logging.threads.isDebugEnabled()) {
                                        Logging.threads.debug((Object)("Seeding thread: Successfully reseeded job " + jobID.toString()));
                                    }
                                    jobManager.noteJobSeeded(jobID, currentTime);
                                    jsr.noteStarted();
                                }
                                catch (ManifoldCFException e) {
                                    if (e.getErrorCode() == 2) {
                                        throw new InterruptedException();
                                    }
                                    if (e.getErrorCode() == 4) {
                                        throw e;
                                    }
                                    if (e.getErrorCode() == 5) {
                                        Logging.threads.warn((Object)("Seeding thread: Ignoring connection error: " + e.getMessage()), (Throwable)e);
                                        continue;
                                    }
                                    if (!jobManager.errorAbort(jobID, e.getMessage())) continue;
                                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                                }
                            }
                        }
                        catch (Throwable var28_37) {
                            var29_31 = null;
                            exception = null;
                            i = 0;
                            while (true) {
                                if (i >= seedJobs.length) {
                                    if (exception == null) throw var28_37;
                                    throw exception;
                                }
                                if ((jsr = seedJobs[i++]).wasStarted()) continue;
                                if (Logging.threads.isDebugEnabled()) {
                                    Logging.threads.debug((Object)("Seeding thread: aborting reseed for " + jsr.getJobID().toString()));
                                }
                                ** try [egrp 6[TRYBLOCK] [10 : 789->803)] { 
lbl112:
                                // 1 sources

                                jobManager.resetSeedJob(jsr.getJobID());
lbl114:
                                // 1 sources

                                catch (ManifoldCFException e) {
                                    exception = e;
                                }
                            }
                        }
                        var29_31 = null;
                        exception = null;
                        i = 0;
                        while (i < seedJobs.length) {
                            if ((jsr = seedJobs[i++]).wasStarted()) continue;
                            if (Logging.threads.isDebugEnabled()) {
                                Logging.threads.debug((Object)("Seeding thread: aborting reseed for " + jsr.getJobID().toString()));
                            }
                            ** try [egrp 6[TRYBLOCK] [10 : 789->803)] { 
lbl125:
                            // 1 sources

                            jobManager.resetSeedJob(jsr.getJobID());
lbl127:
                            // 1 sources

                            catch (ManifoldCFException e) {
                                exception = e;
                            }
                        }
                        if (exception != null) {
                            throw exception;
                        }
                        ManifoldCF.sleep((long)waitTime);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) {
                        return;
                    }
                    if (e.getErrorCode() == 4) {
                        SeedingThread.resetManager.noteEvent();
                        Logging.threads.error((Object)("Seeding thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                        }
                        catch (InterruptedException se) {
                            return;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) ** GOTO lbl-1000
                    System.exit(1);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("SeedingThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
        ** GOTO lbl-1000
    }

    protected static class SeedingResetManager
    extends ResetManager {
        protected void performResetLogic(IThreadContext tc) throws ManifoldCFException {
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.resetSeedingWorkerStatus();
        }
    }
}

