/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.HashMap;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.BlockingDocuments;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class SetPriorityThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: SetPriorityThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected QueueTracker queueTracker;
    protected int cycleCount;
    protected BlockingDocuments blockingDocuments;

    public SetPriorityThread(QueueTracker qt, int workerThreadCount, BlockingDocuments blockingDocuments) throws ManifoldCFException {
        this.queueTracker = qt;
        this.blockingDocuments = blockingDocuments;
        this.cycleCount = workerThreadCount * 10;
        this.setName("Set priority thread");
        this.setDaemon(true);
        this.setPriority(10);
    }

    public void run() {
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IRepositoryConnectionManager mgr = RepositoryConnectionManagerFactory.make(threadContext);
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            Logging.threads.debug((Object)"Set priority thread coming up");
            HashMap jobDescriptionMap = new HashMap();
            HashMap connectionMap = new HashMap();
            while (true) {
                try {
                    block10: while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        Logging.threads.debug((Object)"Set priority thread woke up");
                        long currentTime = System.currentTimeMillis();
                        jobDescriptionMap.clear();
                        connectionMap.clear();
                        int processedCount = 0;
                        while (true) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new ManifoldCFException("Interrupted", 2);
                            }
                            if (processedCount >= this.cycleCount) {
                                Logging.threads.debug((Object)"Done reprioritizing because exceeded cycle count");
                                continue block10;
                            }
                            DocumentDescription desc = this.blockingDocuments.getBlockingDocument();
                            if (desc == null) break;
                            ManifoldCF.writeDocumentPriorities(threadContext, mgr, jobManager, new DocumentDescription[]{desc}, connectionMap, jobDescriptionMap, this.queueTracker, currentTime);
                            ++processedCount;
                        }
                        Logging.threads.debug((Object)"Done reprioritizing because no more documents to reprioritize");
                        ManifoldCF.sleep((long)30000L);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        Logging.threads.error((Object)("Set priority thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("SetPriorityThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }
}

