/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.JobStartRecord;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.ResetManager;

public class StartDeleteThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: StartDeleteThread.java 1062556 2011-01-23 22:33:49Z kwright $";
    protected static DeleteStartupResetManager resetManager = new DeleteStartupResetManager();

    public StartDeleteThread() throws ManifoldCFException {
        this.setName("Delete startup thread");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        resetManager.registerMe();
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            IRepositoryConnectionManager connectionMgr = RepositoryConnectionManagerFactory.make(threadContext);
            IDBInterface database = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            while (true) {
                try {
                    while (true) {
                        resetManager.waitForReset(threadContext);
                        long waitTime = 10000L;
                        if (Logging.threads.isDebugEnabled()) {
                            Logging.threads.debug((Object)"Checking for deleting jobs");
                        }
                        JobStartRecord[] deleteJobs = jobManager.getJobsReadyForDelete();
                        try {
                            if (deleteJobs.length == 0) {
                                ManifoldCF.sleep((long)waitTime);
                                continue;
                            }
                            if (Logging.threads.isDebugEnabled()) {
                                Logging.threads.debug((Object)("Found " + Integer.toString(deleteJobs.length) + " jobs ready to be deleted"));
                            }
                            long currentTime = System.currentTimeMillis();
                            int i = 0;
                            while (i < deleteJobs.length) {
                                JobStartRecord jsr = deleteJobs[i++];
                                Long jobID = jsr.getJobID();
                                try {
                                    jobManager.prepareDeleteScan(jobID);
                                    jobManager.noteJobDeleteStarted(jobID, currentTime);
                                    jsr.noteStarted();
                                }
                                catch (ManifoldCFException e) {
                                    if (e.getErrorCode() == 2) {
                                        throw new InterruptedException();
                                    }
                                    if (e.getErrorCode() == 4) {
                                        throw e;
                                    }
                                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                                }
                            }
                        }
                        finally {
                            ManifoldCFException exception = null;
                            int i = 0;
                            while (i < deleteJobs.length) {
                                JobStartRecord jsr;
                                if ((jsr = deleteJobs[i++]).wasStarted()) continue;
                                try {
                                    jobManager.resetStartDeleteJob(jsr.getJobID());
                                }
                                catch (ManifoldCFException e) {
                                    exception = e;
                                }
                            }
                            if (exception == null) continue;
                            throw exception;
                        }
                        ManifoldCF.sleep((long)waitTime);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        resetManager.noteEvent();
                        Logging.threads.error((Object)("Start delete thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("StartDeleteThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }

    protected static class DeleteStartupResetManager
    extends ResetManager {
        protected void performResetLogic(IThreadContext tc) throws ManifoldCFException {
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.resetDeleteStartupWorkerStatus();
        }
    }
}

