/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.ResetManager;
import org.apache.manifoldcf.crawler.system.SeedingActivity;

public class StartupThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: StartupThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static StartupResetManager resetManager = new StartupResetManager();
    protected QueueTracker queueTracker;

    public StartupThread(QueueTracker queueTracker) throws ManifoldCFException {
        this.setName("Startup thread");
        this.setDaemon(true);
        this.queueTracker = queueTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        StartupThread.resetManager.registerMe();
        try {
            threadContext = ThreadContextFactory.make();
            jobManager = JobManagerFactory.make(threadContext);
            connectionMgr = RepositoryConnectionManagerFactory.make(threadContext);
            database = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            while (true) {
                try {
                    while (true) {
                        StartupThread.resetManager.waitForReset(threadContext);
                        waitTime = 10000L;
                        if (Logging.threads.isDebugEnabled()) {
                            Logging.threads.debug((Object)"Checking for starting jobs");
                        }
                        startupJobs = jobManager.getJobsReadyForStartup();
                        try {
                            if (startupJobs.length == 0) {
                                ManifoldCF.sleep((long)waitTime);
                                continue;
                            }
                            if (Logging.threads.isDebugEnabled()) {
                                Logging.threads.debug((Object)("Found " + Integer.toString(startupJobs.length) + " jobs ready to be started"));
                            }
                            currentTime = System.currentTimeMillis();
                            i = 0;
                            while (i < startupJobs.length) {
                                jsr = startupJobs[i++];
                                jobID = jsr.getJobID();
                                try {
                                    lastJobTime = jsr.getSynchTime();
                                    jobDescription = jobManager.load(jobID, true);
                                    jobType = jobDescription.getType();
                                    hopcountMethod = jobDescription.getHopcountMode();
                                    connection = connectionMgr.load(jobDescription.getConnectionName());
                                    connector = RepositoryConnectorFactory.grab(threadContext, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
                                    if (connector == null) continue;
                                    connectionMgr.recordHistory(jobDescription.getConnectionName(), null, "job start", null, jobID.toString() + "(" + jobDescription.getDescription() + ")", null, null, null);
                                    try {
                                        block46: {
                                            model = connector.getConnectorModel();
                                            legalLinkTypes = connector.getRelationshipTypes();
                                            if (model == 3) break block46;
                                            if (Logging.threads.isDebugEnabled()) {
                                                Logging.threads.debug((Object)("Preparing job " + jobID.toString() + " for execution..."));
                                            }
                                            if (jobType == 0) ** GOTO lbl-1000
                                            if (model == 4) ** GOTO lbl-1000
                                            if (model == 0 || lastJobTime == 0L) {
                                                jobManager.prepareFullScan(jobID, legalLinkTypes, hopcountMethod);
                                            } else lbl-1000:
                                            // 3 sources

                                            {
                                                jobManager.prepareIncrementalScan(jobID, legalLinkTypes, hopcountMethod);
                                            }
                                            if (Logging.threads.isDebugEnabled()) {
                                                Logging.threads.debug((Object)("Prepared job " + jobID.toString() + " for execution."));
                                            }
                                        }
                                        try {
                                            activity = new SeedingActivity(connection.getName(), connectionMgr, jobManager, this.queueTracker, connection, connector, jobID, legalLinkTypes, true, hopcountMethod);
                                            if (Logging.threads.isDebugEnabled()) {
                                                Logging.threads.debug((Object)("Adding initial seed documents for job " + jobID.toString() + "..."));
                                            }
                                            connector.addSeedDocuments(activity, jobDescription.getSpecification(), lastJobTime, currentTime, jobType);
                                            activity.doneSeeding(model == 4);
                                            if (Logging.threads.isDebugEnabled()) {
                                                Logging.threads.debug((Object)("Done adding initial seed documents for job " + jobID.toString() + "."));
                                            }
                                        }
                                        catch (ServiceInterruption e) {
                                            Logging.threads.warn((Object)("Service interruption for job " + jobID), (Throwable)e);
                                            retryInterval = e.getRetryTime() - currentTime;
                                            if (retryInterval >= 0L && retryInterval < waitTime) {
                                                waitTime = retryInterval;
                                            }
                                            RepositoryConnectorFactory.release(connector);
                                            continue;
                                        }
                                    }
                                    catch (Throwable var25_35) {
                                        RepositoryConnectorFactory.release(connector);
                                        throw var25_35;
                                    }
                                    RepositoryConnectorFactory.release(connector);
                                    jobManager.noteJobStarted(jobID, currentTime);
                                    jsr.noteStarted();
                                }
                                catch (ManifoldCFException e) {
                                    if (e.getErrorCode() == 2) {
                                        throw new InterruptedException();
                                    }
                                    if (e.getErrorCode() == 4) {
                                        throw e;
                                    }
                                    if (e.getErrorCode() == 5) {
                                        Logging.threads.warn((Object)("Startup thread: connection error; continuing: " + e.getMessage()), (Throwable)e);
                                        continue;
                                    }
                                    if (!jobManager.errorAbort(jobID, e.getMessage())) continue;
                                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                                }
                            }
                        }
                        finally {
                            exception = null;
                            i = 0;
                            while (i < startupJobs.length) {
                                if ((jsr = startupJobs[i++]).wasStarted()) continue;
                                try {
                                    jobManager.resetStartupJob(jsr.getJobID());
                                }
                                catch (ManifoldCFException e) {
                                    exception = e;
                                }
                            }
                            if (exception == null) continue;
                            throw exception;
                        }
                        ManifoldCF.sleep((long)waitTime);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        StartupThread.resetManager.noteEvent();
                        Logging.threads.error((Object)("Startup thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("StartupThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }

    protected static class StartupResetManager
    extends ResetManager {
        protected void performResetLogic(IThreadContext tc) throws ManifoldCFException {
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.resetStartupWorkerStatus();
        }
    }
}

