/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.manifoldcf.agents.interfaces.DocumentIngestStatus;
import org.apache.manifoldcf.agents.interfaces.IncrementalIngesterFactory;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.BlockingDocuments;
import org.apache.manifoldcf.crawler.interfaces.DepthStatistics;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorFactory;
import org.apache.manifoldcf.crawler.system.DocumentQueue;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.QueuedDocument;
import org.apache.manifoldcf.crawler.system.QueuedDocumentSet;
import org.apache.manifoldcf.crawler.system.WorkerResetManager;

public class StufferThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: StufferThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected DocumentQueue documentQueue;
    protected WorkerResetManager resetManager;
    protected int lowestStuffAmt;
    protected int stuffAmt;
    protected int lowWaterMark;
    protected QueueTracker queueTracker;
    protected BlockingDocuments blockingDocuments;

    public StufferThread(DocumentQueue documentQueue, int n, WorkerResetManager resetManager, QueueTracker qt, BlockingDocuments blockingDocuments, float lowWaterFactor, float stuffSizeFactor) throws ManifoldCFException {
        this.documentQueue = documentQueue;
        this.lowWaterMark = (int)(lowWaterFactor * (float)n);
        this.stuffAmt = this.lowestStuffAmt = (int)(stuffSizeFactor * (float)n);
        this.resetManager = resetManager;
        this.queueTracker = qt;
        this.blockingDocuments = blockingDocuments;
        this.setName("Stuffer thread");
        this.setDaemon(true);
        this.setPriority(this.getPriority() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        this.resetManager.registerMe();
        try {
            threadContext = ThreadContextFactory.make();
            mgr = RepositoryConnectionManagerFactory.make(threadContext);
            ingester = IncrementalIngesterFactory.make((IThreadContext)threadContext);
            jobManager = JobManagerFactory.make(threadContext);
            Logging.threads.debug((Object)("Stuffer thread: Low water mark is " + Integer.toString(this.lowWaterMark) + "; amount per stuffing is " + Integer.toString(this.stuffAmt)));
            lastTime = System.currentTimeMillis();
            documentSets = new HashMap<Long, ArrayList<QueuedDocument>>();
            versionMap = new ArrayList<E>();
            jobDescriptionMap = new HashMap<Long, IJobDescription>();
            connectionMap = new HashMap<String, IRepositoryConnection>();
            lastQueueStart = -1L;
            lastQueueEnd = -1L;
            lastQueueFullResults = false;
            while (true) {
                try {
                    block17: while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        this.resetManager.waitForReset(threadContext);
                        isEmpty = this.documentQueue.checkIfEmpty(this.lowWaterMark);
                        if (!isEmpty) {
                            ManifoldCF.sleep((long)1000L);
                            continue;
                        }
                        queueNeededTime = System.currentTimeMillis();
                        Logging.threads.debug((Object)"Document stuffer thread woke up");
                        if (lastQueueFullResults) {
                            if (lastQueueEnd - lastQueueStart >= queueNeededTime - lastQueueEnd) {
                                this.stuffAmt *= 2;
                            } else if (lastQueueEnd - lastQueueStart < 4L * (queueNeededTime - lastQueueEnd)) {
                                this.stuffAmt /= 2;
                                if (this.stuffAmt < this.lowestStuffAmt) {
                                    this.stuffAmt = this.lowestStuffAmt;
                                }
                            }
                        }
                        depthStatistics = new DepthStatistics();
                        lastQueueStart = currentTime = System.currentTimeMillis();
                        descs = jobManager.getNextDocuments(this.stuffAmt, currentTime, currentTime - lastTime, this.blockingDocuments, this.queueTracker.getCurrentStatistics(), depthStatistics);
                        lastQueueEnd = System.currentTimeMillis();
                        v0 = lastQueueFullResults = descs.length == this.stuffAmt;
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        this.queueTracker.assessMinimumDepth(depthStatistics.getBins());
                        lastTime = currentTime;
                        if (Logging.threads.isDebugEnabled()) {
                            Logging.threads.debug((Object)("Stuffer thread: Found " + Integer.toString(descs.length) + " documents to queue"));
                        }
                        if (descs.length == 0) {
                            ManifoldCF.sleep((long)2000L);
                            continue;
                        }
                        jobDescriptionMap.clear();
                        connectionMap.clear();
                        jobs = new IJobDescription[descs.length];
                        connections = new IRepositoryConnection[descs.length];
                        versions = new DocumentIngestStatus[descs.length];
                        outputConnectionNames = new String[descs.length];
                        documentClasses = new String[descs.length];
                        documentIDHashes = new String[descs.length];
                        for (i = 0; i < descs.length; ++i) {
                            dd = descs[i];
                            job = (IJobDescription)jobDescriptionMap.get(dd.getJobID());
                            if (job == null) {
                                job = jobManager.load(dd.getJobID(), true);
                                jobDescriptionMap.put(dd.getJobID(), job);
                            }
                            jobs[i] = job;
                            documentClasses[i] = connectionName = job.getConnectionName();
                            outputConnectionNames[i] = job.getOutputConnectionName();
                            connection = (IRepositoryConnection)connectionMap.get(connectionName);
                            if (connection == null) {
                                connection = mgr.load(connectionName);
                                connectionMap.put(connectionName, connection);
                            }
                            connections[i] = connection;
                            documentIDHashes[i] = dd.getDocumentIdentifierHash();
                        }
                        versions = ingester.getDocumentIngestDataMultiple(outputConnectionNames, documentClasses, documentIDHashes);
                        documentSets.clear();
                        for (i = 0; i < descs.length; ++i) {
                            block38: {
                                jobID = jobs[i].getID();
                                connection = connections[i];
                                try {
                                    connector = RepositoryConnectorFactory.grab(threadContext, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections());
                                    if (connector == null) {
                                        maxDocuments = 1;
                                        binNames = new String[]{""};
                                        break block38;
                                    }
                                    try {
                                        maxDocuments = connector.getMaxDocumentRequest();
                                        binNames = connector.getBinNames(descs[i].getDocumentIdentifier());
                                    }
                                    finally {
                                        RepositoryConnectorFactory.release(connector);
                                    }
                                }
                                catch (ManifoldCFException e) {
                                    if (e.getErrorCode() == 2) {
                                        throw e;
                                    }
                                    Logging.threads.error((Object)("Stuffer thread ManifoldCF Exception thrown: " + e.getMessage() + " - continuing"), (Throwable)e);
                                    maxDocuments = 1;
                                    binNames = new String[]{""};
                                }
                                catch (OutOfMemoryError e) {
                                    System.err.println("agents process ran out of memory - shutting down");
                                    e.printStackTrace(System.err);
                                    System.exit(-200);
                                    maxDocuments = 1;
                                    binNames = new String[]{""};
                                }
                                catch (Throwable e) {
                                    Logging.threads.fatal((Object)("Stuffer thread Throwable thrown: " + e.getMessage() + " - continuing"), e);
                                    maxDocuments = 1;
                                    binNames = new String[]{""};
                                }
                            }
                            qd = new QueuedDocument(descs[i], versions[i], binNames);
                            set = (ArrayList<QueuedDocument>)documentSets.get(jobID);
                            if (set == null) {
                                set = new ArrayList<QueuedDocument>();
                                documentSets.put(jobID, set);
                            }
                            set.add(qd);
                            this.queueTracker.addRecord(binNames);
                            if (set.size() < maxDocuments) continue;
                            qds = new QueuedDocumentSet(set, jobs[i], connections[i]);
                            this.documentQueue.addDocument(qds);
                            set.clear();
                        }
                        i = 0;
                        while (true) {
                            if (i < descs.length) ** break;
                            continue block17;
                            jobID = jobs[i].getID();
                            x = (ArrayList)documentSets.get(jobID);
                            if (x != null && x.size() > 0) {
                                set = new QueuedDocumentSet(x, jobs[i], connections[i]);
                                this.documentQueue.addDocument(set);
                                documentSets.remove(jobID);
                            }
                            ++i;
                        }
                        break;
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        this.documentQueue.reset();
                        Logging.threads.error((Object)("Stuffer thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("StufferThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }
}

