/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.manifoldcf.agents.interfaces.IIncrementalIngester;
import org.apache.manifoldcf.agents.interfaces.IOutputActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputConnector;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.IncrementalIngesterFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorFactory;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.IVersionActivity;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorFactory;
import org.apache.manifoldcf.crawler.system.DocumentQueue;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.QueuedDocument;
import org.apache.manifoldcf.crawler.system.WorkerResetManager;

public class WorkerThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: WorkerThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected String id;
    protected DocumentQueue documentQueue;
    protected WorkerResetManager resetManager;
    protected QueueTracker queueTracker;
    protected static final int MAX_ADDS_IN_TRANSACTION = 20;

    public WorkerThread(String id, DocumentQueue documentQueue, WorkerResetManager resetManager, QueueTracker queueTracker) throws ManifoldCFException {
        this.id = id;
        this.documentQueue = documentQueue;
        this.resetManager = resetManager;
        this.queueTracker = queueTracker;
        this.setName("Worker thread '" + id + "'");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.resetManager.registerMe();
        try {
            threadContext = ThreadContextFactory.make();
            ingester = IncrementalIngesterFactory.make((IThreadContext)threadContext);
            jobManager = JobManagerFactory.make(threadContext);
            connMgr = RepositoryConnectionManagerFactory.make(threadContext);
            outputMgr = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
            fetchList = new ArrayList<DocumentToProcess>();
            versionMap = new HashMap<String, String>();
            finishList = new ArrayList<QueuedDocument>();
            idHashIndexMap = new HashMap<String, Integer>();
            ingesterDeleteList = new ArrayList<String>();
            ingesterDeleteListUnhashed = new ArrayList<String>();
            jobmanagerDeleteList = new ArrayList<QueuedDocument>();
            ingesterCheckList = new ArrayList<String>();
            tempIDHashList = new ArrayList<String>();
            tempIDList = new ArrayList<String>();
            while (true) lbl-1000:
            // 5 sources

            {
                try {
                    block51: while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        this.resetManager.waitForReset(threadContext);
                        qds = this.documentQueue.getDocument(this.queueTracker);
                        if (qds == null) continue;
                        try {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new ManifoldCFException("Interrupted", 2);
                            }
                            job = qds.getJobDescription();
                            jobID = job.getID();
                            if (!jobManager.checkJobActive(jobID)) continue;
                            if (Logging.threads.isDebugEnabled()) {
                                Logging.threads.debug((Object)("Worker thread received " + Integer.toString(qds.getCount()) + " documents"));
                            }
                            connectionName = job.getConnectionName();
                            outputName = job.getOutputConnectionName();
                            spec = job.getSpecification();
                            outputSpec = job.getOutputSpecification();
                            jobType = job.getType();
                            connection = qds.getConnection();
                            outputConnection = outputMgr.load(outputName);
                            ingestLogger = new OutputActivity(connectionName, connMgr, outputName);
                            docIDHashArray = new String[qds.getCount()];
                            docIDArray = new String[qds.getCount()];
                            for (i = 0; i < docIDArray.length; ++i) {
                                qd = qds.getDocument(i);
                                docIDHashArray[i] = qd.getDocumentDescription().getDocumentIdentifierHash();
                                docIDArray[i] = qd.getDocumentDescription().getDocumentIdentifier();
                            }
                            fetchList.clear();
                            finishList.clear();
                            versionMap.clear();
                            ingesterDeleteList.clear();
                            ingesterDeleteListUnhashed.clear();
                            jobmanagerDeleteList.clear();
                            ingesterCheckList.clear();
                            processingStartTime = System.currentTimeMillis();
                            qds.beginProcessing(this.queueTracker);
                            currentTime = System.currentTimeMillis();
                            legalLinkTypes = RepositoryConnectorFactory.getRelationshipTypes(threadContext, connection.getClassName());
                            if (legalLinkTypes == null) {
                                i = 0;
                                while (true) {
                                    if (i >= qds.getCount()) continue block51;
                                    qd = qds.getDocument(i++);
                                    dd = qd.getDocumentDescription();
                                    jobManager.resetDocument(dd, 0L, 0, -1L, -1);
                                    qd.setProcessed();
                                }
                            }
                            currentVersions = new String[docIDHashArray.length];
                            idHashIndexMap.clear();
                            for (z = 0; z < docIDHashArray.length; ++z) {
                                idHashIndexMap.put(docIDHashArray[z], new Integer(z));
                            }
                            currentDocIDHashArray = docIDHashArray;
                            currentDocIDArray = docIDArray;
                            filterMap = job.getHopCountFilters();
                            filterIter = filterMap.keySet().iterator();
                            while (true) {
                                if (filterIter.hasNext()) {
                                    linkType = (String)filterIter.next();
                                    maxHop = (int)((Long)filterMap.get(linkType)).longValue();
                                    results = jobManager.findHopCounts(job.getID(), legalLinkTypes, currentDocIDHashArray, linkType, maxHop, job.getHopcountMode());
                                    tempIDHashList.clear();
                                    tempIDList.clear();
                                    break;
                                }
                                if (Logging.threads.isDebugEnabled()) {
                                    Logging.threads.debug((Object)("Worker thread post-hopcount pruned document count is " + Integer.toString(currentDocIDHashArray.length)));
                                }
                                oldVersionStringArray = new String[currentDocIDHashArray.length];
                                for (z = 0; z < oldVersionStringArray.length; ++z) {
                                    idHashValue = currentDocIDHashArray[z];
                                    qd = qds.getDocument((Integer)idHashIndexMap.get(idHashValue));
                                    dis = qd.getLastIngestedStatus();
                                    if (dis == null) {
                                        oldVersionStringArray[z] = null;
                                        continue;
                                    }
                                    oldVersionStringArray[z] = dis.getDocumentVersion();
                                    if (oldVersionStringArray[z] != null) continue;
                                    oldVersionStringArray[z] = "";
                                }
                                try {
                                    outputVersion = null;
                                    outputConnector = OutputConnectorFactory.grab((IThreadContext)threadContext, (String)outputConnection.getClassName(), (ConfigParams)outputConnection.getConfigParams(), (int)outputConnection.getMaxConnections());
                                    if (outputConnector != null) {
                                        try {
                                            outputVersion = outputConnector.getOutputDescription(outputSpec);
                                        }
                                        finally {
                                            OutputConnectorFactory.release((IOutputConnector)outputConnector);
                                        }
                                    }
                                    if ((connector = RepositoryConnectorFactory.grab(threadContext, connection.getClassName(), connection.getConfigParams(), connection.getMaxConnections())) == null || outputConnector == null) {
                                        i = 0;
                                        while (true) {
                                            if (i >= qds.getCount()) continue block51;
                                            qd = qds.getDocument(i++);
                                            dd = qd.getDocumentDescription();
                                            jobManager.resetDocument(dd, 0L, 0, -1L, -1);
                                            qd.setProcessed();
                                        }
                                    }
                                    if (Thread.currentThread().isInterrupted()) {
                                        throw new ManifoldCFException("Interrupted", 2);
                                    }
                                    abortSet = new HashMap<K, V>();
                                    versionActivity = new VersionActivity(connectionName, connMgr, jobManager, job, ingester, abortSet);
                                    aclAuthority = connection.getACLAuthority();
                                    isDefaultAuthority = aclAuthority == null || aclAuthority.length() == 0;
                                    try {
                                        if (Logging.threads.isDebugEnabled()) {
                                            Logging.threads.debug((Object)("Worker thread getting versions for " + Integer.toString(currentDocIDArray.length) + " documents"));
                                        }
                                        newCurrentVersions = connector.getDocumentVersions(currentDocIDArray, oldVersionStringArray, versionActivity, spec, jobType, isDefaultAuthority);
                                        for (z = 0; z < currentDocIDHashArray.length; ++z) {
                                            currentVersions[((Integer)idHashIndexMap.get((Object)currentDocIDHashArray[z])).intValue()] = newCurrentVersions[z];
                                        }
                                        if (Logging.threads.isDebugEnabled()) {
                                            Logging.threads.debug((Object)("Worker thread done getting versions for " + Integer.toString(currentDocIDArray.length) + " documents"));
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (ServiceInterruption e) {
                                        Logging.jobs.warn((Object)("Pre-ingest service interruption reported for job " + job.getID() + " connection '" + job.getConnectionName() + "': " + e.getMessage()));
                                        i = 0;
                                        while (i < qds.getCount()) {
                                            if ((dd = (qd = qds.getDocument(i++)).getDocumentDescription()).getFailTime() != -1L && dd.getFailTime() < e.getRetryTime() || dd.getFailRetryCount() == 0) {
                                                if (e.isAbortOnFail()) {
                                                    v0 = new StringBuilder().append("Repeated service interruptions - failure getting document version");
                                                    if (e.getCause() != null) {
                                                        v1 = ": " + e.getCause().getMessage();
                                                        throw new ManifoldCFException(v0.append(v1).toString(), e.getCause());
                                                    }
                                                    v1 = "";
                                                    throw new ManifoldCFException(v0.append(v1).toString(), e.getCause());
                                                }
                                                oldDocStatus = qd.getLastIngestedStatus();
                                                documentIDHash = dd.getDocumentIdentifierHash();
                                                if (oldDocStatus != null) {
                                                    ingesterDeleteList.add(documentIDHash);
                                                    ingesterDeleteListUnhashed.add(dd.getDocumentIdentifier());
                                                }
                                                jobmanagerDeleteList.add(qd);
                                                continue;
                                            }
                                            jobManager.resetDocument(dd, e.getRetryTime(), 0, e.getFailTime(), e.getFailRetryCount());
                                            qd.setProcessed();
                                        }
                                        WorkerThread.processDeleteLists(outputName, connector, connection, jobManager, jobmanagerDeleteList, ingester, ingesterDeleteList, ingesterDeleteListUnhashed, job.getID(), legalLinkTypes, ingestLogger, job.getHopcountMode(), this.queueTracker, currentTime);
                                        RepositoryConnectorFactory.release(connector);
                                        qds.endProcessing(this.queueTracker);
                                        i = 0;
                                        while (true) {
                                            if (i >= qds.getCount()) continue block51;
                                            if ((qd = qds.getDocument(i++)).wasProcessed()) continue;
                                            jobManager.resetDocument(qd.getDocumentDescription(), 0L, 0, -1L, -1);
                                        }
                                    }
                                }
                                catch (ManifoldCFException e) {
                                    if (e.getErrorCode() != 5) throw e;
                                    Logging.jobs.warn((Object)("Connection service interruption reported for job " + job.getID() + " connection '" + job.getConnectionName() + "': " + e.getMessage()), (Throwable)e);
                                    i = 0;
                                    while (true) {
                                        if (i >= qds.getCount()) continue block51;
                                        qd = qds.getDocument(i++);
                                        jobManager.resetDocument(qd.getDocumentDescription(), System.currentTimeMillis() + 300000L, 0, -1L, -1);
                                        qd.setProcessed();
                                    }
                                }
                                break;
                            }
                            for (z = 0; z < currentDocIDHashArray.length; ++z) {
                                if (!results[z]) {
                                    currentVersions[((Integer)idHashIndexMap.get((Object)currentDocIDHashArray[z])).intValue()] = null;
                                    continue;
                                }
                                tempIDHashList.add(currentDocIDHashArray[z]);
                                tempIDList.add(currentDocIDArray[z]);
                            }
                            currentDocIDHashArray = new String[tempIDHashList.size()];
                            currentDocIDArray = new String[tempIDList.size()];
                            z = 0;
                            while (true) {
                                if (z >= currentDocIDHashArray.length) ** continue;
                                currentDocIDHashArray[z] = (String)tempIDHashList.get(z);
                                currentDocIDArray[z] = (String)tempIDList.get(z);
                                ++z;
                            }
lbl-1000:
                            // 1 sources

                            {
                                block132: {
                                    block131: {
                                        newOutputVersion = outputVersion;
                                        if (newOutputVersion == null) {
                                            newOutputVersion = "";
                                        }
                                        for (i = 0; i < currentVersions.length; ++i) {
                                            qd = qds.getDocument(i);
                                            dd = qd.getDocumentDescription();
                                            if (abortSet.get(dd.getDocumentIdentifier()) != null) {
                                                finishList.add(qd);
                                                continue;
                                            }
                                            oldDocStatus = qd.getLastIngestedStatus();
                                            documentIDHash = dd.getDocumentIdentifierHash();
                                            newDocVersion = currentVersions[i];
                                            newAuthorityName = aclAuthority;
                                            if (newAuthorityName == null) {
                                                newAuthorityName = "";
                                            }
                                            versionMap.put(dd.getDocumentIdentifierHash(), newDocVersion);
                                            if (newDocVersion == null) {
                                                if (oldDocStatus != null) {
                                                    ingesterDeleteList.add(documentIDHash);
                                                    ingesterDeleteListUnhashed.add(dd.getDocumentIdentifier());
                                                }
                                                jobmanagerDeleteList.add(qd);
                                                continue;
                                            }
                                            finishList.add(qd);
                                            allowIngest = false;
                                            if (oldDocStatus == null) {
                                                allowIngest = true;
                                            } else {
                                                oldDocVersion = oldDocStatus.getDocumentVersion();
                                                if (oldDocVersion == null) {
                                                    oldDocVersion = "";
                                                }
                                                if ((oldAuthorityName = oldDocStatus.getDocumentAuthorityNameString()) == null) {
                                                    oldAuthorityName = "";
                                                }
                                                if ((oldOutputVersion = oldDocStatus.getOutputVersion()) == null) {
                                                    oldOutputVersion = "";
                                                }
                                                if (newDocVersion.length() == 0) {
                                                    allowIngest = true;
                                                } else if (!(oldDocVersion.equals(newDocVersion) && oldAuthorityName.equals(newAuthorityName) && oldOutputVersion.equals(newOutputVersion))) {
                                                    allowIngest = true;
                                                }
                                            }
                                            fetchList.add(new DocumentToProcess(qd, allowIngest == false));
                                            if (allowIngest) continue;
                                            ingesterCheckList.add(documentIDHash);
                                        }
                                        WorkerThread.processDeleteLists(outputName, connector, connection, jobManager, jobmanagerDeleteList, ingester, ingesterDeleteList, ingesterDeleteListUnhashed, job.getID(), legalLinkTypes, ingestLogger, job.getHopcountMode(), this.queueTracker, currentTime);
                                        activity = new ProcessActivity(threadContext, this.queueTracker, jobManager, ingester, currentTime, job, connection, connector, connMgr, legalLinkTypes, ingestLogger, abortSet, outputVersion);
                                        if (fetchList.size() <= 0) break block131;
                                        processIDs = new String[fetchList.size()];
                                        processIDHashes = new String[fetchList.size()];
                                        versions = new String[fetchList.size()];
                                        scanOnly = new boolean[fetchList.size()];
                                        for (i = 0; i < fetchList.size(); ++i) {
                                            dToP = (DocumentToProcess)fetchList.get(i);
                                            dd = dToP.getDocument().getDocumentDescription();
                                            processIDs[i] = dd.getDocumentIdentifier();
                                            processIDHashes[i] = dd.getDocumentIdentifierHash();
                                            versions[i] = (String)versionMap.get(dd.getDocumentIdentifierHash());
                                            scanOnly[i] = dToP.getScanOnly();
                                        }
                                        try {
                                            if (Thread.currentThread().isInterrupted()) {
                                                throw new ManifoldCFException("Interrupted", 2);
                                            }
                                            if (Logging.threads.isDebugEnabled()) {
                                                Logging.threads.debug((Object)("Worker thread about to process " + Integer.toString(processIDs.length) + " documents"));
                                            }
                                            connector.processDocuments(processIDs, versions, activity, job.getSpecification(), scanOnly, jobType);
                                            activity.flush();
                                            requeueCandidates = jobManager.finishDocuments(job.getID(), legalLinkTypes, processIDHashes, job.getHopcountMode());
                                            ManifoldCF.requeueDocumentsDueToCarrydown(jobManager, requeueCandidates, connector, connection, this.queueTracker, currentTime);
                                            if (Logging.threads.isDebugEnabled()) {
                                                Logging.threads.debug((Object)("Worker thread done processing " + Integer.toString(processIDs.length) + " documents"));
                                            }
                                        }
                                        catch (ServiceInterruption e) {
                                            Logging.jobs.warn((Object)("Service interruption reported for job " + job.getID() + " connection '" + job.getConnectionName() + "': " + e.getMessage()));
                                            ingesterDeleteList.clear();
                                            ingesterDeleteListUnhashed.clear();
                                            jobmanagerDeleteList.clear();
                                            requeueList = new ArrayList<QueuedDocument>();
                                            i = 0;
                                            while (i < finishList.size()) {
                                                if ((dd = (qd = (QueuedDocument)finishList.get(i++)).getDocumentDescription()).getFailTime() != -1L && dd.getFailTime() < e.getRetryTime() || dd.getFailRetryCount() == 0) {
                                                    if (e.isAbortOnFail()) {
                                                        v2 = new StringBuilder().append("Repeated service interruptions - failure processing document");
                                                        if (e.getCause() != null) {
                                                            v3 = ": " + e.getCause().getMessage();
                                                            throw new ManifoldCFException(v2.append(v3).toString(), e.getCause());
                                                        }
                                                        v3 = "";
                                                        throw new ManifoldCFException(v2.append(v3).toString(), e.getCause());
                                                    }
                                                    oldDocStatus = qd.getLastIngestedStatus();
                                                    documentIDHash = dd.getDocumentIdentifierHash();
                                                    if (oldDocStatus != null) {
                                                        ingesterDeleteList.add(documentIDHash);
                                                        ingesterDeleteListUnhashed.add(dd.getDocumentIdentifier());
                                                    }
                                                    jobmanagerDeleteList.add(qd);
                                                    continue;
                                                }
                                                requeueList.add(qd);
                                            }
                                            WorkerThread.requeueDocuments(jobManager, requeueList, e.getRetryTime(), e.getFailTime(), e.getFailRetryCount());
                                            WorkerThread.processDeleteLists(outputName, connector, connection, jobManager, jobmanagerDeleteList, ingester, ingesterDeleteList, ingesterDeleteListUnhashed, job.getID(), legalLinkTypes, ingestLogger, job.getHopcountMode(), this.queueTracker, currentTime);
                                            activity.discard();
                                            connector.releaseDocumentVersions(docIDArray, currentVersions);
                                            RepositoryConnectorFactory.release(connector);
                                            qds.endProcessing(this.queueTracker);
                                            i = 0;
                                            while (true) {
                                                if (i >= qds.getCount()) continue block51;
                                                if ((qd = qds.getDocument(i++)).wasProcessed()) continue;
                                                jobManager.resetDocument(qd.getDocumentDescription(), 0L, 0, -1L, -1);
                                            }
                                        }
                                    }
                                    ** try [egrp 18[TRYBLOCK] [12 : 2966->4017)] { 
lbl332:
                                    // 1 sources

                                    ** try [egrp 20[TRYBLOCK] [5 : 2966->3949)] { 
lbl333:
                                    // 1 sources

                                    if (ingesterCheckList.size() > 0) {
                                        checkClasses = new String[ingesterCheckList.size()];
                                        checkIDs = new String[ingesterCheckList.size()];
                                        for (i = 0; i < checkIDs.length; ++i) {
                                            checkClasses[i] = connectionName;
                                            checkIDs[i] = (String)ingesterCheckList.get(i);
                                        }
                                        ingester.documentCheckMultiple(outputName, checkClasses, checkIDs, currentTime);
                                    }
                                    if (finishList.size() > 0) {
                                        switch (job.getType()) {
                                            case 0: {
                                                timeIDClasses = new String[finishList.size()];
                                                timeIDHashes = new String[finishList.size()];
                                                for (i = 0; i < timeIDHashes.length; ++i) {
                                                    qd = (QueuedDocument)finishList.get(i);
                                                    dd = qd.getDocumentDescription();
                                                    documentIDHash = dd.getDocumentIdentifierHash();
                                                    timeIDClasses[i] = connectionName;
                                                    timeIDHashes[i] = documentIDHash;
                                                }
                                                timeArray = ingester.getDocumentUpdateIntervalMultiple(outputName, timeIDClasses, timeIDHashes);
                                                recheckTimeArray = new Long[timeArray.length];
                                                actionArray = new int[timeArray.length];
                                                recrawlDocs = new DocumentDescription[finishList.size()];
                                                for (i = 0; i < finishList.size(); ++i) {
                                                    qd = (QueuedDocument)finishList.get(i);
                                                    recrawlDocs[i] = qd.getDocumentDescription();
                                                    documentID = recrawlDocs[i].getDocumentIdentifier();
                                                    v4 = wasAborted = abortSet.get(documentID) != null;
                                                    if (wasAborted) {
                                                        if (Logging.scheduling.isDebugEnabled()) {
                                                            Logging.scheduling.debug((Object)("Document '" + documentID + "' will be RESCANNED as soon as prerequisites are met"));
                                                        }
                                                        actionArray[i] = 0;
                                                        recheckTimeArray[i] = new Long(0L);
                                                        continue;
                                                    }
                                                    timeAmt = timeArray[i];
                                                    recrawlTime = activity.calculateDocumentRescheduleTime(currentTime, timeAmt, documentID);
                                                    expireTime = activity.calculateDocumentExpireTime(currentTime, documentID);
                                                    if (expireTime == null || recrawlTime != null && recrawlTime < expireTime) {
                                                        if (Logging.scheduling.isDebugEnabled()) {
                                                            Logging.scheduling.debug((Object)("Document '" + documentID + "' will be RESCANNED at " + recrawlTime.toString()));
                                                        }
                                                        recheckTimeArray[i] = recrawlTime;
                                                        actionArray[i] = 0;
                                                        continue;
                                                    }
                                                    if (recrawlTime == null || expireTime != null && recrawlTime > expireTime) {
                                                        if (Logging.scheduling.isDebugEnabled()) {
                                                            Logging.scheduling.debug((Object)("Document '" + documentID + "' will be REMOVED at " + expireTime.toString()));
                                                        }
                                                        recheckTimeArray[i] = expireTime;
                                                        actionArray[i] = 1;
                                                        continue;
                                                    }
                                                    if (Logging.scheduling.isDebugEnabled() && recrawlTime != null) {
                                                        Logging.scheduling.debug((Object)("Document '" + documentID + "' will be RESCANNED at " + recrawlTime.toString()));
                                                    }
                                                    recheckTimeArray[i] = recrawlTime;
                                                    actionArray[i] = 0;
                                                }
                                                jobManager.requeueDocumentMultiple(recrawlDocs, recheckTimeArray, actionArray);
                                                break;
                                            }
                                            case 1: {
                                                completedList = new ArrayList<DocumentDescription>();
                                                abortedList = new ArrayList<DocumentDescription>();
                                                i = 0;
                                                while (i < finishList.size()) {
                                                    if (abortSet.get((dd = (qd = (QueuedDocument)finishList.get(i++)).getDocumentDescription()).getDocumentIdentifier()) != null) {
                                                        abortedList.add(dd);
                                                        continue;
                                                    }
                                                    completedList.add(dd);
                                                }
                                                if (abortedList.size() > 0) {
                                                    docDescriptions = new DocumentDescription[abortedList.size()];
                                                    recheckTimeArray = new Long[docDescriptions.length];
                                                    actionArray = new int[docDescriptions.length];
                                                    for (i = 0; i < docDescriptions.length; ++i) {
                                                        docDescriptions[i] = (DocumentDescription)abortedList.get(i);
                                                        recheckTimeArray[i] = new Long(0L);
                                                        actionArray[i] = 0;
                                                    }
                                                    jobManager.requeueDocumentMultiple(docDescriptions, recheckTimeArray, actionArray);
                                                }
                                                if (completedList.size() <= 0) break;
                                                docDescriptions = new DocumentDescription[completedList.size()];
                                                for (i = 0; i < docDescriptions.length; ++i) {
                                                    docDescriptions[i] = (DocumentDescription)completedList.get(i);
                                                }
                                                jobManager.markDocumentCompletedMultiple(docDescriptions);
                                                break;
                                            }
                                            default: {
                                                throw new ManifoldCFException("Unexpected value for job type: '" + Integer.toString(job.getType()) + "'");
                                            }
                                        }
                                        i = 0;
                                        while (i < finishList.size()) {
                                            qd = (QueuedDocument)finishList.get(i++);
                                            qd.setProcessed();
                                        }
                                    }
                                    break block132;
lbl427:
                                    // 1 sources

                                    finally {
                                        activity.discard();
                                    }
                                }
                                this.queueTracker.noteConnectionPerformance(qds.getCount(), connectionName, System.currentTimeMillis() - processingStartTime);
                                continue;
                            }
lbl435:
                            // 1 sources

                            finally {
                                RepositoryConnectorFactory.release(connector);
                            }
                        }
                        catch (ManifoldCFException e) {
                            if (e.getErrorCode() == 2) {
                            }
                            if (e.getErrorCode() == 4) {
                                throw e;
                            }
                            if (jobManager.errorAbort(qds.getJobDescription().getID(), e.getMessage())) {
                                Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                            }
                        }
                    }
                    finally {
                        i = 0;
                        while (i < qds.getCount()) {
                            if ((qd = qds.getDocument(i++)).wasProcessed()) continue;
                            jobManager.resetDocument(qd.getDocumentDescription(), 0L, 0, -1L, -1);
                        }
                        return;
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) {
                        return;
                    }
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        this.documentQueue.reset();
                        Logging.threads.error((Object)("Worker thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                        }
                        catch (InterruptedException se) {
                            return;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("WorkerThread " + this.id + " initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
        ** GOTO lbl-1000
    }

    protected static boolean compareArrays(String[] array1, String[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i].equals(array2[i])) continue;
            return false;
        }
        return true;
    }

    protected static void processDeleteLists(String outputName, IRepositoryConnector connector, IRepositoryConnection connection, IJobManager jobManager, ArrayList jobmanagerDeleteList, IIncrementalIngester ingester, ArrayList ingesterDeleteList, ArrayList ingesterDeleteListUnhashed, Long jobID, String[] legalLinkTypes, OutputActivity ingestLogger, int hopcountMethod, QueueTracker queueTracker, long currentTime) throws ManifoldCFException {
        String connectionName = connection.getName();
        if (ingesterDeleteList.size() > 0) {
            String[] deleteClasses = new String[ingesterDeleteList.size()];
            String[] deleteIDs = new String[ingesterDeleteList.size()];
            for (int i = 0; i < ingesterDeleteList.size(); ++i) {
                deleteClasses[i] = connectionName;
                deleteIDs[i] = (String)ingesterDeleteList.get(i);
            }
            while (true) {
                try {
                    ingester.documentDeleteMultiple(outputName, deleteClasses, deleteIDs, (IOutputRemoveActivity)ingestLogger);
                    break;
                }
                catch (ServiceInterruption e) {
                    long amt = e.getRetryTime();
                    long now = System.currentTimeMillis();
                    long waittime = amt - now;
                    if (waittime <= 0L) {
                        waittime = 300000L;
                    }
                    try {
                        ManifoldCF.sleep((long)waittime);
                    }
                    catch (InterruptedException e2) {
                        throw new ManifoldCFException("Interrupted: " + e2.getMessage(), (Throwable)e2, 2);
                    }
                }
            }
        }
        if (jobmanagerDeleteList.size() > 0) {
            int i;
            DocumentDescription[] deleteDescriptions = new DocumentDescription[jobmanagerDeleteList.size()];
            for (i = 0; i < deleteDescriptions.length; ++i) {
                QueuedDocument qd = (QueuedDocument)jobmanagerDeleteList.get(i);
                deleteDescriptions[i] = qd.getDocumentDescription();
            }
            DocumentDescription[] requeueCandidates = jobManager.markDocumentDeletedMultiple(jobID, legalLinkTypes, deleteDescriptions, hopcountMethod);
            ManifoldCF.requeueDocumentsDueToCarrydown(jobManager, requeueCandidates, connector, connection, queueTracker, currentTime);
            i = 0;
            while (i < jobmanagerDeleteList.size()) {
                QueuedDocument qd = (QueuedDocument)jobmanagerDeleteList.get(i++);
                qd.setProcessed();
            }
        }
    }

    protected static void requeueDocuments(IJobManager jobManager, ArrayList requeueList, long retryTime, long failTime, int failCount) throws ManifoldCFException {
        if (requeueList.size() > 0) {
            QueuedDocument qd;
            int i;
            DocumentDescription[] requeueDocs = new DocumentDescription[requeueList.size()];
            for (i = 0; i < requeueDocs.length; ++i) {
                DocumentDescription dd;
                qd = (QueuedDocument)requeueList.get(i);
                requeueDocs[i] = dd = qd.getDocumentDescription();
            }
            jobManager.resetDocumentMultiple(requeueDocs, retryTime, 0, failTime, failCount);
            i = 0;
            while (i < requeueList.size()) {
                qd = (QueuedDocument)requeueList.get(i++);
                qd.setProcessed();
            }
        }
    }

    protected static class OutputActivity
    implements IOutputActivity {
        protected String connectionName;
        protected IRepositoryConnectionManager connMgr;
        protected String outputConnectionName;

        public OutputActivity(String connectionName, IRepositoryConnectionManager connMgr, String outputConnectionName) {
            this.connectionName = connectionName;
            this.connMgr = connMgr;
            this.outputConnectionName = outputConnectionName;
        }

        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityURI, String resultCode, String resultDescription) throws ManifoldCFException {
            this.connMgr.recordHistory(this.connectionName, startTime, ManifoldCF.qualifyOutputActivityName(activityType, this.outputConnectionName), dataSize, entityURI, resultCode, resultDescription, null);
        }

        public String qualifyAccessToken(String authorityNameString, String accessToken) throws ManifoldCFException {
            try {
                if (authorityNameString == null) {
                    return URLEncoder.encode(accessToken, "UTF-8");
                }
                return URLEncoder.encode(authorityNameString, "UTF-8") + ":" + URLEncoder.encode(accessToken, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static class DocumentToProcess {
        protected QueuedDocument document;
        protected boolean scanOnly;

        public DocumentToProcess(QueuedDocument document, boolean scanOnly) {
            this.document = document;
            this.scanOnly = scanOnly;
        }

        public QueuedDocument getDocument() {
            return this.document;
        }

        public boolean getScanOnly() {
            return this.scanOnly;
        }
    }

    protected static class DocumentReference {
        protected String localIdentifierHash;
        protected String localIdentifier;
        protected DocumentBin db;
        protected HashMap data = new HashMap();
        protected HashMap prereqEvents = new HashMap();

        public DocumentReference(String localIdentifierHash, String localIdentifier, DocumentBin db) {
            this.localIdentifierHash = localIdentifierHash;
            this.localIdentifier = localIdentifier;
            this.db = db;
        }

        public void discard() throws ManifoldCFException {
            for (String dataName : this.data.keySet()) {
                ArrayList list = (ArrayList)this.data.get(dataName);
                int i = 0;
                while (i < list.size()) {
                    Object o;
                    if (!((o = list.get(i++)) instanceof CharacterInput)) continue;
                    ((CharacterInput)o).discard();
                }
            }
        }

        public void addData(String[] dataNames, Object[][] dataValues) {
            if (dataNames == null || dataValues == null) {
                return;
            }
            for (int i = 0; i < dataNames.length; ++i) {
                this.addData(dataNames[i], dataValues[i]);
            }
        }

        public void addData(String dataName, Object[] dataValues) {
            if (dataName == null || dataValues == null) {
                return;
            }
            int i = 0;
            while (i < dataValues.length) {
                this.addData(dataName, dataValues[i++]);
            }
        }

        public void addData(String dataName, Object dataValue) {
            if (dataName == null) {
                return;
            }
            ArrayList<Object> valueMap = (ArrayList<Object>)this.data.get(dataName);
            if (valueMap == null) {
                valueMap = new ArrayList<Object>();
                this.data.put(dataName, valueMap);
            }
            valueMap.add(dataValue);
        }

        public void addPrerequisiteEvents(String[] eventNames) {
            if (eventNames == null) {
                return;
            }
            int i = 0;
            while (i < eventNames.length) {
                this.addPrerequisiteEvent(eventNames[i++]);
            }
        }

        public void addPrerequisiteEvent(String eventName) {
            this.prereqEvents.put(eventName, eventName);
        }

        public DocumentBin getKey() {
            return this.db;
        }

        public String getLocalIdentifierHash() {
            return this.localIdentifierHash;
        }

        public String getLocalIdentifier() {
            return this.localIdentifier;
        }

        public String[] getPrerequisiteEventNames() {
            String[] rval = new String[this.prereqEvents.size()];
            int i = 0;
            Iterator iter = this.prereqEvents.keySet().iterator();
            while (iter.hasNext()) {
                rval[i++] = (String)iter.next();
            }
            return rval;
        }

        public String[] getDataNames() {
            String[] rval = new String[this.data.size()];
            int i = 0;
            for (String dataName : this.data.keySet()) {
                rval[i++] = dataName;
            }
            return rval;
        }

        public Object[][] getDataValues() {
            Object[][] rval = new Object[this.data.size()][];
            int i = 0;
            for (String dataName : this.data.keySet()) {
                ArrayList values = (ArrayList)this.data.get(dataName);
                Object[] valueArray = new Object[values.size()];
                rval[i] = valueArray;
                for (int j = 0; j < valueArray.length; ++j) {
                    valueArray[j] = values.get(j);
                }
                ++i;
            }
            return rval;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DocumentReference)) {
                return false;
            }
            DocumentReference other = (DocumentReference)o;
            if (!other.localIdentifierHash.equals(this.localIdentifierHash)) {
                return false;
            }
            return other.db.equals(this.db);
        }

        public int hashCode() {
            return this.localIdentifierHash.hashCode() + this.db.hashCode();
        }
    }

    protected static class DocumentBin {
        protected String linkType;
        protected String parentIdentifierHash;

        public DocumentBin(String parentIdentifierHash, String linkType) {
            this.parentIdentifierHash = parentIdentifierHash;
            this.linkType = linkType;
        }

        public String getParentIdentifierHash() {
            return this.parentIdentifierHash;
        }

        public String getLinkType() {
            return this.linkType;
        }

        public int hashCode() {
            return (this.linkType == null ? 0 : this.linkType.hashCode()) + (this.parentIdentifierHash == null ? 0 : this.parentIdentifierHash.hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof DocumentBin)) {
                return false;
            }
            DocumentBin db = (DocumentBin)o;
            if (this.linkType == null || db.linkType == null ? this.linkType != db.linkType : !this.linkType.equals(db.linkType)) {
                return false;
            }
            return !(this.parentIdentifierHash == null || db.parentIdentifierHash == null ? this.parentIdentifierHash != db.parentIdentifierHash : !this.parentIdentifierHash.equals(db.parentIdentifierHash));
        }
    }

    protected static class ProcessActivity
    implements IProcessActivity {
        protected IThreadContext threadContext;
        protected IJobManager jobManager;
        protected IIncrementalIngester ingester;
        protected boolean ingestAllowed;
        protected long currentTime;
        protected IJobDescription job;
        protected IRepositoryConnection connection;
        protected IRepositoryConnector connector;
        protected IRepositoryConnectionManager connMgr;
        protected String[] legalLinkTypes;
        protected OutputActivity ingestLogger;
        protected QueueTracker queueTracker;
        protected HashMap abortSet;
        protected String outputVersion;
        protected HashMap referenceList = new HashMap();
        protected HashMap lowerRescheduleBounds = new HashMap();
        protected HashMap upperRescheduleBounds = new HashMap();
        protected HashMap lowerExpireBounds = new HashMap();
        protected HashMap upperExpireBounds = new HashMap();
        protected HashMap originationTimes = new HashMap();

        public ProcessActivity(IThreadContext threadContext, QueueTracker queueTracker, IJobManager jobManager, IIncrementalIngester ingester, long currentTime, IJobDescription job, IRepositoryConnection connection, IRepositoryConnector connector, IRepositoryConnectionManager connMgr, String[] legalLinkTypes, OutputActivity ingestLogger, HashMap abortSet, String outputVersion) {
            this.threadContext = threadContext;
            this.queueTracker = queueTracker;
            this.jobManager = jobManager;
            this.ingester = ingester;
            this.currentTime = currentTime;
            this.job = job;
            this.connection = connection;
            this.connector = connector;
            this.connMgr = connMgr;
            this.legalLinkTypes = legalLinkTypes;
            this.ingestLogger = ingestLogger;
            this.abortSet = abortSet;
            this.outputVersion = outputVersion;
        }

        public void discard() throws ManifoldCFException {
            for (DocumentReference dr : this.referenceList.keySet()) {
                dr.discard();
            }
            this.referenceList.clear();
        }

        public void addDocumentReference(String localIdentifier, String parentIdentifier, String relationshipType, String[] dataNames, Object[][] dataValues, Long originationTime, String[] prereqEventNames) throws ManifoldCFException {
            Object[][] savedDataValues;
            DocumentReference dr;
            DocumentReference existingDr;
            long currentTime;
            long expireTime;
            Long expireInterval;
            String localIdentifierHash = ManifoldCF.hash((String)localIdentifier);
            String parentIdentifierHash = null;
            if (parentIdentifier != null && parentIdentifier.length() > 0) {
                parentIdentifierHash = ManifoldCF.hash((String)parentIdentifier);
            }
            if (Logging.threads.isDebugEnabled()) {
                Logging.threads.debug((Object)("Adding document reference, from " + (parentIdentifier == null ? "no parent" : "'" + parentIdentifier + "'") + " to '" + localIdentifier + "', relationship type " + (relationshipType == null ? "null" : "'" + relationshipType + "'") + ", with " + (dataNames == null ? "no" : Integer.toString(dataNames.length)) + " data types, origination time=" + (originationTime == null ? "unknown" : originationTime.toString())));
            }
            if ((expireInterval = this.job.getExpiration()) != null && (expireTime = originationTime == null ? currentTime + expireInterval : originationTime + expireInterval) <= (currentTime = System.currentTimeMillis())) {
                if (Logging.threads.isDebugEnabled()) {
                    Logging.threads.debug((Object)("Not adding document reference for '" + localIdentifier + "', since it has already expired"));
                }
                return;
            }
            if (this.referenceList.size() == 20) {
                this.processDocumentReferences();
            }
            if ((existingDr = (DocumentReference)this.referenceList.get(dr = new DocumentReference(localIdentifierHash, localIdentifier, new DocumentBin(parentIdentifierHash, relationshipType)))) == null) {
                this.referenceList.put(dr, dr);
                existingDr = dr;
            }
            if (dataValues != null) {
                savedDataValues = new Object[dataValues.length][];
                for (int q = 0; q < savedDataValues.length; ++q) {
                    Object[] innerArray = dataValues[q];
                    if (innerArray != null) {
                        savedDataValues[q] = new Object[innerArray.length];
                        for (int z = 0; z < innerArray.length; ++z) {
                            Object innerValue = innerArray[z];
                            if (innerValue != null) {
                                if (innerValue instanceof CharacterInput) {
                                    savedDataValues[q][z] = ((CharacterInput)innerValue).transfer();
                                    continue;
                                }
                                savedDataValues[q][z] = innerValue;
                                continue;
                            }
                            savedDataValues[q][z] = null;
                        }
                        continue;
                    }
                    savedDataValues[q] = null;
                }
            } else {
                savedDataValues = null;
            }
            existingDr.addData(dataNames, savedDataValues);
            existingDr.addPrerequisiteEvents(prereqEventNames);
        }

        public void addDocumentReference(String localIdentifier, String parentIdentifier, String relationshipType, String[] dataNames, Object[][] dataValues, Long originationTime) throws ManifoldCFException {
            this.addDocumentReference(localIdentifier, parentIdentifier, relationshipType, dataNames, dataValues, originationTime, null);
        }

        public void addDocumentReference(String localIdentifier, String parentIdentifier, String relationshipType, String[] dataNames, Object[][] dataValues) throws ManifoldCFException {
            this.addDocumentReference(localIdentifier, parentIdentifier, relationshipType, dataNames, dataValues, null);
        }

        public void addDocumentReference(String localIdentifier, String parentIdentifier, String relationshipType) throws ManifoldCFException {
            this.addDocumentReference(localIdentifier, parentIdentifier, relationshipType, null, null);
        }

        public void addDocumentReference(String localIdentifier) throws ManifoldCFException {
            this.addDocumentReference(localIdentifier, null, null, null, null);
        }

        public String[] retrieveParentData(String localIdentifier, String dataName) throws ManifoldCFException {
            return this.jobManager.retrieveParentData(this.job.getID(), ManifoldCF.hash((String)localIdentifier), dataName);
        }

        public CharacterInput[] retrieveParentDataAsFiles(String localIdentifier, String dataName) throws ManifoldCFException {
            return this.jobManager.retrieveParentDataAsFiles(this.job.getID(), ManifoldCF.hash((String)localIdentifier), dataName);
        }

        public void recordDocument(String documentIdentifier, String version) throws ManifoldCFException, ServiceInterruption {
            String documentIdentifierHash = ManifoldCF.hash((String)documentIdentifier);
            this.ingester.documentRecord(this.job.getOutputConnectionName(), this.job.getConnectionName(), documentIdentifierHash, version, this.currentTime, (IOutputActivity)this.ingestLogger);
        }

        public void ingestDocument(String documentIdentifier, String version, String documentURI, RepositoryDocument data) throws ManifoldCFException, ServiceInterruption {
            String documentIdentifierHash = ManifoldCF.hash((String)documentIdentifier);
            this.ingester.documentIngest(this.job.getOutputConnectionName(), this.job.getConnectionName(), documentIdentifierHash, version, this.outputVersion, this.connection.getACLAuthority(), data, this.currentTime, documentURI, (IOutputActivity)this.ingestLogger);
        }

        public void deleteDocument(String documentIdentifier) throws ManifoldCFException, ServiceInterruption {
            String documentIdentifierHash = ManifoldCF.hash((String)documentIdentifier);
            this.ingester.documentDelete(this.job.getOutputConnectionName(), this.job.getConnectionName(), documentIdentifierHash, (IOutputRemoveActivity)this.ingestLogger);
        }

        public void setDocumentScheduleBounds(String localIdentifier, Long lowerRecrawlBoundTime, Long upperRecrawlBoundTime, Long lowerExpireBoundTime, Long upperExpireBoundTime) throws ManifoldCFException {
            if (lowerRecrawlBoundTime != null) {
                this.lowerRescheduleBounds.put(localIdentifier, lowerRecrawlBoundTime);
            } else {
                this.lowerRescheduleBounds.remove(localIdentifier);
            }
            if (upperRecrawlBoundTime != null) {
                this.upperRescheduleBounds.put(localIdentifier, upperRecrawlBoundTime);
            } else {
                this.upperRescheduleBounds.remove(localIdentifier);
            }
            if (lowerExpireBoundTime != null) {
                this.lowerExpireBounds.put(localIdentifier, lowerExpireBoundTime);
            } else {
                this.lowerExpireBounds.remove(localIdentifier);
            }
            if (upperExpireBoundTime != null) {
                this.upperExpireBounds.put(localIdentifier, upperExpireBoundTime);
            } else {
                this.upperExpireBounds.remove(localIdentifier);
            }
        }

        public void setDocumentOriginationTime(String localIdentifier, Long originationTime) throws ManifoldCFException {
            if (originationTime == null) {
                this.originationTimes.remove(localIdentifier);
            } else {
                this.originationTimes.put(localIdentifier, originationTime);
            }
        }

        public Long getDocumentRescheduleLowerBoundTime(String localIdentifier) {
            return (Long)this.lowerRescheduleBounds.get(localIdentifier);
        }

        public Long getDocumentRescheduleUpperBoundTime(String localIdentifier) {
            return (Long)this.upperRescheduleBounds.get(localIdentifier);
        }

        public Long getDocumentExpirationLowerBoundTime(String localIdentifier) {
            return (Long)this.lowerExpireBounds.get(localIdentifier);
        }

        public Long getDocumentExpirationUpperBoundTime(String localIdentifier) {
            return (Long)this.upperExpireBounds.get(localIdentifier);
        }

        public Long getDocumentOriginationTime(String localIdentifier) {
            return (Long)this.originationTimes.get(localIdentifier);
        }

        public Long calculateDocumentRescheduleTime(long currentTime, long timeAmt, String localIdentifier) {
            Long upperBound;
            Long lowerBound;
            Long recrawlTime = null;
            Long recrawlInterval = this.job.getInterval();
            if (recrawlInterval != null) {
                recrawlTime = new Long(currentTime + timeAmt + recrawlInterval);
            }
            if (Logging.scheduling.isDebugEnabled()) {
                Logging.scheduling.debug((Object)("Default rescan time for document '" + localIdentifier + "' is " + (recrawlTime == null ? "NEVER" : recrawlTime.toString())));
            }
            if ((lowerBound = this.getDocumentRescheduleLowerBoundTime(localIdentifier)) != null && (recrawlTime == null || recrawlTime < lowerBound)) {
                recrawlTime = lowerBound;
                if (Logging.scheduling.isDebugEnabled()) {
                    Logging.scheduling.debug((Object)(" Rescan time overridden for document '" + localIdentifier + "' due to lower bound; new value is " + recrawlTime.toString()));
                }
            }
            if ((upperBound = this.getDocumentRescheduleUpperBoundTime(localIdentifier)) != null && (recrawlTime == null || recrawlTime > upperBound)) {
                recrawlTime = upperBound;
                if (Logging.scheduling.isDebugEnabled()) {
                    Logging.scheduling.debug((Object)(" Rescan time overridden for document '" + localIdentifier + "' due to upper bound; new value is " + recrawlTime.toString()));
                }
            }
            return recrawlTime;
        }

        public Long calculateDocumentExpireTime(long currentTime, String localIdentifier) {
            Long upperBound;
            Long lowerBound;
            Long originationTime = this.getDocumentOriginationTime(localIdentifier);
            if (originationTime == null) {
                originationTime = new Long(currentTime);
            }
            Long expireInterval = this.job.getExpiration();
            Long expireTime = null;
            if (expireInterval != null) {
                expireTime = new Long(originationTime + expireInterval);
            }
            if ((lowerBound = this.getDocumentExpirationLowerBoundTime(localIdentifier)) != null && (expireTime == null || expireTime < lowerBound)) {
                expireTime = lowerBound;
            }
            if ((upperBound = this.getDocumentExpirationUpperBoundTime(localIdentifier)) != null && (expireTime == null || expireTime > upperBound)) {
                expireTime = upperBound;
            }
            return expireTime;
        }

        public void resetTimes() {
            this.lowerRescheduleBounds.clear();
            this.upperRescheduleBounds.clear();
            this.lowerExpireBounds.clear();
            this.upperExpireBounds.clear();
        }

        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityIdentifier, String resultCode, String resultDescription, String[] childIdentifiers) throws ManifoldCFException {
            this.connMgr.recordHistory(this.connection.getName(), startTime, activityType, dataSize, entityIdentifier, resultCode, resultDescription, childIdentifiers);
        }

        public void flush() throws ManifoldCFException {
            this.processDocumentReferences();
        }

        protected void processDocumentReferences() throws ManifoldCFException {
            if (this.referenceList.size() == 0) {
                return;
            }
            HashMap<DocumentBin, ArrayList<DocumentReference>> linkBins = new HashMap<DocumentBin, ArrayList<DocumentReference>>();
            for (DocumentReference dr : this.referenceList.keySet()) {
                DocumentBin key = dr.getKey();
                ArrayList<DocumentReference> set = (ArrayList<DocumentReference>)linkBins.get(key);
                if (set == null) {
                    set = new ArrayList<DocumentReference>();
                    linkBins.put(key, set);
                }
                set.add(dr);
            }
            for (DocumentBin db : linkBins.keySet()) {
                String[] bins;
                int j;
                ArrayList set = (ArrayList)linkBins.get(db);
                String[] docidHashes = new String[set.size()];
                String[] docids = new String[set.size()];
                double[] priorities = new double[set.size()];
                String[][] binNames = new String[set.size()][];
                String[][] dataNames = new String[docids.length][];
                Object[][][] dataValues = new Object[docids.length][][];
                String[][] eventNames = new String[docids.length][];
                long currentTime = System.currentTimeMillis();
                for (j = 0; j < docidHashes.length; ++j) {
                    DocumentReference dr = (DocumentReference)set.get(j);
                    docidHashes[j] = dr.getLocalIdentifierHash();
                    docids[j] = dr.getLocalIdentifier();
                    dataNames[j] = dr.getDataNames();
                    dataValues[j] = dr.getDataValues();
                    eventNames[j] = dr.getPrerequisiteEventNames();
                    bins = ManifoldCF.calculateBins(this.connector, dr.getLocalIdentifier());
                    binNames[j] = bins;
                    priorities[j] = this.queueTracker.calculatePriority(bins, this.connection);
                    if (!Logging.scheduling.isDebugEnabled()) continue;
                    Logging.scheduling.debug((Object)("Assigning '" + docids[j] + "' priority " + new Double(priorities[j]).toString()));
                }
                boolean[] trackerNote = this.jobManager.addDocuments(this.job.getID(), this.legalLinkTypes, docidHashes, docids, db.getParentIdentifierHash(), db.getLinkType(), this.job.getHopcountMode(), dataNames, dataValues, currentTime, priorities, eventNames);
                for (j = 0; j < trackerNote.length; ++j) {
                    if (trackerNote[j]) continue;
                    bins = binNames[j];
                    this.queueTracker.notePriorityNotUsed(bins, this.connection, priorities[j]);
                }
            }
            this.discard();
        }

        public void checkJobStillActive() throws ManifoldCFException, ServiceInterruption {
            if (!this.jobManager.checkJobActive(this.job.getID())) {
                throw new ServiceInterruption("Job no longer active", System.currentTimeMillis());
            }
        }

        public boolean beginEventSequence(String eventName) throws ManifoldCFException {
            return this.jobManager.beginEventSequence(eventName);
        }

        public void completeEventSequence(String eventName) throws ManifoldCFException {
            this.jobManager.completeEventSequence(eventName);
        }

        public void retryDocumentProcessing(String localIdentifier) throws ManifoldCFException {
            this.abortSet.put(localIdentifier, localIdentifier);
        }

        public boolean checkMimeTypeIndexable(String mimeType) throws ManifoldCFException, ServiceInterruption {
            return this.ingester.checkMimeTypeIndexable(this.job.getOutputConnectionName(), mimeType);
        }

        public boolean checkDocumentIndexable(File localFile) throws ManifoldCFException, ServiceInterruption {
            return this.ingester.checkDocumentIndexable(this.job.getOutputConnectionName(), localFile);
        }

        public String createGlobalString(String simpleString) {
            return ManifoldCF.createGlobalString(simpleString);
        }

        public String createConnectionSpecificString(String simpleString) {
            return ManifoldCF.createConnectionSpecificString(this.connection.getName(), simpleString);
        }

        public String createJobSpecificString(String simpleString) {
            return ManifoldCF.createJobSpecificString(this.job.getID(), simpleString);
        }
    }

    protected static class VersionActivity
    implements IVersionActivity {
        protected String connectionName;
        protected IRepositoryConnectionManager connMgr;
        protected IJobManager jobManager;
        protected Long jobID;
        protected IJobDescription job;
        protected IIncrementalIngester ingester;
        protected HashMap abortSet;

        public VersionActivity(String connectionName, IRepositoryConnectionManager connMgr, IJobManager jobManager, IJobDescription job, IIncrementalIngester ingester, HashMap abortSet) {
            this.connectionName = connectionName;
            this.connMgr = connMgr;
            this.jobManager = jobManager;
            this.job = job;
            this.ingester = ingester;
            this.abortSet = abortSet;
        }

        public boolean checkMimeTypeIndexable(String mimeType) throws ManifoldCFException, ServiceInterruption {
            return this.ingester.checkMimeTypeIndexable(this.job.getOutputConnectionName(), mimeType);
        }

        public boolean checkDocumentIndexable(File localFile) throws ManifoldCFException, ServiceInterruption {
            return this.ingester.checkDocumentIndexable(this.job.getOutputConnectionName(), localFile);
        }

        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityIdentifier, String resultCode, String resultDescription, String[] childIdentifiers) throws ManifoldCFException {
            this.connMgr.recordHistory(this.connectionName, startTime, activityType, dataSize, entityIdentifier, resultCode, resultDescription, childIdentifiers);
        }

        public String[] retrieveParentData(String localIdentifier, String dataName) throws ManifoldCFException {
            return this.jobManager.retrieveParentData(this.job.getID(), ManifoldCF.hash((String)localIdentifier), dataName);
        }

        public CharacterInput[] retrieveParentDataAsFiles(String localIdentifier, String dataName) throws ManifoldCFException {
            return this.jobManager.retrieveParentDataAsFiles(this.job.getID(), ManifoldCF.hash((String)localIdentifier), dataName);
        }

        public void checkJobStillActive() throws ManifoldCFException, ServiceInterruption {
            if (!this.jobManager.checkJobActive(this.job.getID())) {
                throw new ServiceInterruption("Job no longer active", System.currentTimeMillis());
            }
        }

        public boolean beginEventSequence(String eventName) throws ManifoldCFException {
            return this.jobManager.beginEventSequence(eventName);
        }

        public void completeEventSequence(String eventName) throws ManifoldCFException {
            this.jobManager.completeEventSequence(eventName);
        }

        public void retryDocumentProcessing(String localIdentifier) throws ManifoldCFException {
            this.abortSet.put(localIdentifier, localIdentifier);
        }

        public String createGlobalString(String simpleString) {
            return ManifoldCF.createGlobalString(simpleString);
        }

        public String createConnectionSpecificString(String simpleString) {
            return ManifoldCF.createConnectionSpecificString(this.connectionName, simpleString);
        }

        public String createJobSpecificString(String simpleString) {
            return ManifoldCF.createJobSpecificString(this.jobID, simpleString);
        }
    }
}

