/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.gts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.common.Base64;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class HttpPoster {
    public static final String _rcsid = "@(#)$Id: HttpPoster.java 988245 2010-08-23 18:39:35Z kwright $";
    public static String ingestBufferSizeProperty = "org.apache.manifoldcf.ingest.buffersize";
    public static String ingestCredentialsRealm = "org.apache.manifoldcf.ingest.credentialrealm";
    public static String ingestResponseRetryCount = "org.apache.manifoldcf.ingest.responseretrycount";
    public static String ingestResponseRetryInterval = "org.apache.manifoldcf.ingest.retryinterval";
    public static String ingestRescheduleInterval = "org.apache.manifoldcf.ingest.rescheduleinterval";
    public static String ingestURIProperty = "org.apache.manifoldcf.ingest.uri";
    public static String ingestUserProperty = "org.apache.manifoldcf.ingest.user";
    public static String ingestPasswordProperty = "org.apache.manifoldcf.ingest.password";
    public static String ingestMaxConnectionsProperty = "org.apache.manifoldcf.ingest.maxconnections";
    protected static final int HEADER_CHUNK = 4096;
    private String encodedCredentials = null;
    private String realm = null;
    private String postURI = null;
    private URL url = null;
    private URL deleteURL = null;
    private URL infoURL = null;
    private String host = null;
    private int port = 80;
    private String protocol = null;
    private int buffersize = 32768;
    double sizeCoefficient = 5.0E-4;
    int responseRetries = 9000;
    long responseRetryWait = 20L;
    long interruptionRetryTime = 60000L;
    protected static SSLSocketFactory secureSocketFactory = null;

    public HttpPoster(String realm, String userID, String password, String postURI) throws ManifoldCFException {
        String x;
        if (userID != null && userID.length() > 0 && password != null) {
            try {
                this.encodedCredentials = new Base64().encodeByteArray((userID + ":" + password).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new ManifoldCFException("Couldn't convert to utf-8 bytes", (Throwable)e);
            }
            this.realm = realm;
        }
        this.postURI = postURI;
        try {
            this.url = new URL(postURI);
            this.deleteURL = new URL(postURI + "?DELETE");
            this.infoURL = new URL(postURI + "?STATUS");
        }
        catch (MalformedURLException murl) {
            throw new ManifoldCFException("Bad url", (Throwable)murl);
        }
        this.port = this.url.getPort();
        this.host = this.url.getHost();
        this.protocol = this.url.getProtocol();
        if (this.port == -1) {
            this.port = this.protocol.equalsIgnoreCase("https") ? 443 : 80;
        }
        if ((x = ManifoldCF.getProperty((String)ingestBufferSizeProperty)) != null && x.length() > 0) {
            this.buffersize = new Integer(x);
        }
        if ((x = ManifoldCF.getProperty((String)ingestResponseRetryCount)) != null && x.length() > 0) {
            this.responseRetries = new Integer(x);
        }
        if ((x = ManifoldCF.getProperty((String)ingestResponseRetryInterval)) != null && x.length() > 0) {
            this.responseRetryWait = new Long(x);
        }
        if ((x = ManifoldCF.getProperty((String)ingestRescheduleInterval)) != null && x.length() > 0) {
            this.interruptionRetryTime = new Long(x);
        }
    }

    public boolean indexPost(String documentURI, String[] collections, String documentTemplate, String authorityNameString, RepositoryDocument document, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption {
        StringBuffer aclXml = new StringBuffer();
        HttpPoster.writeACLs(aclXml, "share", document.getShareACL(), document.getShareDenyACL(), authorityNameString, activities);
        int directoryCount = document.countDirectoryACLs();
        for (int q = 0; q < directoryCount; ++q) {
            HttpPoster.writeACLs(aclXml, "directory", document.getDirectoryACL(q), document.getDirectoryDenyACL(q), authorityNameString, activities);
        }
        HttpPoster.writeACLs(aclXml, "file", document.getACL(), document.getDenyACL(), authorityNameString, activities);
        if (aclXml.length() > 0) {
            aclXml.append("</document-acl>");
        }
        String aclXmlString = aclXml.toString();
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)("indexPost(): '" + documentURI + "'"));
        }
        boolean readFromDocumentStreamYet = false;
        int ioErrorRetry = 3;
        while (true) {
            block18: {
                try {
                    IngestThread t = new IngestThread(documentURI, aclXmlString, collections, documentTemplate, document);
                    try {
                        t.start();
                        t.join();
                        if (t.getActivityCode() != null) {
                            activities.recordActivity(t.getActivityStart(), "document ingest", t.getActivityBytes(), documentURI, t.getActivityCode(), t.getActivityDetails());
                        }
                        readFromDocumentStreamYet = readFromDocumentStreamYet || t.getReadFromDocumentStreamYet();
                        Throwable thr = t.getException();
                        if (thr != null) {
                            if (thr instanceof ServiceInterruption) {
                                throw (ServiceInterruption)thr;
                            }
                            if (thr instanceof ManifoldCFException) {
                                throw (ManifoldCFException)thr;
                            }
                            if (thr instanceof IOException) {
                                throw (IOException)thr;
                            }
                            if (thr instanceof RuntimeException) {
                                throw (RuntimeException)thr;
                            }
                            throw (Error)thr;
                        }
                        return t.getRval();
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
                    }
                }
                catch (SocketTimeoutException ioe) {
                    if (readFromDocumentStreamYet || ioErrorRetry == 0) {
                        long currentTime = System.currentTimeMillis();
                        throw new ServiceInterruption("IO error connecting to ingestion API: " + ioe.getMessage() + "; ingestion will be retried again later", (Throwable)ioe, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                    }
                }
                catch (IOException ioe) {
                    if (!readFromDocumentStreamYet && ioErrorRetry != 0) break block18;
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("IO error ingesting document: " + ioe.getMessage() + "; ingestion will be retried again later", (Throwable)ioe, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                }
            }
            try {
                ManifoldCF.sleep((long)10000L);
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
            }
            --ioErrorRetry;
        }
    }

    protected static void writeACLs(StringBuffer aclXml, String type, String[] acl, String[] denyAcl, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException {
        if (acl != null && acl.length > 0 || denyAcl != null && denyAcl.length > 0) {
            int i;
            if (aclXml.length() == 0) {
                aclXml.append("<document-acl>");
            }
            aclXml.append("<acl scope=\"").append(type).append("\">");
            if (acl != null) {
                for (i = 0; i < acl.length; ++i) {
                    if (Logging.ingest.isDebugEnabled()) {
                        Logging.ingest.debug((Object)("Adding " + type + " ACL: " + acl[i]));
                    }
                    aclXml.append("<allow>");
                    aclXml.append(activities.qualifyAccessToken(authorityNameString, acl[i]));
                    aclXml.append("</allow>");
                }
            }
            if (denyAcl != null) {
                for (i = 0; i < denyAcl.length; ++i) {
                    if (Logging.ingest.isDebugEnabled()) {
                        Logging.ingest.debug((Object)("Adding " + type + " deny ACL: " + denyAcl[i]));
                    }
                    aclXml.append("<deny>");
                    aclXml.append(activities.qualifyAccessToken(authorityNameString, denyAcl[i]));
                    aclXml.append("</deny>");
                }
            }
            aclXml.append("</acl>");
        }
    }

    public void checkPost() throws ManifoldCFException, ServiceInterruption {
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)"checkPost()");
        }
        int ioErrorRetry = 5;
        while (true) {
            try {
                StatusThread t = new StatusThread();
                try {
                    t.start();
                    t.join();
                    Throwable thr = t.getException();
                    if (thr != null) {
                        if (thr instanceof ServiceInterruption) {
                            throw (ServiceInterruption)thr;
                        }
                        if (thr instanceof ManifoldCFException) {
                            throw (ManifoldCFException)thr;
                        }
                        if (thr instanceof IOException) {
                            throw (IOException)thr;
                        }
                        if (thr instanceof RuntimeException) {
                            throw (RuntimeException)thr;
                        }
                        throw (Error)thr;
                    }
                    return;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
                }
            }
            catch (IOException ioe) {
                if (ioErrorRetry == 0) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("IO exception checking: " + ioe.getMessage(), (Throwable)ioe, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                }
                try {
                    ManifoldCF.sleep((long)10000L);
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                --ioErrorRetry;
                continue;
            }
            break;
        }
    }

    public void deletePost(String documentURI, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)("deletePost(): '" + documentURI + "'"));
        }
        int ioErrorRetry = 5;
        while (true) {
            try {
                DeleteThread t = new DeleteThread(documentURI);
                try {
                    Throwable thr;
                    t.start();
                    t.join();
                    if (t.getActivityCode() != null) {
                        activities.recordActivity(t.getActivityStart(), "document deletion", null, documentURI, t.getActivityCode(), t.getActivityDetails());
                    }
                    if ((thr = t.getException()) != null) {
                        if (thr instanceof ServiceInterruption) {
                            throw (ServiceInterruption)thr;
                        }
                        if (thr instanceof ManifoldCFException) {
                            throw (ManifoldCFException)thr;
                        }
                        if (thr instanceof IOException) {
                            throw (IOException)thr;
                        }
                        if (thr instanceof RuntimeException) {
                            throw (RuntimeException)thr;
                        }
                        throw (Error)thr;
                    }
                    return;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
                }
            }
            catch (IOException ioe) {
                if (ioErrorRetry == 0) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("IO exception deleting: " + ioe.getMessage() + "; deletion will be retried again later", (Throwable)ioe, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                }
                try {
                    ManifoldCF.sleep((long)10000L);
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                --ioErrorRetry;
                continue;
            }
            break;
        }
    }

    protected String getResponse(BufferedReader stream) throws ManifoldCFException, ServiceInterruption {
        Logging.ingest.debug((Object)"Waiting for response stream");
        StringBuffer res = new StringBuffer();
        try {
            int i;
            while ((i = stream.read()) != -1) {
                res.append((char)i);
            }
            Logging.ingest.debug((Object)"Read of response stream complete");
        }
        catch (SocketTimeoutException e) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Ingestion API socket timeout exception waiting for response code: " + e.getMessage() + "; ingestion will be retried again later", (Throwable)e, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted", 2);
        }
        catch (ConnectException e) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Timed out connecting to ingestion API: " + e.getMessage() + "; ingestion will be retried again later", (Throwable)e, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
        }
        catch (SocketException e) {
            return "HTTP/1.0 400 Connection Reset";
        }
        catch (IOException ioe) {
            Logging.ingest.warn((Object)("IO exception trying to get response from ingestion API: " + ioe.getMessage()), (Throwable)ioe);
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("IO exception waiting for response code: " + ioe.getMessage() + "; ingestion will be retried again later", (Throwable)ioe, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
        }
        return res.toString();
    }

    protected void writeCredentials(OutputStream out) throws IOException {
        if (this.encodedCredentials != null) {
            Logging.ingest.debug((Object)"Applying credentials");
            byte[] tmp = ("Authorization: Basic " + this.encodedCredentials + "\r\n").getBytes("UTF-8");
            out.write(tmp, 0, tmp.length);
            tmp = ("WWW-Authenticate: Basic realm=\"" + (this.realm != null ? this.realm : "") + "\"\r\n").getBytes("UTF-8");
            out.write(tmp, 0, tmp.length);
        }
    }

    protected static String metadataEncode(String inputString) {
        StringBuffer rval = new StringBuffer();
        int i = 0;
        while (i < inputString.length()) {
            char x;
            if ((x = inputString.charAt(i++)) < ' ' || x > '\u007f') continue;
            if (x == '\\' || x == ',') {
                rval.append('\\');
            }
            rval.append(x);
        }
        return rval.toString();
    }

    protected static SSLSocketFactory getSecureSocketFactory() throws ManifoldCFException {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new LaxTrustManager[]{new LaxTrustManager()}, secureRandom);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ManifoldCFException("No such algorithm", (Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new ManifoldCFException("Key management exception", (Throwable)e);
        }
    }

    protected Socket createSocket(long responseRetryCount) throws IOException, ManifoldCFException {
        Socket socket;
        if (this.protocol.equals("https")) {
            try {
                SocketFactory factory = SSLSocketFactory.getDefault();
                socket = factory.createSocket(this.host, this.port);
            }
            catch (InterruptedIOException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ManifoldCFException("Couldn't set up SSL connection to ingestion API: " + e.getMessage(), (Throwable)e);
            }
        } else {
            socket = new Socket(this.host, this.port);
        }
        long timeoutMilliseconds = this.responseRetryWait * responseRetryCount;
        socket.setSoTimeout((int)timeoutMilliseconds);
        return socket;
    }

    static {
        try {
            secureSocketFactory = HttpPoster.getSecureSocketFactory();
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    protected static class CodeDetails {
        protected String code = "-100";
        protected int codeValue = -100;
        protected String details = "Http response was improperly formed";

        public CodeDetails(String res) {
            int secondSpace;
            int firstSpace = res.indexOf(" ");
            if (firstSpace != -1 && (secondSpace = res.indexOf(" ", firstSpace + 1)) != -1) {
                this.code = res.substring(firstSpace + 1, secondSpace);
                this.details = res.substring(secondSpace + 1).trim();
                try {
                    this.codeValue = (int)new Double(this.code).doubleValue();
                    if (this.codeValue == 200) {
                        this.details = null;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }

        public String getCode() {
            return this.code;
        }

        public int getCodeValue() {
            return this.codeValue;
        }

        public String getDetails() {
            return this.details;
        }
    }

    protected class StatusThread
    extends Thread {
        protected Throwable exception = null;

        public StatusThread() {
            this.setDaemon(true);
        }

        public void run() {
            try {
                try {
                    Socket socket = HttpPoster.this.createSocket(HttpPoster.this.responseRetries);
                    try {
                        InputStreamReader isr = new InputStreamReader(socket.getInputStream(), "ASCII");
                        try {
                            BufferedReader in = new BufferedReader(isr);
                            try {
                                OutputStream out = socket.getOutputStream();
                                try {
                                    CodeDetails cd;
                                    int codeValue;
                                    byte[] tmp = ("GET " + HttpPoster.this.infoURL.getFile() + " HTTP/1.0\r\n").getBytes("UTF-8");
                                    out.write(tmp, 0, tmp.length);
                                    HttpPoster.this.writeCredentials(out);
                                    tmp = "Content-length: 0\r\n\n".getBytes("UTF-8");
                                    out.write(tmp, 0, tmp.length);
                                    if (Logging.ingest.isDebugEnabled()) {
                                        Logging.ingest.debug((Object)"Status request posted");
                                    }
                                    out.flush();
                                    String res = HttpPoster.this.getResponse(in);
                                    if (Logging.ingest.isDebugEnabled()) {
                                        Logging.ingest.debug((Object)("Response code from delete: '" + res + "'"));
                                    }
                                    if ((codeValue = (cd = new CodeDetails(res)).getCodeValue()) < 0) {
                                        throw new ManifoldCFException("Http protocol error");
                                    }
                                    if (codeValue == 200) {
                                        return;
                                    }
                                    if (codeValue == 401) {
                                        throw new ManifoldCFException("Bad credentials for ingestion", 3);
                                    }
                                    throw new ManifoldCFException("Error connecting to MetaCarta ingestion API: '" + res + "'");
                                }
                                finally {
                                    out.close();
                                }
                            }
                            finally {
                                in.close();
                            }
                        }
                        finally {
                            isr.close();
                        }
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (InterruptedIOException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            Logging.ingest.debug((Object)("Error closing socket: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                catch (UnsupportedEncodingException ioe) {
                    throw new ManifoldCFException("Fatal ingestion error: " + ioe.getMessage(), (Throwable)ioe);
                }
                catch (InterruptedIOException ioe) {
                    return;
                }
                catch (IOException ioe) {
                    Logging.ingest.warn((Object)("Error communicating with Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                    throw ioe;
                }
            }
            catch (Throwable e) {
                this.exception = e;
                return;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class DeleteThread
    extends Thread {
        protected String documentURI;
        protected Long activityStart = null;
        protected String activityCode = null;
        protected String activityDetails = null;
        protected Throwable exception = null;

        public DeleteThread(String documentURI) {
            this.setDaemon(true);
            this.documentURI = documentURI;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                long fullStartTime = System.currentTimeMillis();
                try {
                    Socket socket = HttpPoster.this.createSocket(HttpPoster.this.responseRetries);
                    try {
                        InputStreamReader isr = new InputStreamReader(socket.getInputStream(), "ASCII");
                        try {
                            BufferedReader in = new BufferedReader(isr);
                            try {
                                OutputStream out = socket.getOutputStream();
                                try {
                                    String res;
                                    long startTime = System.currentTimeMillis();
                                    byte[] tmp = ("POST " + HttpPoster.this.deleteURL.getFile() + " HTTP/1.0\r\n").getBytes("UTF-8");
                                    out.write(tmp, 0, tmp.length);
                                    tmp = ("Document-URI: " + this.documentURI + "\r\n").getBytes("UTF-8");
                                    out.write(tmp, 0, tmp.length);
                                    HttpPoster.this.writeCredentials(out);
                                    tmp = "Content-length: 0\r\n\n".getBytes("UTF-8");
                                    out.write(tmp, 0, tmp.length);
                                    if (Logging.ingest.isDebugEnabled()) {
                                        Logging.ingest.debug((Object)"Delete posted");
                                    }
                                    out.flush();
                                    try {
                                        res = HttpPoster.this.getResponse(in);
                                    }
                                    catch (ServiceInterruption si) {
                                        this.activityStart = new Long(startTime);
                                        this.activityCode = "-2";
                                        this.activityDetails = si.getMessage();
                                        throw si;
                                    }
                                    if (Logging.ingest.isDebugEnabled()) {
                                        Logging.ingest.debug((Object)("Response code from delete: '" + res + "'"));
                                    }
                                    CodeDetails cd = new CodeDetails(res);
                                    this.activityStart = new Long(startTime);
                                    this.activityCode = cd.getCode();
                                    this.activityDetails = cd.getDetails();
                                    int codeValue = cd.getCodeValue();
                                    if (codeValue < 0) {
                                        throw new ManifoldCFException("Http protocol error");
                                    }
                                    if (codeValue == 200) {
                                        return;
                                    }
                                    if (codeValue == 401) {
                                        throw new ManifoldCFException("Bad credentials for ingestion", 3);
                                    }
                                    if (codeValue < 400) throw new ManifoldCFException("Error deleting document: '" + res + "'");
                                    if (codeValue >= 500) throw new ManifoldCFException("Error deleting document: '" + res + "'");
                                    return;
                                }
                                finally {
                                    out.close();
                                }
                            }
                            finally {
                                in.close();
                            }
                        }
                        finally {
                            isr.close();
                        }
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (InterruptedIOException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            Logging.ingest.debug((Object)("Error closing socket: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                catch (UnsupportedEncodingException ioe) {
                    throw new ManifoldCFException("Fatal ingestion error: " + ioe.getMessage(), (Throwable)ioe);
                }
                catch (InterruptedIOException ioe) {
                    return;
                }
                catch (IOException ioe) {
                    Logging.ingest.warn((Object)("Error communicating with Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                    this.activityStart = new Long(fullStartTime);
                    this.activityCode = "-1";
                    this.activityDetails = ioe.getMessage();
                    throw ioe;
                }
            }
            catch (Throwable e) {
                this.exception = e;
                return;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public Long getActivityStart() {
            return this.activityStart;
        }

        public String getActivityCode() {
            return this.activityCode;
        }

        public String getActivityDetails() {
            return this.activityDetails;
        }
    }

    protected class IngestThread
    extends Thread {
        protected String documentURI;
        protected String aclXmlString;
        protected String[] collections;
        protected String documentTemplate;
        protected RepositoryDocument document;
        protected Long activityStart = null;
        protected Long activityBytes = null;
        protected String activityCode = null;
        protected String activityDetails = null;
        protected Throwable exception = null;
        protected boolean readFromDocumentStreamYet = false;
        protected boolean rval = false;

        public IngestThread(String documentURI, String aclXmlString, String[] collections, String documentTemplate, RepositoryDocument document) {
            this.setDaemon(true);
            this.documentURI = documentURI;
            this.aclXmlString = aclXmlString;
            this.collections = collections;
            this.documentTemplate = documentTemplate;
            this.document = document;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            long length = this.document.getBinaryLength();
            InputStream is = this.document.getBinaryStream();
            try {
                long fullStartTime = System.currentTimeMillis();
                try {
                    long responseRetryCount = (long)HttpPoster.this.responseRetries + (long)((double)length * HttpPoster.this.sizeCoefficient);
                    Socket socket = HttpPoster.this.createSocket(responseRetryCount);
                    try {
                        InputStreamReader isr = new InputStreamReader(socket.getInputStream(), "ASCII");
                        try {
                            BufferedReader in = new BufferedReader(isr);
                            try {
                                OutputStream out = socket.getOutputStream();
                                try {
                                    String res;
                                    long now;
                                    block62: {
                                        long later;
                                        int index;
                                        String uri = HttpPoster.this.url.getFile();
                                        if (uri.length() == 0) {
                                            uri = "/";
                                        }
                                        byte[] tmp = ("POST " + uri + " HTTP/1.0\r\n").getBytes("UTF-8");
                                        out.write(tmp, 0, tmp.length);
                                        tmp = ("Document-URI: " + this.documentURI + "\r\n").getBytes("UTF-8");
                                        out.write(tmp, 0, tmp.length);
                                        HttpPoster.this.writeCredentials(out);
                                        if (this.aclXmlString.length() > 0) {
                                            String encodedACL = new Base64().encodeByteArray(this.aclXmlString.getBytes("UTF-8"));
                                            index = 0;
                                            while (true) {
                                                if (index + 4096 >= encodedACL.length()) {
                                                    tmp = ("Document-ACL: " + encodedACL.substring(index) + "\r\n").getBytes("UTF-8");
                                                    out.write(tmp, 0, tmp.length);
                                                    break;
                                                }
                                                tmp = ("Document-ACL: " + encodedACL.substring(index, index + 4096) + "\r\n").getBytes("UTF-8");
                                                out.write(tmp, 0, tmp.length);
                                                index += 4096;
                                            }
                                        }
                                        if (this.collections != null) {
                                            int index2 = 0;
                                            while (index2 < this.collections.length) {
                                                String collectionName = this.collections[index2++];
                                                String encodedValue = HttpPoster.metadataEncode(collectionName);
                                                tmp = ("Document-Metadata: collection_name=" + encodedValue + "\r\n").getBytes("UTF-8");
                                                out.write(tmp, 0, tmp.length);
                                            }
                                        }
                                        if (this.documentTemplate != null && this.documentTemplate.length() > 0) {
                                            String encodedTemplate = new Base64().encodeByteArray(this.documentTemplate.getBytes("UTF-8"));
                                            index = 0;
                                            while (true) {
                                                if (index + 4096 >= encodedTemplate.length()) {
                                                    tmp = ("Document-Template: " + encodedTemplate.substring(index) + "\r\n").getBytes("UTF-8");
                                                    out.write(tmp, 0, tmp.length);
                                                    break;
                                                }
                                                tmp = ("Document-Template: " + encodedTemplate.substring(index, index + 4096) + "\r\n").getBytes("UTF-8");
                                                out.write(tmp, 0, tmp.length);
                                                index += 4096;
                                            }
                                        }
                                        Iterator iter = this.document.getFields();
                                        while (iter.hasNext()) {
                                            String fieldName = (String)iter.next();
                                            Object[] values = this.document.getField(fieldName);
                                            int k = 0;
                                            while (k < values.length) {
                                                String value = (String)values[k++];
                                                String encodedValue = HttpPoster.metadataEncode(value);
                                                tmp = ("Document-Metadata: " + fieldName + "=" + encodedValue + "\r\n").getBytes("UTF-8");
                                                out.write(tmp, 0, tmp.length);
                                            }
                                        }
                                        tmp = ("Content-length: " + new Long(length).toString() + "\r\n\n").getBytes("UTF-8");
                                        out.write(tmp, 0, tmp.length);
                                        long total = 0L;
                                        now = System.currentTimeMillis();
                                        byte[] bytes = new byte[HttpPoster.this.buffersize];
                                        while (true) {
                                            int count;
                                            try {
                                                count = is.read(bytes);
                                            }
                                            catch (SocketTimeoutException ioe) {
                                                Logging.ingest.warn((Object)("Error reading data for transmission to Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                                                this.activityStart = new Long(fullStartTime);
                                                this.activityCode = "-1";
                                                this.activityDetails = "Couldn't read document: " + ioe.getMessage();
                                                long currentTime = System.currentTimeMillis();
                                                throw new ServiceInterruption("IO error reading document for ingestion: " + ioe.getMessage() + "; read will be retried again later", (Throwable)ioe, currentTime + HttpPoster.this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                                            }
                                            catch (InterruptedIOException ioe) {
                                                if (ioe.getClass().getName().equals("java.io.InterruptedIOException")) throw ioe;
                                                Logging.ingest.warn((Object)("Error reading data for transmission to Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                                                this.activityStart = new Long(fullStartTime);
                                                this.activityCode = "-1";
                                                this.activityDetails = "Couldn't read document: " + ioe.getMessage();
                                                long currentTime = System.currentTimeMillis();
                                                throw new ServiceInterruption("IO error reading document for ingestion: " + ioe.getMessage() + "; read will be retried again later", (Throwable)ioe, currentTime + HttpPoster.this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                                            }
                                            catch (IOException ioe) {
                                                Logging.ingest.warn((Object)("Error reading data for transmission to Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                                                this.activityStart = new Long(fullStartTime);
                                                this.activityCode = "-1";
                                                this.activityDetails = "Couldn't read document: " + ioe.getMessage();
                                                long currentTime = System.currentTimeMillis();
                                                throw new ServiceInterruption("IO error reading document for ingestion: " + ioe.getMessage() + "; read will be retried again later", (Throwable)ioe, currentTime + HttpPoster.this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                                            }
                                            if (count == -1) {
                                                later = System.currentTimeMillis();
                                                if (Logging.ingest.isDebugEnabled()) {
                                                    break;
                                                }
                                                break block62;
                                            }
                                            this.readFromDocumentStreamYet = true;
                                            out.write(bytes, 0, count);
                                            total += (long)count;
                                        }
                                        Logging.ingest.debug((Object)("Total bytes posted: " + new Long(total).toString() + ", total time: " + (later - now)));
                                    }
                                    out.flush();
                                    try {
                                        res = HttpPoster.this.getResponse(in);
                                    }
                                    catch (ServiceInterruption si) {
                                        this.activityStart = new Long(now);
                                        this.activityCode = "-2";
                                        this.activityDetails = si.getMessage();
                                        throw si;
                                    }
                                    if (Logging.ingest.isDebugEnabled()) {
                                        Logging.ingest.debug((Object)("Response code from ingest: '" + res + "'"));
                                    }
                                    CodeDetails cd = new CodeDetails(res);
                                    this.activityStart = new Long(now);
                                    this.activityBytes = new Long(length);
                                    this.activityCode = cd.getCode();
                                    this.activityDetails = cd.getDetails();
                                    int codeValue = cd.getCodeValue();
                                    if (codeValue < 0) {
                                        throw new ManifoldCFException("Http protocol error");
                                    }
                                    if (codeValue == 200) {
                                        this.rval = true;
                                        return;
                                    }
                                    if (codeValue == 401) {
                                        throw new ManifoldCFException("Bad credentials for ingestion", 3);
                                    }
                                    if (codeValue >= 400 && codeValue < 500) {
                                        this.rval = false;
                                        return;
                                    }
                                    long currentTime = System.currentTimeMillis();
                                    throw new ServiceInterruption("Error " + Integer.toString(codeValue) + " from ingestion request; ingestion will be retried again later", (Throwable)new ManifoldCFException("Ingestion HTTP error code " + Integer.toString(codeValue)), currentTime + HttpPoster.this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                                }
                                finally {
                                    out.close();
                                }
                            }
                            finally {
                                in.close();
                            }
                        }
                        finally {
                            isr.close();
                        }
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (InterruptedIOException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            Logging.ingest.debug((Object)("Error closing socket: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                catch (UnsupportedEncodingException ioe) {
                    throw new ManifoldCFException("Fatal ingestion error: " + ioe.getMessage(), (Throwable)ioe);
                }
                catch (SocketTimeoutException ioe) {
                    Logging.ingest.warn((Object)("Error connecting to ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                    this.activityStart = new Long(fullStartTime);
                    this.activityCode = "-1";
                    this.activityDetails = ioe.getMessage();
                    throw ioe;
                }
                catch (InterruptedIOException e) {
                    return;
                }
                catch (IOException ioe) {
                    this.activityStart = new Long(fullStartTime);
                    if (ioe.getClass().getName().equals("java.net.SocketException") && ioe.getMessage().toLowerCase().indexOf("broken pipe") != -1) {
                        this.activityCode = "-103";
                        this.activityDetails = "Presuming an ingestion rejection: " + ioe.getMessage();
                        this.rval = false;
                        return;
                    }
                    this.activityCode = "-1";
                    this.activityDetails = ioe.getMessage();
                    Logging.ingest.warn((Object)("Error communicating with Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                    throw ioe;
                }
            }
            catch (Throwable e) {
                this.exception = e;
                return;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public Long getActivityStart() {
            return this.activityStart;
        }

        public Long getActivityBytes() {
            return this.activityBytes;
        }

        public String getActivityCode() {
            return this.activityCode;
        }

        public String getActivityDetails() {
            return this.activityDetails;
        }

        public boolean getReadFromDocumentStreamYet() {
            return this.readFromDocumentStreamYet;
        }

        public boolean getRval() {
            return this.rval;
        }
    }

    protected static class LaxTrustManager
    implements X509TrustManager {
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

