/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.archive.crawler.WebUI;
import org.archive.crawler.WebUIConfig;
import org.archive.crawler.framework.EngineConfig;
import org.archive.crawler.framework.EngineImpl;
import org.archive.crawler.framework.JobStage;
import org.archive.util.ArchiveUtils;
import org.archive.util.JndiUtils;

public class Heritrix {
    private static final String CONF = "conf";
    private static final String PROPERTIES = "logging.properties";
    private static final Logger logger = Logger.getLogger(Heritrix.class.getName());
    private static final String STARTLOG = "heritrix_dmesg.log";

    private static void usage(PrintStream out) {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("Heritrix", Heritrix.options());
    }

    private static Options options() {
        Options options = new Options();
        options.addOption("h", "help", true, "Usage information.");
        options.addOption("j", "jobs-dir", true, "The jobs directory.  Defaults to ./jobs");
        options.addOption("l", "logging-properties", true, "The full path to the logging properties file (eg, conf/logging.properties).  If present, this file will be used to configure Java logging.  Defaults to ./conf/logging.properties");
        options.addOption("a", "webui-admin", true, "Specifies the authorization password which must be supplied to access the webui. Required if launching the webui.");
        options.addOption("b", "webui-bind-hosts", true, "A comma-separated list of hostnames for the webui to bind to.");
        options.addOption("p", "webui-port", true, "The port the webui should listen on.");
        options.addOption("w", "webui-war-path", true, "The path to the Heritrix webui WAR.");
        options.addOption("n", "no-web-ui", false, "Do not run the admin web user interface; only run the crawl engine.  If set, the crawl engine will need to be controlled via JMX or a remote web UI.");
        options.addOption("u", "no-engine", false, "Do not run the crawl engine; only run the admin web UI.");
        options.addOption("r", "run-job", true, "Specify a ready job or a profile name to launch at launch.  If you specify a profile name, the profile will first be copied to a new ready job, and that ready job will be launched.");
        return options;
    }

    private static File getDefaultPropertiesFile() {
        File confDir = new File(CONF);
        File props = new File(confDir, PROPERTIES);
        return props;
    }

    private static CommandLine getCommandLine(PrintStream out, String[] args) {
        CommandLine cl;
        GnuParser clp = new GnuParser();
        try {
            cl = clp.parse(Heritrix.options(), args);
        }
        catch (ParseException e) {
            Heritrix.usage(out);
            return null;
        }
        if (cl.getArgList().size() != 0) {
            Heritrix.usage(out);
            return null;
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PrintStream out;
        String maxFormSize;
        String ignoredSchemes = "org.archive.net.UURIFactory.ignored-schemes";
        if (System.getProperty(ignoredSchemes) == null) {
            System.setProperty(ignoredSchemes, "mailto, clsid, res, file, rtsp, about");
        }
        if (System.getProperty(maxFormSize = "org.mortbay.jetty.Request.maxFormContentSize") == null) {
            System.setProperty(maxFormSize, "52428800");
        }
        if (Heritrix.isDevelopment()) {
            out = System.out;
            out.println("heritrix.development mode");
        } else {
            File startLog = new File(Heritrix.getHeritrixHome(), STARTLOG);
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(startLog), 16384));
        }
        CommandLine cl = Heritrix.getCommandLine(out, args);
        if (cl == null) {
            return;
        }
        if (cl.hasOption('h')) {
            Heritrix.usage(out);
            return;
        }
        if (cl.hasOption('n') && cl.hasOption('u')) {
            out.println("Only one of -n or -u may be specified.");
            Heritrix.usage(out);
            System.exit(1);
        }
        if (cl.hasOption('n') && System.getProperty("com.sun.management.jmxremote.port") == null) {
            out.println("The crawl engine is inaccessible.  You must specify the system property com.sun.management.jmxremote.port if you disable the web UI with -n.");
            System.exit(1);
        }
        EngineConfig config = new EngineConfig();
        WebUIConfig webConfig = new WebUIConfig();
        File properties = Heritrix.getDefaultPropertiesFile();
        if (!cl.hasOption('n')) {
            if (cl.hasOption('a')) {
                webConfig.setUiPassword(cl.getOptionValue('a'));
            } else {
                System.err.println("Unless -n is specified, you must specify an admin password for the web UI using -a.");
                System.exit(1);
            }
        }
        if (cl.hasOption('j')) {
            config.setJobsDirectory(cl.getOptionValue('j'));
        }
        if (cl.hasOption('l')) {
            properties = new File(cl.getOptionValue('l'));
        }
        if (cl.hasOption('b')) {
            String hosts = cl.getOptionValue('b');
            List<Object> list = "/".equals(hosts) ? new ArrayList() : Arrays.asList(hosts.split(","));
            webConfig.getHosts().addAll(list);
        } else {
            webConfig.getHosts().add("localhost");
        }
        if (cl.hasOption('p')) {
            int port = Integer.parseInt(cl.getOptionValue('p'));
            webConfig.setPort(port);
        }
        if (cl.hasOption('w')) {
            webConfig.setPathToWAR(cl.getOptionValue('w'));
        }
        if (properties.exists()) {
            FileInputStream finp = new FileInputStream(properties);
            LogManager.getLogManager().readConfiguration(finp);
            finp.close();
        }
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        WebUI webui = null;
        try {
            if (cl.hasOption('u')) {
                out.println("Not running crawl engine.");
            } else {
                EngineImpl cjm = new EngineImpl(config);
                Heritrix.registerJndi(cjm.getObjectName(), out);
                out.println("Engine registered at " + cjm.getObjectName());
                if (cl.hasOption('r')) {
                    Heritrix.launch(cjm, cl.getOptionValue('r'));
                }
            }
            if (cl.hasOption('n')) {
                out.println("Not running web UI.");
            } else {
                webui = new WebUI(webConfig);
                webui.start();
                out.println("Web UI listening on " + webConfig.hostAndPort() + ".");
            }
        }
        catch (Exception e) {
            e.printStackTrace(out);
            if (webui != null) {
                webui.stop();
            }
            throw e;
        }
        finally {
            if (!Heritrix.isDevelopment()) {
                if (out != null) {
                    out.flush();
                    out.close();
                }
                System.out.println("Heritrix version: " + ArchiveUtils.VERSION);
            } else if (out != null) {
                out.flush();
            }
        }
        try {
            Object eternity;
            Object object = eternity = new Object();
            synchronized (object) {
                eternity.wait();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    protected static File getHeritrixHome() throws IOException {
        File heritrixHome = null;
        String home = System.getProperty("heritrix.home");
        if (home != null && home.length() > 0) {
            heritrixHome = new File(home);
            if (!heritrixHome.exists()) {
                throw new IOException("HERITRIX_HOME <" + home + "> does not exist.");
            }
        } else {
            heritrixHome = new File(new File("").getAbsolutePath());
        }
        return heritrixHome;
    }

    protected static void registerJndi(ObjectName name, PrintStream out) throws NullPointerException, NamingException {
        Context c = Heritrix.getJndiContext();
        if (c == null) {
            out.println("No JNDI context.");
            return;
        }
        CompoundName key = JndiUtils.bindObjectName((Context)c, (ObjectName)name);
        out.println("Bound '" + key + "' to '" + JndiUtils.getCompoundName((String)c.getNameInNamespace()).toString() + "' jndi context");
    }

    protected static void deregisterJndi(ObjectName name, PrintStream out) throws NullPointerException, NamingException {
        Context c = Heritrix.getJndiContext();
        if (c == null) {
            return;
        }
        CompoundName key = JndiUtils.unbindObjectName((Context)c, (ObjectName)name);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Unbound '" + key + "' from '" + JndiUtils.getCompoundName((String)c.getNameInNamespace()).toString() + "' jndi context");
        }
    }

    protected static Context getJndiContext() throws NamingException {
        Context c = null;
        try {
            c = JndiUtils.getSubContext((String)"org.archive.crawler");
        }
        catch (NoInitialContextException e) {
            logger.fine("No JNDI Context: " + e.toString());
        }
        return c;
    }

    protected static boolean isDevelopment() {
        return System.getProperty("heritrix.development") != null;
    }

    private static void launch(EngineImpl cjm, String job) throws Exception {
        for (String s : cjm.listJobs()) {
            if (s.equals(JobStage.PROFILE.getPrefix() + job)) {
                String newName = EngineImpl.getCopyDefaultName(job);
                newName = JobStage.READY.getPrefix() + newName;
                cjm.copy(s, newName);
                cjm.launchJob(newName);
                return;
            }
            if (!s.equals(JobStage.READY.getPrefix() + job)) continue;
            cjm.launchJob(s);
            return;
        }
        throw new IllegalStateException("No such job: " + job);
    }
}

