/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.archive.crawler.WebUIConfig;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.webapp.WebAppContext;

public class WebUI {
    private Set<String> hosts;
    private int port;
    private String pathToWAR;
    private String uiPassword;
    private Server server;

    public WebUI(WebUIConfig config) {
        this.hosts = new HashSet<String>(config.getHosts());
        this.port = config.getPort();
        this.pathToWAR = config.getPathToWAR();
        if (this.pathToWAR == null) {
            this.pathToWAR = this.getDefaultPathToWAR();
        }
        this.uiPassword = config.getUiPassword();
    }

    private String getDefaultPathToWAR() {
        File file = new File("lib");
        if (!file.isDirectory()) {
            throw new IllegalStateException("No path to WAR specified, and no WAR found in ./lib.  Use -w to specify a path to the Heritrix WAR file.");
        }
        for (String filename : file.list()) {
            if (!filename.endsWith(".war")) continue;
            return new File(file, filename).getAbsolutePath();
        }
        throw new IllegalStateException("No path to WAR specified, and no WAR found in ./lib.  Use -w to specify a path to the Heritrix WAR file.");
    }

    public void start() throws Exception {
        this.server = new Server();
        for (String host : this.hosts) {
            SocketConnector sc = new SocketConnector();
            sc.setHost(host);
            sc.setPort(this.port);
            this.server.addConnector((Connector)sc);
        }
        if (this.hosts.isEmpty()) {
            SocketConnector sc = new SocketConnector();
            sc.setPort(this.port);
            this.server.addConnector((Connector)sc);
        }
        WebAppContext webapp = new WebAppContext(this.pathToWAR, "/");
        webapp.setAttribute("uiPassword", (Object)this.uiPassword);
        webapp.setParentLoaderPriority(true);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{webapp, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
        this.server.start();
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

